/*
 * Decompiled with CFR 0.152.
 */
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FutureTaskTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)FutureTaskTest.suite());
    }

    public static Test suite() {
        return new TestSuite(FutureTaskTest.class);
    }

    void checkNotDone(Future<?> f) {
        FutureTaskTest.assertFalse((boolean)f.isDone());
        FutureTaskTest.assertFalse((boolean)f.isCancelled());
    }

    <T> void checkCompletedNormally(Future<T> f, T expected) {
        FutureTaskTest.assertTrue((boolean)f.isDone());
        FutureTaskTest.assertFalse((boolean)f.isCancelled());
        try {
            FutureTaskTest.assertSame(expected, f.get());
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
        try {
            FutureTaskTest.assertSame(expected, f.get(5L, TimeUnit.SECONDS));
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
        FutureTaskTest.assertFalse((boolean)f.cancel(false));
        FutureTaskTest.assertFalse((boolean)f.cancel(true));
    }

    void checkCancelled(Future<?> f) {
        FutureTaskTest.assertTrue((boolean)f.isDone());
        FutureTaskTest.assertTrue((boolean)f.isCancelled());
        try {
            f.get();
            this.shouldThrow();
        }
        catch (CancellationException success) {
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
        try {
            f.get(5L, TimeUnit.SECONDS);
            this.shouldThrow();
        }
        catch (CancellationException success) {
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
        FutureTaskTest.assertFalse((boolean)f.cancel(false));
        FutureTaskTest.assertFalse((boolean)f.cancel(true));
    }

    void checkCompletedAbnormally(Future<?> f, Throwable t) {
        FutureTaskTest.assertTrue((boolean)f.isDone());
        FutureTaskTest.assertFalse((boolean)f.isCancelled());
        try {
            f.get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            FutureTaskTest.assertSame((Object)t, (Object)success.getCause());
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
        try {
            f.get(5L, TimeUnit.SECONDS);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            FutureTaskTest.assertSame((Object)t, (Object)success.getCause());
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
        FutureTaskTest.assertFalse((boolean)f.cancel(false));
        FutureTaskTest.assertFalse((boolean)f.cancel(true));
    }

    public void testConstructor() {
        try {
            FutureTask task = new FutureTask(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor2() {
        try {
            FutureTask<Boolean> task = new FutureTask<Boolean>(null, Boolean.TRUE);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testIsDone() {
        FutureTask task = new FutureTask(new JSR166TestCase.NoOpCallable());
        task.run();
        FutureTaskTest.assertTrue((boolean)task.isDone());
        this.checkCompletedNormally(task, Boolean.TRUE);
    }

    public void testRunAndReset() {
        PublicFutureTask task = new PublicFutureTask((Callable)new JSR166TestCase.NoOpCallable());
        FutureTaskTest.assertTrue((boolean)task.runAndReset());
        this.checkNotDone(task);
    }

    public void testResetAfterCancel() {
        PublicFutureTask task = new PublicFutureTask((Callable)new JSR166TestCase.NoOpCallable());
        FutureTaskTest.assertTrue((boolean)task.cancel(false));
        FutureTaskTest.assertFalse((boolean)task.runAndReset());
        this.checkCancelled(task);
    }

    public void testSet() throws Exception {
        PublicFutureTask task = new PublicFutureTask((Callable)new JSR166TestCase.NoOpCallable());
        task.set(one);
        FutureTaskTest.assertSame(task.get(), (Object)one);
        this.checkCompletedNormally(task, one);
    }

    public void testSetException() throws Exception {
        NoSuchElementException nse = new NoSuchElementException();
        PublicFutureTask task = new PublicFutureTask((Callable)new JSR166TestCase.NoOpCallable());
        task.setException(nse);
        try {
            Object x = task.get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            FutureTaskTest.assertSame((Object)success.getCause(), (Object)nse);
            this.checkCompletedAbnormally(task, nse);
        }
    }

    public void testCancelBeforeRun() {
        FutureTask task = new FutureTask(new JSR166TestCase.NoOpCallable());
        FutureTaskTest.assertTrue((boolean)task.cancel(false));
        task.run();
        this.checkCancelled(task);
    }

    public void testCancelBeforeRun2() {
        FutureTask task = new FutureTask(new JSR166TestCase.NoOpCallable());
        FutureTaskTest.assertTrue((boolean)task.cancel(true));
        task.run();
        this.checkCancelled(task);
    }

    public void testCancelAfterRun() {
        FutureTask task = new FutureTask(new JSR166TestCase.NoOpCallable());
        task.run();
        FutureTaskTest.assertFalse((boolean)task.cancel(false));
        this.checkCompletedNormally(task, Boolean.TRUE);
    }

    public void testCancelInterrupt() throws InterruptedException {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        FutureTask<Object> task = new FutureTask<Object>(new JSR166TestCase.CheckedCallable<Object>(){

            @Override
            public Object realCall() {
                threadStarted.countDown();
                long t0 = System.nanoTime();
                while (!Thread.interrupted()) {
                    if (FutureTaskTest.this.millisElapsedSince(t0) > JSR166TestCase.MEDIUM_DELAY_MS) {
                        Assert.fail((String)"interrupt not delivered");
                    }
                    Thread.yield();
                }
                return Boolean.TRUE;
            }
        });
        Thread t = this.newStartedThread(task);
        threadStarted.await();
        FutureTaskTest.assertTrue((boolean)task.cancel(true));
        this.checkCancelled(task);
        this.awaitTermination(t, MEDIUM_DELAY_MS);
        this.checkCancelled(task);
    }

    public void testCancelNoInterrupt() throws InterruptedException {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final CountDownLatch cancelled = new CountDownLatch(1);
        FutureTask<Boolean> task = new FutureTask<Boolean>(new JSR166TestCase.CheckedCallable<Boolean>(){

            @Override
            public Boolean realCall() throws InterruptedException {
                threadStarted.countDown();
                cancelled.await(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
                Assert.assertFalse((boolean)Thread.interrupted());
                return Boolean.TRUE;
            }
        });
        Thread t = this.newStartedThread(task);
        threadStarted.await();
        FutureTaskTest.assertTrue((boolean)task.cancel(false));
        this.checkCancelled(task);
        cancelled.countDown();
        this.awaitTermination(t, MEDIUM_DELAY_MS);
        this.checkCancelled(task);
    }

    public void testGetRun() throws InterruptedException {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final FutureTask<Object> task = new FutureTask<Object>(new JSR166TestCase.CheckedCallable<Object>(){

            @Override
            public Object realCall() throws InterruptedException {
                return Boolean.TRUE;
            }
        });
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                threadStarted.countDown();
                Assert.assertSame((Object)Boolean.TRUE, task.get());
            }
        });
        threadStarted.await();
        this.checkNotDone(task);
        FutureTaskTest.assertTrue((boolean)t.isAlive());
        task.run();
        this.checkCompletedNormally(task, Boolean.TRUE);
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testGetSet() throws InterruptedException {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final PublicFutureTask task = new PublicFutureTask(new JSR166TestCase.CheckedCallable<Object>(){

            @Override
            public Object realCall() throws InterruptedException {
                return Boolean.TRUE;
            }
        });
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                threadStarted.countDown();
                Assert.assertSame((Object)Boolean.FALSE, task.get());
            }
        });
        threadStarted.await();
        this.checkNotDone(task);
        FutureTaskTest.assertTrue((boolean)t.isAlive());
        task.set(Boolean.FALSE);
        this.checkCompletedNormally(task, Boolean.FALSE);
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testTimedGetRun() throws InterruptedException {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final FutureTask<Object> task = new FutureTask<Object>(new JSR166TestCase.CheckedCallable<Object>(){

            @Override
            public Object realCall() throws InterruptedException {
                return Boolean.TRUE;
            }
        });
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                threadStarted.countDown();
                Assert.assertSame((Object)Boolean.TRUE, task.get(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
            }
        });
        threadStarted.await();
        this.checkNotDone(task);
        FutureTaskTest.assertTrue((boolean)t.isAlive());
        task.run();
        this.checkCompletedNormally(task, Boolean.TRUE);
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testTimedGetSet() throws InterruptedException {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final PublicFutureTask task = new PublicFutureTask(new JSR166TestCase.CheckedCallable<Object>(){

            @Override
            public Object realCall() throws InterruptedException {
                return Boolean.TRUE;
            }
        });
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                threadStarted.countDown();
                Assert.assertSame((Object)Boolean.FALSE, task.get(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
            }
        });
        threadStarted.await();
        this.checkNotDone(task);
        FutureTaskTest.assertTrue((boolean)t.isAlive());
        task.set(Boolean.FALSE);
        this.checkCompletedNormally(task, Boolean.FALSE);
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testTimedGet_Cancellation() throws InterruptedException {
        final CountDownLatch threadStarted = new CountDownLatch(2);
        final FutureTask<Object> task = new FutureTask<Object>(new JSR166TestCase.CheckedInterruptedCallable<Object>(){

            @Override
            public Object realCall() throws InterruptedException {
                threadStarted.countDown();
                JSR166TestCase.delay(JSR166TestCase.LONG_DELAY_MS);
                return Boolean.TRUE;
            }
        });
        JSR166TestCase.ThreadShouldThrow t1 = new JSR166TestCase.ThreadShouldThrow(CancellationException.class){

            @Override
            public void realRun() throws Exception {
                threadStarted.countDown();
                task.get(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        };
        Thread t2 = new Thread(task);
        t1.start();
        t2.start();
        threadStarted.await();
        task.cancel(true);
        this.awaitTermination(t1, MEDIUM_DELAY_MS);
        this.awaitTermination(t2, MEDIUM_DELAY_MS);
        this.checkCancelled(task);
    }

    public void testGet_Cancellation() throws InterruptedException {
        final CountDownLatch threadStarted = new CountDownLatch(2);
        final FutureTask<Object> task = new FutureTask<Object>(new JSR166TestCase.CheckedInterruptedCallable<Object>(){

            @Override
            public Object realCall() throws InterruptedException {
                threadStarted.countDown();
                JSR166TestCase.delay(JSR166TestCase.LONG_DELAY_MS);
                return Boolean.TRUE;
            }
        });
        JSR166TestCase.ThreadShouldThrow t1 = new JSR166TestCase.ThreadShouldThrow(CancellationException.class){

            @Override
            public void realRun() throws Exception {
                threadStarted.countDown();
                task.get();
            }
        };
        Thread t2 = new Thread(task);
        t1.start();
        t2.start();
        threadStarted.await();
        task.cancel(true);
        this.awaitTermination(t1, MEDIUM_DELAY_MS);
        this.awaitTermination(t2, MEDIUM_DELAY_MS);
        this.checkCancelled(task);
    }

    public void testGet_ExecutionException() throws InterruptedException {
        FutureTask task = new FutureTask(new Callable(){

            public Object call() {
                return 5 / 0;
            }
        });
        task.run();
        try {
            task.get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            FutureTaskTest.assertTrue((boolean)(success.getCause() instanceof ArithmeticException));
            this.checkCompletedAbnormally(task, success.getCause());
        }
    }

    public void testTimedGet_ExecutionException2() throws Exception {
        FutureTask task = new FutureTask(new Callable(){

            public Object call() {
                return 5 / 0;
            }
        });
        task.run();
        try {
            task.get(SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            FutureTaskTest.assertTrue((boolean)(success.getCause() instanceof ArithmeticException));
            this.checkCompletedAbnormally(task, success.getCause());
        }
    }

    public void testGet_InterruptedException() throws InterruptedException {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final FutureTask task = new FutureTask(new JSR166TestCase.NoOpCallable());
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws Exception {
                threadStarted.countDown();
                task.get();
            }
        });
        threadStarted.await();
        t.interrupt();
        this.awaitTermination(t, MEDIUM_DELAY_MS);
        this.checkNotDone(task);
    }

    public void testTimedGet_InterruptedException2() throws InterruptedException {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final FutureTask task = new FutureTask(new JSR166TestCase.NoOpCallable());
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws Exception {
                threadStarted.countDown();
                task.get(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        });
        threadStarted.await();
        t.interrupt();
        this.awaitTermination(t, MEDIUM_DELAY_MS);
        this.checkNotDone(task);
    }

    public void testGet_TimeoutException() throws Exception {
        try {
            FutureTask task = new FutureTask(new JSR166TestCase.NoOpCallable());
            task.get(1L, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    static class PublicFutureTask
    extends FutureTask {
        public PublicFutureTask(Callable r) {
            super(r);
        }

        @Override
        public boolean runAndReset() {
            return super.runAndReset();
        }

        public void set(Object x) {
            super.set(x);
        }

        @Override
        public void setException(Throwable t) {
            super.setException(t);
        }
    }
}

