/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.Test;
import junit.textui.TestRunner;

public class LinkedBlockingDequeTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)LinkedBlockingDequeTest.suite());
    }

    public static Test suite() {
        return LinkedBlockingDequeTest.newTestSuite(LinkedBlockingDequeTest.class, new Unbounded().testSuite(), new Bounded().testSuite());
    }

    private LinkedBlockingDeque<Integer> populatedDeque(int n) {
        LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(n);
        LinkedBlockingDequeTest.assertTrue((boolean)q.isEmpty());
        for (int i = 0; i < n; ++i) {
            LinkedBlockingDequeTest.assertTrue((boolean)q.offer(new Integer(i)));
        }
        LinkedBlockingDequeTest.assertFalse((boolean)q.isEmpty());
        LinkedBlockingDequeTest.assertEquals((int)0, (int)q.remainingCapacity());
        LinkedBlockingDequeTest.assertEquals((int)n, (int)q.size());
        return q;
    }

    public void testEmpty() {
        LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>();
        LinkedBlockingDequeTest.assertTrue((boolean)q.isEmpty());
        q.add(new Integer(1));
        LinkedBlockingDequeTest.assertFalse((boolean)q.isEmpty());
        q.add(new Integer(2));
        q.removeFirst();
        q.removeFirst();
        LinkedBlockingDequeTest.assertTrue((boolean)q.isEmpty());
    }

    public void testSize() {
        int i;
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((int)(20 - i), (int)q.size());
            q.removeFirst();
        }
        for (i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((int)i, (int)q.size());
            q.add(new Integer(i));
        }
    }

    public void testOfferFirstNull() {
        try {
            LinkedBlockingDeque<Object> q = new LinkedBlockingDeque<Object>();
            q.offerFirst(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testOfferFirst() {
        LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>();
        LinkedBlockingDequeTest.assertTrue((boolean)q.offerFirst(new Integer(0)));
        LinkedBlockingDequeTest.assertTrue((boolean)q.offerFirst(new Integer(1)));
    }

    public void testOfferLast() {
        LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>();
        LinkedBlockingDequeTest.assertTrue((boolean)q.offerLast(new Integer(0)));
        LinkedBlockingDequeTest.assertTrue((boolean)q.offerLast(new Integer(1)));
    }

    public void testPollFirst() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.pollFirst());
        }
        LinkedBlockingDequeTest.assertNull((Object)q.pollFirst());
    }

    public void testPollLast() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 19; i >= 0; --i) {
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.pollLast());
        }
        LinkedBlockingDequeTest.assertNull((Object)q.pollLast());
    }

    public void testPeekFirst() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.peekFirst());
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.pollFirst());
            LinkedBlockingDequeTest.assertTrue((q.peekFirst() == null || !((Object)q.peekFirst()).equals(i) ? 1 : 0) != 0);
        }
        LinkedBlockingDequeTest.assertNull((Object)q.peekFirst());
    }

    public void testPeek() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.peek());
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.pollFirst());
            LinkedBlockingDequeTest.assertTrue((q.peek() == null || !((Object)q.peek()).equals(i) ? 1 : 0) != 0);
        }
        LinkedBlockingDequeTest.assertNull((Object)q.peek());
    }

    public void testPeekLast() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 19; i >= 0; --i) {
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.peekLast());
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.pollLast());
            LinkedBlockingDequeTest.assertTrue((q.peekLast() == null || !((Object)q.peekLast()).equals(i) ? 1 : 0) != 0);
        }
        LinkedBlockingDequeTest.assertNull((Object)q.peekLast());
    }

    public void testFirstElement() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.getFirst());
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.pollFirst());
        }
        try {
            q.getFirst();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        LinkedBlockingDequeTest.assertNull((Object)q.peekFirst());
    }

    public void testLastElement() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 19; i >= 0; --i) {
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.getLast());
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.pollLast());
        }
        try {
            q.getLast();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        LinkedBlockingDequeTest.assertNull((Object)q.peekLast());
    }

    public void testRemoveFirst() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.removeFirst());
        }
        try {
            q.removeFirst();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        LinkedBlockingDequeTest.assertNull((Object)q.peekFirst());
    }

    public void testRemoveLast() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 19; i >= 0; --i) {
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.removeLast());
        }
        try {
            q.removeLast();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        LinkedBlockingDequeTest.assertNull((Object)q.peekLast());
    }

    public void testRemove() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.remove());
        }
        try {
            q.remove();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemoveFirstOccurrence() {
        int i;
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (i = 1; i < 20; i += 2) {
            LinkedBlockingDequeTest.assertTrue((boolean)q.removeFirstOccurrence(new Integer(i)));
        }
        for (i = 0; i < 20; i += 2) {
            LinkedBlockingDequeTest.assertTrue((boolean)q.removeFirstOccurrence(new Integer(i)));
            LinkedBlockingDequeTest.assertFalse((boolean)q.removeFirstOccurrence(new Integer(i + 1)));
        }
        LinkedBlockingDequeTest.assertTrue((boolean)q.isEmpty());
    }

    public void testRemoveLastOccurrence() {
        int i;
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (i = 1; i < 20; i += 2) {
            LinkedBlockingDequeTest.assertTrue((boolean)q.removeLastOccurrence(new Integer(i)));
        }
        for (i = 0; i < 20; i += 2) {
            LinkedBlockingDequeTest.assertTrue((boolean)q.removeLastOccurrence(new Integer(i)));
            LinkedBlockingDequeTest.assertFalse((boolean)q.removeLastOccurrence(new Integer(i + 1)));
        }
        LinkedBlockingDequeTest.assertTrue((boolean)q.isEmpty());
    }

    public void testAddFirst() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(3);
        q.pollLast();
        q.addFirst(four);
        LinkedBlockingDequeTest.assertSame((Object)four, (Object)q.peekFirst());
    }

    public void testAddLast() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(3);
        q.pollLast();
        q.addLast(four);
        LinkedBlockingDequeTest.assertSame((Object)four, (Object)q.peekLast());
    }

    public void testConstructor1() {
        LinkedBlockingDequeTest.assertEquals((int)20, (int)new LinkedBlockingDeque(20).remainingCapacity());
        LinkedBlockingDequeTest.assertEquals((int)Integer.MAX_VALUE, (int)new LinkedBlockingDeque().remainingCapacity());
    }

    public void testConstructor2() {
        try {
            LinkedBlockingDeque q = new LinkedBlockingDeque(0);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor3() {
        try {
            LinkedBlockingDeque q = new LinkedBlockingDeque(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor4() {
        try {
            Integer[] ints = new Integer[20];
            LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor5() {
        try {
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor6() {
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(Arrays.asList(ints));
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((Object)ints[i], (Object)q.poll());
        }
    }

    public void testEmptyFull() {
        LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(2);
        LinkedBlockingDequeTest.assertTrue((boolean)q.isEmpty());
        LinkedBlockingDequeTest.assertEquals((String)"should have room for 2", (int)2, (int)q.remainingCapacity());
        q.add(one);
        LinkedBlockingDequeTest.assertFalse((boolean)q.isEmpty());
        q.add(two);
        LinkedBlockingDequeTest.assertFalse((boolean)q.isEmpty());
        LinkedBlockingDequeTest.assertEquals((int)0, (int)q.remainingCapacity());
        LinkedBlockingDequeTest.assertFalse((boolean)q.offer(three));
    }

    public void testRemainingCapacity() {
        int i;
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((int)i, (int)q.remainingCapacity());
            LinkedBlockingDequeTest.assertEquals((int)(20 - i), (int)q.size());
            q.remove();
        }
        for (i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((int)(20 - i), (int)q.remainingCapacity());
            LinkedBlockingDequeTest.assertEquals((int)i, (int)q.size());
            q.add(new Integer(i));
        }
    }

    public void testOfferNull() {
        try {
            LinkedBlockingDeque<Object> q = new LinkedBlockingDeque<Object>(1);
            q.offer(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddNull() {
        try {
            LinkedBlockingDeque<Object> q = new LinkedBlockingDeque<Object>(1);
            q.add(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPushNull() {
        try {
            LinkedBlockingDeque<Object> q = new LinkedBlockingDeque<Object>(1);
            q.push(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPush() {
        try {
            LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(20);
            for (int i = 0; i < 20; ++i) {
                Integer I = new Integer(i);
                q.push(I);
                LinkedBlockingDequeTest.assertEquals((Object)I, q.peek());
            }
            LinkedBlockingDequeTest.assertEquals((int)0, (int)q.remainingCapacity());
            q.push(new Integer(20));
            this.shouldThrow();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testPushWithPeek() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(3);
        q.pollLast();
        q.push(four);
        LinkedBlockingDequeTest.assertSame((Object)four, (Object)q.peekFirst());
    }

    public void testPop() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.pop());
        }
        try {
            q.pop();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testOffer() {
        LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(1);
        LinkedBlockingDequeTest.assertTrue((boolean)q.offer(zero));
        LinkedBlockingDequeTest.assertFalse((boolean)q.offer(one));
    }

    public void testAdd() {
        try {
            LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(20);
            for (int i = 0; i < 20; ++i) {
                LinkedBlockingDequeTest.assertTrue((boolean)q.add(new Integer(i)));
            }
            LinkedBlockingDequeTest.assertEquals((int)0, (int)q.remainingCapacity());
            q.add(new Integer(20));
            this.shouldThrow();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testAddAll1() {
        try {
            LinkedBlockingDeque q = new LinkedBlockingDeque(1);
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAllSelf() {
        try {
            LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
            q.addAll(q);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddAll2() {
        try {
            LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(20);
            Integer[] ints = new Integer[20];
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll3() {
        try {
            LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(20);
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll4() {
        try {
            LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(1);
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 20; ++i) {
                ints[i] = new Integer(i);
            }
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testAddAll5() {
        Integer[] empty = new Integer[]{};
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(20);
        LinkedBlockingDequeTest.assertFalse((boolean)q.addAll(Arrays.asList(empty)));
        LinkedBlockingDequeTest.assertTrue((boolean)q.addAll(Arrays.asList(ints)));
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((Object)ints[i], q.poll());
        }
    }

    public void testPutNull() throws InterruptedException {
        try {
            LinkedBlockingDeque<Object> q = new LinkedBlockingDeque<Object>(20);
            q.put(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPut() throws InterruptedException {
        LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(20);
        for (int i = 0; i < 20; ++i) {
            Integer I = new Integer(i);
            q.put(I);
            LinkedBlockingDequeTest.assertTrue((boolean)q.contains(I));
        }
        LinkedBlockingDequeTest.assertEquals((int)0, (int)q.remainingCapacity());
    }

    public void testBlockingPut() throws InterruptedException {
        final LinkedBlockingDeque q = new LinkedBlockingDeque(20);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                for (int i = 0; i < 20; ++i) {
                    q.put(i);
                }
                Assert.assertEquals((int)20, (int)q.size());
                Assert.assertEquals((int)0, (int)q.remainingCapacity());
                try {
                    q.put(99);
                    LinkedBlockingDequeTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        LinkedBlockingDequeTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
        LinkedBlockingDequeTest.assertEquals((int)20, (int)q.size());
        LinkedBlockingDequeTest.assertEquals((int)0, (int)q.remainingCapacity());
    }

    public void testPutWithTake() throws InterruptedException {
        int capacity = 2;
        final LinkedBlockingDeque q = new LinkedBlockingDeque(2);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                for (int i = 0; i < 3; ++i) {
                    q.put(i);
                }
                try {
                    q.put(99);
                    LinkedBlockingDequeTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        LinkedBlockingDequeTest.delay(SHORT_DELAY_MS);
        LinkedBlockingDequeTest.assertEquals((int)q.remainingCapacity(), (int)0);
        LinkedBlockingDequeTest.assertEquals((Object)0, q.take());
        LinkedBlockingDequeTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
        LinkedBlockingDequeTest.assertEquals((int)q.remainingCapacity(), (int)0);
    }

    public void testTimedOffer() throws InterruptedException {
        final LinkedBlockingDeque q = new LinkedBlockingDeque(2);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                q.put(new Object());
                q.put(new Object());
                Assert.assertFalse((boolean)q.offer(new Object(), JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                try {
                    q.offer(new Object(), JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
                    LinkedBlockingDequeTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        LinkedBlockingDequeTest.delay(SMALL_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTake() throws InterruptedException {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.take());
        }
    }

    public void testBlockingTake() throws InterruptedException {
        final LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                for (int i = 0; i < 20; ++i) {
                    Assert.assertEquals((Object)i, q.take());
                }
                try {
                    q.take();
                    LinkedBlockingDequeTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        LinkedBlockingDequeTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testPoll() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.poll());
        }
        LinkedBlockingDequeTest.assertNull((Object)q.poll());
    }

    public void testTimedPoll0() throws InterruptedException {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.poll(0L, TimeUnit.MILLISECONDS));
        }
        LinkedBlockingDequeTest.assertNull((Object)q.poll(0L, TimeUnit.MILLISECONDS));
    }

    public void testTimedPoll() throws InterruptedException {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.poll(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        }
        LinkedBlockingDequeTest.assertNull((Object)q.poll(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
    }

    public void testInterruptedTimedPoll() throws InterruptedException {
        final LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        final CountDownLatch aboutToWait = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                for (int i = 0; i < 20; ++i) {
                    long t0 = System.nanoTime();
                    Assert.assertEquals((int)i, (int)((Integer)q.poll(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS)));
                    Assert.assertTrue((LinkedBlockingDequeTest.this.millisElapsedSince(t0) < JSR166TestCase.SMALL_DELAY_MS ? 1 : 0) != 0);
                }
                long t0 = System.nanoTime();
                aboutToWait.countDown();
                try {
                    q.poll(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
                    LinkedBlockingDequeTest.this.shouldThrow();
                }
                catch (InterruptedException success) {
                    Assert.assertTrue((LinkedBlockingDequeTest.this.millisElapsedSince(t0) < JSR166TestCase.MEDIUM_DELAY_MS ? 1 : 0) != 0);
                }
            }
        });
        aboutToWait.await();
        this.waitForThreadToEnterWaitState(t, SMALL_DELAY_MS);
        t.interrupt();
        this.awaitTermination(t, MEDIUM_DELAY_MS);
        this.checkEmpty(q);
    }

    public void testPutFirstNull() throws InterruptedException {
        try {
            LinkedBlockingDeque<Object> q = new LinkedBlockingDeque<Object>(20);
            q.putFirst(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPutFirst() throws InterruptedException {
        LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(20);
        for (int i = 0; i < 20; ++i) {
            Integer I = new Integer(i);
            q.putFirst(I);
            LinkedBlockingDequeTest.assertTrue((boolean)q.contains(I));
        }
        LinkedBlockingDequeTest.assertEquals((int)0, (int)q.remainingCapacity());
    }

    public void testBlockingPutFirst() throws InterruptedException {
        final LinkedBlockingDeque q = new LinkedBlockingDeque(20);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                for (int i = 0; i < 20; ++i) {
                    q.putFirst(i);
                }
                Assert.assertEquals((int)20, (int)q.size());
                Assert.assertEquals((int)0, (int)q.remainingCapacity());
                try {
                    q.putFirst(99);
                    LinkedBlockingDequeTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        LinkedBlockingDequeTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
        LinkedBlockingDequeTest.assertEquals((int)20, (int)q.size());
        LinkedBlockingDequeTest.assertEquals((int)0, (int)q.remainingCapacity());
    }

    public void testPutFirstWithTake() throws InterruptedException {
        int capacity = 2;
        final LinkedBlockingDeque q = new LinkedBlockingDeque(2);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                for (int i = 0; i < 3; ++i) {
                    q.putFirst(i);
                }
                try {
                    q.putFirst(99);
                    LinkedBlockingDequeTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        LinkedBlockingDequeTest.delay(SHORT_DELAY_MS);
        LinkedBlockingDequeTest.assertEquals((int)q.remainingCapacity(), (int)0);
        LinkedBlockingDequeTest.assertEquals((Object)1, q.take());
        LinkedBlockingDequeTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
        LinkedBlockingDequeTest.assertEquals((int)q.remainingCapacity(), (int)0);
    }

    public void testTimedOfferFirst() throws InterruptedException {
        final LinkedBlockingDeque q = new LinkedBlockingDeque(2);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                q.putFirst(new Object());
                q.putFirst(new Object());
                Assert.assertFalse((boolean)q.offerFirst(new Object(), JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                try {
                    q.offerFirst(new Object(), JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
                    LinkedBlockingDequeTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        LinkedBlockingDequeTest.delay(SMALL_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTakeFirst() throws InterruptedException {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.takeFirst());
        }
    }

    public void testTakeFirstFromEmpty() throws InterruptedException {
        final LinkedBlockingDeque q = new LinkedBlockingDeque(2);
        JSR166TestCase.ThreadShouldThrow t = new JSR166TestCase.ThreadShouldThrow(InterruptedException.class){

            @Override
            public void realRun() throws InterruptedException {
                q.takeFirst();
            }
        };
        t.start();
        LinkedBlockingDequeTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testBlockingTakeFirst() throws InterruptedException {
        final LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                for (int i = 0; i < 20; ++i) {
                    Assert.assertEquals((Object)i, q.takeFirst());
                }
                try {
                    q.takeFirst();
                    LinkedBlockingDequeTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        LinkedBlockingDequeTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTimedPollFirst0() throws InterruptedException {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.pollFirst(0L, TimeUnit.MILLISECONDS));
        }
        LinkedBlockingDequeTest.assertNull((Object)q.pollFirst(0L, TimeUnit.MILLISECONDS));
    }

    public void testTimedPollFirst() throws InterruptedException {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.pollFirst(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        }
        LinkedBlockingDequeTest.assertNull((Object)q.pollFirst(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
    }

    public void testInterruptedTimedPollFirst() throws InterruptedException {
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                LinkedBlockingDeque q = LinkedBlockingDequeTest.this.populatedDeque(20);
                for (int i = 0; i < 20; ++i) {
                    Assert.assertEquals((Object)i, q.pollFirst(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                }
                try {
                    q.pollFirst(JSR166TestCase.SMALL_DELAY_MS, TimeUnit.MILLISECONDS);
                    LinkedBlockingDequeTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        LinkedBlockingDequeTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTimedPollFirstWithOfferFirst() throws InterruptedException {
        final LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(2);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertNull(q.pollFirst(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertSame((Object)JSR166TestCase.zero, q.pollFirst(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS));
                try {
                    q.pollFirst(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
                    LinkedBlockingDequeTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        LinkedBlockingDequeTest.delay(SMALL_DELAY_MS);
        LinkedBlockingDequeTest.assertTrue((boolean)q.offerFirst(zero, SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        t.interrupt();
        t.join();
    }

    public void testPutLastNull() throws InterruptedException {
        try {
            LinkedBlockingDeque<Object> q = new LinkedBlockingDeque<Object>(20);
            q.putLast(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPutLast() throws InterruptedException {
        LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(20);
        for (int i = 0; i < 20; ++i) {
            Integer I = new Integer(i);
            q.putLast(I);
            LinkedBlockingDequeTest.assertTrue((boolean)q.contains(I));
        }
        LinkedBlockingDequeTest.assertEquals((int)0, (int)q.remainingCapacity());
    }

    public void testBlockingPutLast() throws InterruptedException {
        final LinkedBlockingDeque q = new LinkedBlockingDeque(20);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                for (int i = 0; i < 20; ++i) {
                    q.putLast(i);
                }
                Assert.assertEquals((int)20, (int)q.size());
                Assert.assertEquals((int)0, (int)q.remainingCapacity());
                try {
                    q.putLast(99);
                    LinkedBlockingDequeTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        LinkedBlockingDequeTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
        LinkedBlockingDequeTest.assertEquals((int)20, (int)q.size());
        LinkedBlockingDequeTest.assertEquals((int)0, (int)q.remainingCapacity());
    }

    public void testPutLastWithTake() throws InterruptedException {
        int capacity = 2;
        final LinkedBlockingDeque q = new LinkedBlockingDeque(2);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                for (int i = 0; i < 3; ++i) {
                    q.putLast(i);
                }
                try {
                    q.putLast(99);
                    LinkedBlockingDequeTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        LinkedBlockingDequeTest.delay(SHORT_DELAY_MS);
        LinkedBlockingDequeTest.assertEquals((int)q.remainingCapacity(), (int)0);
        LinkedBlockingDequeTest.assertEquals((Object)0, q.take());
        LinkedBlockingDequeTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
        LinkedBlockingDequeTest.assertEquals((int)q.remainingCapacity(), (int)0);
    }

    public void testTimedOfferLast() throws InterruptedException {
        final LinkedBlockingDeque q = new LinkedBlockingDeque(2);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                q.putLast(new Object());
                q.putLast(new Object());
                Assert.assertFalse((boolean)q.offerLast(new Object(), JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                try {
                    q.offerLast(new Object(), JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
                    LinkedBlockingDequeTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        LinkedBlockingDequeTest.delay(SMALL_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTakeLast() throws InterruptedException {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((Object)(20 - i - 1), (Object)q.takeLast());
        }
    }

    public void testTakeLastFromEmpty() throws InterruptedException {
        final LinkedBlockingDeque q = new LinkedBlockingDeque(2);
        JSR166TestCase.ThreadShouldThrow t = new JSR166TestCase.ThreadShouldThrow(InterruptedException.class){

            @Override
            public void realRun() throws InterruptedException {
                q.takeLast();
            }
        };
        t.start();
        LinkedBlockingDequeTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testBlockingTakeLast() throws InterruptedException {
        final LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                for (int i = 0; i < 20; ++i) {
                    Assert.assertEquals((Object)(19 - i), q.takeLast());
                }
                try {
                    q.takeLast();
                    LinkedBlockingDequeTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        LinkedBlockingDequeTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTimedPollLast0() throws InterruptedException {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((Object)(20 - i - 1), (Object)q.pollLast(0L, TimeUnit.MILLISECONDS));
        }
        LinkedBlockingDequeTest.assertNull((Object)q.pollLast(0L, TimeUnit.MILLISECONDS));
    }

    public void testTimedPollLast() throws InterruptedException {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((Object)(20 - i - 1), (Object)q.pollLast(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        }
        LinkedBlockingDequeTest.assertNull((Object)q.pollLast(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
    }

    public void testInterruptedTimedPollLast() throws InterruptedException {
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                LinkedBlockingDeque q = LinkedBlockingDequeTest.this.populatedDeque(20);
                for (int i = 0; i < 20; ++i) {
                    Assert.assertEquals((Object)(20 - i - 1), q.pollLast(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                }
                try {
                    q.pollLast(JSR166TestCase.SMALL_DELAY_MS, TimeUnit.MILLISECONDS);
                    LinkedBlockingDequeTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        LinkedBlockingDequeTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTimedPollWithOfferLast() throws InterruptedException {
        final LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(2);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertNull(q.poll(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertSame((Object)JSR166TestCase.zero, q.poll(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS));
                try {
                    q.poll(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
                    LinkedBlockingDequeTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        LinkedBlockingDequeTest.delay(SMALL_DELAY_MS);
        LinkedBlockingDequeTest.assertTrue((boolean)q.offerLast(zero, SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        t.interrupt();
        t.join();
    }

    public void testElement() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals((Object)i, (Object)q.element());
            q.poll();
        }
        try {
            q.element();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemoveElement() {
        int i;
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (i = 1; i < 20; i += 2) {
            LinkedBlockingDequeTest.assertTrue((boolean)q.contains(i));
            LinkedBlockingDequeTest.assertTrue((boolean)q.remove(i));
            LinkedBlockingDequeTest.assertFalse((boolean)q.contains(i));
            LinkedBlockingDequeTest.assertTrue((boolean)q.contains(i - 1));
        }
        for (i = 0; i < 20; i += 2) {
            LinkedBlockingDequeTest.assertTrue((boolean)q.contains(i));
            LinkedBlockingDequeTest.assertTrue((boolean)q.remove(i));
            LinkedBlockingDequeTest.assertFalse((boolean)q.contains(i));
            LinkedBlockingDequeTest.assertFalse((boolean)q.remove(i + 1));
            LinkedBlockingDequeTest.assertFalse((boolean)q.contains(i + 1));
        }
        LinkedBlockingDequeTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContains() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertTrue((boolean)q.contains(new Integer(i)));
            q.poll();
            LinkedBlockingDequeTest.assertFalse((boolean)q.contains(new Integer(i)));
        }
    }

    public void testClear() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        q.clear();
        LinkedBlockingDequeTest.assertTrue((boolean)q.isEmpty());
        LinkedBlockingDequeTest.assertEquals((int)0, (int)q.size());
        LinkedBlockingDequeTest.assertEquals((int)20, (int)q.remainingCapacity());
        q.add(one);
        LinkedBlockingDequeTest.assertFalse((boolean)q.isEmpty());
        LinkedBlockingDequeTest.assertTrue((boolean)q.contains(one));
        q.clear();
        LinkedBlockingDequeTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContainsAll() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        LinkedBlockingDeque<Integer> p = new LinkedBlockingDeque<Integer>(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertTrue((boolean)q.containsAll(p));
            LinkedBlockingDequeTest.assertFalse((boolean)p.containsAll(q));
            p.add(new Integer(i));
        }
        LinkedBlockingDequeTest.assertTrue((boolean)p.containsAll(q));
    }

    public void testRetainAll() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        LinkedBlockingDeque<Integer> p = this.populatedDeque(20);
        for (int i = 0; i < 20; ++i) {
            boolean changed = q.retainAll(p);
            if (i == 0) {
                LinkedBlockingDequeTest.assertFalse((boolean)changed);
            } else {
                LinkedBlockingDequeTest.assertTrue((boolean)changed);
            }
            LinkedBlockingDequeTest.assertTrue((boolean)q.containsAll(p));
            LinkedBlockingDequeTest.assertEquals((int)(20 - i), (int)q.size());
            p.remove();
        }
    }

    public void testRemoveAll() {
        for (int i = 1; i < 20; ++i) {
            LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
            LinkedBlockingDeque<Integer> p = this.populatedDeque(i);
            LinkedBlockingDequeTest.assertTrue((boolean)q.removeAll(p));
            LinkedBlockingDequeTest.assertEquals((int)(20 - i), (int)q.size());
            for (int j = 0; j < i; ++j) {
                Integer I = p.remove();
                LinkedBlockingDequeTest.assertFalse((boolean)q.contains(I));
            }
        }
    }

    public void testToArray() throws InterruptedException {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        Object[] o = q.toArray();
        for (int i = 0; i < o.length; ++i) {
            LinkedBlockingDequeTest.assertSame((Object)o[i], (Object)q.poll());
        }
    }

    public void testToArray2() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        Integer[] ints = new Integer[20];
        Integer[] array = q.toArray(ints);
        LinkedBlockingDequeTest.assertSame((Object)ints, (Object)array);
        for (int i = 0; i < ints.length; ++i) {
            LinkedBlockingDequeTest.assertSame((Object)ints[i], (Object)q.remove());
        }
    }

    public void testToArray_NullArg() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        try {
            q.toArray((T[])null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToArray1_BadArg() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        try {
            q.toArray(new String[10]);
            this.shouldThrow();
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    public void testIterator() throws InterruptedException {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        Iterator<Integer> it = q.iterator();
        while (it.hasNext()) {
            LinkedBlockingDequeTest.assertEquals((Object)it.next(), (Object)q.take());
        }
    }

    public void testIteratorRemove() {
        LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(3);
        q.add(two);
        q.add(one);
        q.add(three);
        Iterator it = q.iterator();
        it.next();
        it.remove();
        it = q.iterator();
        LinkedBlockingDequeTest.assertSame(it.next(), (Object)one);
        LinkedBlockingDequeTest.assertSame(it.next(), (Object)three);
        LinkedBlockingDequeTest.assertFalse((boolean)it.hasNext());
    }

    public void testIteratorOrdering() {
        LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(3);
        q.add(one);
        q.add(two);
        q.add(three);
        LinkedBlockingDequeTest.assertEquals((int)0, (int)q.remainingCapacity());
        int k = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            LinkedBlockingDequeTest.assertEquals((Object)(++k), it.next());
        }
        LinkedBlockingDequeTest.assertEquals((int)3, (int)k);
    }

    public void testWeaklyConsistentIteration() {
        LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(3);
        q.add(one);
        q.add(two);
        q.add(three);
        Iterator it = q.iterator();
        while (it.hasNext()) {
            q.remove();
            it.next();
        }
        LinkedBlockingDequeTest.assertEquals((int)0, (int)q.size());
    }

    public void testDescendingIterator() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        int i = 0;
        Iterator<Integer> it = q.descendingIterator();
        while (it.hasNext()) {
            LinkedBlockingDequeTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        LinkedBlockingDequeTest.assertEquals((int)i, (int)20);
        LinkedBlockingDequeTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            this.shouldThrow();
        }
        catch (NoSuchElementException success) {
            // empty catch block
        }
    }

    public void testDescendingIteratorOrdering() {
        LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>();
        for (int iters = 0; iters < 100; ++iters) {
            q.add(new Integer(3));
            q.add(new Integer(2));
            q.add(new Integer(1));
            int k = 0;
            Iterator it = q.descendingIterator();
            while (it.hasNext()) {
                LinkedBlockingDequeTest.assertEquals((Object)(++k), it.next());
            }
            LinkedBlockingDequeTest.assertEquals((int)3, (int)k);
            q.remove();
            q.remove();
            q.remove();
        }
    }

    public void testDescendingIteratorRemove() {
        LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>();
        for (int iters = 0; iters < 100; ++iters) {
            q.add(new Integer(3));
            q.add(new Integer(2));
            q.add(new Integer(1));
            Iterator it = q.descendingIterator();
            LinkedBlockingDequeTest.assertEquals(it.next(), (Object)new Integer(1));
            it.remove();
            LinkedBlockingDequeTest.assertEquals(it.next(), (Object)new Integer(2));
            it = q.descendingIterator();
            LinkedBlockingDequeTest.assertEquals(it.next(), (Object)new Integer(2));
            LinkedBlockingDequeTest.assertEquals(it.next(), (Object)new Integer(3));
            it.remove();
            LinkedBlockingDequeTest.assertFalse((boolean)it.hasNext());
            q.remove();
        }
    }

    public void testToString() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        String s = q.toString();
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testOfferInExecutor() {
        final LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>(2);
        q.add(one);
        q.add(two);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertFalse((boolean)q.offer(JSR166TestCase.three));
                Assert.assertTrue((boolean)q.offer(JSR166TestCase.three, JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertEquals((int)0, (int)q.remainingCapacity());
            }
        });
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                JSR166TestCase.delay(JSR166TestCase.SMALL_DELAY_MS);
                Assert.assertSame((Object)JSR166TestCase.one, q.take());
            }
        });
        this.joinPool(executor);
    }

    public void testPollInExecutor() {
        final LinkedBlockingDeque q = new LinkedBlockingDeque(2);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertNull(q.poll());
                Assert.assertSame((Object)JSR166TestCase.one, q.poll(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertTrue((boolean)q.isEmpty());
            }
        });
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                JSR166TestCase.delay(JSR166TestCase.SMALL_DELAY_MS);
                q.put(JSR166TestCase.one);
            }
        });
        this.joinPool(executor);
    }

    public void testSerialization() throws Exception {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        LinkedBlockingDeque r = (LinkedBlockingDeque)in.readObject();
        LinkedBlockingDequeTest.assertEquals((int)q.size(), (int)r.size());
        while (!q.isEmpty()) {
            LinkedBlockingDequeTest.assertEquals((Object)q.remove(), r.remove());
        }
    }

    public void testDrainToNull() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        try {
            q.drainTo(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDrainToSelf() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        try {
            q.drainTo(q);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDrainTo() {
        int i;
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        ArrayList l = new ArrayList();
        q.drainTo(l);
        LinkedBlockingDequeTest.assertEquals((int)q.size(), (int)0);
        LinkedBlockingDequeTest.assertEquals((int)l.size(), (int)20);
        for (i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals(l.get(i), (Object)new Integer(i));
        }
        q.add(zero);
        q.add(one);
        LinkedBlockingDequeTest.assertFalse((boolean)q.isEmpty());
        LinkedBlockingDequeTest.assertTrue((boolean)q.contains(zero));
        LinkedBlockingDequeTest.assertTrue((boolean)q.contains(one));
        l.clear();
        q.drainTo(l);
        LinkedBlockingDequeTest.assertEquals((int)q.size(), (int)0);
        LinkedBlockingDequeTest.assertEquals((int)l.size(), (int)2);
        for (i = 0; i < 2; ++i) {
            LinkedBlockingDequeTest.assertEquals(l.get(i), (Object)new Integer(i));
        }
    }

    public void testDrainToWithActivePut() throws InterruptedException {
        final LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                q.put(new Integer(21));
            }
        });
        t.start();
        ArrayList l = new ArrayList();
        q.drainTo(l);
        LinkedBlockingDequeTest.assertTrue((l.size() >= 20 ? 1 : 0) != 0);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingDequeTest.assertEquals(l.get(i), (Object)new Integer(i));
        }
        t.join();
        LinkedBlockingDequeTest.assertTrue((q.size() + l.size() >= 20 ? 1 : 0) != 0);
    }

    public void testDrainToNullN() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        try {
            q.drainTo(null, 0);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDrainToSelfN() {
        LinkedBlockingDeque<Integer> q = this.populatedDeque(20);
        try {
            q.drainTo(q, 0);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDrainToN() {
        LinkedBlockingDeque<Integer> q = new LinkedBlockingDeque<Integer>();
        for (int i = 0; i < 22; ++i) {
            for (int j = 0; j < 20; ++j) {
                LinkedBlockingDequeTest.assertTrue((boolean)q.offer(new Integer(j)));
            }
            ArrayList l = new ArrayList();
            q.drainTo(l, i);
            int k = i < 20 ? i : 20;
            LinkedBlockingDequeTest.assertEquals((int)l.size(), (int)k);
            LinkedBlockingDequeTest.assertEquals((int)q.size(), (int)(20 - k));
            for (int j = 0; j < k; ++j) {
                LinkedBlockingDequeTest.assertEquals(l.get(j), (Object)new Integer(j));
            }
            while (q.poll() != null) {
            }
        }
    }

    public static class Bounded
    extends BlockingQueueTest {
        @Override
        protected BlockingQueue emptyCollection() {
            return new LinkedBlockingDeque(20);
        }
    }

    public static class Unbounded
    extends BlockingQueueTest {
        @Override
        protected BlockingQueue emptyCollection() {
            return new LinkedBlockingDeque();
        }
    }
}

