/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.Test;
import junit.textui.TestRunner;

public class LinkedBlockingQueueTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)LinkedBlockingQueueTest.suite());
    }

    public static Test suite() {
        return LinkedBlockingQueueTest.newTestSuite(LinkedBlockingQueueTest.class, new Unbounded().testSuite(), new Bounded().testSuite());
    }

    private LinkedBlockingQueue<Integer> populatedQueue(int n) {
        LinkedBlockingQueue<Integer> q = new LinkedBlockingQueue<Integer>(n);
        LinkedBlockingQueueTest.assertTrue((boolean)q.isEmpty());
        for (int i = 0; i < n; ++i) {
            LinkedBlockingQueueTest.assertTrue((boolean)q.offer(new Integer(i)));
        }
        LinkedBlockingQueueTest.assertFalse((boolean)q.isEmpty());
        LinkedBlockingQueueTest.assertEquals((int)0, (int)q.remainingCapacity());
        LinkedBlockingQueueTest.assertEquals((int)n, (int)q.size());
        return q;
    }

    public void testConstructor1() {
        LinkedBlockingQueueTest.assertEquals((int)20, (int)new LinkedBlockingQueue(20).remainingCapacity());
        LinkedBlockingQueueTest.assertEquals((int)Integer.MAX_VALUE, (int)new LinkedBlockingQueue().remainingCapacity());
    }

    public void testConstructor2() {
        try {
            LinkedBlockingQueue q = new LinkedBlockingQueue(0);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor3() {
        try {
            LinkedBlockingQueue q = new LinkedBlockingQueue(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor4() {
        try {
            Integer[] ints = new Integer[20];
            LinkedBlockingQueue<Integer> q = new LinkedBlockingQueue<Integer>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor5() {
        try {
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            LinkedBlockingQueue<Integer> q = new LinkedBlockingQueue<Integer>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor6() {
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        LinkedBlockingQueue<Integer> q = new LinkedBlockingQueue<Integer>(Arrays.asList(ints));
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingQueueTest.assertEquals((Object)ints[i], (Object)q.poll());
        }
    }

    public void testEmptyFull() {
        LinkedBlockingQueue<Integer> q = new LinkedBlockingQueue<Integer>(2);
        LinkedBlockingQueueTest.assertTrue((boolean)q.isEmpty());
        LinkedBlockingQueueTest.assertEquals((String)"should have room for 2", (int)2, (int)q.remainingCapacity());
        q.add(one);
        LinkedBlockingQueueTest.assertFalse((boolean)q.isEmpty());
        q.add(two);
        LinkedBlockingQueueTest.assertFalse((boolean)q.isEmpty());
        LinkedBlockingQueueTest.assertEquals((int)0, (int)q.remainingCapacity());
        LinkedBlockingQueueTest.assertFalse((boolean)q.offer(three));
    }

    public void testRemainingCapacity() {
        int i;
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        for (i = 0; i < 20; ++i) {
            LinkedBlockingQueueTest.assertEquals((int)i, (int)q.remainingCapacity());
            LinkedBlockingQueueTest.assertEquals((int)(20 - i), (int)q.size());
            q.remove();
        }
        for (i = 0; i < 20; ++i) {
            LinkedBlockingQueueTest.assertEquals((int)(20 - i), (int)q.remainingCapacity());
            LinkedBlockingQueueTest.assertEquals((int)i, (int)q.size());
            q.add(new Integer(i));
        }
    }

    public void testOfferNull() {
        try {
            LinkedBlockingQueue<Object> q = new LinkedBlockingQueue<Object>(1);
            q.offer(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddNull() {
        try {
            LinkedBlockingQueue<Object> q = new LinkedBlockingQueue<Object>(1);
            q.add(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testOffer() {
        LinkedBlockingQueue<Integer> q = new LinkedBlockingQueue<Integer>(1);
        LinkedBlockingQueueTest.assertTrue((boolean)q.offer(zero));
        LinkedBlockingQueueTest.assertFalse((boolean)q.offer(one));
    }

    public void testAdd() {
        try {
            LinkedBlockingQueue<Integer> q = new LinkedBlockingQueue<Integer>(20);
            for (int i = 0; i < 20; ++i) {
                LinkedBlockingQueueTest.assertTrue((boolean)q.add(new Integer(i)));
            }
            LinkedBlockingQueueTest.assertEquals((int)0, (int)q.remainingCapacity());
            q.add(new Integer(20));
            this.shouldThrow();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testAddAll1() {
        try {
            LinkedBlockingQueue q = new LinkedBlockingQueue(1);
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAllSelf() {
        try {
            LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
            q.addAll(q);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddAll2() {
        try {
            LinkedBlockingQueue<Integer> q = new LinkedBlockingQueue<Integer>(20);
            Integer[] ints = new Integer[20];
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll3() {
        try {
            LinkedBlockingQueue<Integer> q = new LinkedBlockingQueue<Integer>(20);
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll4() {
        try {
            LinkedBlockingQueue<Integer> q = new LinkedBlockingQueue<Integer>(1);
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 20; ++i) {
                ints[i] = new Integer(i);
            }
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testAddAll5() {
        Integer[] empty = new Integer[]{};
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        LinkedBlockingQueue<Integer> q = new LinkedBlockingQueue<Integer>(20);
        LinkedBlockingQueueTest.assertFalse((boolean)q.addAll(Arrays.asList(empty)));
        LinkedBlockingQueueTest.assertTrue((boolean)q.addAll(Arrays.asList(ints)));
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingQueueTest.assertEquals((Object)ints[i], q.poll());
        }
    }

    public void testPutNull() throws InterruptedException {
        try {
            LinkedBlockingQueue<Object> q = new LinkedBlockingQueue<Object>(20);
            q.put(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPut() throws InterruptedException {
        LinkedBlockingQueue<Integer> q = new LinkedBlockingQueue<Integer>(20);
        for (int i = 0; i < 20; ++i) {
            Integer I = new Integer(i);
            q.put(I);
            LinkedBlockingQueueTest.assertTrue((boolean)q.contains(I));
        }
        LinkedBlockingQueueTest.assertEquals((int)0, (int)q.remainingCapacity());
    }

    public void testBlockingPut() throws InterruptedException {
        final LinkedBlockingQueue q = new LinkedBlockingQueue(20);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                for (int i = 0; i < 20; ++i) {
                    q.put(i);
                }
                Assert.assertEquals((int)20, (int)q.size());
                Assert.assertEquals((int)0, (int)q.remainingCapacity());
                try {
                    q.put(99);
                    LinkedBlockingQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        LinkedBlockingQueueTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
        LinkedBlockingQueueTest.assertEquals((int)20, (int)q.size());
        LinkedBlockingQueueTest.assertEquals((int)0, (int)q.remainingCapacity());
    }

    public void testPutWithTake() throws InterruptedException {
        int capacity = 2;
        final LinkedBlockingQueue q = new LinkedBlockingQueue(2);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                for (int i = 0; i < 3; ++i) {
                    q.put(i);
                }
                try {
                    q.put(99);
                    LinkedBlockingQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        LinkedBlockingQueueTest.delay(SHORT_DELAY_MS);
        LinkedBlockingQueueTest.assertEquals((int)q.remainingCapacity(), (int)0);
        LinkedBlockingQueueTest.assertEquals((Object)0, q.take());
        LinkedBlockingQueueTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
        LinkedBlockingQueueTest.assertEquals((int)q.remainingCapacity(), (int)0);
    }

    public void testTimedOffer() throws InterruptedException {
        final LinkedBlockingQueue q = new LinkedBlockingQueue(2);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                q.put(new Object());
                q.put(new Object());
                Assert.assertFalse((boolean)q.offer(new Object(), JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                try {
                    q.offer(new Object(), JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
                    LinkedBlockingQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        LinkedBlockingQueueTest.delay(SMALL_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTake() throws InterruptedException {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingQueueTest.assertEquals((Object)i, (Object)q.take());
        }
    }

    public void testBlockingTake() throws InterruptedException {
        final LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                for (int i = 0; i < 20; ++i) {
                    Assert.assertEquals((Object)i, q.take());
                }
                try {
                    q.take();
                    LinkedBlockingQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        LinkedBlockingQueueTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testPoll() {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingQueueTest.assertEquals((Object)i, (Object)q.poll());
        }
        LinkedBlockingQueueTest.assertNull((Object)q.poll());
    }

    public void testTimedPoll0() throws InterruptedException {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingQueueTest.assertEquals((Object)i, (Object)q.poll(0L, TimeUnit.MILLISECONDS));
        }
        LinkedBlockingQueueTest.assertNull((Object)q.poll(0L, TimeUnit.MILLISECONDS));
    }

    public void testTimedPoll() throws InterruptedException {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingQueueTest.assertEquals((Object)i, (Object)q.poll(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        }
        LinkedBlockingQueueTest.assertNull((Object)q.poll(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
    }

    public void testInterruptedTimedPoll() throws InterruptedException {
        final LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        final CountDownLatch aboutToWait = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                for (int i = 0; i < 20; ++i) {
                    long t0 = System.nanoTime();
                    Assert.assertEquals((int)i, (int)((Integer)q.poll(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS)));
                    Assert.assertTrue((LinkedBlockingQueueTest.this.millisElapsedSince(t0) < JSR166TestCase.SMALL_DELAY_MS ? 1 : 0) != 0);
                }
                long t0 = System.nanoTime();
                aboutToWait.countDown();
                try {
                    q.poll(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
                    LinkedBlockingQueueTest.this.shouldThrow();
                }
                catch (InterruptedException success) {
                    Assert.assertTrue((LinkedBlockingQueueTest.this.millisElapsedSince(t0) < JSR166TestCase.MEDIUM_DELAY_MS ? 1 : 0) != 0);
                }
            }
        });
        aboutToWait.await();
        this.waitForThreadToEnterWaitState(t, SMALL_DELAY_MS);
        t.interrupt();
        this.awaitTermination(t, MEDIUM_DELAY_MS);
        this.checkEmpty(q);
    }

    public void testPeek() {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingQueueTest.assertEquals((Object)i, (Object)q.peek());
            LinkedBlockingQueueTest.assertEquals((Object)i, (Object)q.poll());
            LinkedBlockingQueueTest.assertTrue((q.peek() == null || !((Object)q.peek()).equals(i) ? 1 : 0) != 0);
        }
        LinkedBlockingQueueTest.assertNull((Object)q.peek());
    }

    public void testElement() {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingQueueTest.assertEquals((Object)i, q.element());
            LinkedBlockingQueueTest.assertEquals((Object)i, (Object)q.poll());
        }
        try {
            q.element();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemove() {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingQueueTest.assertEquals((Object)i, q.remove());
        }
        try {
            q.remove();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemoveElement() {
        int i;
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        for (i = 1; i < 20; i += 2) {
            LinkedBlockingQueueTest.assertTrue((boolean)q.contains(i));
            LinkedBlockingQueueTest.assertTrue((boolean)q.remove(i));
            LinkedBlockingQueueTest.assertFalse((boolean)q.contains(i));
            LinkedBlockingQueueTest.assertTrue((boolean)q.contains(i - 1));
        }
        for (i = 0; i < 20; i += 2) {
            LinkedBlockingQueueTest.assertTrue((boolean)q.contains(i));
            LinkedBlockingQueueTest.assertTrue((boolean)q.remove(i));
            LinkedBlockingQueueTest.assertFalse((boolean)q.contains(i));
            LinkedBlockingQueueTest.assertFalse((boolean)q.remove(i + 1));
            LinkedBlockingQueueTest.assertFalse((boolean)q.contains(i + 1));
        }
        LinkedBlockingQueueTest.assertTrue((boolean)q.isEmpty());
    }

    public void testRemoveElementAndAdd() throws InterruptedException {
        LinkedBlockingQueue<Integer> q = new LinkedBlockingQueue<Integer>();
        LinkedBlockingQueueTest.assertTrue((boolean)q.add(new Integer(1)));
        LinkedBlockingQueueTest.assertTrue((boolean)q.add(new Integer(2)));
        LinkedBlockingQueueTest.assertTrue((boolean)q.remove(new Integer(1)));
        LinkedBlockingQueueTest.assertTrue((boolean)q.remove(new Integer(2)));
        LinkedBlockingQueueTest.assertTrue((boolean)q.add(new Integer(3)));
        LinkedBlockingQueueTest.assertTrue((q.take() != null ? 1 : 0) != 0);
    }

    public void testContains() {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingQueueTest.assertTrue((boolean)q.contains(new Integer(i)));
            q.poll();
            LinkedBlockingQueueTest.assertFalse((boolean)q.contains(new Integer(i)));
        }
    }

    public void testClear() {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        q.clear();
        LinkedBlockingQueueTest.assertTrue((boolean)q.isEmpty());
        LinkedBlockingQueueTest.assertEquals((int)0, (int)q.size());
        LinkedBlockingQueueTest.assertEquals((int)20, (int)q.remainingCapacity());
        q.add(one);
        LinkedBlockingQueueTest.assertFalse((boolean)q.isEmpty());
        LinkedBlockingQueueTest.assertTrue((boolean)q.contains(one));
        q.clear();
        LinkedBlockingQueueTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContainsAll() {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        LinkedBlockingQueue<Integer> p = new LinkedBlockingQueue<Integer>(20);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingQueueTest.assertTrue((boolean)q.containsAll(p));
            LinkedBlockingQueueTest.assertFalse((boolean)p.containsAll(q));
            p.add(new Integer(i));
        }
        LinkedBlockingQueueTest.assertTrue((boolean)p.containsAll(q));
    }

    public void testRetainAll() {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        LinkedBlockingQueue<Integer> p = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            boolean changed = q.retainAll(p);
            if (i == 0) {
                LinkedBlockingQueueTest.assertFalse((boolean)changed);
            } else {
                LinkedBlockingQueueTest.assertTrue((boolean)changed);
            }
            LinkedBlockingQueueTest.assertTrue((boolean)q.containsAll(p));
            LinkedBlockingQueueTest.assertEquals((int)(20 - i), (int)q.size());
            p.remove();
        }
    }

    public void testRemoveAll() {
        for (int i = 1; i < 20; ++i) {
            LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
            LinkedBlockingQueue<Integer> p = this.populatedQueue(i);
            LinkedBlockingQueueTest.assertTrue((boolean)q.removeAll(p));
            LinkedBlockingQueueTest.assertEquals((int)(20 - i), (int)q.size());
            for (int j = 0; j < i; ++j) {
                Integer I = (Integer)p.remove();
                LinkedBlockingQueueTest.assertFalse((boolean)q.contains(I));
            }
        }
    }

    public void testToArray() {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        Object[] o = q.toArray();
        for (int i = 0; i < o.length; ++i) {
            LinkedBlockingQueueTest.assertSame((Object)o[i], (Object)q.poll());
        }
    }

    public void testToArray2() throws InterruptedException {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        Integer[] ints = new Integer[20];
        Integer[] array = q.toArray(ints);
        LinkedBlockingQueueTest.assertSame((Object)ints, (Object)array);
        for (int i = 0; i < ints.length; ++i) {
            LinkedBlockingQueueTest.assertSame((Object)ints[i], (Object)q.poll());
        }
    }

    public void testToArray_NullArg() {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        try {
            q.toArray((T[])null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToArray1_BadArg() {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        try {
            q.toArray(new String[10]);
            this.shouldThrow();
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    public void testIterator() throws InterruptedException {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        Iterator<Integer> it = q.iterator();
        while (it.hasNext()) {
            LinkedBlockingQueueTest.assertEquals((Object)it.next(), (Object)q.take());
        }
    }

    public void testIteratorRemove() {
        LinkedBlockingQueue<Integer> q = new LinkedBlockingQueue<Integer>(3);
        q.add(two);
        q.add(one);
        q.add(three);
        Iterator it = q.iterator();
        it.next();
        it.remove();
        it = q.iterator();
        LinkedBlockingQueueTest.assertSame(it.next(), (Object)one);
        LinkedBlockingQueueTest.assertSame(it.next(), (Object)three);
        LinkedBlockingQueueTest.assertFalse((boolean)it.hasNext());
    }

    public void testIteratorOrdering() {
        LinkedBlockingQueue<Integer> q = new LinkedBlockingQueue<Integer>(3);
        q.add(one);
        q.add(two);
        q.add(three);
        LinkedBlockingQueueTest.assertEquals((int)0, (int)q.remainingCapacity());
        int k = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            LinkedBlockingQueueTest.assertEquals((Object)(++k), it.next());
        }
        LinkedBlockingQueueTest.assertEquals((int)3, (int)k);
    }

    public void testWeaklyConsistentIteration() {
        LinkedBlockingQueue<Integer> q = new LinkedBlockingQueue<Integer>(3);
        q.add(one);
        q.add(two);
        q.add(three);
        Iterator it = q.iterator();
        while (it.hasNext()) {
            q.remove();
            it.next();
        }
        LinkedBlockingQueueTest.assertEquals((int)0, (int)q.size());
    }

    public void testToString() {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        String s = q.toString();
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingQueueTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testOfferInExecutor() {
        final LinkedBlockingQueue<Integer> q = new LinkedBlockingQueue<Integer>(2);
        q.add(one);
        q.add(two);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertFalse((boolean)q.offer(JSR166TestCase.three));
                Assert.assertTrue((boolean)q.offer(JSR166TestCase.three, JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertEquals((int)0, (int)q.remainingCapacity());
            }
        });
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                JSR166TestCase.delay(JSR166TestCase.SMALL_DELAY_MS);
                Assert.assertSame((Object)JSR166TestCase.one, q.take());
            }
        });
        this.joinPool(executor);
    }

    public void testPollInExecutor() {
        final LinkedBlockingQueue q = new LinkedBlockingQueue(2);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertNull(q.poll());
                Assert.assertSame((Object)JSR166TestCase.one, q.poll(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertTrue((boolean)q.isEmpty());
            }
        });
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                JSR166TestCase.delay(JSR166TestCase.SMALL_DELAY_MS);
                q.put(JSR166TestCase.one);
            }
        });
        this.joinPool(executor);
    }

    public void testSerialization() throws Exception {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        LinkedBlockingQueue r = (LinkedBlockingQueue)in.readObject();
        LinkedBlockingQueueTest.assertEquals((int)q.size(), (int)r.size());
        while (!q.isEmpty()) {
            LinkedBlockingQueueTest.assertEquals(q.remove(), r.remove());
        }
    }

    public void testDrainToNull() {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        try {
            q.drainTo(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDrainToSelf() {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        try {
            q.drainTo(q);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDrainTo() {
        int i;
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        ArrayList l = new ArrayList();
        q.drainTo(l);
        LinkedBlockingQueueTest.assertEquals((int)q.size(), (int)0);
        LinkedBlockingQueueTest.assertEquals((int)l.size(), (int)20);
        for (i = 0; i < 20; ++i) {
            LinkedBlockingQueueTest.assertEquals(l.get(i), (Object)new Integer(i));
        }
        q.add(zero);
        q.add(one);
        LinkedBlockingQueueTest.assertFalse((boolean)q.isEmpty());
        LinkedBlockingQueueTest.assertTrue((boolean)q.contains(zero));
        LinkedBlockingQueueTest.assertTrue((boolean)q.contains(one));
        l.clear();
        q.drainTo(l);
        LinkedBlockingQueueTest.assertEquals((int)q.size(), (int)0);
        LinkedBlockingQueueTest.assertEquals((int)l.size(), (int)2);
        for (i = 0; i < 2; ++i) {
            LinkedBlockingQueueTest.assertEquals(l.get(i), (Object)new Integer(i));
        }
    }

    public void testDrainToWithActivePut() throws InterruptedException {
        final LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                q.put(new Integer(21));
            }
        });
        t.start();
        ArrayList l = new ArrayList();
        q.drainTo(l);
        LinkedBlockingQueueTest.assertTrue((l.size() >= 20 ? 1 : 0) != 0);
        for (int i = 0; i < 20; ++i) {
            LinkedBlockingQueueTest.assertEquals(l.get(i), (Object)new Integer(i));
        }
        t.join();
        LinkedBlockingQueueTest.assertTrue((q.size() + l.size() >= 20 ? 1 : 0) != 0);
    }

    public void testDrainToNullN() {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        try {
            q.drainTo(null, 0);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDrainToSelfN() {
        LinkedBlockingQueue<Integer> q = this.populatedQueue(20);
        try {
            q.drainTo(q, 0);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDrainToN() {
        LinkedBlockingQueue<Integer> q = new LinkedBlockingQueue<Integer>();
        for (int i = 0; i < 22; ++i) {
            for (int j = 0; j < 20; ++j) {
                LinkedBlockingQueueTest.assertTrue((boolean)q.offer(new Integer(j)));
            }
            ArrayList l = new ArrayList();
            q.drainTo(l, i);
            int k = i < 20 ? i : 20;
            LinkedBlockingQueueTest.assertEquals((int)l.size(), (int)k);
            LinkedBlockingQueueTest.assertEquals((int)q.size(), (int)(20 - k));
            for (int j = 0; j < k; ++j) {
                LinkedBlockingQueueTest.assertEquals(l.get(j), (Object)new Integer(j));
            }
            while (q.poll() != null) {
            }
        }
    }

    public static class Bounded
    extends BlockingQueueTest {
        @Override
        protected BlockingQueue emptyCollection() {
            return new LinkedBlockingQueue(20);
        }
    }

    public static class Unbounded
    extends BlockingQueueTest {
        @Override
        protected BlockingQueue emptyCollection() {
            return new LinkedBlockingQueue();
        }
    }
}

