/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LinkedListTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)LinkedListTest.suite());
    }

    public static Test suite() {
        return new TestSuite(LinkedListTest.class);
    }

    private LinkedList<Integer> populatedQueue(int n) {
        LinkedList<Integer> q = new LinkedList<Integer>();
        LinkedListTest.assertTrue((boolean)q.isEmpty());
        for (int i = 0; i < n; ++i) {
            LinkedListTest.assertTrue((boolean)q.offer(new Integer(i)));
        }
        LinkedListTest.assertFalse((boolean)q.isEmpty());
        LinkedListTest.assertEquals((int)n, (int)q.size());
        return q;
    }

    public void testConstructor1() {
        LinkedListTest.assertEquals((int)0, (int)new LinkedList().size());
    }

    public void testConstructor3() {
        try {
            LinkedList q = new LinkedList(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor6() {
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = i;
        }
        LinkedList<Integer> q = new LinkedList<Integer>(Arrays.asList(ints));
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((Object)ints[i], (Object)q.poll());
        }
    }

    public void testEmpty() {
        LinkedList<Integer> q = new LinkedList<Integer>();
        LinkedListTest.assertTrue((boolean)q.isEmpty());
        q.add(new Integer(1));
        LinkedListTest.assertFalse((boolean)q.isEmpty());
        q.add(new Integer(2));
        q.remove();
        q.remove();
        LinkedListTest.assertTrue((boolean)q.isEmpty());
    }

    public void testSize() {
        int i;
        LinkedList<Integer> q = this.populatedQueue(20);
        for (i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((int)(20 - i), (int)q.size());
            q.remove();
        }
        for (i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((int)i, (int)q.size());
            q.add(new Integer(i));
        }
    }

    public void testOfferNull() {
        LinkedList<Object> q = new LinkedList<Object>();
        q.offer(null);
    }

    public void testOffer() {
        LinkedList<Integer> q = new LinkedList<Integer>();
        LinkedListTest.assertTrue((boolean)q.offer(new Integer(0)));
        LinkedListTest.assertTrue((boolean)q.offer(new Integer(1)));
    }

    public void testAdd() {
        LinkedList<Integer> q = new LinkedList<Integer>();
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((int)i, (int)q.size());
            LinkedListTest.assertTrue((boolean)q.add(new Integer(i)));
        }
    }

    public void testAddAll1() {
        try {
            LinkedList q = new LinkedList();
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll5() {
        Integer[] empty = new Integer[]{};
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = i;
        }
        LinkedList<Integer> q = new LinkedList<Integer>();
        LinkedListTest.assertFalse((boolean)q.addAll(Arrays.asList(empty)));
        LinkedListTest.assertTrue((boolean)q.addAll(Arrays.asList(ints)));
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((Object)ints[i], q.poll());
        }
    }

    public void testAddAll2_IndexOutOfBoundsException() {
        LinkedList<Object> l = new LinkedList<Object>();
        l.add(new Object());
        LinkedList<Object> m = new LinkedList<Object>();
        m.add(new Object());
        try {
            l.addAll(4, m);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testAddAll4_BadIndex() {
        LinkedList<Object> l = new LinkedList<Object>();
        l.add(new Object());
        LinkedList<Object> m = new LinkedList<Object>();
        m.add(new Object());
        try {
            l.addAll(-1, m);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testPoll() {
        LinkedList<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((Object)i, (Object)q.poll());
        }
        LinkedListTest.assertNull((Object)q.poll());
    }

    public void testPeek() {
        LinkedList<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((Object)i, (Object)q.peek());
            LinkedListTest.assertEquals((Object)i, (Object)q.poll());
            LinkedListTest.assertTrue((q.peek() == null || !((Object)q.peek()).equals(i) ? 1 : 0) != 0);
        }
        LinkedListTest.assertNull((Object)q.peek());
    }

    public void testElement() {
        LinkedList<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((Object)i, (Object)q.element());
            LinkedListTest.assertEquals((Object)i, (Object)q.poll());
        }
        try {
            q.element();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemove() {
        LinkedList<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((Object)i, (Object)q.remove());
        }
        try {
            q.remove();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemoveElement() {
        int i;
        LinkedList<Integer> q = this.populatedQueue(20);
        for (i = 1; i < 20; i += 2) {
            LinkedListTest.assertTrue((boolean)q.contains(i));
            LinkedListTest.assertTrue((boolean)q.remove((Object)i));
            LinkedListTest.assertFalse((boolean)q.contains(i));
            LinkedListTest.assertTrue((boolean)q.contains(i - 1));
        }
        for (i = 0; i < 20; i += 2) {
            LinkedListTest.assertTrue((boolean)q.contains(i));
            LinkedListTest.assertTrue((boolean)q.remove((Object)i));
            LinkedListTest.assertFalse((boolean)q.contains(i));
            LinkedListTest.assertFalse((boolean)q.remove((Object)(i + 1)));
            LinkedListTest.assertFalse((boolean)q.contains(i + 1));
        }
        LinkedListTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContains() {
        LinkedList<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertTrue((boolean)q.contains(new Integer(i)));
            q.poll();
            LinkedListTest.assertFalse((boolean)q.contains(new Integer(i)));
        }
    }

    public void testClear() {
        LinkedList<Integer> q = this.populatedQueue(20);
        q.clear();
        LinkedListTest.assertTrue((boolean)q.isEmpty());
        LinkedListTest.assertEquals((int)0, (int)q.size());
        LinkedListTest.assertTrue((boolean)q.add(new Integer(1)));
        LinkedListTest.assertFalse((boolean)q.isEmpty());
        q.clear();
        LinkedListTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContainsAll() {
        LinkedList<Integer> q = this.populatedQueue(20);
        LinkedList<Integer> p = new LinkedList<Integer>();
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertTrue((boolean)q.containsAll(p));
            LinkedListTest.assertFalse((boolean)p.containsAll(q));
            LinkedListTest.assertTrue((boolean)p.add(new Integer(i)));
        }
        LinkedListTest.assertTrue((boolean)p.containsAll(q));
    }

    public void testRetainAll() {
        LinkedList<Integer> q = this.populatedQueue(20);
        LinkedList<Integer> p = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            boolean changed = q.retainAll(p);
            if (i == 0) {
                LinkedListTest.assertFalse((boolean)changed);
            } else {
                LinkedListTest.assertTrue((boolean)changed);
            }
            LinkedListTest.assertTrue((boolean)q.containsAll(p));
            LinkedListTest.assertEquals((int)(20 - i), (int)q.size());
            p.remove();
        }
    }

    public void testRemoveAll() {
        for (int i = 1; i < 20; ++i) {
            LinkedList<Integer> q = this.populatedQueue(20);
            LinkedList<Integer> p = this.populatedQueue(i);
            LinkedListTest.assertTrue((boolean)q.removeAll(p));
            LinkedListTest.assertEquals((int)(20 - i), (int)q.size());
            for (int j = 0; j < i; ++j) {
                Integer I = p.remove();
                LinkedListTest.assertFalse((boolean)q.contains(I));
            }
        }
    }

    public void testToArray() {
        LinkedList<Integer> q = this.populatedQueue(20);
        Object[] o = q.toArray();
        for (int i = 0; i < o.length; ++i) {
            LinkedListTest.assertSame((Object)o[i], (Object)q.poll());
        }
    }

    public void testToArray2() {
        LinkedList<Integer> q = this.populatedQueue(20);
        Integer[] ints = new Integer[20];
        Integer[] array = q.toArray(ints);
        LinkedListTest.assertSame((Object)ints, (Object)array);
        for (int i = 0; i < ints.length; ++i) {
            LinkedListTest.assertSame((Object)ints[i], (Object)q.poll());
        }
    }

    public void testToArray_NullArg() {
        LinkedList<Object> l = new LinkedList<Object>();
        l.add(new Object());
        try {
            l.toArray((T[])null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToArray1_BadArg() {
        LinkedList<Integer> l = new LinkedList<Integer>();
        l.add(new Integer(5));
        try {
            l.toArray(new String[10]);
            this.shouldThrow();
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    public void testIterator() {
        LinkedList<Integer> q = this.populatedQueue(20);
        int i = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            LinkedListTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        LinkedListTest.assertEquals((int)i, (int)20);
    }

    public void testIteratorOrdering() {
        LinkedList<Integer> q = new LinkedList<Integer>();
        q.add(new Integer(1));
        q.add(new Integer(2));
        q.add(new Integer(3));
        int k = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            LinkedListTest.assertEquals((Object)(++k), it.next());
        }
        LinkedListTest.assertEquals((int)3, (int)k);
    }

    public void testIteratorRemove() {
        LinkedList<Integer> q = new LinkedList<Integer>();
        q.add(new Integer(1));
        q.add(new Integer(2));
        q.add(new Integer(3));
        Iterator it = q.iterator();
        LinkedListTest.assertEquals(it.next(), (Object)1);
        it.remove();
        it = q.iterator();
        LinkedListTest.assertEquals(it.next(), (Object)2);
        LinkedListTest.assertEquals(it.next(), (Object)3);
        LinkedListTest.assertFalse((boolean)it.hasNext());
    }

    public void testDescendingIterator() {
        LinkedList<Integer> q = this.populatedQueue(20);
        int i = 0;
        Iterator<Integer> it = q.descendingIterator();
        while (it.hasNext()) {
            LinkedListTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        LinkedListTest.assertEquals((int)i, (int)20);
        LinkedListTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            this.shouldThrow();
        }
        catch (NoSuchElementException success) {
            // empty catch block
        }
    }

    public void testDescendingIteratorOrdering() {
        LinkedList<Integer> q = new LinkedList<Integer>();
        q.add(new Integer(3));
        q.add(new Integer(2));
        q.add(new Integer(1));
        int k = 0;
        Iterator it = q.descendingIterator();
        while (it.hasNext()) {
            LinkedListTest.assertEquals((Object)(++k), it.next());
        }
        LinkedListTest.assertEquals((int)3, (int)k);
    }

    public void testDescendingIteratorRemove() {
        LinkedList<Integer> q = new LinkedList<Integer>();
        q.add(three);
        q.add(two);
        q.add(one);
        Iterator it = q.descendingIterator();
        it.next();
        it.remove();
        it = q.descendingIterator();
        LinkedListTest.assertSame(it.next(), (Object)two);
        LinkedListTest.assertSame(it.next(), (Object)three);
        LinkedListTest.assertFalse((boolean)it.hasNext());
    }

    public void testToString() {
        LinkedList<Integer> q = this.populatedQueue(20);
        String s = q.toString();
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testAddFirst() {
        LinkedList<Integer> q = this.populatedQueue(3);
        q.addFirst(four);
        LinkedListTest.assertSame((Object)four, (Object)q.peek());
    }

    public void testPush() {
        LinkedList<Integer> q = this.populatedQueue(3);
        q.push(four);
        LinkedListTest.assertSame((Object)four, (Object)q.peekFirst());
    }

    public void testPop() {
        LinkedList<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((Object)i, (Object)q.pop());
        }
        try {
            q.pop();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testOfferFirst() {
        LinkedList<Integer> q = new LinkedList<Integer>();
        LinkedListTest.assertTrue((boolean)q.offerFirst(new Integer(0)));
        LinkedListTest.assertTrue((boolean)q.offerFirst(new Integer(1)));
    }

    public void testOfferLast() {
        LinkedList<Integer> q = new LinkedList<Integer>();
        LinkedListTest.assertTrue((boolean)q.offerLast(new Integer(0)));
        LinkedListTest.assertTrue((boolean)q.offerLast(new Integer(1)));
    }

    public void testPollLast() {
        LinkedList<Integer> q = this.populatedQueue(20);
        for (int i = 19; i >= 0; --i) {
            LinkedListTest.assertEquals((Object)i, (Object)q.pollLast());
        }
        LinkedListTest.assertNull((Object)q.pollLast());
    }

    public void testPeekFirst() {
        LinkedList<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((Object)i, (Object)q.peekFirst());
            LinkedListTest.assertEquals((Object)i, (Object)q.pollFirst());
            LinkedListTest.assertTrue((q.peekFirst() == null || !((Object)q.peekFirst()).equals(i) ? 1 : 0) != 0);
        }
        LinkedListTest.assertNull((Object)q.peekFirst());
    }

    public void testPeekLast() {
        LinkedList<Integer> q = this.populatedQueue(20);
        for (int i = 19; i >= 0; --i) {
            LinkedListTest.assertEquals((Object)i, (Object)q.peekLast());
            LinkedListTest.assertEquals((Object)i, (Object)q.pollLast());
            LinkedListTest.assertTrue((q.peekLast() == null || !((Object)q.peekLast()).equals(i) ? 1 : 0) != 0);
        }
        LinkedListTest.assertNull((Object)q.peekLast());
    }

    public void testFirstElement() {
        LinkedList<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedListTest.assertEquals((Object)i, (Object)q.getFirst());
            LinkedListTest.assertEquals((Object)i, (Object)q.pollFirst());
        }
        try {
            q.getFirst();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testLastElement() {
        LinkedList<Integer> q = this.populatedQueue(20);
        for (int i = 19; i >= 0; --i) {
            LinkedListTest.assertEquals((Object)i, (Object)q.getLast());
            LinkedListTest.assertEquals((Object)i, (Object)q.pollLast());
        }
        try {
            q.getLast();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        LinkedListTest.assertNull((Object)q.peekLast());
    }

    public void testRemoveFirstOccurrence() {
        int i;
        LinkedList<Integer> q = this.populatedQueue(20);
        for (i = 1; i < 20; i += 2) {
            LinkedListTest.assertTrue((boolean)q.removeFirstOccurrence(new Integer(i)));
        }
        for (i = 0; i < 20; i += 2) {
            LinkedListTest.assertTrue((boolean)q.removeFirstOccurrence(new Integer(i)));
            LinkedListTest.assertFalse((boolean)q.removeFirstOccurrence(new Integer(i + 1)));
        }
        LinkedListTest.assertTrue((boolean)q.isEmpty());
    }

    public void testRemoveLastOccurrence() {
        int i;
        LinkedList<Integer> q = this.populatedQueue(20);
        for (i = 1; i < 20; i += 2) {
            LinkedListTest.assertTrue((boolean)q.removeLastOccurrence(new Integer(i)));
        }
        for (i = 0; i < 20; i += 2) {
            LinkedListTest.assertTrue((boolean)q.removeLastOccurrence(new Integer(i)));
            LinkedListTest.assertFalse((boolean)q.removeLastOccurrence(new Integer(i + 1)));
        }
        LinkedListTest.assertTrue((boolean)q.isEmpty());
    }
}

