/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.Test;
import junit.textui.TestRunner;

public class LinkedTransferQueueTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)LinkedTransferQueueTest.suite());
    }

    public static Test suite() {
        return LinkedTransferQueueTest.newTestSuite(LinkedTransferQueueTest.class, new Generic().testSuite());
    }

    public void testConstructor1() {
        LinkedTransferQueueTest.assertEquals((int)0, (int)new LinkedTransferQueue().size());
        LinkedTransferQueueTest.assertTrue((boolean)new LinkedTransferQueue().isEmpty());
    }

    public void testConstructor2() {
        try {
            new LinkedTransferQueue(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor3() {
        try {
            Integer[] ints = new Integer[20];
            new LinkedTransferQueue<Integer>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor4() {
        try {
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = i;
            }
            new LinkedTransferQueue<Integer>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor5() {
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = i;
        }
        List<Integer> intList = Arrays.asList(ints);
        LinkedTransferQueue<Integer> q = new LinkedTransferQueue<Integer>(intList);
        LinkedTransferQueueTest.assertEquals((int)q.size(), (int)intList.size());
        LinkedTransferQueueTest.assertEquals((String)q.toString(), (String)intList.toString());
        LinkedTransferQueueTest.assertTrue((boolean)Arrays.equals(q.toArray(), intList.toArray()));
        LinkedTransferQueueTest.assertTrue((boolean)Arrays.equals(q.toArray(new Object[0]), intList.toArray(new Object[0])));
        LinkedTransferQueueTest.assertTrue((boolean)Arrays.equals(q.toArray(new Object[20]), intList.toArray(new Object[20])));
        for (int i = 0; i < 20; ++i) {
            LinkedTransferQueueTest.assertEquals((Object)ints[i], (Object)q.poll());
        }
    }

    public void testRemainingCapacity() {
        int i;
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        for (i = 0; i < 20; ++i) {
            LinkedTransferQueueTest.assertEquals((int)Integer.MAX_VALUE, (int)q.remainingCapacity());
            LinkedTransferQueueTest.assertEquals((int)(20 - i), (int)q.size());
            q.remove();
        }
        for (i = 0; i < 20; ++i) {
            LinkedTransferQueueTest.assertEquals((int)Integer.MAX_VALUE, (int)q.remainingCapacity());
            LinkedTransferQueueTest.assertEquals((int)i, (int)q.size());
            q.add(i);
        }
    }

    public void testOfferNull() {
        try {
            LinkedTransferQueue<Object> q = new LinkedTransferQueue<Object>();
            q.offer(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddNull() {
        try {
            LinkedTransferQueue<Object> q = new LinkedTransferQueue<Object>();
            q.add(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll1() {
        try {
            LinkedTransferQueue q = new LinkedTransferQueue();
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAllSelf() {
        try {
            LinkedTransferQueue<Integer> q = this.populatedQueue(20);
            q.addAll(q);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddAll2() {
        try {
            LinkedTransferQueue<Integer> q = new LinkedTransferQueue<Integer>();
            Integer[] ints = new Integer[20];
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll3() {
        try {
            LinkedTransferQueue<Integer> q = new LinkedTransferQueue<Integer>();
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = i;
            }
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll5() {
        Integer[] empty = new Integer[]{};
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = i;
        }
        LinkedTransferQueue<Integer> q = new LinkedTransferQueue<Integer>();
        LinkedTransferQueueTest.assertFalse((boolean)q.addAll(Arrays.asList(empty)));
        LinkedTransferQueueTest.assertTrue((boolean)q.addAll(Arrays.asList(ints)));
        for (int i = 0; i < 20; ++i) {
            LinkedTransferQueueTest.assertEquals((Object)ints[i], q.poll());
        }
    }

    public void testPutNull() throws InterruptedException {
        try {
            LinkedTransferQueue<Object> q = new LinkedTransferQueue<Object>();
            q.put(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPut() {
        LinkedTransferQueue<Integer> q = new LinkedTransferQueue<Integer>();
        for (int i = 0; i < 20; ++i) {
            LinkedTransferQueueTest.assertEquals((int)q.size(), (int)i);
            q.put(i);
            LinkedTransferQueueTest.assertTrue((boolean)q.contains(i));
        }
    }

    public void testTake() throws InterruptedException {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedTransferQueueTest.assertEquals((int)i, (int)q.take());
        }
    }

    public void testBlockingTake() throws InterruptedException {
        final LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        final CountDownLatch aboutToWait = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                for (int i = 0; i < 20; ++i) {
                    Assert.assertEquals((int)i, (int)((Integer)q.take()));
                }
                aboutToWait.countDown();
                try {
                    q.take();
                    LinkedTransferQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        aboutToWait.await();
        this.waitForThreadToEnterWaitState(t, SMALL_DELAY_MS);
        t.interrupt();
        this.awaitTermination(t, MEDIUM_DELAY_MS);
        this.checkEmpty(q);
    }

    public void testPoll() throws InterruptedException {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedTransferQueueTest.assertEquals((int)i, (int)q.poll());
        }
        LinkedTransferQueueTest.assertNull((Object)q.poll());
        this.checkEmpty(q);
    }

    public void testTimedPoll0() throws InterruptedException {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedTransferQueueTest.assertEquals((int)i, (int)q.poll(0L, TimeUnit.MILLISECONDS));
        }
        LinkedTransferQueueTest.assertNull((Object)q.poll(0L, TimeUnit.MILLISECONDS));
        this.checkEmpty(q);
    }

    public void testTimedPoll() throws InterruptedException {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            long t0 = System.nanoTime();
            LinkedTransferQueueTest.assertEquals((int)i, (int)q.poll(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            LinkedTransferQueueTest.assertTrue((this.millisElapsedSince(t0) < SMALL_DELAY_MS ? 1 : 0) != 0);
        }
        long t0 = System.nanoTime();
        LinkedTransferQueueTest.assertNull((Object)q.poll(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        LinkedTransferQueueTest.assertTrue((this.millisElapsedSince(t0) >= SHORT_DELAY_MS ? 1 : 0) != 0);
        this.checkEmpty(q);
    }

    public void testInterruptedTimedPoll() throws InterruptedException {
        final LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        final CountDownLatch aboutToWait = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                for (int i = 0; i < 20; ++i) {
                    long t0 = System.nanoTime();
                    Assert.assertEquals((int)i, (int)((Integer)q.poll(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS)));
                    Assert.assertTrue((LinkedTransferQueueTest.this.millisElapsedSince(t0) < JSR166TestCase.SMALL_DELAY_MS ? 1 : 0) != 0);
                }
                long t0 = System.nanoTime();
                aboutToWait.countDown();
                try {
                    q.poll(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
                    LinkedTransferQueueTest.this.shouldThrow();
                }
                catch (InterruptedException success) {
                    Assert.assertTrue((LinkedTransferQueueTest.this.millisElapsedSince(t0) < JSR166TestCase.MEDIUM_DELAY_MS ? 1 : 0) != 0);
                }
            }
        });
        aboutToWait.await();
        this.waitForThreadToEnterWaitState(t, SMALL_DELAY_MS);
        t.interrupt();
        this.awaitTermination(t, MEDIUM_DELAY_MS);
        this.checkEmpty(q);
    }

    public void testTimedPollAfterInterrupt() throws InterruptedException {
        final LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Thread.currentThread().interrupt();
                for (int i = 0; i < 20; ++i) {
                    long t0 = System.nanoTime();
                    Assert.assertEquals((int)i, (int)((Integer)q.poll(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS)));
                    Assert.assertTrue((LinkedTransferQueueTest.this.millisElapsedSince(t0) < JSR166TestCase.SMALL_DELAY_MS ? 1 : 0) != 0);
                }
                try {
                    q.poll(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
                    LinkedTransferQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.awaitTermination(t, MEDIUM_DELAY_MS);
        this.checkEmpty(q);
    }

    public void testPeek() throws InterruptedException {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedTransferQueueTest.assertEquals((int)i, (int)q.peek());
            LinkedTransferQueueTest.assertEquals((int)i, (int)q.poll());
            LinkedTransferQueueTest.assertTrue((q.peek() == null || i != q.peek() ? 1 : 0) != 0);
        }
        LinkedTransferQueueTest.assertNull((Object)q.peek());
        this.checkEmpty(q);
    }

    public void testElement() throws InterruptedException {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedTransferQueueTest.assertEquals((int)i, (int)((Integer)q.element()));
            LinkedTransferQueueTest.assertEquals((int)i, (int)q.poll());
        }
        try {
            q.element();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.checkEmpty(q);
    }

    public void testRemove() throws InterruptedException {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedTransferQueueTest.assertEquals((int)i, (int)((Integer)q.remove()));
        }
        try {
            q.remove();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.checkEmpty(q);
    }

    public void testRemoveElement() throws InterruptedException {
        int i;
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        for (i = 1; i < 20; i += 2) {
            LinkedTransferQueueTest.assertTrue((boolean)q.contains(i));
            LinkedTransferQueueTest.assertTrue((boolean)q.remove(i));
            LinkedTransferQueueTest.assertFalse((boolean)q.contains(i));
            LinkedTransferQueueTest.assertTrue((boolean)q.contains(i - 1));
        }
        for (i = 0; i < 20; i += 2) {
            LinkedTransferQueueTest.assertTrue((boolean)q.contains(i));
            LinkedTransferQueueTest.assertTrue((boolean)q.remove(i));
            LinkedTransferQueueTest.assertFalse((boolean)q.contains(i));
            LinkedTransferQueueTest.assertFalse((boolean)q.remove(i + 1));
            LinkedTransferQueueTest.assertFalse((boolean)q.contains(i + 1));
        }
        this.checkEmpty(q);
    }

    public void testRemoveElementAndAdd() throws InterruptedException {
        LinkedTransferQueue<Integer> q = new LinkedTransferQueue<Integer>();
        LinkedTransferQueueTest.assertTrue((boolean)q.add(one));
        LinkedTransferQueueTest.assertTrue((boolean)q.add(two));
        LinkedTransferQueueTest.assertTrue((boolean)q.remove(one));
        LinkedTransferQueueTest.assertTrue((boolean)q.remove(two));
        LinkedTransferQueueTest.assertTrue((boolean)q.add(three));
        LinkedTransferQueueTest.assertSame(q.take(), (Object)three);
    }

    public void testContains() {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            LinkedTransferQueueTest.assertTrue((boolean)q.contains(i));
            LinkedTransferQueueTest.assertEquals((int)i, (int)q.poll());
            LinkedTransferQueueTest.assertFalse((boolean)q.contains(i));
        }
    }

    public void testClear() throws InterruptedException {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        q.clear();
        this.checkEmpty(q);
        LinkedTransferQueueTest.assertEquals((int)Integer.MAX_VALUE, (int)q.remainingCapacity());
        q.add(one);
        LinkedTransferQueueTest.assertFalse((boolean)q.isEmpty());
        LinkedTransferQueueTest.assertEquals((int)1, (int)q.size());
        LinkedTransferQueueTest.assertTrue((boolean)q.contains(one));
        q.clear();
        this.checkEmpty(q);
    }

    public void testContainsAll() {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        LinkedTransferQueue<Integer> p = new LinkedTransferQueue<Integer>();
        for (int i = 0; i < 20; ++i) {
            LinkedTransferQueueTest.assertTrue((boolean)q.containsAll(p));
            LinkedTransferQueueTest.assertFalse((boolean)p.containsAll(q));
            p.add(i);
        }
        LinkedTransferQueueTest.assertTrue((boolean)p.containsAll(q));
    }

    public void testRetainAll() {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        LinkedTransferQueue<Integer> p = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            boolean changed = q.retainAll(p);
            if (i == 0) {
                LinkedTransferQueueTest.assertFalse((boolean)changed);
            } else {
                LinkedTransferQueueTest.assertTrue((boolean)changed);
            }
            LinkedTransferQueueTest.assertTrue((boolean)q.containsAll(p));
            LinkedTransferQueueTest.assertEquals((int)(20 - i), (int)q.size());
            p.remove();
        }
    }

    public void testRemoveAll() {
        for (int i = 1; i < 20; ++i) {
            LinkedTransferQueue<Integer> q = this.populatedQueue(20);
            LinkedTransferQueue<Integer> p = this.populatedQueue(i);
            LinkedTransferQueueTest.assertTrue((boolean)q.removeAll(p));
            LinkedTransferQueueTest.assertEquals((int)(20 - i), (int)q.size());
            for (int j = 0; j < i; ++j) {
                LinkedTransferQueueTest.assertFalse((boolean)q.contains(p.remove()));
            }
        }
    }

    public void testToArray() {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        Object[] o = q.toArray();
        for (int i = 0; i < o.length; ++i) {
            LinkedTransferQueueTest.assertSame((Object)o[i], (Object)q.poll());
        }
    }

    public void testToArray2() {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        Integer[] ints = new Integer[20];
        Integer[] array = q.toArray(ints);
        LinkedTransferQueueTest.assertSame((Object)ints, (Object)array);
        for (int i = 0; i < ints.length; ++i) {
            LinkedTransferQueueTest.assertSame((Object)ints[i], (Object)q.poll());
        }
    }

    public void testToArray_NullArg() {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        try {
            q.toArray((T[])null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToArray1_BadArg() {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        try {
            q.toArray(new String[10]);
            this.shouldThrow();
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    public void testIterator() throws InterruptedException {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        Iterator<Integer> it = q.iterator();
        int i = 0;
        while (it.hasNext()) {
            LinkedTransferQueueTest.assertEquals((Object)it.next(), (Object)i++);
        }
        LinkedTransferQueueTest.assertEquals((int)i, (int)20);
    }

    public void testIteratorRemove() {
        LinkedTransferQueue<Integer> q = new LinkedTransferQueue<Integer>();
        q.add(two);
        q.add(one);
        q.add(three);
        Iterator it = q.iterator();
        it.next();
        it.remove();
        it = q.iterator();
        LinkedTransferQueueTest.assertSame(it.next(), (Object)one);
        LinkedTransferQueueTest.assertSame(it.next(), (Object)three);
        LinkedTransferQueueTest.assertFalse((boolean)it.hasNext());
    }

    public void testIteratorOrdering() {
        LinkedTransferQueue<Integer> q = new LinkedTransferQueue<Integer>();
        LinkedTransferQueueTest.assertEquals((int)Integer.MAX_VALUE, (int)q.remainingCapacity());
        q.add(one);
        q.add(two);
        q.add(three);
        LinkedTransferQueueTest.assertEquals((int)Integer.MAX_VALUE, (int)q.remainingCapacity());
        int k = 0;
        for (Integer n : q) {
            LinkedTransferQueueTest.assertEquals((int)(++k), (int)n);
        }
        LinkedTransferQueueTest.assertEquals((int)3, (int)k);
    }

    public void testWeaklyConsistentIteration() {
        LinkedTransferQueue<Integer> q = new LinkedTransferQueue<Integer>();
        q.add(one);
        q.add(two);
        q.add(three);
        Iterator it = q.iterator();
        while (it.hasNext()) {
            q.remove();
            it.next();
        }
        LinkedTransferQueueTest.assertEquals((int)0, (int)q.size());
    }

    public void testToString() {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        String s = q.toString();
        for (int i = 0; i < 20; ++i) {
            LinkedTransferQueueTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testOfferInExecutor() {
        final LinkedTransferQueue q = new LinkedTransferQueue();
        final CountDownLatch threadsStarted = new CountDownLatch(2);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                threadsStarted.countDown();
                threadsStarted.await();
                Assert.assertTrue((boolean)q.offer(JSR166TestCase.one, JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
            }
        });
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                threadsStarted.countDown();
                threadsStarted.await();
                Assert.assertSame((Object)JSR166TestCase.one, q.take());
                LinkedTransferQueueTest.this.checkEmpty(q);
            }
        });
        this.joinPool(executor);
    }

    public void testPollInExecutor() {
        final LinkedTransferQueue q = new LinkedTransferQueue();
        final CountDownLatch threadsStarted = new CountDownLatch(2);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertNull(q.poll());
                threadsStarted.countDown();
                threadsStarted.await();
                Assert.assertSame((Object)JSR166TestCase.one, q.poll(JSR166TestCase.SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
                LinkedTransferQueueTest.this.checkEmpty(q);
            }
        });
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                threadsStarted.countDown();
                threadsStarted.await();
                q.put(JSR166TestCase.one);
            }
        });
        this.joinPool(executor);
    }

    public void testSerialization() throws Exception {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        LinkedTransferQueue r = (LinkedTransferQueue)in.readObject();
        LinkedTransferQueueTest.assertEquals((int)q.size(), (int)r.size());
        LinkedTransferQueueTest.assertEquals((String)q.toString(), (String)r.toString());
        LinkedTransferQueueTest.assertTrue((boolean)Arrays.equals(q.toArray(), r.toArray()));
        while (!q.isEmpty()) {
            LinkedTransferQueueTest.assertEquals(q.remove(), r.remove());
        }
    }

    public void testDrainToNull() {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        try {
            q.drainTo(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDrainToSelf() {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        try {
            q.drainTo(q);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDrainTo() {
        int i;
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        ArrayList l = new ArrayList();
        q.drainTo(l);
        LinkedTransferQueueTest.assertEquals((int)q.size(), (int)0);
        LinkedTransferQueueTest.assertEquals((int)l.size(), (int)20);
        for (i = 0; i < 20; ++i) {
            LinkedTransferQueueTest.assertEquals(l.get(i), (Object)i);
        }
        q.add(zero);
        q.add(one);
        LinkedTransferQueueTest.assertFalse((boolean)q.isEmpty());
        LinkedTransferQueueTest.assertTrue((boolean)q.contains(zero));
        LinkedTransferQueueTest.assertTrue((boolean)q.contains(one));
        l.clear();
        q.drainTo(l);
        LinkedTransferQueueTest.assertEquals((int)q.size(), (int)0);
        LinkedTransferQueueTest.assertEquals((int)l.size(), (int)2);
        for (i = 0; i < 2; ++i) {
            LinkedTransferQueueTest.assertEquals(l.get(i), (Object)i);
        }
    }

    public void testDrainToWithActivePut() throws InterruptedException {
        final LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                q.put(21);
            }
        });
        ArrayList l = new ArrayList();
        q.drainTo(l);
        LinkedTransferQueueTest.assertTrue((l.size() >= 20 ? 1 : 0) != 0);
        for (int i = 0; i < 20; ++i) {
            LinkedTransferQueueTest.assertEquals(l.get(i), (Object)i);
        }
        this.awaitTermination(t, MEDIUM_DELAY_MS);
        LinkedTransferQueueTest.assertTrue((q.size() + l.size() >= 20 ? 1 : 0) != 0);
    }

    public void testDrainToNullN() {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        try {
            q.drainTo(null, 20);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDrainToSelfN() {
        LinkedTransferQueue<Integer> q = this.populatedQueue(20);
        try {
            q.drainTo(q, 20);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDrainToN() {
        LinkedTransferQueue<Integer> q = new LinkedTransferQueue<Integer>();
        for (int i = 0; i < 22; ++i) {
            for (int j = 0; j < 20; ++j) {
                LinkedTransferQueueTest.assertTrue((boolean)q.offer(j));
            }
            ArrayList l = new ArrayList();
            q.drainTo(l, i);
            int k = i < 20 ? i : 20;
            LinkedTransferQueueTest.assertEquals((int)l.size(), (int)k);
            LinkedTransferQueueTest.assertEquals((int)q.size(), (int)(20 - k));
            for (int j = 0; j < k; ++j) {
                LinkedTransferQueueTest.assertEquals(l.get(j), (Object)j);
            }
            while (q.poll() != null) {
            }
        }
    }

    public void testWaitingConsumer() throws InterruptedException {
        final LinkedTransferQueue<Integer> q = new LinkedTransferQueue<Integer>();
        LinkedTransferQueueTest.assertEquals((int)q.getWaitingConsumerCount(), (int)0);
        LinkedTransferQueueTest.assertFalse((boolean)q.hasWaitingConsumer());
        final CountDownLatch threadStarted = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                threadStarted.countDown();
                Assert.assertSame((Object)JSR166TestCase.one, q.poll(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertEquals((int)q.getWaitingConsumerCount(), (int)0);
                Assert.assertFalse((boolean)q.hasWaitingConsumer());
            }
        });
        threadStarted.await();
        this.waitForThreadToEnterWaitState(t, SMALL_DELAY_MS);
        LinkedTransferQueueTest.assertEquals((int)q.getWaitingConsumerCount(), (int)1);
        LinkedTransferQueueTest.assertTrue((boolean)q.hasWaitingConsumer());
        LinkedTransferQueueTest.assertTrue((boolean)q.offer(one));
        LinkedTransferQueueTest.assertEquals((int)q.getWaitingConsumerCount(), (int)0);
        LinkedTransferQueueTest.assertFalse((boolean)q.hasWaitingConsumer());
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testTransfer1() throws InterruptedException {
        try {
            LinkedTransferQueue<Object> q = new LinkedTransferQueue<Object>();
            q.transfer(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testTransfer2() throws InterruptedException {
        final LinkedTransferQueue q = new LinkedTransferQueue();
        final CountDownLatch threadStarted = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                threadStarted.countDown();
                q.transfer(JSR166TestCase.five);
                LinkedTransferQueueTest.this.checkEmpty(q);
            }
        });
        threadStarted.await();
        this.waitForThreadToEnterWaitState(t, SMALL_DELAY_MS);
        LinkedTransferQueueTest.assertEquals((int)1, (int)q.size());
        LinkedTransferQueueTest.assertSame((Object)five, q.poll());
        this.checkEmpty(q);
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testTransfer3() throws InterruptedException {
        final LinkedTransferQueue q = new LinkedTransferQueue();
        Thread first = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                q.transfer(JSR166TestCase.four);
                Assert.assertTrue((!q.contains(JSR166TestCase.four) ? 1 : 0) != 0);
                Assert.assertEquals((int)1, (int)q.size());
            }
        });
        Thread interruptedThread = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                while (q.isEmpty()) {
                    Thread.yield();
                }
                q.transfer(JSR166TestCase.five);
            }
        });
        while (q.size() < 2) {
            Thread.yield();
        }
        LinkedTransferQueueTest.assertEquals((int)2, (int)q.size());
        LinkedTransferQueueTest.assertSame((Object)four, q.poll());
        first.join();
        LinkedTransferQueueTest.assertEquals((int)1, (int)q.size());
        interruptedThread.interrupt();
        interruptedThread.join();
        this.checkEmpty(q);
    }

    public void testTransfer4() throws InterruptedException {
        final LinkedTransferQueue<Integer> q = new LinkedTransferQueue<Integer>();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                q.transfer(JSR166TestCase.four);
                Assert.assertFalse((boolean)q.contains(JSR166TestCase.four));
                Assert.assertSame((Object)JSR166TestCase.three, q.poll());
            }
        });
        while (q.isEmpty()) {
            Thread.yield();
        }
        LinkedTransferQueueTest.assertFalse((boolean)q.isEmpty());
        LinkedTransferQueueTest.assertEquals((int)1, (int)q.size());
        LinkedTransferQueueTest.assertTrue((boolean)q.offer(three));
        LinkedTransferQueueTest.assertSame((Object)four, q.poll());
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testTransfer5() throws InterruptedException {
        final LinkedTransferQueue q = new LinkedTransferQueue();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                q.transfer(JSR166TestCase.four);
                LinkedTransferQueueTest.this.checkEmpty(q);
            }
        });
        while (q.isEmpty()) {
            Thread.yield();
        }
        LinkedTransferQueueTest.assertFalse((boolean)q.isEmpty());
        LinkedTransferQueueTest.assertEquals((int)1, (int)q.size());
        LinkedTransferQueueTest.assertSame((Object)four, q.take());
        this.checkEmpty(q);
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testTryTransfer1() {
        try {
            LinkedTransferQueue<Object> q = new LinkedTransferQueue<Object>();
            q.tryTransfer(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testTryTransfer2() throws InterruptedException {
        LinkedTransferQueue<Object> q = new LinkedTransferQueue<Object>();
        LinkedTransferQueueTest.assertFalse((boolean)q.tryTransfer(new Object()));
        LinkedTransferQueueTest.assertFalse((boolean)q.hasWaitingConsumer());
        this.checkEmpty(q);
    }

    public void testTryTransfer3() throws InterruptedException {
        final Object hotPotato = new Object();
        final LinkedTransferQueue q = new LinkedTransferQueue();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                while (!q.hasWaitingConsumer()) {
                    Thread.yield();
                }
                Assert.assertTrue((boolean)q.hasWaitingConsumer());
                LinkedTransferQueueTest.this.checkEmpty(q);
                Assert.assertTrue((boolean)q.tryTransfer(hotPotato));
            }
        });
        LinkedTransferQueueTest.assertSame((Object)hotPotato, q.poll(MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
        this.checkEmpty(q);
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testTryTransfer4() throws InterruptedException {
        final Object hotPotato = new Object();
        final LinkedTransferQueue q = new LinkedTransferQueue();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                while (!q.hasWaitingConsumer()) {
                    Thread.yield();
                }
                Assert.assertTrue((boolean)q.hasWaitingConsumer());
                LinkedTransferQueueTest.this.checkEmpty(q);
                Assert.assertTrue((boolean)q.tryTransfer(hotPotato));
            }
        });
        LinkedTransferQueueTest.assertSame(q.take(), (Object)hotPotato);
        this.checkEmpty(q);
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testTryTransfer5() throws InterruptedException {
        final LinkedTransferQueue q = new LinkedTransferQueue();
        final CountDownLatch threadStarted = new CountDownLatch(1);
        LinkedTransferQueueTest.assertTrue((boolean)q.isEmpty());
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                long t0 = System.nanoTime();
                threadStarted.countDown();
                try {
                    q.tryTransfer(new Object(), JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
                    LinkedTransferQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Assert.assertTrue((LinkedTransferQueueTest.this.millisElapsedSince(t0) >= JSR166TestCase.SHORT_DELAY_MS ? 1 : 0) != 0);
                Assert.assertTrue((LinkedTransferQueueTest.this.millisElapsedSince(t0) < JSR166TestCase.MEDIUM_DELAY_MS ? 1 : 0) != 0);
            }
        });
        threadStarted.await();
        while (q.isEmpty()) {
            Thread.yield();
        }
        LinkedTransferQueueTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        this.awaitTermination(t, MEDIUM_DELAY_MS);
        this.checkEmpty(q);
    }

    public void testTryTransfer6() throws InterruptedException {
        final LinkedTransferQueue q = new LinkedTransferQueue();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                long t0 = System.nanoTime();
                Assert.assertFalse((boolean)q.tryTransfer(new Object(), JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertTrue((LinkedTransferQueueTest.this.millisElapsedSince(t0) >= JSR166TestCase.SHORT_DELAY_MS ? 1 : 0) != 0);
                LinkedTransferQueueTest.this.checkEmpty(q);
            }
        });
        this.awaitTermination(t, MEDIUM_DELAY_MS);
        this.checkEmpty(q);
    }

    public void testTryTransfer7() throws InterruptedException {
        final LinkedTransferQueue<Integer> q = new LinkedTransferQueue<Integer>();
        LinkedTransferQueueTest.assertTrue((boolean)q.offer(four));
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertTrue((boolean)q.tryTransfer(JSR166TestCase.five, JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
                LinkedTransferQueueTest.this.checkEmpty(q);
            }
        });
        while (q.size() != 2) {
            Thread.yield();
        }
        LinkedTransferQueueTest.assertEquals((int)2, (int)q.size());
        LinkedTransferQueueTest.assertSame((Object)four, q.poll());
        LinkedTransferQueueTest.assertSame((Object)five, q.poll());
        this.checkEmpty(q);
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testTryTransfer8() throws InterruptedException {
        LinkedTransferQueue<Integer> q = new LinkedTransferQueue<Integer>();
        LinkedTransferQueueTest.assertTrue((boolean)q.offer(four));
        LinkedTransferQueueTest.assertEquals((int)1, (int)q.size());
        long t0 = System.nanoTime();
        LinkedTransferQueueTest.assertFalse((boolean)q.tryTransfer(five, SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        LinkedTransferQueueTest.assertTrue((this.millisElapsedSince(t0) >= SHORT_DELAY_MS ? 1 : 0) != 0);
        LinkedTransferQueueTest.assertEquals((int)1, (int)q.size());
        LinkedTransferQueueTest.assertSame((Object)four, q.poll());
        LinkedTransferQueueTest.assertNull(q.poll());
        this.checkEmpty(q);
    }

    private LinkedTransferQueue<Integer> populatedQueue(int n) {
        LinkedTransferQueue<Integer> q = new LinkedTransferQueue<Integer>();
        this.checkEmpty(q);
        for (int i = 0; i < n; ++i) {
            LinkedTransferQueueTest.assertEquals((int)i, (int)q.size());
            LinkedTransferQueueTest.assertTrue((boolean)q.offer(i));
            LinkedTransferQueueTest.assertEquals((int)Integer.MAX_VALUE, (int)q.remainingCapacity());
        }
        LinkedTransferQueueTest.assertFalse((boolean)q.isEmpty());
        return q;
    }

    public static class Generic
    extends BlockingQueueTest {
        @Override
        protected BlockingQueue emptyCollection() {
            return new LinkedTransferQueue();
        }
    }
}

