/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LockSupportTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)LockSupportTest.suite());
    }

    public static Test suite() {
        return new TestSuite(LockSupportTest.class);
    }

    public void testParkBeforeUnpark() throws InterruptedException {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                threadStarted.countDown();
                LockSupport.park();
            }
        });
        threadStarted.await();
        LockSupportTest.delay(SHORT_DELAY_MS);
        LockSupport.unpark(t);
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testParkUntilBeforeUnpark() throws InterruptedException {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                long d = new Date().getTime() + JSR166TestCase.LONG_DELAY_MS;
                long nanos = JSR166TestCase.LONG_DELAY_MS * 1000L * 1000L;
                long t0 = System.nanoTime();
                threadStarted.countDown();
                LockSupport.parkUntil(d);
                Assert.assertTrue((System.nanoTime() - t0 < nanos ? 1 : 0) != 0);
            }
        });
        threadStarted.await();
        LockSupportTest.delay(SHORT_DELAY_MS);
        LockSupport.unpark(t);
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testParkNanosBeforeUnpark() throws InterruptedException {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                long nanos = JSR166TestCase.LONG_DELAY_MS * 1000L * 1000L;
                long t0 = System.nanoTime();
                threadStarted.countDown();
                LockSupport.parkNanos(nanos);
                Assert.assertTrue((System.nanoTime() - t0 < nanos ? 1 : 0) != 0);
            }
        });
        threadStarted.await();
        LockSupportTest.delay(SHORT_DELAY_MS);
        LockSupport.unpark(t);
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testParkAfterUnpark() throws Exception {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final AtomicBoolean unparked = new AtomicBoolean(false);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                threadStarted.countDown();
                while (!unparked.get()) {
                    Thread.yield();
                }
                LockSupport.park();
            }
        });
        threadStarted.await();
        LockSupport.unpark(t);
        unparked.set(true);
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testParkUntilAfterUnpark() throws Exception {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final AtomicBoolean unparked = new AtomicBoolean(false);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                threadStarted.countDown();
                while (!unparked.get()) {
                    Thread.yield();
                }
                long d = new Date().getTime() + JSR166TestCase.LONG_DELAY_MS;
                long nanos = JSR166TestCase.LONG_DELAY_MS * 1000L * 1000L;
                long t0 = System.nanoTime();
                LockSupport.parkUntil(d);
                Assert.assertTrue((System.nanoTime() - t0 < nanos ? 1 : 0) != 0);
            }
        });
        threadStarted.await();
        LockSupport.unpark(t);
        unparked.set(true);
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testParkNanosAfterUnpark() throws Exception {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final AtomicBoolean unparked = new AtomicBoolean(false);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                threadStarted.countDown();
                while (!unparked.get()) {
                    Thread.yield();
                }
                long nanos = JSR166TestCase.LONG_DELAY_MS * 1000L * 1000L;
                long t0 = System.nanoTime();
                LockSupport.parkNanos(nanos);
                Assert.assertTrue((System.nanoTime() - t0 < nanos ? 1 : 0) != 0);
            }
        });
        threadStarted.await();
        LockSupport.unpark(t);
        unparked.set(true);
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testParkBeforeInterrupt() throws InterruptedException {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                Assert.assertFalse((boolean)Thread.currentThread().isInterrupted());
                threadStarted.countDown();
                do {
                    LockSupport.park();
                } while (!Thread.currentThread().isInterrupted());
            }
        });
        threadStarted.await();
        LockSupportTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testParkUntilBeforeInterrupt() throws InterruptedException {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                long d = new Date().getTime() + JSR166TestCase.LONG_DELAY_MS;
                long nanos = JSR166TestCase.LONG_DELAY_MS * 1000L * 1000L;
                long t0 = System.nanoTime();
                Assert.assertFalse((boolean)Thread.currentThread().isInterrupted());
                threadStarted.countDown();
                do {
                    LockSupport.parkUntil(d);
                } while (!Thread.currentThread().isInterrupted());
                Assert.assertTrue((System.nanoTime() - t0 < nanos ? 1 : 0) != 0);
            }
        });
        threadStarted.await();
        LockSupportTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testParkNanosBeforeInterrupt() throws InterruptedException {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                long nanos = JSR166TestCase.LONG_DELAY_MS * 1000L * 1000L;
                long t0 = System.nanoTime();
                Assert.assertFalse((boolean)Thread.currentThread().isInterrupted());
                threadStarted.countDown();
                do {
                    LockSupport.parkNanos(nanos);
                } while (!Thread.currentThread().isInterrupted());
                Assert.assertTrue((System.nanoTime() - t0 < nanos ? 1 : 0) != 0);
            }
        });
        threadStarted.await();
        LockSupportTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testParkAfterInterrupt() throws Exception {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final AtomicBoolean unparked = new AtomicBoolean(false);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                threadStarted.countDown();
                while (!unparked.get()) {
                    Thread.yield();
                }
                Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
                LockSupport.park();
                Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
            }
        });
        threadStarted.await();
        t.interrupt();
        unparked.set(true);
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testParkUntilAfterInterrupt() throws Exception {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final AtomicBoolean unparked = new AtomicBoolean(false);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                threadStarted.countDown();
                while (!unparked.get()) {
                    Thread.yield();
                }
                long d = new Date().getTime() + JSR166TestCase.LONG_DELAY_MS;
                long nanos = JSR166TestCase.LONG_DELAY_MS * 1000L * 1000L;
                long t0 = System.nanoTime();
                Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
                LockSupport.parkUntil(d);
                Assert.assertTrue((System.nanoTime() - t0 < nanos ? 1 : 0) != 0);
                Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
            }
        });
        threadStarted.await();
        t.interrupt();
        unparked.set(true);
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testParkNanosAfterInterrupt() throws Exception {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final AtomicBoolean unparked = new AtomicBoolean(false);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                threadStarted.countDown();
                while (!unparked.get()) {
                    Thread.yield();
                }
                long nanos = JSR166TestCase.LONG_DELAY_MS * 1000L * 1000L;
                long t0 = System.nanoTime();
                Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
                LockSupport.parkNanos(nanos);
                Assert.assertTrue((System.nanoTime() - t0 < nanos ? 1 : 0) != 0);
                Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
            }
        });
        threadStarted.await();
        t.interrupt();
        unparked.set(true);
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testParkNanosTimesOut() throws InterruptedException {
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                long timeoutNanos;
                long t0;
                do {
                    timeoutNanos = JSR166TestCase.SHORT_DELAY_MS * 1000L * 1000L;
                    t0 = System.nanoTime();
                    LockSupport.parkNanos(timeoutNanos);
                } while (System.nanoTime() - t0 < timeoutNanos);
            }
        });
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testParkUntilTimesOut() throws InterruptedException {
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                long timeoutNanos;
                long t0;
                do {
                    long d = new Date().getTime() + JSR166TestCase.SHORT_DELAY_MS;
                    timeoutNanos = (JSR166TestCase.SHORT_DELAY_MS - 1L) * 1000L * 1000L;
                    t0 = System.nanoTime();
                    LockSupport.parkUntil(d);
                } while (System.nanoTime() - t0 < timeoutNanos);
            }
        });
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testGetBlockerNull() {
        try {
            LockSupport.getBlocker(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testParkUntil0Returns() throws InterruptedException {
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                LockSupport.parkUntil(0L);
            }
        });
        this.awaitTermination(t);
    }
}

