/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class PhaserTest
extends JSR166TestCase {
    private static final int maxParties = 65535;

    public static void main(String[] args) {
        TestRunner.run((Test)PhaserTest.suite());
    }

    public static Test suite() {
        return new TestSuite(PhaserTest.class);
    }

    protected void assertState(Phaser phaser, int phase, int parties, int unarrived) {
        PhaserTest.assertEquals((int)phase, (int)phaser.getPhase());
        PhaserTest.assertEquals((int)parties, (int)phaser.getRegisteredParties());
        PhaserTest.assertEquals((int)unarrived, (int)phaser.getUnarrivedParties());
        PhaserTest.assertEquals((int)(parties - unarrived), (int)phaser.getArrivedParties());
        PhaserTest.assertFalse((boolean)phaser.isTerminated());
    }

    protected void assertTerminated(Phaser phaser, int maxPhase, int parties) {
        PhaserTest.assertTrue((boolean)phaser.isTerminated());
        int expectedPhase = maxPhase + Integer.MIN_VALUE;
        PhaserTest.assertEquals((int)expectedPhase, (int)phaser.getPhase());
        PhaserTest.assertEquals((int)parties, (int)phaser.getRegisteredParties());
        PhaserTest.assertEquals((int)expectedPhase, (int)phaser.register());
        PhaserTest.assertEquals((int)expectedPhase, (int)phaser.arrive());
        PhaserTest.assertEquals((int)expectedPhase, (int)phaser.arriveAndDeregister());
    }

    protected void assertTerminated(Phaser phaser, int maxPhase) {
        this.assertTerminated(phaser, maxPhase, 0);
    }

    public void testConstructorDefaultValues() {
        Phaser phaser = new Phaser();
        PhaserTest.assertNull((Object)phaser.getParent());
        PhaserTest.assertEquals((int)0, (int)phaser.getRegisteredParties());
        PhaserTest.assertEquals((int)0, (int)phaser.getArrivedParties());
        PhaserTest.assertEquals((int)0, (int)phaser.getUnarrivedParties());
        PhaserTest.assertEquals((int)0, (int)phaser.getPhase());
    }

    public void testConstructorNegativeParties() {
        try {
            new Phaser(-1);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorNegativeParties2() {
        try {
            new Phaser(new Phaser(), -1);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorPartiesExceedsLimit() {
        new Phaser(65535);
        try {
            new Phaser(65536);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            // empty catch block
        }
        new Phaser(new Phaser(), 65535);
        try {
            new Phaser(new Phaser(), 65536);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor3() {
        Phaser parent = new Phaser();
        PhaserTest.assertSame((Object)parent, (Object)new Phaser(parent).getParent());
        PhaserTest.assertNull((Object)new Phaser(null).getParent());
    }

    public void testConstructor5() {
        Phaser parent = new Phaser();
        PhaserTest.assertSame((Object)parent, (Object)new Phaser(parent, 0).getParent());
        PhaserTest.assertNull((Object)new Phaser(null, 0).getParent());
    }

    public void testRegister1() {
        Phaser phaser = new Phaser();
        this.assertState(phaser, 0, 0, 0);
        PhaserTest.assertEquals((int)0, (int)phaser.register());
        this.assertState(phaser, 0, 1, 1);
    }

    public void testRegister2() {
        Phaser phaser = new Phaser(0);
        this.assertState(phaser, 0, 0, 0);
        PhaserTest.assertEquals((int)0, (int)phaser.bulkRegister(65525));
        this.assertState(phaser, 0, 65525, 65525);
        for (int i = 0; i < 10; ++i) {
            this.assertState(phaser, 0, 65525 + i, 65525 + i);
            PhaserTest.assertEquals((int)0, (int)phaser.register());
        }
        this.assertState(phaser, 0, 65535, 65535);
        try {
            phaser.register();
            this.shouldThrow();
        }
        catch (IllegalStateException success) {
            // empty catch block
        }
        try {
            phaser.bulkRegister(Integer.MAX_VALUE);
            this.shouldThrow();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        PhaserTest.assertEquals((int)0, (int)phaser.bulkRegister(0));
        this.assertState(phaser, 0, 65535, 65535);
    }

    public void testRegister3() {
        Phaser phaser = new Phaser();
        PhaserTest.assertEquals((int)0, (int)phaser.register());
        PhaserTest.assertEquals((int)0, (int)phaser.arrive());
        PhaserTest.assertEquals((int)1, (int)phaser.register());
        this.assertState(phaser, 1, 2, 2);
    }

    public void testRegister4() {
        Phaser phaser = new Phaser(1);
        PhaserTest.assertEquals((int)0, (int)phaser.arrive());
        PhaserTest.assertEquals((int)1, (int)phaser.register());
        PhaserTest.assertEquals((int)1, (int)phaser.arrive());
        this.assertState(phaser, 1, 2, 1);
    }

    public void testBulkRegister1() {
        try {
            new Phaser().bulkRegister(-1);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBulkRegister2() {
        Phaser phaser = new Phaser();
        PhaserTest.assertEquals((int)0, (int)phaser.bulkRegister(0));
        this.assertState(phaser, 0, 0, 0);
        PhaserTest.assertEquals((int)0, (int)phaser.bulkRegister(20));
        this.assertState(phaser, 0, 20, 20);
    }

    public void testBulkRegister3() {
        PhaserTest.assertEquals((int)0, (int)new Phaser().bulkRegister(65535));
        try {
            new Phaser().bulkRegister(65536);
            this.shouldThrow();
        }
        catch (IllegalStateException success) {
            // empty catch block
        }
        try {
            new Phaser(2).bulkRegister(65534);
            this.shouldThrow();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testPhaseIncrement1() {
        for (int size = 1; size < nine; ++size) {
            Phaser phaser = new Phaser(size);
            for (int index = 0; index <= 1 << size; ++index) {
                int phase = phaser.arrive();
                PhaserTest.assertTrue((boolean)(index % size == 0 ? index / size == phase : index - phase * size > 0));
            }
        }
    }

    public void testArrive1() {
        Phaser phaser = new Phaser(1);
        this.assertState(phaser, 0, 1, 1);
        PhaserTest.assertEquals((int)0, (int)phaser.arrive());
        this.assertState(phaser, 1, 1, 1);
    }

    public void testArriveAndDeregister() throws InterruptedException {
        Phaser phaser = new Phaser(1);
        for (int i = 0; i < 10; ++i) {
            this.assertState(phaser, 0, 1, 1);
            PhaserTest.assertEquals((int)0, (int)phaser.register());
            this.assertState(phaser, 0, 2, 2);
            PhaserTest.assertEquals((int)0, (int)phaser.arriveAndDeregister());
            this.assertState(phaser, 0, 1, 1);
        }
        PhaserTest.assertEquals((int)0, (int)phaser.arriveAndDeregister());
        this.assertTerminated(phaser, 1);
    }

    public void testArrive2() throws InterruptedException {
        final Phaser phaser = new Phaser();
        PhaserTest.assertEquals((int)0, (int)phaser.register());
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 10; ++i) {
            PhaserTest.assertEquals((int)0, (int)phaser.register());
            threads.add(this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() throws InterruptedException {
                    Assert.assertEquals((int)0, (int)phaser.arriveAndDeregister());
                }
            }));
        }
        for (Thread thread : threads) {
            this.awaitTermination(thread, LONG_DELAY_MS);
        }
        this.assertState(phaser, 0, 1, 1);
        PhaserTest.assertEquals((int)0, (int)phaser.arrive());
        this.assertState(phaser, 1, 1, 1);
    }

    public void testArrive3() {
        Phaser phaser = new Phaser(1);
        phaser.forceTermination();
        this.assertTerminated(phaser, 0, 1);
        PhaserTest.assertEquals((int)0, (int)(phaser.getPhase() + Integer.MIN_VALUE));
        PhaserTest.assertTrue((phaser.arrive() < 0 ? 1 : 0) != 0);
        PhaserTest.assertTrue((phaser.register() < 0 ? 1 : 0) != 0);
        PhaserTest.assertTrue((phaser.arriveAndDeregister() < 0 ? 1 : 0) != 0);
        PhaserTest.assertTrue((phaser.awaitAdvance(1) < 0 ? 1 : 0) != 0);
        PhaserTest.assertTrue((phaser.getPhase() < 0 ? 1 : 0) != 0);
    }

    public void testArriveAndDeregister1() {
        try {
            Phaser phaser = new Phaser();
            phaser.arriveAndDeregister();
            this.shouldThrow();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testArriveAndDeregister2() {
        Phaser phaser = new Phaser(1);
        PhaserTest.assertEquals((int)0, (int)phaser.register());
        PhaserTest.assertEquals((int)0, (int)phaser.arrive());
        this.assertState(phaser, 0, 2, 1);
        PhaserTest.assertEquals((int)0, (int)phaser.arriveAndDeregister());
        this.assertState(phaser, 1, 1, 1);
    }

    public void testArriveAndDeregister3() {
        Phaser parent = new Phaser();
        Phaser child = new Phaser(parent);
        this.assertState(child, 0, 0, 0);
        this.assertState(parent, 0, 0, 0);
        PhaserTest.assertEquals((int)0, (int)child.register());
        this.assertState(child, 0, 1, 1);
        this.assertState(parent, 0, 1, 1);
        PhaserTest.assertEquals((int)0, (int)child.arriveAndDeregister());
        this.assertTerminated(child, 1);
        this.assertTerminated(parent, 1);
    }

    public void testArriveAndDeregister4() {
        Phaser parent = new Phaser();
        Phaser child = new Phaser(parent);
        PhaserTest.assertEquals((int)0, (int)parent.register());
        PhaserTest.assertEquals((int)0, (int)child.register());
        this.assertState(child, 0, 1, 1);
        this.assertState(parent, 0, 2, 2);
        PhaserTest.assertEquals((int)0, (int)child.arriveAndDeregister());
        this.assertState(child, 0, 0, 0);
        this.assertState(parent, 0, 1, 1);
    }

    public void testArriveAndDeregister5() {
        Phaser root = new Phaser();
        Phaser parent = new Phaser(root);
        Phaser child = new Phaser(parent);
        this.assertState(root, 0, 0, 0);
        this.assertState(parent, 0, 0, 0);
        this.assertState(child, 0, 0, 0);
        PhaserTest.assertEquals((int)0, (int)child.register());
        this.assertState(root, 0, 1, 1);
        this.assertState(parent, 0, 1, 1);
        this.assertState(child, 0, 1, 1);
        PhaserTest.assertEquals((int)0, (int)child.arriveAndDeregister());
        this.assertTerminated(child, 1);
        this.assertTerminated(parent, 1);
        this.assertTerminated(root, 1);
    }

    public void testArriveAndDeregister6() throws InterruptedException {
        final Phaser phaser = new Phaser(2);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                Assert.assertEquals((int)0, (int)phaser.arrive());
            }
        });
        PhaserTest.assertEquals((int)1, (int)phaser.arriveAndAwaitAdvance());
        this.assertState(phaser, 1, 2, 2);
        PhaserTest.assertEquals((int)1, (int)phaser.arriveAndDeregister());
        this.assertState(phaser, 1, 1, 1);
        PhaserTest.assertEquals((int)1, (int)phaser.arriveAndDeregister());
        this.assertTerminated(phaser, 2);
        this.awaitTermination(t, SHORT_DELAY_MS);
    }

    public void testAwaitAdvance1() {
        Phaser phaser = new Phaser(1);
        PhaserTest.assertEquals((int)0, (int)phaser.arrive());
        PhaserTest.assertEquals((int)1, (int)phaser.awaitAdvance(0));
    }

    public void testAwaitAdvance2() {
        Phaser phaser = new Phaser();
        PhaserTest.assertTrue((phaser.awaitAdvance(-1) < 0 ? 1 : 0) != 0);
        this.assertState(phaser, 0, 0, 0);
    }

    public void testAwaitAdvanceAfterInterrupt() throws InterruptedException {
        final Phaser phaser = new Phaser();
        PhaserTest.assertEquals((int)0, (int)phaser.register());
        final CountDownLatch threadStarted = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Thread.currentThread().interrupt();
                Assert.assertEquals((int)0, (int)phaser.register());
                Assert.assertEquals((int)0, (int)phaser.arrive());
                threadStarted.countDown();
                Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
                Assert.assertEquals((int)1, (int)phaser.awaitAdvance(0));
                Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
            }
        });
        PhaserTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
        this.waitForThreadToEnterWaitState(t, SMALL_DELAY_MS);
        PhaserTest.assertEquals((int)0, (int)phaser.arrive());
        this.awaitTermination(t, SMALL_DELAY_MS);
        Thread.currentThread().interrupt();
        PhaserTest.assertEquals((int)1, (int)phaser.awaitAdvance(0));
        PhaserTest.assertTrue((boolean)Thread.interrupted());
    }

    public void testAwaitAdvanceBeforeInterrupt() throws InterruptedException {
        final Phaser phaser = new Phaser();
        PhaserTest.assertEquals((int)0, (int)phaser.register());
        final CountDownLatch threadStarted = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertEquals((int)0, (int)phaser.register());
                Assert.assertEquals((int)0, (int)phaser.arrive());
                threadStarted.countDown();
                Assert.assertFalse((boolean)Thread.currentThread().isInterrupted());
                Assert.assertEquals((int)1, (int)phaser.awaitAdvance(0));
                Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
            }
        });
        PhaserTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
        this.waitForThreadToEnterWaitState(t, SMALL_DELAY_MS);
        t.interrupt();
        PhaserTest.assertEquals((int)0, (int)phaser.arrive());
        this.awaitTermination(t, SMALL_DELAY_MS);
        Thread.currentThread().interrupt();
        PhaserTest.assertEquals((int)1, (int)phaser.awaitAdvance(0));
        PhaserTest.assertTrue((boolean)Thread.interrupted());
    }

    public void testArriveAndAwaitAdvanceAfterInterrupt() throws InterruptedException {
        final Phaser phaser = new Phaser();
        PhaserTest.assertEquals((int)0, (int)phaser.register());
        final CountDownLatch threadStarted = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Thread.currentThread().interrupt();
                Assert.assertEquals((int)0, (int)phaser.register());
                threadStarted.countDown();
                Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
                Assert.assertEquals((int)1, (int)phaser.arriveAndAwaitAdvance());
                Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
            }
        });
        PhaserTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
        this.waitForThreadToEnterWaitState(t, SMALL_DELAY_MS);
        Thread.currentThread().interrupt();
        PhaserTest.assertEquals((int)1, (int)phaser.arriveAndAwaitAdvance());
        PhaserTest.assertTrue((boolean)Thread.interrupted());
        this.awaitTermination(t, SMALL_DELAY_MS);
    }

    public void testArriveAndAwaitAdvanceBeforeInterrupt() throws InterruptedException {
        final Phaser phaser = new Phaser();
        PhaserTest.assertEquals((int)0, (int)phaser.register());
        final CountDownLatch threadStarted = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertEquals((int)0, (int)phaser.register());
                threadStarted.countDown();
                Assert.assertFalse((boolean)Thread.currentThread().isInterrupted());
                Assert.assertEquals((int)1, (int)phaser.arriveAndAwaitAdvance());
                Assert.assertTrue((boolean)Thread.currentThread().isInterrupted());
            }
        });
        PhaserTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
        this.waitForThreadToEnterWaitState(t, SMALL_DELAY_MS);
        t.interrupt();
        Thread.currentThread().interrupt();
        PhaserTest.assertEquals((int)1, (int)phaser.arriveAndAwaitAdvance());
        PhaserTest.assertTrue((boolean)Thread.interrupted());
        this.awaitTermination(t, SMALL_DELAY_MS);
    }

    public void testAwaitAdvance4() throws InterruptedException {
        final Phaser phaser = new Phaser(4);
        final AtomicInteger count = new AtomicInteger(0);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 4; ++i) {
            threads.add(this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() {
                    for (int k = 0; k < 3; ++k) {
                        Assert.assertEquals((int)(2 * k + 1), (int)phaser.arriveAndAwaitAdvance());
                        count.incrementAndGet();
                        Assert.assertEquals((int)(2 * k + 1), (int)phaser.arrive());
                        Assert.assertEquals((int)(2 * k + 2), (int)phaser.awaitAdvance(2 * k + 1));
                        Assert.assertEquals((int)count.get(), (int)(4 * (k + 1)));
                    }
                }
            }));
        }
        for (Thread thread : threads) {
            this.awaitTermination(thread, MEDIUM_DELAY_MS);
        }
    }

    public void testAwaitAdvance5() throws InterruptedException {
        final Phaser phaser = new Phaser(1);
        PhaserTest.assertEquals((int)1, (int)phaser.awaitAdvance(phaser.arrive()));
        PhaserTest.assertEquals((int)1, (int)phaser.getPhase());
        PhaserTest.assertEquals((int)1, (int)phaser.register());
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 8; ++i) {
            final CountDownLatch latch = new CountDownLatch(1);
            final boolean goesFirst = (i & 1) == 0;
            threads.add(this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() throws InterruptedException {
                    if (goesFirst) {
                        latch.countDown();
                    } else {
                        Assert.assertTrue((boolean)latch.await(JSR166TestCase.SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
                    }
                    phaser.arrive();
                }
            }));
            if (goesFirst) {
                PhaserTest.assertTrue((boolean)latch.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            } else {
                latch.countDown();
            }
            PhaserTest.assertEquals((int)(i + 2), (int)phaser.awaitAdvance(phaser.arrive()));
            PhaserTest.assertEquals((int)(i + 2), (int)phaser.getPhase());
        }
        for (Thread thread : threads) {
            this.awaitTermination(thread, SMALL_DELAY_MS);
        }
    }

    public void testAwaitAdvanceTieredPhaser() throws Exception {
        Phaser parent = new Phaser();
        ArrayList<Phaser> zeroPartyChildren = new ArrayList<Phaser>(3);
        ArrayList<Phaser> onePartyChildren = new ArrayList<Phaser>(3);
        for (int i = 0; i < 3; ++i) {
            zeroPartyChildren.add(new Phaser(parent, 0));
            onePartyChildren.add(new Phaser(parent, 1));
        }
        ArrayList<Phaser> phasers = new ArrayList<Phaser>();
        phasers.addAll(zeroPartyChildren);
        phasers.addAll(onePartyChildren);
        phasers.add(parent);
        for (Phaser phaser : phasers) {
            PhaserTest.assertEquals((int)-42, (int)phaser.awaitAdvance(-42));
            PhaserTest.assertEquals((int)-42, (int)phaser.awaitAdvanceInterruptibly(-42));
            PhaserTest.assertEquals((int)-42, (int)phaser.awaitAdvanceInterruptibly(-42, SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
        }
        for (Phaser child : onePartyChildren) {
            PhaserTest.assertEquals((int)0, (int)child.arrive());
        }
        for (Phaser phaser : phasers) {
            PhaserTest.assertEquals((int)-42, (int)phaser.awaitAdvance(-42));
            PhaserTest.assertEquals((int)-42, (int)phaser.awaitAdvanceInterruptibly(-42));
            PhaserTest.assertEquals((int)-42, (int)phaser.awaitAdvanceInterruptibly(-42, SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            PhaserTest.assertEquals((int)1, (int)phaser.awaitAdvance(0));
            PhaserTest.assertEquals((int)1, (int)phaser.awaitAdvanceInterruptibly(0));
            PhaserTest.assertEquals((int)1, (int)phaser.awaitAdvanceInterruptibly(0, SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
        }
        for (Phaser child : onePartyChildren) {
            PhaserTest.assertEquals((int)1, (int)child.arrive());
        }
        for (Phaser phaser : phasers) {
            PhaserTest.assertEquals((int)-42, (int)phaser.awaitAdvance(-42));
            PhaserTest.assertEquals((int)-42, (int)phaser.awaitAdvanceInterruptibly(-42));
            PhaserTest.assertEquals((int)-42, (int)phaser.awaitAdvanceInterruptibly(-42, SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            PhaserTest.assertEquals((int)2, (int)phaser.awaitAdvance(0));
            PhaserTest.assertEquals((int)2, (int)phaser.awaitAdvanceInterruptibly(0));
            PhaserTest.assertEquals((int)2, (int)phaser.awaitAdvanceInterruptibly(0, SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            PhaserTest.assertEquals((int)2, (int)phaser.awaitAdvance(1));
            PhaserTest.assertEquals((int)2, (int)phaser.awaitAdvanceInterruptibly(1));
            PhaserTest.assertEquals((int)2, (int)phaser.awaitAdvanceInterruptibly(1, SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
        }
    }

    public void testAwaitAdvance6() throws InterruptedException {
        final Phaser phaser = new Phaser(3);
        final CountDownLatch threadsStarted = new CountDownLatch(2);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 2; ++i) {
            JSR166TestCase.CheckedRunnable r = new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() {
                    Assert.assertEquals((int)0, (int)phaser.arrive());
                    threadsStarted.countDown();
                    Assert.assertTrue((phaser.awaitAdvance(0) < 0 ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)phaser.isTerminated());
                    Assert.assertTrue((phaser.getPhase() < 0 ? 1 : 0) != 0);
                    Assert.assertEquals((int)0, (int)(phaser.getPhase() + Integer.MIN_VALUE));
                    Assert.assertEquals((int)3, (int)phaser.getRegisteredParties());
                }
            };
            threads.add(this.newStartedThread(r));
        }
        threadsStarted.await();
        phaser.forceTermination();
        PhaserTest.assertTrue((boolean)phaser.isTerminated());
        PhaserTest.assertEquals((int)0, (int)(phaser.getPhase() + Integer.MIN_VALUE));
        for (Thread thread : threads) {
            this.awaitTermination(thread, SMALL_DELAY_MS);
        }
        PhaserTest.assertEquals((int)3, (int)phaser.getRegisteredParties());
    }

    public void testArriveAndAwaitAdvance1() {
        try {
            Phaser phaser = new Phaser();
            phaser.arriveAndAwaitAdvance();
            this.shouldThrow();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testArriveAndAwaitAdvance3() throws InterruptedException {
        final Phaser phaser = new Phaser(1);
        int THREADS = 3;
        final CountDownLatch threadsStarted = new CountDownLatch(3);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 3; ++i) {
            threads.add(this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() throws InterruptedException {
                    Assert.assertEquals((int)0, (int)phaser.register());
                    threadsStarted.countDown();
                    Assert.assertEquals((int)1, (int)phaser.arriveAndAwaitAdvance());
                }
            }));
        }
        PhaserTest.assertTrue((boolean)threadsStarted.await(MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
        long t0 = System.nanoTime();
        while (phaser.getArrivedParties() < 3) {
            Thread.yield();
        }
        PhaserTest.assertEquals((int)3, (int)phaser.getArrivedParties());
        PhaserTest.assertTrue((TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0) < SMALL_DELAY_MS ? 1 : 0) != 0);
        for (Thread thread : threads) {
            PhaserTest.assertTrue((boolean)thread.isAlive());
        }
        this.assertState(phaser, 0, 4, 1);
        phaser.arriveAndAwaitAdvance();
        for (Thread thread : threads) {
            this.awaitTermination(thread, SMALL_DELAY_MS);
        }
        this.assertState(phaser, 1, 4, 4);
    }
}

