/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class PriorityQueueTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)PriorityQueueTest.suite());
    }

    public static Test suite() {
        return new TestSuite(PriorityQueueTest.class);
    }

    private PriorityQueue<Integer> populatedQueue(int n) {
        int i;
        PriorityQueue<Integer> q = new PriorityQueue<Integer>(n);
        PriorityQueueTest.assertTrue((boolean)q.isEmpty());
        for (i = n - 1; i >= 0; i -= 2) {
            PriorityQueueTest.assertTrue((boolean)q.offer(new Integer(i)));
        }
        for (i = n & 1; i < n; i += 2) {
            PriorityQueueTest.assertTrue((boolean)q.offer(new Integer(i)));
        }
        PriorityQueueTest.assertFalse((boolean)q.isEmpty());
        PriorityQueueTest.assertEquals((int)n, (int)q.size());
        return q;
    }

    public void testConstructor1() {
        PriorityQueueTest.assertEquals((int)0, (int)new PriorityQueue(20).size());
    }

    public void testConstructor2() {
        try {
            PriorityQueue q = new PriorityQueue(0);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor3() {
        try {
            PriorityQueue q = new PriorityQueue((Collection)null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor4() {
        try {
            Integer[] ints = new Integer[20];
            PriorityQueue<Integer> q = new PriorityQueue<Integer>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor5() {
        try {
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            PriorityQueue<Integer> q = new PriorityQueue<Integer>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor6() {
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        PriorityQueue<Integer> q = new PriorityQueue<Integer>(Arrays.asList(ints));
        for (int i = 0; i < 20; ++i) {
            PriorityQueueTest.assertEquals((Object)ints[i], (Object)q.poll());
        }
    }

    public void testConstructor7() {
        int i;
        MyReverseComparator cmp = new MyReverseComparator();
        PriorityQueue<Integer> q = new PriorityQueue<Integer>(20, cmp);
        PriorityQueueTest.assertEquals((Object)cmp, q.comparator());
        Integer[] ints = new Integer[20];
        for (i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        q.addAll(Arrays.asList(ints));
        for (i = 19; i >= 0; --i) {
            PriorityQueueTest.assertEquals((Object)ints[i], q.poll());
        }
    }

    public void testEmpty() {
        PriorityQueue<Integer> q = new PriorityQueue<Integer>(2);
        PriorityQueueTest.assertTrue((boolean)q.isEmpty());
        q.add(new Integer(1));
        PriorityQueueTest.assertFalse((boolean)q.isEmpty());
        q.add(new Integer(2));
        q.remove();
        q.remove();
        PriorityQueueTest.assertTrue((boolean)q.isEmpty());
    }

    public void testSize() {
        int i;
        PriorityQueue<Integer> q = this.populatedQueue(20);
        for (i = 0; i < 20; ++i) {
            PriorityQueueTest.assertEquals((int)(20 - i), (int)q.size());
            q.remove();
        }
        for (i = 0; i < 20; ++i) {
            PriorityQueueTest.assertEquals((int)i, (int)q.size());
            q.add(new Integer(i));
        }
    }

    public void testOfferNull() {
        try {
            PriorityQueue<Object> q = new PriorityQueue<Object>(1);
            q.offer(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddNull() {
        try {
            PriorityQueue<Object> q = new PriorityQueue<Object>(1);
            q.add(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testOffer() {
        PriorityQueue<Integer> q = new PriorityQueue<Integer>(1);
        PriorityQueueTest.assertTrue((boolean)q.offer(zero));
        PriorityQueueTest.assertTrue((boolean)q.offer(one));
    }

    public void testOfferNonComparable() {
        try {
            PriorityQueue<Object> q = new PriorityQueue<Object>(1);
            q.offer(new Object());
            q.offer(new Object());
            q.offer(new Object());
            this.shouldThrow();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testAdd() {
        PriorityQueue<Integer> q = new PriorityQueue<Integer>(20);
        for (int i = 0; i < 20; ++i) {
            PriorityQueueTest.assertEquals((int)i, (int)q.size());
            PriorityQueueTest.assertTrue((boolean)q.add(new Integer(i)));
        }
    }

    public void testAddAll1() {
        try {
            PriorityQueue q = new PriorityQueue(1);
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll2() {
        try {
            PriorityQueue<Integer> q = new PriorityQueue<Integer>(20);
            Integer[] ints = new Integer[20];
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll3() {
        try {
            PriorityQueue<Integer> q = new PriorityQueue<Integer>(20);
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll5() {
        Integer[] empty = new Integer[]{};
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(19 - i);
        }
        PriorityQueue<Integer> q = new PriorityQueue<Integer>(20);
        PriorityQueueTest.assertFalse((boolean)q.addAll(Arrays.asList(empty)));
        PriorityQueueTest.assertTrue((boolean)q.addAll(Arrays.asList(ints)));
        for (int i = 0; i < 20; ++i) {
            PriorityQueueTest.assertEquals((Object)new Integer(i), q.poll());
        }
    }

    public void testPoll() {
        PriorityQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            PriorityQueueTest.assertEquals((Object)i, (Object)q.poll());
        }
        PriorityQueueTest.assertNull((Object)q.poll());
    }

    public void testPeek() {
        PriorityQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            PriorityQueueTest.assertEquals((Object)i, (Object)q.peek());
            PriorityQueueTest.assertEquals((Object)i, (Object)q.poll());
            PriorityQueueTest.assertTrue((q.peek() == null || !((Object)q.peek()).equals(i) ? 1 : 0) != 0);
        }
        PriorityQueueTest.assertNull((Object)q.peek());
    }

    public void testElement() {
        PriorityQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            PriorityQueueTest.assertEquals((Object)i, q.element());
            PriorityQueueTest.assertEquals((Object)i, (Object)q.poll());
        }
        try {
            q.element();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemove() {
        PriorityQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            PriorityQueueTest.assertEquals((Object)i, q.remove());
        }
        try {
            q.remove();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemoveElement() {
        int i;
        PriorityQueue<Integer> q = this.populatedQueue(20);
        for (i = 1; i < 20; i += 2) {
            PriorityQueueTest.assertTrue((boolean)q.contains(i));
            PriorityQueueTest.assertTrue((boolean)q.remove(i));
            PriorityQueueTest.assertFalse((boolean)q.contains(i));
            PriorityQueueTest.assertTrue((boolean)q.contains(i - 1));
        }
        for (i = 0; i < 20; i += 2) {
            PriorityQueueTest.assertTrue((boolean)q.contains(i));
            PriorityQueueTest.assertTrue((boolean)q.remove(i));
            PriorityQueueTest.assertFalse((boolean)q.contains(i));
            PriorityQueueTest.assertFalse((boolean)q.remove(i + 1));
            PriorityQueueTest.assertFalse((boolean)q.contains(i + 1));
        }
        PriorityQueueTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContains() {
        PriorityQueue<Integer> q = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            PriorityQueueTest.assertTrue((boolean)q.contains(new Integer(i)));
            q.poll();
            PriorityQueueTest.assertFalse((boolean)q.contains(new Integer(i)));
        }
    }

    public void testClear() {
        PriorityQueue<Integer> q = this.populatedQueue(20);
        q.clear();
        PriorityQueueTest.assertTrue((boolean)q.isEmpty());
        PriorityQueueTest.assertEquals((int)0, (int)q.size());
        q.add(new Integer(1));
        PriorityQueueTest.assertFalse((boolean)q.isEmpty());
        q.clear();
        PriorityQueueTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContainsAll() {
        PriorityQueue<Integer> q = this.populatedQueue(20);
        PriorityQueue<Integer> p = new PriorityQueue<Integer>(20);
        for (int i = 0; i < 20; ++i) {
            PriorityQueueTest.assertTrue((boolean)q.containsAll(p));
            PriorityQueueTest.assertFalse((boolean)p.containsAll(q));
            p.add(new Integer(i));
        }
        PriorityQueueTest.assertTrue((boolean)p.containsAll(q));
    }

    public void testRetainAll() {
        PriorityQueue<Integer> q = this.populatedQueue(20);
        PriorityQueue<Integer> p = this.populatedQueue(20);
        for (int i = 0; i < 20; ++i) {
            boolean changed = q.retainAll(p);
            if (i == 0) {
                PriorityQueueTest.assertFalse((boolean)changed);
            } else {
                PriorityQueueTest.assertTrue((boolean)changed);
            }
            PriorityQueueTest.assertTrue((boolean)q.containsAll(p));
            PriorityQueueTest.assertEquals((int)(20 - i), (int)q.size());
            p.remove();
        }
    }

    public void testRemoveAll() {
        for (int i = 1; i < 20; ++i) {
            PriorityQueue<Integer> q = this.populatedQueue(20);
            PriorityQueue<Integer> p = this.populatedQueue(i);
            PriorityQueueTest.assertTrue((boolean)q.removeAll(p));
            PriorityQueueTest.assertEquals((int)(20 - i), (int)q.size());
            for (int j = 0; j < i; ++j) {
                Integer I = (Integer)p.remove();
                PriorityQueueTest.assertFalse((boolean)q.contains(I));
            }
        }
    }

    public void testToArray() {
        PriorityQueue<Integer> q = this.populatedQueue(20);
        Object[] o = q.toArray();
        Arrays.sort(o);
        for (int i = 0; i < o.length; ++i) {
            PriorityQueueTest.assertSame((Object)o[i], (Object)q.poll());
        }
    }

    public void testToArray2() {
        PriorityQueue<Integer> q = this.populatedQueue(20);
        Object[] ints = new Integer[20];
        Integer[] array = q.toArray(ints);
        PriorityQueueTest.assertSame((Object)ints, (Object)array);
        Arrays.sort(ints);
        for (int i = 0; i < ints.length; ++i) {
            PriorityQueueTest.assertSame((Object)ints[i], (Object)q.poll());
        }
    }

    public void testIterator() {
        PriorityQueue<Integer> q = this.populatedQueue(20);
        int i = 0;
        Iterator<Integer> it = q.iterator();
        while (it.hasNext()) {
            PriorityQueueTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        PriorityQueueTest.assertEquals((int)i, (int)20);
    }

    public void testIteratorRemove() {
        PriorityQueue<Integer> q = new PriorityQueue<Integer>(3);
        q.add(new Integer(2));
        q.add(new Integer(1));
        q.add(new Integer(3));
        Iterator it = q.iterator();
        it.next();
        it.remove();
        it = q.iterator();
        PriorityQueueTest.assertEquals(it.next(), (Object)new Integer(2));
        PriorityQueueTest.assertEquals(it.next(), (Object)new Integer(3));
        PriorityQueueTest.assertFalse((boolean)it.hasNext());
    }

    public void testToString() {
        PriorityQueue<Integer> q = this.populatedQueue(20);
        String s = q.toString();
        for (int i = 0; i < 20; ++i) {
            PriorityQueueTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testSerialization() throws Exception {
        PriorityQueue<Integer> q = this.populatedQueue(20);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        PriorityQueue r = (PriorityQueue)in.readObject();
        PriorityQueueTest.assertEquals((int)q.size(), (int)r.size());
        while (!q.isEmpty()) {
            PriorityQueueTest.assertEquals(q.remove(), r.remove());
        }
    }

    static class MyReverseComparator
    implements Comparator {
        MyReverseComparator() {
        }

        public int compare(Object x, Object y) {
            return ((Comparable)y).compareTo(x);
        }
    }
}

