/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RecursiveActionTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)RecursiveActionTest.suite());
    }

    public static Test suite() {
        return new TestSuite(RecursiveActionTest.class);
    }

    private static ForkJoinPool mainPool() {
        return new ForkJoinPool();
    }

    private static ForkJoinPool singletonPool() {
        return new ForkJoinPool(1);
    }

    private static ForkJoinPool asyncSingletonPool() {
        return new ForkJoinPool(1, ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInvokeOnPool(ForkJoinPool pool, RecursiveAction a) {
        try {
            this.checkNotDone(a);
            RecursiveActionTest.assertNull((Object)pool.invoke(a));
            this.checkCompletedNormally(a);
        }
        finally {
            this.joinPool(pool);
        }
    }

    void checkNotDone(RecursiveAction a) {
        RecursiveActionTest.assertFalse((boolean)a.isDone());
        RecursiveActionTest.assertFalse((boolean)a.isCompletedNormally());
        RecursiveActionTest.assertFalse((boolean)a.isCompletedAbnormally());
        RecursiveActionTest.assertFalse((boolean)a.isCancelled());
        RecursiveActionTest.assertNull((Object)a.getException());
        RecursiveActionTest.assertNull((Object)a.getRawResult());
        if (!ForkJoinTask.inForkJoinPool()) {
            Thread.currentThread().interrupt();
            try {
                a.get();
                this.shouldThrow();
            }
            catch (InterruptedException success) {
            }
            catch (Throwable fail) {
                this.threadUnexpectedException(fail);
            }
            Thread.currentThread().interrupt();
            try {
                a.get(5L, TimeUnit.SECONDS);
                this.shouldThrow();
            }
            catch (InterruptedException success) {
            }
            catch (Throwable fail) {
                this.threadUnexpectedException(fail);
            }
        }
        try {
            a.get(0L, TimeUnit.SECONDS);
            this.shouldThrow();
        }
        catch (TimeoutException success) {
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
    }

    void checkCompletedNormally(RecursiveAction a) {
        RecursiveActionTest.assertTrue((boolean)a.isDone());
        RecursiveActionTest.assertFalse((boolean)a.isCancelled());
        RecursiveActionTest.assertTrue((boolean)a.isCompletedNormally());
        RecursiveActionTest.assertFalse((boolean)a.isCompletedAbnormally());
        RecursiveActionTest.assertNull((Object)a.getException());
        RecursiveActionTest.assertNull((Object)a.getRawResult());
        RecursiveActionTest.assertNull(a.join());
        RecursiveActionTest.assertFalse((boolean)a.cancel(false));
        RecursiveActionTest.assertFalse((boolean)a.cancel(true));
        try {
            RecursiveActionTest.assertNull(a.get());
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
        try {
            RecursiveActionTest.assertNull(a.get(5L, TimeUnit.SECONDS));
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
    }

    void checkCancelled(RecursiveAction a) {
        RecursiveActionTest.assertTrue((boolean)a.isDone());
        RecursiveActionTest.assertTrue((boolean)a.isCancelled());
        RecursiveActionTest.assertFalse((boolean)a.isCompletedNormally());
        RecursiveActionTest.assertTrue((boolean)a.isCompletedAbnormally());
        RecursiveActionTest.assertTrue((boolean)(a.getException() instanceof CancellationException));
        RecursiveActionTest.assertNull((Object)a.getRawResult());
        try {
            a.join();
            this.shouldThrow();
        }
        catch (CancellationException success) {
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
        try {
            a.get();
            this.shouldThrow();
        }
        catch (CancellationException success) {
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
        try {
            a.get(5L, TimeUnit.SECONDS);
            this.shouldThrow();
        }
        catch (CancellationException success) {
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
    }

    void checkCompletedAbnormally(RecursiveAction a, Throwable t) {
        RecursiveActionTest.assertTrue((boolean)a.isDone());
        RecursiveActionTest.assertFalse((boolean)a.isCancelled());
        RecursiveActionTest.assertFalse((boolean)a.isCompletedNormally());
        RecursiveActionTest.assertTrue((boolean)a.isCompletedAbnormally());
        RecursiveActionTest.assertSame(t.getClass(), a.getException().getClass());
        RecursiveActionTest.assertNull((Object)a.getRawResult());
        RecursiveActionTest.assertFalse((boolean)a.cancel(false));
        RecursiveActionTest.assertFalse((boolean)a.cancel(true));
        try {
            a.join();
            this.shouldThrow();
        }
        catch (Throwable expected) {
            RecursiveActionTest.assertSame(expected.getClass(), t.getClass());
        }
        try {
            a.get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            RecursiveActionTest.assertSame(t.getClass(), success.getCause().getClass());
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
        try {
            a.get(5L, TimeUnit.SECONDS);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            RecursiveActionTest.assertSame(t.getClass(), success.getCause().getClass());
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
    }

    public void testInvoke() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction f = new FibAction(8);
                Assert.assertNull(f.invoke());
                Assert.assertEquals((int)21, (int)f.result);
                RecursiveActionTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testQuietlyInvoke() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction f = new FibAction(8);
                f.quietlyInvoke();
                Assert.assertEquals((int)21, (int)f.result);
                RecursiveActionTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testForkJoin() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction f = new FibAction(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertNull(f.join());
                Assert.assertEquals((int)21, (int)f.result);
                RecursiveActionTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testJoinIgnoresInterrupts() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction f = new FibAction(8);
                Thread myself = Thread.currentThread();
                Assert.assertSame((Object)f, f.fork());
                myself.interrupt();
                Assert.assertTrue((boolean)myself.isInterrupted());
                Assert.assertNull(f.join());
                Thread.interrupted();
                Assert.assertEquals((int)21, (int)f.result);
                RecursiveActionTest.this.checkCompletedNormally(f);
                f.reinitialize();
                f.cancel(true);
                Assert.assertSame((Object)f, f.fork());
                myself.interrupt();
                Assert.assertTrue((boolean)myself.isInterrupted());
                try {
                    f.join();
                    RecursiveActionTest.this.shouldThrow();
                }
                catch (CancellationException success) {
                    Thread.interrupted();
                    RecursiveActionTest.this.checkCancelled(f);
                }
                f.reinitialize();
                f.completeExceptionally(new FJException());
                Assert.assertSame((Object)f, f.fork());
                myself.interrupt();
                Assert.assertTrue((boolean)myself.isInterrupted());
                try {
                    f.join();
                    RecursiveActionTest.this.shouldThrow();
                }
                catch (FJException success) {
                    Thread.interrupted();
                    RecursiveActionTest.this.checkCompletedAbnormally(f, success);
                }
                f.reinitialize();
                Assert.assertSame((Object)f, f.fork());
                myself.interrupt();
                Assert.assertTrue((boolean)myself.isInterrupted());
                f.quietlyJoin();
                Thread.interrupted();
                Assert.assertEquals((int)21, (int)f.result);
                RecursiveActionTest.this.checkCompletedNormally(f);
                f.reinitialize();
                f.cancel(true);
                Assert.assertSame((Object)f, f.fork());
                myself.interrupt();
                Assert.assertTrue((boolean)myself.isInterrupted());
                f.quietlyJoin();
                Thread.interrupted();
                RecursiveActionTest.this.checkCancelled(f);
                f.reinitialize();
                f.completeExceptionally(new FJException());
                Assert.assertSame((Object)f, f.fork());
                myself.interrupt();
                Assert.assertTrue((boolean)myself.isInterrupted());
                f.quietlyJoin();
                Thread.interrupted();
                RecursiveActionTest.this.checkCompletedAbnormally(f, f.getException());
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
        a.reinitialize();
        this.testInvokeOnPool(RecursiveActionTest.singletonPool(), a);
    }

    public void testJoinIgnoresInterruptsOutsideForkJoinPool() {
        final SynchronousQueue sq = new SynchronousQueue();
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws InterruptedException {
                int i;
                FibAction[] fibActions = new FibAction[6];
                for (i = 0; i < fibActions.length; ++i) {
                    fibActions[i] = new FibAction(8);
                }
                fibActions[1].cancel(false);
                fibActions[2].completeExceptionally(new FJException());
                fibActions[4].cancel(true);
                fibActions[5].completeExceptionally(new FJException());
                for (i = 0; i < fibActions.length; ++i) {
                    fibActions[i].fork();
                }
                sq.put(fibActions);
                5.helpQuiesce();
            }
        };
        JSR166TestCase.CheckedRunnable r = new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                FibAction[] fibActions = (FibAction[])sq.take();
                Thread myself = Thread.currentThread();
                FibAction f = fibActions[0];
                Assert.assertFalse((boolean)ForkJoinTask.inForkJoinPool());
                myself.interrupt();
                Assert.assertTrue((boolean)myself.isInterrupted());
                Assert.assertNull(f.join());
                Assert.assertTrue((boolean)Thread.interrupted());
                Assert.assertEquals((int)21, (int)f.result);
                RecursiveActionTest.this.checkCompletedNormally(f);
                f = fibActions[1];
                myself.interrupt();
                Assert.assertTrue((boolean)myself.isInterrupted());
                try {
                    f.join();
                    RecursiveActionTest.this.shouldThrow();
                }
                catch (CancellationException success) {
                    Assert.assertTrue((boolean)Thread.interrupted());
                    RecursiveActionTest.this.checkCancelled(f);
                }
                f = fibActions[2];
                myself.interrupt();
                Assert.assertTrue((boolean)myself.isInterrupted());
                try {
                    f.join();
                    RecursiveActionTest.this.shouldThrow();
                }
                catch (FJException success) {
                    Assert.assertTrue((boolean)Thread.interrupted());
                    RecursiveActionTest.this.checkCompletedAbnormally(f, success);
                }
                f = fibActions[3];
                myself.interrupt();
                Assert.assertTrue((boolean)myself.isInterrupted());
                f.quietlyJoin();
                Assert.assertTrue((boolean)Thread.interrupted());
                Assert.assertEquals((int)21, (int)f.result);
                RecursiveActionTest.this.checkCompletedNormally(f);
                f = fibActions[4];
                myself.interrupt();
                Assert.assertTrue((boolean)myself.isInterrupted());
                f.quietlyJoin();
                Assert.assertTrue((boolean)Thread.interrupted());
                RecursiveActionTest.this.checkCancelled(f);
                f = fibActions[5];
                myself.interrupt();
                Assert.assertTrue((boolean)myself.isInterrupted());
                f.quietlyJoin();
                Assert.assertTrue((boolean)Thread.interrupted());
                Assert.assertTrue((boolean)(f.getException() instanceof FJException));
                RecursiveActionTest.this.checkCompletedAbnormally(f, f.getException());
            }
        };
        Thread t = this.newStartedThread(r);
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
        this.awaitTermination(t, LONG_DELAY_MS);
        a.reinitialize();
        t = this.newStartedThread(r);
        this.testInvokeOnPool(RecursiveActionTest.singletonPool(), a);
        this.awaitTermination(t, LONG_DELAY_MS);
    }

    public void testForkGet() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                FibAction f = new FibAction(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertNull(f.get());
                Assert.assertEquals((int)21, (int)f.result);
                RecursiveActionTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testForkTimedGet() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                FibAction f = new FibAction(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertNull(f.get(5L, TimeUnit.SECONDS));
                Assert.assertEquals((int)21, (int)f.result);
                RecursiveActionTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testForkTimedGetNPE() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                FibAction f = new FibAction(8);
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.get(5L, null);
                    RecursiveActionTest.this.shouldThrow();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testForkQuietlyJoin() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction f = new FibAction(8);
                Assert.assertSame((Object)f, f.fork());
                f.quietlyJoin();
                Assert.assertEquals((int)21, (int)f.result);
                RecursiveActionTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testForkHelpQuiesce() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction f = new FibAction(8);
                Assert.assertSame((Object)f, f.fork());
                f.helpQuiesce();
                Assert.assertEquals((int)21, (int)f.result);
                Assert.assertEquals((int)0, (int)11.getQueuedTaskCount());
                RecursiveActionTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testAbnormalInvoke() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FailingFibAction f = new FailingFibAction(8);
                try {
                    f.invoke();
                    RecursiveActionTest.this.shouldThrow();
                }
                catch (FJException success) {
                    RecursiveActionTest.this.checkCompletedAbnormally(f, success);
                }
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testAbnormalQuietlyInvoke() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FailingFibAction f = new FailingFibAction(8);
                f.quietlyInvoke();
                Assert.assertTrue((boolean)(f.getException() instanceof FJException));
                RecursiveActionTest.this.checkCompletedAbnormally(f, f.getException());
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testAbnormalForkJoin() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FailingFibAction f = new FailingFibAction(8);
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.join();
                    RecursiveActionTest.this.shouldThrow();
                }
                catch (FJException success) {
                    RecursiveActionTest.this.checkCompletedAbnormally(f, success);
                }
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testAbnormalForkGet() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                FailingFibAction f = new FailingFibAction(8);
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.get();
                    RecursiveActionTest.this.shouldThrow();
                }
                catch (ExecutionException success) {
                    Throwable cause = success.getCause();
                    Assert.assertTrue((boolean)(cause instanceof FJException));
                    RecursiveActionTest.this.checkCompletedAbnormally(f, cause);
                }
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testAbnormalForkTimedGet() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                FailingFibAction f = new FailingFibAction(8);
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.get(5L, TimeUnit.SECONDS);
                    RecursiveActionTest.this.shouldThrow();
                }
                catch (ExecutionException success) {
                    Throwable cause = success.getCause();
                    Assert.assertTrue((boolean)(cause instanceof FJException));
                    RecursiveActionTest.this.checkCompletedAbnormally(f, cause);
                }
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testAbnormalForkQuietlyJoin() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FailingFibAction f = new FailingFibAction(8);
                Assert.assertSame((Object)f, f.fork());
                f.quietlyJoin();
                Assert.assertTrue((boolean)(f.getException() instanceof FJException));
                RecursiveActionTest.this.checkCompletedAbnormally(f, f.getException());
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testCancelledInvoke() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction f = new FibAction(8);
                Assert.assertTrue((boolean)f.cancel(true));
                try {
                    f.invoke();
                    RecursiveActionTest.this.shouldThrow();
                }
                catch (CancellationException success) {
                    RecursiveActionTest.this.checkCancelled(f);
                }
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testCancelledForkJoin() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction f = new FibAction(8);
                Assert.assertTrue((boolean)f.cancel(true));
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.join();
                    RecursiveActionTest.this.shouldThrow();
                }
                catch (CancellationException success) {
                    RecursiveActionTest.this.checkCancelled(f);
                }
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testCancelledForkGet() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                FibAction f = new FibAction(8);
                Assert.assertTrue((boolean)f.cancel(true));
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.get();
                    RecursiveActionTest.this.shouldThrow();
                }
                catch (CancellationException success) {
                    RecursiveActionTest.this.checkCancelled(f);
                }
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testCancelledForkTimedGet() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() throws Exception {
                FibAction f = new FibAction(8);
                Assert.assertTrue((boolean)f.cancel(true));
                Assert.assertSame((Object)f, f.fork());
                try {
                    f.get(5L, TimeUnit.SECONDS);
                    RecursiveActionTest.this.shouldThrow();
                }
                catch (CancellationException success) {
                    RecursiveActionTest.this.checkCancelled(f);
                }
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testCancelledForkQuietlyJoin() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction f = new FibAction(8);
                Assert.assertTrue((boolean)f.cancel(true));
                Assert.assertSame((Object)f, f.fork());
                f.quietlyJoin();
                RecursiveActionTest.this.checkCancelled(f);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testGetPool() {
        final ForkJoinPool mainPool = RecursiveActionTest.mainPool();
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                Assert.assertSame((Object)mainPool, (Object)23.getPool());
            }
        };
        this.testInvokeOnPool(mainPool, a);
    }

    public void testGetPool2() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                Assert.assertNull((Object)24.getPool());
            }
        };
        RecursiveActionTest.assertNull(a.invoke());
    }

    public void testInForkJoinPool() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                Assert.assertTrue((boolean)25.inForkJoinPool());
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testInForkJoinPool2() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                Assert.assertFalse((boolean)26.inForkJoinPool());
            }
        };
        RecursiveActionTest.assertNull(a.invoke());
    }

    public void testWorkerGetPool() {
        final ForkJoinPool mainPool = RecursiveActionTest.mainPool();
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                ForkJoinWorkerThread w = (ForkJoinWorkerThread)Thread.currentThread();
                Assert.assertSame((Object)mainPool, (Object)w.getPool());
            }
        };
        this.testInvokeOnPool(mainPool, a);
    }

    public void testWorkerGetPoolIndex() {
        ForkJoinPool mainPool = RecursiveActionTest.mainPool();
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                ForkJoinWorkerThread w = (ForkJoinWorkerThread)Thread.currentThread();
                Assert.assertTrue((w.getPoolIndex() >= 0 ? 1 : 0) != 0);
            }
        };
        this.testInvokeOnPool(mainPool, a);
    }

    public void testSetRawResult() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                this.setRawResult(null);
                Assert.assertNull((Object)this.getRawResult());
            }
        };
        RecursiveActionTest.assertNull(a.invoke());
    }

    public void testReinitialize() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction f = new FibAction(8);
                RecursiveActionTest.this.checkNotDone(f);
                for (int i = 0; i < 3; ++i) {
                    Assert.assertNull(f.invoke());
                    Assert.assertEquals((int)21, (int)f.result);
                    RecursiveActionTest.this.checkCompletedNormally(f);
                    f.reinitialize();
                    RecursiveActionTest.this.checkNotDone(f);
                }
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testCompleteExceptionally() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction f = new FibAction(8);
                f.completeExceptionally(new FJException());
                try {
                    f.invoke();
                    RecursiveActionTest.this.shouldThrow();
                }
                catch (FJException success) {
                    RecursiveActionTest.this.checkCompletedAbnormally(f, success);
                }
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testComplete() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction f = new FibAction(8);
                f.complete(null);
                Assert.assertNull(f.invoke());
                Assert.assertEquals((int)0, (int)f.result);
                RecursiveActionTest.this.checkCompletedNormally(f);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testInvokeAll2() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction f = new FibAction(8);
                FibAction g = new FibAction(9);
                33.invokeAll(f, g);
                RecursiveActionTest.this.checkCompletedNormally(f);
                Assert.assertEquals((int)21, (int)f.result);
                RecursiveActionTest.this.checkCompletedNormally(g);
                Assert.assertEquals((int)34, (int)g.result);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testInvokeAll1() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction f = new FibAction(8);
                34.invokeAll(f);
                RecursiveActionTest.this.checkCompletedNormally(f);
                Assert.assertEquals((int)21, (int)f.result);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testInvokeAll3() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction f = new FibAction(8);
                FibAction g = new FibAction(9);
                FibAction h = new FibAction(7);
                35.invokeAll(f, g, h);
                Assert.assertTrue((boolean)f.isDone());
                Assert.assertTrue((boolean)g.isDone());
                Assert.assertTrue((boolean)h.isDone());
                RecursiveActionTest.this.checkCompletedNormally(f);
                Assert.assertEquals((int)21, (int)f.result);
                RecursiveActionTest.this.checkCompletedNormally(g);
                Assert.assertEquals((int)34, (int)g.result);
                RecursiveActionTest.this.checkCompletedNormally(g);
                Assert.assertEquals((int)13, (int)h.result);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testInvokeAllCollection() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction f = new FibAction(8);
                FibAction g = new FibAction(9);
                FibAction h = new FibAction(7);
                HashSet<FibAction> set = new HashSet<FibAction>();
                set.add(f);
                set.add(g);
                set.add(h);
                36.invokeAll(set);
                Assert.assertTrue((boolean)f.isDone());
                Assert.assertTrue((boolean)g.isDone());
                Assert.assertTrue((boolean)h.isDone());
                RecursiveActionTest.this.checkCompletedNormally(f);
                Assert.assertEquals((int)21, (int)f.result);
                RecursiveActionTest.this.checkCompletedNormally(g);
                Assert.assertEquals((int)34, (int)g.result);
                RecursiveActionTest.this.checkCompletedNormally(g);
                Assert.assertEquals((int)13, (int)h.result);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testInvokeAllNPE() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction f = new FibAction(8);
                FibAction g = new FibAction(9);
                Object h = null;
                try {
                    37.invokeAll(f, g, h);
                    RecursiveActionTest.this.shouldThrow();
                }
                catch (NullPointerException success) {
                    // empty catch block
                }
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testAbnormalInvokeAll2() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction f = new FibAction(8);
                FailingFibAction g = new FailingFibAction(9);
                try {
                    38.invokeAll(f, g);
                    RecursiveActionTest.this.shouldThrow();
                }
                catch (FJException success) {
                    RecursiveActionTest.this.checkCompletedAbnormally(g, success);
                }
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testAbnormalInvokeAll1() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FailingFibAction g = new FailingFibAction(9);
                try {
                    39.invokeAll(g);
                    RecursiveActionTest.this.shouldThrow();
                }
                catch (FJException success) {
                    RecursiveActionTest.this.checkCompletedAbnormally(g, success);
                }
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testAbnormalInvokeAll3() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction f = new FibAction(8);
                FailingFibAction g = new FailingFibAction(9);
                FibAction h = new FibAction(7);
                try {
                    40.invokeAll(f, g, h);
                    RecursiveActionTest.this.shouldThrow();
                }
                catch (FJException success) {
                    RecursiveActionTest.this.checkCompletedAbnormally(g, success);
                }
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testAbnormalInvokeAllCollection() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FailingFibAction f = new FailingFibAction(8);
                FibAction g = new FibAction(9);
                FibAction h = new FibAction(7);
                HashSet<RecursiveAction> set = new HashSet<RecursiveAction>();
                set.add(f);
                set.add(g);
                set.add(h);
                try {
                    41.invokeAll(set);
                    RecursiveActionTest.this.shouldThrow();
                }
                catch (FJException success) {
                    RecursiveActionTest.this.checkCompletedAbnormally(f, success);
                }
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.mainPool(), a);
    }

    public void testTryUnfork() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction g = new FibAction(9);
                Assert.assertSame((Object)g, g.fork());
                FibAction f = new FibAction(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertTrue((boolean)f.tryUnfork());
                42.helpQuiesce();
                RecursiveActionTest.this.checkNotDone(f);
                RecursiveActionTest.this.checkCompletedNormally(g);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.singletonPool(), a);
    }

    public void testGetSurplusQueuedTaskCount() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction h = new FibAction(7);
                Assert.assertSame((Object)h, h.fork());
                FibAction g = new FibAction(9);
                Assert.assertSame((Object)g, g.fork());
                FibAction f = new FibAction(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertTrue((43.getSurplusQueuedTaskCount() > 0 ? 1 : 0) != 0);
                43.helpQuiesce();
                Assert.assertEquals((int)0, (int)43.getSurplusQueuedTaskCount());
                RecursiveActionTest.this.checkCompletedNormally(f);
                RecursiveActionTest.this.checkCompletedNormally(g);
                RecursiveActionTest.this.checkCompletedNormally(h);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.singletonPool(), a);
    }

    public void testPeekNextLocalTask() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction g = new FibAction(9);
                Assert.assertSame((Object)g, g.fork());
                FibAction f = new FibAction(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertSame((Object)f, 44.peekNextLocalTask());
                Assert.assertNull(f.join());
                RecursiveActionTest.this.checkCompletedNormally(f);
                44.helpQuiesce();
                RecursiveActionTest.this.checkCompletedNormally(f);
                RecursiveActionTest.this.checkCompletedNormally(g);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.singletonPool(), a);
    }

    public void testPollNextLocalTask() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction g = new FibAction(9);
                Assert.assertSame((Object)g, g.fork());
                FibAction f = new FibAction(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertSame((Object)f, 45.pollNextLocalTask());
                45.helpQuiesce();
                RecursiveActionTest.this.checkNotDone(f);
                RecursiveActionTest.this.checkCompletedNormally(g);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.singletonPool(), a);
    }

    public void testPollTask() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction g = new FibAction(9);
                Assert.assertSame((Object)g, g.fork());
                FibAction f = new FibAction(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertSame((Object)f, 46.pollTask());
                46.helpQuiesce();
                RecursiveActionTest.this.checkNotDone(f);
                RecursiveActionTest.this.checkCompletedNormally(g);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.singletonPool(), a);
    }

    public void testPeekNextLocalTaskAsync() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction g = new FibAction(9);
                Assert.assertSame((Object)g, g.fork());
                FibAction f = new FibAction(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertSame((Object)g, 47.peekNextLocalTask());
                Assert.assertNull(f.join());
                47.helpQuiesce();
                RecursiveActionTest.this.checkCompletedNormally(f);
                RecursiveActionTest.this.checkCompletedNormally(g);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.asyncSingletonPool(), a);
    }

    public void testPollNextLocalTaskAsync() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction g = new FibAction(9);
                Assert.assertSame((Object)g, g.fork());
                FibAction f = new FibAction(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertSame((Object)g, 48.pollNextLocalTask());
                48.helpQuiesce();
                RecursiveActionTest.this.checkCompletedNormally(f);
                RecursiveActionTest.this.checkNotDone(g);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.asyncSingletonPool(), a);
    }

    public void testPollTaskAsync() {
        JSR166TestCase.CheckedRecursiveAction a = new JSR166TestCase.CheckedRecursiveAction(){

            @Override
            public void realCompute() {
                FibAction g = new FibAction(9);
                Assert.assertSame((Object)g, g.fork());
                FibAction f = new FibAction(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertSame((Object)g, 49.pollTask());
                49.helpQuiesce();
                RecursiveActionTest.this.checkCompletedNormally(f);
                RecursiveActionTest.this.checkNotDone(g);
            }
        };
        this.testInvokeOnPool(RecursiveActionTest.asyncSingletonPool(), a);
    }

    static final class FailingFibAction
    extends RecursiveAction {
        final int number;
        int result;

        FailingFibAction(int n) {
            this.number = n;
        }

        @Override
        public void compute() {
            int n = this.number;
            if (n <= 1) {
                throw new FJException();
            }
            FailingFibAction f1 = new FailingFibAction(n - 1);
            FailingFibAction f2 = new FailingFibAction(n - 2);
            FailingFibAction.invokeAll(f1, f2);
            this.result = f1.result + f2.result;
        }
    }

    final class FibAction
    extends JSR166TestCase.CheckedRecursiveAction {
        final int number;
        int result;

        FibAction(int n) {
            this.number = n;
        }

        @Override
        public void realCompute() {
            int n = this.number;
            if (n <= 1) {
                this.result = n;
            } else {
                FibAction f1 = new FibAction(n - 1);
                FibAction f2 = new FibAction(n - 2);
                FibAction.invokeAll(f1, f2);
                this.result = f1.result + f2.result;
            }
        }
    }

    public static final class FJException
    extends RuntimeException {
        public FJException() {
        }

        public FJException(Throwable cause) {
            super(cause);
        }
    }
}

