/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RecursiveTaskTest
extends JSR166TestCase {
    static final Integer NoResult = -17;

    public static void main(String[] args) {
        TestRunner.run((Test)RecursiveTaskTest.suite());
    }

    public static Test suite() {
        return new TestSuite(RecursiveTaskTest.class);
    }

    private static ForkJoinPool mainPool() {
        return new ForkJoinPool();
    }

    private static ForkJoinPool singletonPool() {
        return new ForkJoinPool(1);
    }

    private static ForkJoinPool asyncSingletonPool() {
        return new ForkJoinPool(1, ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T testInvokeOnPool(ForkJoinPool pool, RecursiveTask<T> a) {
        try {
            this.checkNotDone(a);
            T result = pool.invoke(a);
            this.checkCompletedNormally(a, result);
            T t = result;
            return t;
        }
        finally {
            this.joinPool(pool);
        }
    }

    void checkNotDone(RecursiveTask a) {
        RecursiveTaskTest.assertFalse((boolean)a.isDone());
        RecursiveTaskTest.assertFalse((boolean)a.isCompletedNormally());
        RecursiveTaskTest.assertFalse((boolean)a.isCompletedAbnormally());
        RecursiveTaskTest.assertFalse((boolean)a.isCancelled());
        RecursiveTaskTest.assertNull((Object)a.getException());
        RecursiveTaskTest.assertNull(a.getRawResult());
        if (!ForkJoinTask.inForkJoinPool()) {
            Thread.currentThread().interrupt();
            try {
                a.get();
                this.shouldThrow();
            }
            catch (InterruptedException success) {
            }
            catch (Throwable fail) {
                this.threadUnexpectedException(fail);
            }
            Thread.currentThread().interrupt();
            try {
                a.get(5L, TimeUnit.SECONDS);
                this.shouldThrow();
            }
            catch (InterruptedException success) {
            }
            catch (Throwable fail) {
                this.threadUnexpectedException(fail);
            }
        }
        try {
            a.get(0L, TimeUnit.SECONDS);
            this.shouldThrow();
        }
        catch (TimeoutException success) {
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
    }

    <T> void checkCompletedNormally(RecursiveTask<T> a, T expected) {
        RecursiveTaskTest.assertTrue((boolean)a.isDone());
        RecursiveTaskTest.assertFalse((boolean)a.isCancelled());
        RecursiveTaskTest.assertTrue((boolean)a.isCompletedNormally());
        RecursiveTaskTest.assertFalse((boolean)a.isCompletedAbnormally());
        RecursiveTaskTest.assertNull((Object)a.getException());
        RecursiveTaskTest.assertSame(expected, a.getRawResult());
        RecursiveTaskTest.assertSame(expected, a.join());
        RecursiveTaskTest.assertFalse((boolean)a.cancel(false));
        RecursiveTaskTest.assertFalse((boolean)a.cancel(true));
        try {
            RecursiveTaskTest.assertSame(expected, a.get());
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
        try {
            RecursiveTaskTest.assertSame(expected, a.get(5L, TimeUnit.SECONDS));
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
    }

    void checkCompletesNormally(RecursiveTask<Integer> a, int expected) {
        Integer r = (Integer)a.join();
        RecursiveTaskTest.assertEquals((int)expected, (int)r);
        this.checkCompletedNormally((RecursiveTask)a, (Object)r);
    }

    void checkCompletedNormally(RecursiveTask<Integer> a, int expected) {
        Integer r = a.getRawResult();
        RecursiveTaskTest.assertEquals((int)expected, (int)r);
        this.checkCompletedNormally((RecursiveTask)a, (Object)r);
    }

    void checkCancelled(RecursiveTask a) {
        RecursiveTaskTest.assertTrue((boolean)a.isDone());
        RecursiveTaskTest.assertTrue((boolean)a.isCancelled());
        RecursiveTaskTest.assertFalse((boolean)a.isCompletedNormally());
        RecursiveTaskTest.assertTrue((boolean)a.isCompletedAbnormally());
        RecursiveTaskTest.assertTrue((boolean)(a.getException() instanceof CancellationException));
        RecursiveTaskTest.assertNull(a.getRawResult());
        try {
            a.join();
            this.shouldThrow();
        }
        catch (CancellationException success) {
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
        try {
            a.get();
            this.shouldThrow();
        }
        catch (CancellationException success) {
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
        try {
            a.get(5L, TimeUnit.SECONDS);
            this.shouldThrow();
        }
        catch (CancellationException success) {
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
    }

    void checkCompletedAbnormally(RecursiveTask a, Throwable t) {
        RecursiveTaskTest.assertTrue((boolean)a.isDone());
        RecursiveTaskTest.assertFalse((boolean)a.isCancelled());
        RecursiveTaskTest.assertFalse((boolean)a.isCompletedNormally());
        RecursiveTaskTest.assertTrue((boolean)a.isCompletedAbnormally());
        RecursiveTaskTest.assertSame(t.getClass(), a.getException().getClass());
        RecursiveTaskTest.assertNull(a.getRawResult());
        RecursiveTaskTest.assertFalse((boolean)a.cancel(false));
        RecursiveTaskTest.assertFalse((boolean)a.cancel(true));
        try {
            a.join();
            this.shouldThrow();
        }
        catch (Throwable expected) {
            RecursiveTaskTest.assertSame(t.getClass(), expected.getClass());
        }
        try {
            a.get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            RecursiveTaskTest.assertSame(t.getClass(), success.getCause().getClass());
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
        try {
            a.get(5L, TimeUnit.SECONDS);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            RecursiveTaskTest.assertSame(t.getClass(), success.getCause().getClass());
        }
        catch (Throwable fail) {
            this.threadUnexpectedException(fail);
        }
    }

    public void testInvoke() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask f = new FibTask(8);
                Integer r = (Integer)f.invoke();
                Assert.assertEquals((int)21, (int)r);
                RecursiveTaskTest.this.checkCompletedNormally(f, r);
                return r;
            }
        };
        RecursiveTaskTest.assertEquals((int)21, (int)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testQuietlyInvoke() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask f = new FibTask(8);
                f.quietlyInvoke();
                RecursiveTaskTest.this.checkCompletedNormally(f, 21);
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testForkJoin() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask f = new FibTask(8);
                Assert.assertSame((Object)f, f.fork());
                Integer r = (Integer)f.join();
                Assert.assertEquals((int)21, (int)r);
                RecursiveTaskTest.this.checkCompletedNormally(f, r);
                return r;
            }
        };
        RecursiveTaskTest.assertEquals((int)21, (int)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testForkGet() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() throws Exception {
                FibTask f = new FibTask(8);
                Assert.assertSame((Object)f, f.fork());
                Integer r = (Integer)f.get();
                Assert.assertEquals((int)21, (int)r);
                RecursiveTaskTest.this.checkCompletedNormally(f, r);
                return r;
            }
        };
        RecursiveTaskTest.assertEquals((int)21, (int)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testForkTimedGet() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() throws Exception {
                FibTask f = new FibTask(8);
                Assert.assertSame((Object)f, f.fork());
                Integer r = (Integer)f.get(5L, TimeUnit.SECONDS);
                Assert.assertEquals((int)21, (int)r);
                RecursiveTaskTest.this.checkCompletedNormally(f, r);
                return r;
            }
        };
        RecursiveTaskTest.assertEquals((int)21, (int)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testForkQuietlyJoin() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask f = new FibTask(8);
                Assert.assertSame((Object)f, f.fork());
                f.quietlyJoin();
                Integer r = (Integer)f.getRawResult();
                Assert.assertEquals((int)21, (int)r);
                RecursiveTaskTest.this.checkCompletedNormally(f, r);
                return r;
            }
        };
        RecursiveTaskTest.assertEquals((int)21, (int)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testForkHelpQuiesce() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask f = new FibTask(8);
                Assert.assertSame((Object)f, f.fork());
                f.helpQuiesce();
                Assert.assertEquals((int)0, (int)7.getQueuedTaskCount());
                RecursiveTaskTest.this.checkCompletedNormally(f, 21);
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testAbnormalInvoke() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FailingFibTask f = new FailingFibTask(8);
                try {
                    f.invoke();
                    RecursiveTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    RecursiveTaskTest.this.checkCompletedAbnormally(f, success);
                }
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testAbnormalQuietlyInvoke() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FailingFibTask f = new FailingFibTask(8);
                f.quietlyInvoke();
                Assert.assertTrue((boolean)(f.getException() instanceof FJException));
                RecursiveTaskTest.this.checkCompletedAbnormally(f, f.getException());
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testAbnormalForkJoin() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FailingFibTask f = new FailingFibTask(8);
                Assert.assertSame((Object)f, f.fork());
                try {
                    Integer r = (Integer)f.join();
                    RecursiveTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    RecursiveTaskTest.this.checkCompletedAbnormally(f, success);
                }
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testAbnormalForkGet() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() throws Exception {
                FailingFibTask f = new FailingFibTask(8);
                Assert.assertSame((Object)f, f.fork());
                try {
                    Integer r = (Integer)f.get();
                    RecursiveTaskTest.this.shouldThrow();
                }
                catch (ExecutionException success) {
                    Throwable cause = success.getCause();
                    Assert.assertTrue((boolean)(cause instanceof FJException));
                    RecursiveTaskTest.this.checkCompletedAbnormally(f, cause);
                }
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testAbnormalForkTimedGet() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() throws Exception {
                FailingFibTask f = new FailingFibTask(8);
                Assert.assertSame((Object)f, f.fork());
                try {
                    Integer r = (Integer)f.get(5L, TimeUnit.SECONDS);
                    RecursiveTaskTest.this.shouldThrow();
                }
                catch (ExecutionException success) {
                    Throwable cause = success.getCause();
                    Assert.assertTrue((boolean)(cause instanceof FJException));
                    RecursiveTaskTest.this.checkCompletedAbnormally(f, cause);
                }
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testAbnormalForkQuietlyJoin() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FailingFibTask f = new FailingFibTask(8);
                Assert.assertSame((Object)f, f.fork());
                f.quietlyJoin();
                Assert.assertTrue((boolean)(f.getException() instanceof FJException));
                RecursiveTaskTest.this.checkCompletedAbnormally(f, f.getException());
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testCancelledInvoke() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask f = new FibTask(8);
                Assert.assertTrue((boolean)f.cancel(true));
                try {
                    Integer r = (Integer)f.invoke();
                    RecursiveTaskTest.this.shouldThrow();
                }
                catch (CancellationException success) {
                    RecursiveTaskTest.this.checkCancelled(f);
                }
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testCancelledForkJoin() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask f = new FibTask(8);
                Assert.assertTrue((boolean)f.cancel(true));
                Assert.assertSame((Object)f, f.fork());
                try {
                    Integer r = (Integer)f.join();
                    RecursiveTaskTest.this.shouldThrow();
                }
                catch (CancellationException success) {
                    RecursiveTaskTest.this.checkCancelled(f);
                }
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testCancelledForkGet() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() throws Exception {
                FibTask f = new FibTask(8);
                Assert.assertTrue((boolean)f.cancel(true));
                Assert.assertSame((Object)f, f.fork());
                try {
                    Integer r = (Integer)f.get();
                    RecursiveTaskTest.this.shouldThrow();
                }
                catch (CancellationException success) {
                    RecursiveTaskTest.this.checkCancelled(f);
                }
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testCancelledForkTimedGet() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() throws Exception {
                FibTask f = new FibTask(8);
                Assert.assertTrue((boolean)f.cancel(true));
                Assert.assertSame((Object)f, f.fork());
                try {
                    Integer r = (Integer)f.get(5L, TimeUnit.SECONDS);
                    RecursiveTaskTest.this.shouldThrow();
                }
                catch (CancellationException success) {
                    RecursiveTaskTest.this.checkCancelled(f);
                }
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testCancelledForkQuietlyJoin() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask f = new FibTask(8);
                Assert.assertTrue((boolean)f.cancel(true));
                Assert.assertSame((Object)f, f.fork());
                f.quietlyJoin();
                RecursiveTaskTest.this.checkCancelled(f);
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testGetPool() {
        final ForkJoinPool mainPool = RecursiveTaskTest.mainPool();
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                Assert.assertSame((Object)mainPool, (Object)19.getPool());
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(mainPool, a));
    }

    public void testGetPool2() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                Assert.assertNull((Object)20.getPool());
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, a.invoke());
    }

    public void testInForkJoinPool() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                Assert.assertTrue((boolean)21.inForkJoinPool());
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testInForkJoinPool2() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                Assert.assertFalse((boolean)22.inForkJoinPool());
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, a.invoke());
    }

    public void testSetRawResult() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                this.setRawResult(NoResult);
                Assert.assertSame((Object)NoResult, this.getRawResult());
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, a.invoke());
    }

    public void testReinitialize() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask f = new FibTask(8);
                RecursiveTaskTest.this.checkNotDone(f);
                for (int i = 0; i < 3; ++i) {
                    Integer r = (Integer)f.invoke();
                    Assert.assertEquals((int)21, (int)r);
                    RecursiveTaskTest.this.checkCompletedNormally(f, r);
                    f.reinitialize();
                    f.publicSetRawResult(null);
                    RecursiveTaskTest.this.checkNotDone(f);
                }
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testReinitializeAbnormal() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FailingFibTask f = new FailingFibTask(8);
                RecursiveTaskTest.this.checkNotDone(f);
                for (int i = 0; i < 3; ++i) {
                    try {
                        f.invoke();
                        RecursiveTaskTest.this.shouldThrow();
                    }
                    catch (FJException success) {
                        RecursiveTaskTest.this.checkCompletedAbnormally(f, success);
                    }
                    f.reinitialize();
                    RecursiveTaskTest.this.checkNotDone(f);
                }
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testCompleteExceptionally() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask f = new FibTask(8);
                f.completeExceptionally(new FJException());
                try {
                    Integer r = (Integer)f.invoke();
                    RecursiveTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    RecursiveTaskTest.this.checkCompletedAbnormally(f, success);
                }
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testComplete() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask f = new FibTask(8);
                f.complete(NoResult);
                Integer r = (Integer)f.invoke();
                Assert.assertSame((Object)NoResult, (Object)r);
                RecursiveTaskTest.this.checkCompletedNormally(f, NoResult);
                return r;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testInvokeAll2() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask f = new FibTask(8);
                FibTask g = new FibTask(9);
                28.invokeAll(f, g);
                RecursiveTaskTest.this.checkCompletedNormally(f, 21);
                RecursiveTaskTest.this.checkCompletedNormally(g, 34);
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testInvokeAll1() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask f = new FibTask(8);
                29.invokeAll(f);
                RecursiveTaskTest.this.checkCompletedNormally(f, 21);
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testInvokeAll3() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask f = new FibTask(8);
                FibTask g = new FibTask(9);
                FibTask h = new FibTask(7);
                30.invokeAll(f, g, h);
                Assert.assertTrue((boolean)f.isDone());
                Assert.assertTrue((boolean)g.isDone());
                Assert.assertTrue((boolean)h.isDone());
                RecursiveTaskTest.this.checkCompletedNormally(f, 21);
                RecursiveTaskTest.this.checkCompletedNormally(g, 34);
                RecursiveTaskTest.this.checkCompletedNormally(h, 13);
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testInvokeAllCollection() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask f = new FibTask(8);
                FibTask g = new FibTask(9);
                FibTask h = new FibTask(7);
                HashSet<FibTask> set = new HashSet<FibTask>();
                set.add(f);
                set.add(g);
                set.add(h);
                31.invokeAll(set);
                Assert.assertTrue((boolean)f.isDone());
                Assert.assertTrue((boolean)g.isDone());
                Assert.assertTrue((boolean)h.isDone());
                RecursiveTaskTest.this.checkCompletedNormally(f, 21);
                RecursiveTaskTest.this.checkCompletedNormally(g, 34);
                RecursiveTaskTest.this.checkCompletedNormally(h, 13);
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testInvokeAllNPE() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask f = new FibTask(8);
                FibTask g = new FibTask(9);
                Object h = null;
                try {
                    32.invokeAll(f, g, h);
                    RecursiveTaskTest.this.shouldThrow();
                }
                catch (NullPointerException success) {
                    // empty catch block
                }
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testAbnormalInvokeAll2() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask f = new FibTask(8);
                FailingFibTask g = new FailingFibTask(9);
                try {
                    33.invokeAll(f, g);
                    RecursiveTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    RecursiveTaskTest.this.checkCompletedAbnormally(g, success);
                }
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testAbnormalInvokeAll1() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FailingFibTask g = new FailingFibTask(9);
                try {
                    34.invokeAll(g);
                    RecursiveTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    RecursiveTaskTest.this.checkCompletedAbnormally(g, success);
                }
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testAbnormalInvokeAll3() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask f = new FibTask(8);
                FailingFibTask g = new FailingFibTask(9);
                FibTask h = new FibTask(7);
                try {
                    35.invokeAll(f, g, h);
                    RecursiveTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    RecursiveTaskTest.this.checkCompletedAbnormally(g, success);
                }
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testAbnormalInvokeAllCollection() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FailingFibTask f = new FailingFibTask(8);
                FibTask g = new FibTask(9);
                FibTask h = new FibTask(7);
                HashSet<RecursiveTask> set = new HashSet<RecursiveTask>();
                set.add(f);
                set.add(g);
                set.add(h);
                try {
                    36.invokeAll(set);
                    RecursiveTaskTest.this.shouldThrow();
                }
                catch (FJException success) {
                    RecursiveTaskTest.this.checkCompletedAbnormally(f, success);
                }
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.mainPool(), a));
    }

    public void testTryUnfork() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask g = new FibTask(9);
                Assert.assertSame((Object)g, g.fork());
                FibTask f = new FibTask(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertTrue((boolean)f.tryUnfork());
                37.helpQuiesce();
                RecursiveTaskTest.this.checkNotDone(f);
                RecursiveTaskTest.this.checkCompletedNormally(g, 34);
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.singletonPool(), a));
    }

    public void testGetSurplusQueuedTaskCount() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask h = new FibTask(7);
                Assert.assertSame((Object)h, h.fork());
                FibTask g = new FibTask(9);
                Assert.assertSame((Object)g, g.fork());
                FibTask f = new FibTask(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertTrue((38.getSurplusQueuedTaskCount() > 0 ? 1 : 0) != 0);
                38.helpQuiesce();
                Assert.assertEquals((int)0, (int)38.getSurplusQueuedTaskCount());
                RecursiveTaskTest.this.checkCompletedNormally(f, 21);
                RecursiveTaskTest.this.checkCompletedNormally(g, 34);
                RecursiveTaskTest.this.checkCompletedNormally(h, 13);
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.singletonPool(), a));
    }

    public void testPeekNextLocalTask() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask g = new FibTask(9);
                Assert.assertSame((Object)g, g.fork());
                FibTask f = new FibTask(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertSame((Object)f, 39.peekNextLocalTask());
                RecursiveTaskTest.this.checkCompletesNormally(f, 21);
                39.helpQuiesce();
                RecursiveTaskTest.this.checkCompletedNormally(g, 34);
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.singletonPool(), a));
    }

    public void testPollNextLocalTask() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask g = new FibTask(9);
                Assert.assertSame((Object)g, g.fork());
                FibTask f = new FibTask(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertSame((Object)f, 40.pollNextLocalTask());
                40.helpQuiesce();
                RecursiveTaskTest.this.checkNotDone(f);
                RecursiveTaskTest.this.checkCompletedNormally(g, 34);
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.singletonPool(), a));
    }

    public void testPollTask() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask g = new FibTask(9);
                Assert.assertSame((Object)g, g.fork());
                FibTask f = new FibTask(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertSame((Object)f, 41.pollTask());
                41.helpQuiesce();
                RecursiveTaskTest.this.checkNotDone(f);
                RecursiveTaskTest.this.checkCompletedNormally(g, 34);
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.singletonPool(), a));
    }

    public void testPeekNextLocalTaskAsync() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask g = new FibTask(9);
                Assert.assertSame((Object)g, g.fork());
                FibTask f = new FibTask(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertSame((Object)g, 42.peekNextLocalTask());
                Assert.assertEquals((int)21, (int)((Integer)f.join()));
                42.helpQuiesce();
                RecursiveTaskTest.this.checkCompletedNormally(f, 21);
                RecursiveTaskTest.this.checkCompletedNormally(g, 34);
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.asyncSingletonPool(), a));
    }

    public void testPollNextLocalTaskAsync() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask g = new FibTask(9);
                Assert.assertSame((Object)g, g.fork());
                FibTask f = new FibTask(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertSame((Object)g, 43.pollNextLocalTask());
                43.helpQuiesce();
                RecursiveTaskTest.this.checkCompletedNormally(f, 21);
                RecursiveTaskTest.this.checkNotDone(g);
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.asyncSingletonPool(), a));
    }

    public void testPollTaskAsync() {
        JSR166TestCase.CheckedRecursiveTask<Integer> a = new JSR166TestCase.CheckedRecursiveTask<Integer>(){

            @Override
            public Integer realCompute() {
                FibTask g = new FibTask(9);
                Assert.assertSame((Object)g, g.fork());
                FibTask f = new FibTask(8);
                Assert.assertSame((Object)f, f.fork());
                Assert.assertSame((Object)g, 44.pollTask());
                44.helpQuiesce();
                RecursiveTaskTest.this.checkCompletedNormally(f, 21);
                RecursiveTaskTest.this.checkNotDone(g);
                return NoResult;
            }
        };
        RecursiveTaskTest.assertSame((Object)NoResult, (Object)this.testInvokeOnPool(RecursiveTaskTest.asyncSingletonPool(), a));
    }

    final class FailingFibTask
    extends RecursiveTask<Integer> {
        final int number;
        int result;

        FailingFibTask(int n) {
            this.number = n;
        }

        @Override
        public Integer compute() {
            int n = this.number;
            if (n <= 1) {
                throw new FJException();
            }
            FailingFibTask f1 = new FailingFibTask(n - 1);
            f1.fork();
            return (Integer)new FibTask(n - 2).compute() + (Integer)f1.join();
        }
    }

    final class FibTask
    extends JSR166TestCase.CheckedRecursiveTask<Integer> {
        final int number;

        FibTask(int n) {
            this.number = n;
        }

        @Override
        public Integer realCompute() {
            int n = this.number;
            if (n <= 1) {
                return n;
            }
            FibTask f1 = new FibTask(n - 1);
            f1.fork();
            return (Integer)new FibTask(n - 2).compute() + (Integer)f1.join();
        }

        public void publicSetRawResult(Integer result) {
            this.setRawResult(result);
        }
    }

    public static final class FJException
    extends RuntimeException {
    }
}

