/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ReentrantLockTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)ReentrantLockTest.suite());
    }

    public static Test suite() {
        return new TestSuite(ReentrantLockTest.class);
    }

    void releaseLock(PublicReentrantLock lock) {
        this.assertLockedBy(lock, Thread.currentThread());
        lock.unlock();
        ReentrantLockTest.assertFalse((boolean)lock.isHeldByCurrentThread());
        this.assertNotLocked(lock);
    }

    void waitForQueuedThread(PublicReentrantLock lock, Thread t) {
        long startTime = System.nanoTime();
        while (!lock.hasQueuedThread(t)) {
            if (this.millisElapsedSince(startTime) > LONG_DELAY_MS) {
                throw new AssertionError((Object)"timed out");
            }
            Thread.yield();
        }
        ReentrantLockTest.assertTrue((boolean)t.isAlive());
        ReentrantLockTest.assertTrue((lock.getOwner() != t ? 1 : 0) != 0);
    }

    void assertNotLocked(PublicReentrantLock lock) {
        ReentrantLockTest.assertFalse((boolean)lock.isLocked());
        ReentrantLockTest.assertFalse((boolean)lock.isHeldByCurrentThread());
        ReentrantLockTest.assertNull((Object)lock.getOwner());
        ReentrantLockTest.assertEquals((int)0, (int)lock.getHoldCount());
    }

    void assertLockedBy(PublicReentrantLock lock, Thread t) {
        ReentrantLockTest.assertTrue((boolean)lock.isLocked());
        ReentrantLockTest.assertSame((Object)t, (Object)lock.getOwner());
        ReentrantLockTest.assertEquals((t == Thread.currentThread() ? 1 : 0) != 0, (boolean)lock.isHeldByCurrentThread());
        ReentrantLockTest.assertEquals((t == Thread.currentThread() ? 1 : 0) != 0, (lock.getHoldCount() > 0 ? 1 : 0) != 0);
    }

    void assertHasNoWaiters(PublicReentrantLock lock, Condition c) {
        this.assertHasWaiters(lock, c, new Thread[0]);
    }

    void assertHasWaiters(PublicReentrantLock lock, Condition c, Thread ... threads) {
        lock.lock();
        ReentrantLockTest.assertEquals((threads.length > 0 ? 1 : 0) != 0, (boolean)lock.hasWaiters(c));
        ReentrantLockTest.assertEquals((int)threads.length, (int)lock.getWaitQueueLength(c));
        ReentrantLockTest.assertEquals((threads.length == 0 ? 1 : 0) != 0, (boolean)lock.getWaitingThreads(c).isEmpty());
        ReentrantLockTest.assertEquals((int)threads.length, (int)lock.getWaitingThreads(c).size());
        ReentrantLockTest.assertEquals(new HashSet<Thread>(lock.getWaitingThreads(c)), new HashSet<Thread>(Arrays.asList(threads)));
        lock.unlock();
    }

    public void testConstructor() {
        PublicReentrantLock lock = new PublicReentrantLock();
        ReentrantLockTest.assertFalse((boolean)lock.isFair());
        this.assertNotLocked(lock);
        lock = new PublicReentrantLock(true);
        ReentrantLockTest.assertTrue((boolean)lock.isFair());
        this.assertNotLocked(lock);
        lock = new PublicReentrantLock(false);
        ReentrantLockTest.assertFalse((boolean)lock.isFair());
        this.assertNotLocked(lock);
    }

    public void testLock() {
        PublicReentrantLock lock = new PublicReentrantLock();
        lock.lock();
        this.assertLockedBy(lock, Thread.currentThread());
        this.releaseLock(lock);
    }

    public void testFairLock() {
        PublicReentrantLock lock = new PublicReentrantLock(true);
        lock.lock();
        this.assertLockedBy(lock, Thread.currentThread());
        this.releaseLock(lock);
    }

    public void testUnlock_IllegalMonitorStateException() {
        ReentrantLock lock = new ReentrantLock();
        try {
            lock.unlock();
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testTryLock() {
        PublicReentrantLock lock = new PublicReentrantLock();
        ReentrantLockTest.assertTrue((boolean)lock.tryLock());
        this.assertLockedBy(lock, Thread.currentThread());
        this.releaseLock(lock);
    }

    public void testHasQueuedThreads() throws InterruptedException {
        PublicReentrantLock lock = new PublicReentrantLock();
        Thread t1 = new Thread(new InterruptedLockRunnable(lock));
        Thread t2 = new Thread(new InterruptibleLockRunnable(lock));
        ReentrantLockTest.assertFalse((boolean)lock.hasQueuedThreads());
        lock.lock();
        ReentrantLockTest.assertFalse((boolean)lock.hasQueuedThreads());
        t1.start();
        this.waitForQueuedThread(lock, t1);
        ReentrantLockTest.assertTrue((boolean)lock.hasQueuedThreads());
        t2.start();
        this.waitForQueuedThread(lock, t2);
        ReentrantLockTest.assertTrue((boolean)lock.hasQueuedThreads());
        t1.interrupt();
        this.awaitTermination(t1);
        ReentrantLockTest.assertTrue((boolean)lock.hasQueuedThreads());
        lock.unlock();
        this.awaitTermination(t2);
        ReentrantLockTest.assertFalse((boolean)lock.hasQueuedThreads());
    }

    public void testGetQueueLength() throws InterruptedException {
        PublicReentrantLock lock = new PublicReentrantLock();
        Thread t1 = new Thread(new InterruptedLockRunnable(lock));
        Thread t2 = new Thread(new InterruptibleLockRunnable(lock));
        ReentrantLockTest.assertEquals((int)0, (int)lock.getQueueLength());
        lock.lock();
        t1.start();
        this.waitForQueuedThread(lock, t1);
        ReentrantLockTest.assertEquals((int)1, (int)lock.getQueueLength());
        t2.start();
        this.waitForQueuedThread(lock, t2);
        ReentrantLockTest.assertEquals((int)2, (int)lock.getQueueLength());
        t1.interrupt();
        this.awaitTermination(t1);
        ReentrantLockTest.assertEquals((int)1, (int)lock.getQueueLength());
        lock.unlock();
        this.awaitTermination(t2);
        ReentrantLockTest.assertEquals((int)0, (int)lock.getQueueLength());
    }

    public void testGetQueueLength_fair() throws InterruptedException {
        PublicReentrantLock lock = new PublicReentrantLock(true);
        Thread t1 = new Thread(new InterruptedLockRunnable(lock));
        Thread t2 = new Thread(new InterruptibleLockRunnable(lock));
        ReentrantLockTest.assertEquals((int)0, (int)lock.getQueueLength());
        lock.lock();
        t1.start();
        this.waitForQueuedThread(lock, t1);
        ReentrantLockTest.assertEquals((int)1, (int)lock.getQueueLength());
        t2.start();
        this.waitForQueuedThread(lock, t2);
        ReentrantLockTest.assertEquals((int)2, (int)lock.getQueueLength());
        t1.interrupt();
        this.awaitTermination(t1);
        ReentrantLockTest.assertEquals((int)1, (int)lock.getQueueLength());
        lock.unlock();
        this.awaitTermination(t2);
        ReentrantLockTest.assertEquals((int)0, (int)lock.getQueueLength());
    }

    public void testHasQueuedThreadNPE() {
        ReentrantLock lock = new ReentrantLock();
        try {
            lock.hasQueuedThread(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testHasQueuedThread() throws InterruptedException {
        PublicReentrantLock lock = new PublicReentrantLock();
        Thread t1 = new Thread(new InterruptedLockRunnable(lock));
        Thread t2 = new Thread(new InterruptibleLockRunnable(lock));
        ReentrantLockTest.assertFalse((boolean)lock.hasQueuedThread(t1));
        ReentrantLockTest.assertFalse((boolean)lock.hasQueuedThread(t2));
        lock.lock();
        t1.start();
        this.waitForQueuedThread(lock, t1);
        ReentrantLockTest.assertTrue((boolean)lock.hasQueuedThread(t1));
        ReentrantLockTest.assertFalse((boolean)lock.hasQueuedThread(t2));
        t2.start();
        this.waitForQueuedThread(lock, t2);
        ReentrantLockTest.assertTrue((boolean)lock.hasQueuedThread(t1));
        ReentrantLockTest.assertTrue((boolean)lock.hasQueuedThread(t2));
        t1.interrupt();
        this.awaitTermination(t1);
        ReentrantLockTest.assertFalse((boolean)lock.hasQueuedThread(t1));
        ReentrantLockTest.assertTrue((boolean)lock.hasQueuedThread(t2));
        lock.unlock();
        this.awaitTermination(t2);
        ReentrantLockTest.assertFalse((boolean)lock.hasQueuedThread(t1));
        ReentrantLockTest.assertFalse((boolean)lock.hasQueuedThread(t2));
    }

    public void testGetQueuedThreads() throws InterruptedException {
        PublicReentrantLock lock = new PublicReentrantLock();
        Thread t1 = new Thread(new InterruptedLockRunnable(lock));
        Thread t2 = new Thread(new InterruptibleLockRunnable(lock));
        ReentrantLockTest.assertTrue((boolean)lock.getQueuedThreads().isEmpty());
        lock.lock();
        ReentrantLockTest.assertTrue((boolean)lock.getQueuedThreads().isEmpty());
        t1.start();
        this.waitForQueuedThread(lock, t1);
        ReentrantLockTest.assertEquals((int)1, (int)lock.getQueuedThreads().size());
        ReentrantLockTest.assertTrue((boolean)lock.getQueuedThreads().contains(t1));
        t2.start();
        this.waitForQueuedThread(lock, t2);
        ReentrantLockTest.assertEquals((int)2, (int)lock.getQueuedThreads().size());
        ReentrantLockTest.assertTrue((boolean)lock.getQueuedThreads().contains(t1));
        ReentrantLockTest.assertTrue((boolean)lock.getQueuedThreads().contains(t2));
        t1.interrupt();
        this.awaitTermination(t1);
        ReentrantLockTest.assertFalse((boolean)lock.getQueuedThreads().contains(t1));
        ReentrantLockTest.assertTrue((boolean)lock.getQueuedThreads().contains(t2));
        ReentrantLockTest.assertEquals((int)1, (int)lock.getQueuedThreads().size());
        lock.unlock();
        this.awaitTermination(t2);
        ReentrantLockTest.assertTrue((boolean)lock.getQueuedThreads().isEmpty());
    }

    public void testTryLock_Interrupted() throws InterruptedException {
        final PublicReentrantLock lock = new PublicReentrantLock();
        lock.lock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.tryLock(2L * JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        });
        this.waitForQueuedThread(lock, t);
        t.interrupt();
        this.awaitTermination(t);
        this.releaseLock(lock);
    }

    public void testTryLockWhenLocked() throws InterruptedException {
        final PublicReentrantLock lock = new PublicReentrantLock();
        lock.lock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                Assert.assertFalse((boolean)lock.tryLock());
            }
        });
        this.awaitTermination(t);
        this.releaseLock(lock);
    }

    public void testTryLock_Timeout() throws InterruptedException {
        final PublicReentrantLock lock = new PublicReentrantLock();
        lock.lock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                long startTime = System.nanoTime();
                long timeoutMillis = 10L;
                Assert.assertFalse((boolean)lock.tryLock(timeoutMillis, TimeUnit.MILLISECONDS));
                Assert.assertTrue((ReentrantLockTest.this.millisElapsedSince(startTime) >= timeoutMillis ? 1 : 0) != 0);
            }
        });
        this.awaitTermination(t);
        this.releaseLock(lock);
    }

    public void testGetHoldCount() {
        int i;
        ReentrantLock lock = new ReentrantLock();
        for (i = 1; i <= 20; ++i) {
            lock.lock();
            ReentrantLockTest.assertEquals((int)i, (int)lock.getHoldCount());
        }
        for (i = 20; i > 0; --i) {
            lock.unlock();
            ReentrantLockTest.assertEquals((int)(i - 1), (int)lock.getHoldCount());
        }
    }

    public void testIsLocked() throws Exception {
        final ReentrantLock lock = new ReentrantLock();
        ReentrantLockTest.assertFalse((boolean)lock.isLocked());
        lock.lock();
        ReentrantLockTest.assertTrue((boolean)lock.isLocked());
        lock.lock();
        ReentrantLockTest.assertTrue((boolean)lock.isLocked());
        lock.unlock();
        ReentrantLockTest.assertTrue((boolean)lock.isLocked());
        lock.unlock();
        ReentrantLockTest.assertFalse((boolean)lock.isLocked());
        final CyclicBarrier barrier = new CyclicBarrier(2);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws Exception {
                lock.lock();
                Assert.assertTrue((boolean)lock.isLocked());
                barrier.await();
                barrier.await();
                lock.unlock();
            }
        });
        barrier.await();
        ReentrantLockTest.assertTrue((boolean)lock.isLocked());
        barrier.await();
        this.awaitTermination(t);
        ReentrantLockTest.assertFalse((boolean)lock.isLocked());
    }

    public void testLockInterruptibly_Interrupted() throws InterruptedException {
        PublicReentrantLock lock = new PublicReentrantLock();
        lock.lock();
        Thread t = this.newStartedThread(new InterruptedLockRunnable(lock));
        this.waitForQueuedThread(lock, t);
        t.interrupt();
        this.awaitTermination(t);
        this.releaseLock(lock);
    }

    public void testLockInterruptibly_Interrupted2() throws InterruptedException {
        PublicReentrantLock lock = new PublicReentrantLock();
        lock.lockInterruptibly();
        Thread t = this.newStartedThread(new InterruptedLockRunnable(lock));
        this.waitForQueuedThread(lock, t);
        t.interrupt();
        ReentrantLockTest.assertTrue((boolean)lock.isLocked());
        ReentrantLockTest.assertTrue((boolean)lock.isHeldByCurrentThread());
        this.awaitTermination(t);
        this.releaseLock(lock);
    }

    public void testAwait_IllegalMonitor() throws InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        Condition c = lock.newCondition();
        try {
            c.await();
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException success) {
            // empty catch block
        }
        try {
            c.await(LONG_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException success) {
            // empty catch block
        }
        try {
            c.awaitNanos(100L);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException success) {
            // empty catch block
        }
        try {
            c.awaitUninterruptibly();
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testSignal_IllegalMonitor() {
        ReentrantLock lock = new ReentrantLock();
        Condition c = lock.newCondition();
        try {
            c.signal();
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testAwaitNanos_Timeout() throws InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        Condition c = lock.newCondition();
        lock.lock();
        long startTime = System.nanoTime();
        long timeoutMillis = 10L;
        long timeoutNanos = TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
        long nanosRemaining = c.awaitNanos(timeoutNanos);
        ReentrantLockTest.assertTrue((nanosRemaining <= 0L ? 1 : 0) != 0);
        ReentrantLockTest.assertTrue((this.millisElapsedSince(startTime) >= timeoutMillis ? 1 : 0) != 0);
        lock.unlock();
    }

    public void testAwait_Timeout() throws InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        Condition c = lock.newCondition();
        lock.lock();
        long startTime = System.nanoTime();
        long timeoutMillis = 10L;
        ReentrantLockTest.assertFalse((boolean)c.await(timeoutMillis, TimeUnit.MILLISECONDS));
        ReentrantLockTest.assertTrue((this.millisElapsedSince(startTime) >= timeoutMillis ? 1 : 0) != 0);
        lock.unlock();
    }

    public void testAwaitUntil_Timeout() throws InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        Condition c = lock.newCondition();
        lock.lock();
        long startTime = System.nanoTime();
        long timeoutMillis = 10L;
        Date d = new Date();
        ReentrantLockTest.assertFalse((boolean)c.awaitUntil(new Date(d.getTime() + timeoutMillis)));
        ReentrantLockTest.assertTrue((this.millisElapsedSince(startTime) >= timeoutMillis ? 1 : 0) != 0);
        lock.unlock();
    }

    public void testAwait() throws InterruptedException {
        final PublicReentrantLock lock = new PublicReentrantLock();
        final Condition c = lock.newCondition();
        final CountDownLatch locked = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.lock();
                locked.countDown();
                c.await();
                lock.unlock();
            }
        });
        locked.await();
        lock.lock();
        this.assertHasWaiters(lock, c, t);
        c.signal();
        this.assertHasNoWaiters(lock, c);
        ReentrantLockTest.assertTrue((boolean)t.isAlive());
        lock.unlock();
        this.awaitTermination(t);
    }

    public void testHasWaitersNPE() {
        ReentrantLock lock = new ReentrantLock();
        try {
            lock.hasWaiters(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetWaitQueueLengthNPE() {
        ReentrantLock lock = new ReentrantLock();
        try {
            lock.getWaitQueueLength(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetWaitingThreadsNPE() {
        PublicReentrantLock lock = new PublicReentrantLock();
        try {
            lock.getWaitingThreads(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testHasWaitersIAE() {
        ReentrantLock lock = new ReentrantLock();
        Condition c = lock.newCondition();
        ReentrantLock lock2 = new ReentrantLock();
        try {
            lock2.hasWaiters(c);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            // empty catch block
        }
    }

    public void testHasWaitersIMSE() {
        ReentrantLock lock = new ReentrantLock();
        Condition c = lock.newCondition();
        try {
            lock.hasWaiters(c);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testGetWaitQueueLengthIAE() {
        ReentrantLock lock = new ReentrantLock();
        Condition c = lock.newCondition();
        ReentrantLock lock2 = new ReentrantLock();
        try {
            lock2.getWaitQueueLength(c);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            // empty catch block
        }
    }

    public void testGetWaitQueueLengthIMSE() {
        ReentrantLock lock = new ReentrantLock();
        Condition c = lock.newCondition();
        try {
            lock.getWaitQueueLength(c);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testGetWaitingThreadsIAE() {
        PublicReentrantLock lock = new PublicReentrantLock();
        Condition c = lock.newCondition();
        PublicReentrantLock lock2 = new PublicReentrantLock();
        try {
            lock2.getWaitingThreads(c);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            // empty catch block
        }
    }

    public void testGetWaitingThreadsIMSE() {
        PublicReentrantLock lock = new PublicReentrantLock();
        Condition c = lock.newCondition();
        try {
            lock.getWaitingThreads(c);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testHasWaiters() throws InterruptedException {
        final PublicReentrantLock lock = new PublicReentrantLock();
        final Condition c = lock.newCondition();
        final CountDownLatch locked = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.lock();
                ReentrantLockTest.this.assertHasNoWaiters(lock, c);
                Assert.assertFalse((boolean)lock.hasWaiters(c));
                locked.countDown();
                c.await();
                ReentrantLockTest.this.assertHasNoWaiters(lock, c);
                Assert.assertFalse((boolean)lock.hasWaiters(c));
                lock.unlock();
            }
        });
        locked.await();
        lock.lock();
        this.assertHasWaiters(lock, c, t);
        ReentrantLockTest.assertTrue((boolean)lock.hasWaiters(c));
        c.signal();
        this.assertHasNoWaiters(lock, c);
        ReentrantLockTest.assertFalse((boolean)lock.hasWaiters(c));
        lock.unlock();
        this.awaitTermination(t);
        this.assertHasNoWaiters(lock, c);
    }

    public void testGetWaitQueueLength() throws InterruptedException {
        final PublicReentrantLock lock = new PublicReentrantLock();
        final Condition c = lock.newCondition();
        final CountDownLatch locked1 = new CountDownLatch(1);
        final CountDownLatch locked2 = new CountDownLatch(1);
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.lock();
                Assert.assertFalse((boolean)lock.hasWaiters(c));
                Assert.assertEquals((int)0, (int)lock.getWaitQueueLength(c));
                locked1.countDown();
                c.await();
                lock.unlock();
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.lock();
                Assert.assertTrue((boolean)lock.hasWaiters(c));
                Assert.assertEquals((int)1, (int)lock.getWaitQueueLength(c));
                locked2.countDown();
                c.await();
                lock.unlock();
            }
        });
        lock.lock();
        ReentrantLockTest.assertEquals((int)0, (int)lock.getWaitQueueLength(c));
        lock.unlock();
        t1.start();
        locked1.await();
        lock.lock();
        this.assertHasWaiters(lock, c, t1);
        ReentrantLockTest.assertEquals((int)1, (int)lock.getWaitQueueLength(c));
        lock.unlock();
        t2.start();
        locked2.await();
        lock.lock();
        this.assertHasWaiters(lock, c, t1, t2);
        ReentrantLockTest.assertEquals((int)2, (int)lock.getWaitQueueLength(c));
        c.signalAll();
        this.assertHasNoWaiters(lock, c);
        lock.unlock();
        this.awaitTermination(t1);
        this.awaitTermination(t2);
        this.assertHasNoWaiters(lock, c);
    }

    public void testGetWaitingThreads() throws InterruptedException {
        final PublicReentrantLock lock = new PublicReentrantLock();
        final Condition c = lock.newCondition();
        final CountDownLatch locked1 = new CountDownLatch(1);
        final CountDownLatch locked2 = new CountDownLatch(1);
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.lock();
                Assert.assertTrue((boolean)lock.getWaitingThreads(c).isEmpty());
                locked1.countDown();
                c.await();
                lock.unlock();
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.lock();
                Assert.assertFalse((boolean)lock.getWaitingThreads(c).isEmpty());
                locked2.countDown();
                c.await();
                lock.unlock();
            }
        });
        lock.lock();
        ReentrantLockTest.assertTrue((boolean)lock.getWaitingThreads(c).isEmpty());
        lock.unlock();
        t1.start();
        locked1.await();
        lock.lock();
        this.assertHasWaiters(lock, c, t1);
        ReentrantLockTest.assertTrue((boolean)lock.getWaitingThreads(c).contains(t1));
        ReentrantLockTest.assertFalse((boolean)lock.getWaitingThreads(c).contains(t2));
        ReentrantLockTest.assertEquals((int)1, (int)lock.getWaitingThreads(c).size());
        lock.unlock();
        t2.start();
        locked2.await();
        lock.lock();
        this.assertHasWaiters(lock, c, t1, t2);
        ReentrantLockTest.assertTrue((boolean)lock.getWaitingThreads(c).contains(t1));
        ReentrantLockTest.assertTrue((boolean)lock.getWaitingThreads(c).contains(t2));
        ReentrantLockTest.assertEquals((int)2, (int)lock.getWaitingThreads(c).size());
        c.signalAll();
        this.assertHasNoWaiters(lock, c);
        lock.unlock();
        this.awaitTermination(t1);
        this.awaitTermination(t2);
        this.assertHasNoWaiters(lock, c);
    }

    public void testAwaitUninterruptibly() throws InterruptedException {
        final ReentrantLock lock = new ReentrantLock();
        final Condition c = lock.newCondition();
        final CountDownLatch locked = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                lock.lock();
                locked.countDown();
                c.awaitUninterruptibly();
                Assert.assertTrue((boolean)Thread.interrupted());
                lock.unlock();
            }
        });
        locked.await();
        lock.lock();
        lock.unlock();
        t.interrupt();
        long timeoutMillis = 10L;
        this.assertThreadJoinTimesOut(t, timeoutMillis);
        lock.lock();
        c.signal();
        lock.unlock();
        this.awaitTermination(t);
    }

    public void testAwait_Interrupt() throws InterruptedException {
        final PublicReentrantLock lock = new PublicReentrantLock();
        final Condition c = lock.newCondition();
        final CountDownLatch locked = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void realRun() throws InterruptedException {
                lock.lock();
                Assert.assertTrue((boolean)lock.isLocked());
                Assert.assertTrue((boolean)lock.isHeldByCurrentThread());
                ReentrantLockTest.this.assertHasNoWaiters(lock, c);
                locked.countDown();
                try {
                    c.await();
                }
                finally {
                    Assert.assertTrue((boolean)lock.isLocked());
                    Assert.assertTrue((boolean)lock.isHeldByCurrentThread());
                    ReentrantLockTest.this.assertHasNoWaiters(lock, c);
                    lock.unlock();
                    Assert.assertFalse((boolean)Thread.interrupted());
                }
            }
        });
        locked.await();
        this.assertHasWaiters(lock, c, t);
        t.interrupt();
        this.awaitTermination(t);
        ReentrantLockTest.assertFalse((boolean)lock.isLocked());
    }

    public void testAwaitNanos_Interrupt() throws InterruptedException {
        final PublicReentrantLock lock = new PublicReentrantLock();
        final Condition c = lock.newCondition();
        final CountDownLatch locked = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void realRun() throws InterruptedException {
                lock.lock();
                Assert.assertTrue((boolean)lock.isLocked());
                Assert.assertTrue((boolean)lock.isHeldByCurrentThread());
                ReentrantLockTest.this.assertHasNoWaiters(lock, c);
                locked.countDown();
                try {
                    c.awaitNanos(TimeUnit.MILLISECONDS.toNanos(2L * JSR166TestCase.LONG_DELAY_MS));
                }
                finally {
                    Assert.assertTrue((boolean)lock.isLocked());
                    Assert.assertTrue((boolean)lock.isHeldByCurrentThread());
                    ReentrantLockTest.this.assertHasNoWaiters(lock, c);
                    lock.unlock();
                    Assert.assertFalse((boolean)Thread.interrupted());
                }
            }
        });
        locked.await();
        this.assertHasWaiters(lock, c, t);
        t.interrupt();
        this.awaitTermination(t);
        ReentrantLockTest.assertFalse((boolean)lock.isLocked());
    }

    public void testAwaitUntil_Interrupt() throws InterruptedException {
        final PublicReentrantLock lock = new PublicReentrantLock();
        final Condition c = lock.newCondition();
        final CountDownLatch locked = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void realRun() throws InterruptedException {
                lock.lock();
                Assert.assertTrue((boolean)lock.isLocked());
                Assert.assertTrue((boolean)lock.isHeldByCurrentThread());
                ReentrantLockTest.this.assertHasNoWaiters(lock, c);
                locked.countDown();
                Date d = new Date();
                try {
                    c.awaitUntil(new Date(d.getTime() + 2L * JSR166TestCase.LONG_DELAY_MS));
                }
                finally {
                    Assert.assertTrue((boolean)lock.isLocked());
                    Assert.assertTrue((boolean)lock.isHeldByCurrentThread());
                    ReentrantLockTest.this.assertHasNoWaiters(lock, c);
                    lock.unlock();
                    Assert.assertFalse((boolean)Thread.interrupted());
                }
            }
        });
        locked.await();
        this.assertHasWaiters(lock, c, t);
        t.interrupt();
        this.awaitTermination(t);
        ReentrantLockTest.assertFalse((boolean)lock.isLocked());
    }

    public void testSignalAll() throws InterruptedException {
        final PublicReentrantLock lock = new PublicReentrantLock();
        final Condition c = lock.newCondition();
        final CountDownLatch locked = new CountDownLatch(2);
        Thread t1 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.lock();
                locked.countDown();
                c.await();
                lock.unlock();
            }
        });
        Thread t2 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.lock();
                locked.countDown();
                c.await();
                lock.unlock();
            }
        });
        locked.await();
        lock.lock();
        this.assertHasWaiters(lock, c, t1, t2);
        c.signalAll();
        this.assertHasNoWaiters(lock, c);
        lock.unlock();
        this.awaitTermination(t1);
        this.awaitTermination(t2);
    }

    public void testAwaitLockCount() throws InterruptedException {
        final PublicReentrantLock lock = new PublicReentrantLock();
        final Condition c = lock.newCondition();
        final CountDownLatch locked = new CountDownLatch(2);
        Thread t1 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.lock();
                ReentrantLockTest.this.assertLockedBy(lock, Thread.currentThread());
                Assert.assertEquals((int)1, (int)lock.getHoldCount());
                locked.countDown();
                c.await();
                ReentrantLockTest.this.assertLockedBy(lock, Thread.currentThread());
                Assert.assertEquals((int)1, (int)lock.getHoldCount());
                lock.unlock();
            }
        });
        Thread t2 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.lock();
                lock.lock();
                ReentrantLockTest.this.assertLockedBy(lock, Thread.currentThread());
                Assert.assertEquals((int)2, (int)lock.getHoldCount());
                locked.countDown();
                c.await();
                ReentrantLockTest.this.assertLockedBy(lock, Thread.currentThread());
                Assert.assertEquals((int)2, (int)lock.getHoldCount());
                lock.unlock();
                lock.unlock();
            }
        });
        locked.await();
        lock.lock();
        this.assertHasWaiters(lock, c, t1, t2);
        ReentrantLockTest.assertEquals((int)1, (int)lock.getHoldCount());
        c.signalAll();
        this.assertHasNoWaiters(lock, c);
        lock.unlock();
        this.awaitTermination(t1);
        this.awaitTermination(t2);
    }

    public void testSerialization() throws Exception {
        ReentrantLock l = new ReentrantLock();
        l.lock();
        l.unlock();
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(l);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        ReentrantLock r = (ReentrantLock)in.readObject();
        r.lock();
        r.unlock();
    }

    public void testToString() {
        ReentrantLock lock = new ReentrantLock();
        String us = lock.toString();
        ReentrantLockTest.assertTrue((us.indexOf("Unlocked") >= 0 ? 1 : 0) != 0);
        lock.lock();
        String ls = lock.toString();
        ReentrantLockTest.assertTrue((ls.indexOf("Locked") >= 0 ? 1 : 0) != 0);
    }

    static class PublicReentrantLock
    extends ReentrantLock {
        PublicReentrantLock() {
        }

        PublicReentrantLock(boolean fair) {
            super(fair);
        }

        @Override
        public Thread getOwner() {
            return super.getOwner();
        }

        @Override
        public Collection<Thread> getQueuedThreads() {
            return super.getQueuedThreads();
        }

        @Override
        public Collection<Thread> getWaitingThreads(Condition c) {
            return super.getWaitingThreads(c);
        }
    }

    class InterruptedLockRunnable
    extends JSR166TestCase.CheckedInterruptedRunnable {
        final ReentrantLock lock;

        InterruptedLockRunnable(ReentrantLock l) {
            super(ReentrantLockTest.this);
            this.lock = l;
        }

        @Override
        public void realRun() throws InterruptedException {
            this.lock.lockInterruptibly();
        }
    }

    class InterruptibleLockRunnable
    extends JSR166TestCase.CheckedRunnable {
        final ReentrantLock lock;

        InterruptibleLockRunnable(ReentrantLock l) {
            super(ReentrantLockTest.this);
            this.lock = l;
        }

        @Override
        public void realRun() throws InterruptedException {
            this.lock.lockInterruptibly();
        }
    }
}

