/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ReentrantReadWriteLockTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)ReentrantReadWriteLockTest.suite());
    }

    public static Test suite() {
        return new TestSuite(ReentrantReadWriteLockTest.class);
    }

    void releaseWriteLock(PublicReentrantReadWriteLock lock) {
        ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();
        this.assertWriteLockedBy(lock, Thread.currentThread());
        ReentrantReadWriteLockTest.assertEquals((int)1, (int)lock.getWriteHoldCount());
        writeLock.unlock();
        this.assertNotWriteLocked(lock);
    }

    void waitForQueuedThread(PublicReentrantReadWriteLock lock, Thread t) {
        long startTime = System.nanoTime();
        while (!lock.hasQueuedThread(t)) {
            if (this.millisElapsedSince(startTime) > LONG_DELAY_MS) {
                throw new AssertionError((Object)"timed out");
            }
            Thread.yield();
        }
        ReentrantReadWriteLockTest.assertTrue((boolean)t.isAlive());
        ReentrantReadWriteLockTest.assertTrue((lock.getOwner() != t ? 1 : 0) != 0);
    }

    void assertNotWriteLocked(PublicReentrantReadWriteLock lock) {
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.isWriteLocked());
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.isWriteLockedByCurrentThread());
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.writeLock().isHeldByCurrentThread());
        ReentrantReadWriteLockTest.assertNull((Object)lock.getOwner());
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)lock.getWriteHoldCount());
    }

    void assertWriteLockedBy(PublicReentrantReadWriteLock lock, Thread t) {
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.isWriteLocked());
        ReentrantReadWriteLockTest.assertSame((Object)t, (Object)lock.getOwner());
        ReentrantReadWriteLockTest.assertEquals((t == Thread.currentThread() ? 1 : 0) != 0, (boolean)lock.isWriteLockedByCurrentThread());
        ReentrantReadWriteLockTest.assertEquals((t == Thread.currentThread() ? 1 : 0) != 0, (boolean)lock.writeLock().isHeldByCurrentThread());
        ReentrantReadWriteLockTest.assertEquals((t == Thread.currentThread() ? 1 : 0) != 0, (lock.getWriteHoldCount() > 0 ? 1 : 0) != 0);
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)lock.getReadLockCount());
    }

    void assertHasNoWaiters(PublicReentrantReadWriteLock lock, Condition c) {
        this.assertHasWaiters(lock, c, new Thread[0]);
    }

    void assertHasWaiters(PublicReentrantReadWriteLock lock, Condition c, Thread ... threads) {
        lock.writeLock().lock();
        ReentrantReadWriteLockTest.assertEquals((threads.length > 0 ? 1 : 0) != 0, (boolean)lock.hasWaiters(c));
        ReentrantReadWriteLockTest.assertEquals((int)threads.length, (int)lock.getWaitQueueLength(c));
        ReentrantReadWriteLockTest.assertEquals((threads.length == 0 ? 1 : 0) != 0, (boolean)lock.getWaitingThreads(c).isEmpty());
        ReentrantReadWriteLockTest.assertEquals((int)threads.length, (int)lock.getWaitingThreads(c).size());
        ReentrantReadWriteLockTest.assertEquals(new HashSet<Thread>(lock.getWaitingThreads(c)), new HashSet<Thread>(Arrays.asList(threads)));
        lock.writeLock().unlock();
    }

    public void testConstructor() {
        PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.isFair());
        this.assertNotWriteLocked(lock);
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)lock.getReadLockCount());
        lock = new PublicReentrantReadWriteLock(true);
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.isFair());
        this.assertNotWriteLocked(lock);
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)lock.getReadLockCount());
        lock = new PublicReentrantReadWriteLock(false);
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.isFair());
        this.assertNotWriteLocked(lock);
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)lock.getReadLockCount());
    }

    public void testLock() {
        PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        this.assertNotWriteLocked(lock);
        lock.writeLock().lock();
        this.assertWriteLockedBy(lock, Thread.currentThread());
        lock.writeLock().unlock();
        this.assertNotWriteLocked(lock);
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)lock.getReadLockCount());
        lock.readLock().lock();
        this.assertNotWriteLocked(lock);
        ReentrantReadWriteLockTest.assertEquals((int)1, (int)lock.getReadLockCount());
        lock.readLock().unlock();
        this.assertNotWriteLocked(lock);
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)lock.getReadLockCount());
    }

    public void testFairLock() {
        PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock(true);
        this.assertNotWriteLocked(lock);
        lock.writeLock().lock();
        this.assertWriteLockedBy(lock, Thread.currentThread());
        lock.writeLock().unlock();
        this.assertNotWriteLocked(lock);
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)lock.getReadLockCount());
        lock.readLock().lock();
        this.assertNotWriteLocked(lock);
        ReentrantReadWriteLockTest.assertEquals((int)1, (int)lock.getReadLockCount());
        lock.readLock().unlock();
        this.assertNotWriteLocked(lock);
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)lock.getReadLockCount());
    }

    public void testGetWriteHoldCount() {
        int i;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        for (i = 1; i <= 20; ++i) {
            lock.writeLock().lock();
            ReentrantReadWriteLockTest.assertEquals((int)i, (int)lock.getWriteHoldCount());
        }
        for (i = 20; i > 0; --i) {
            lock.writeLock().unlock();
            ReentrantReadWriteLockTest.assertEquals((int)(i - 1), (int)lock.getWriteHoldCount());
        }
    }

    public void testGetHoldCount() {
        int i;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        for (i = 1; i <= 20; ++i) {
            lock.writeLock().lock();
            ReentrantReadWriteLockTest.assertEquals((int)i, (int)lock.writeLock().getHoldCount());
        }
        for (i = 20; i > 0; --i) {
            lock.writeLock().unlock();
            ReentrantReadWriteLockTest.assertEquals((int)(i - 1), (int)lock.writeLock().getHoldCount());
        }
    }

    public void testGetReadHoldCount() {
        int i;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        for (i = 1; i <= 20; ++i) {
            lock.readLock().lock();
            ReentrantReadWriteLockTest.assertEquals((int)i, (int)lock.getReadHoldCount());
        }
        for (i = 20; i > 0; --i) {
            lock.readLock().unlock();
            ReentrantReadWriteLockTest.assertEquals((int)(i - 1), (int)lock.getReadHoldCount());
        }
    }

    public void testWriteUnlock_IllegalMonitorStateException() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        try {
            lock.writeLock().unlock();
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testReadUnlock_IllegalMonitorStateException() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        try {
            lock.readLock().unlock();
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testWriteLockInterruptibly_Interrupted() throws Exception {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        lock.writeLock().lock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.writeLock().lockInterruptibly();
            }
        });
        this.waitForQueuedThread(lock, t);
        t.interrupt();
        this.awaitTermination(t);
        this.releaseWriteLock(lock);
    }

    public void testWriteTryLock_Interrupted() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        lock.writeLock().lock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.writeLock().tryLock(2L * JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        });
        this.waitForQueuedThread(lock, t);
        t.interrupt();
        this.awaitTermination(t);
        this.releaseWriteLock(lock);
    }

    public void testReadLockInterruptibly_Interrupted() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        lock.writeLock().lock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.readLock().lockInterruptibly();
            }
        });
        this.waitForQueuedThread(lock, t);
        t.interrupt();
        this.awaitTermination(t);
        this.releaseWriteLock(lock);
    }

    public void testReadTryLock_Interrupted() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        lock.writeLock().lock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.readLock().tryLock(2L * JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        });
        this.waitForQueuedThread(lock, t);
        t.interrupt();
        this.awaitTermination(t);
        this.releaseWriteLock(lock);
    }

    public void testWriteTryLockWhenLocked() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        lock.writeLock().lock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                Assert.assertFalse((boolean)lock.writeLock().tryLock());
            }
        });
        this.awaitTermination(t);
        this.releaseWriteLock(lock);
    }

    public void testReadTryLockWhenLocked() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        lock.writeLock().lock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                Assert.assertFalse((boolean)lock.readLock().tryLock());
            }
        });
        this.awaitTermination(t);
        this.releaseWriteLock(lock);
    }

    public void testMultipleReadLocks() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.readLock().lock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                Assert.assertTrue((boolean)lock.readLock().tryLock());
                lock.readLock().unlock();
            }
        });
        this.awaitTermination(t);
        lock.readLock().unlock();
    }

    public void testWriteAfterReadLock() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        lock.readLock().lock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                Assert.assertEquals((int)1, (int)lock.getReadLockCount());
                lock.writeLock().lock();
                Assert.assertEquals((int)0, (int)lock.getReadLockCount());
                lock.writeLock().unlock();
            }
        });
        this.waitForQueuedThread(lock, t);
        this.assertNotWriteLocked(lock);
        ReentrantReadWriteLockTest.assertEquals((int)1, (int)lock.getReadLockCount());
        lock.readLock().unlock();
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)lock.getReadLockCount());
        this.awaitTermination(t);
        this.assertNotWriteLocked(lock);
    }

    public void testWriteAfterMultipleReadLocks() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        lock.readLock().lock();
        lock.readLock().lock();
        Thread t1 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                lock.readLock().lock();
                Assert.assertEquals((int)3, (int)lock.getReadLockCount());
                lock.readLock().unlock();
            }
        });
        this.awaitTermination(t1);
        Thread t2 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                Assert.assertEquals((int)2, (int)lock.getReadLockCount());
                lock.writeLock().lock();
                Assert.assertEquals((int)0, (int)lock.getReadLockCount());
                lock.writeLock().unlock();
            }
        });
        this.waitForQueuedThread(lock, t2);
        this.assertNotWriteLocked(lock);
        ReentrantReadWriteLockTest.assertEquals((int)2, (int)lock.getReadLockCount());
        lock.readLock().unlock();
        lock.readLock().unlock();
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)lock.getReadLockCount());
        this.awaitTermination(t2);
        this.assertNotWriteLocked(lock);
    }

    public void testReaderWriterReaderFairFifo() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock(true);
        final AtomicBoolean t1GotLock = new AtomicBoolean(false);
        lock.readLock().lock();
        Thread t1 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                Assert.assertEquals((int)1, (int)lock.getReadLockCount());
                lock.writeLock().lock();
                Assert.assertEquals((int)0, (int)lock.getReadLockCount());
                t1GotLock.set(true);
                lock.writeLock().unlock();
            }
        });
        this.waitForQueuedThread(lock, t1);
        Thread t2 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                Assert.assertEquals((int)1, (int)lock.getReadLockCount());
                lock.readLock().lock();
                Assert.assertEquals((int)1, (int)lock.getReadLockCount());
                Assert.assertTrue((boolean)t1GotLock.get());
                lock.readLock().unlock();
            }
        });
        this.waitForQueuedThread(lock, t2);
        ReentrantReadWriteLockTest.assertTrue((boolean)t1.isAlive());
        this.assertNotWriteLocked(lock);
        ReentrantReadWriteLockTest.assertEquals((int)1, (int)lock.getReadLockCount());
        lock.readLock().unlock();
        this.awaitTermination(t1);
        this.awaitTermination(t2);
        this.assertNotWriteLocked(lock);
    }

    public void testReadAfterWriteLock() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        lock.writeLock().lock();
        Thread t1 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                lock.readLock().lock();
                lock.readLock().unlock();
            }
        });
        Thread t2 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                lock.readLock().lock();
                lock.readLock().unlock();
            }
        });
        this.waitForQueuedThread(lock, t1);
        this.waitForQueuedThread(lock, t2);
        this.releaseWriteLock(lock);
        this.awaitTermination(t1);
        this.awaitTermination(t2);
    }

    public void testReadHoldingWriteLock() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.writeLock().lock();
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.readLock().tryLock());
        lock.readLock().unlock();
        lock.writeLock().unlock();
    }

    public void testReadHoldingWriteLock2() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        lock.writeLock().lock();
        lock.readLock().lock();
        lock.readLock().unlock();
        Thread t1 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                lock.readLock().lock();
                lock.readLock().unlock();
            }
        });
        Thread t2 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                lock.readLock().lock();
                lock.readLock().unlock();
            }
        });
        this.waitForQueuedThread(lock, t1);
        this.waitForQueuedThread(lock, t2);
        this.assertWriteLockedBy(lock, Thread.currentThread());
        lock.readLock().lock();
        lock.readLock().unlock();
        this.releaseWriteLock(lock);
        this.awaitTermination(t1);
        this.awaitTermination(t2);
    }

    public void testReadHoldingWriteLock3() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        lock.writeLock().lock();
        lock.readLock().lock();
        lock.readLock().unlock();
        Thread t1 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                lock.writeLock().lock();
                lock.writeLock().unlock();
            }
        });
        Thread t2 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                lock.writeLock().lock();
                lock.writeLock().unlock();
            }
        });
        this.waitForQueuedThread(lock, t1);
        this.waitForQueuedThread(lock, t2);
        this.assertWriteLockedBy(lock, Thread.currentThread());
        lock.readLock().lock();
        lock.readLock().unlock();
        this.releaseWriteLock(lock);
        this.awaitTermination(t1);
        this.awaitTermination(t2);
    }

    public void testWriteHoldingWriteLock4() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        lock.writeLock().lock();
        lock.writeLock().lock();
        lock.writeLock().unlock();
        Thread t1 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                lock.writeLock().lock();
                lock.writeLock().unlock();
            }
        });
        Thread t2 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                lock.writeLock().lock();
                lock.writeLock().unlock();
            }
        });
        this.waitForQueuedThread(lock, t1);
        this.waitForQueuedThread(lock, t2);
        this.assertWriteLockedBy(lock, Thread.currentThread());
        ReentrantReadWriteLockTest.assertEquals((int)1, (int)lock.getWriteHoldCount());
        lock.writeLock().lock();
        this.assertWriteLockedBy(lock, Thread.currentThread());
        ReentrantReadWriteLockTest.assertEquals((int)2, (int)lock.getWriteHoldCount());
        lock.writeLock().unlock();
        this.releaseWriteLock(lock);
        this.awaitTermination(t1);
        this.awaitTermination(t2);
    }

    public void testReadHoldingWriteLockFair() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        lock.writeLock().lock();
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.readLock().tryLock());
        lock.readLock().unlock();
        lock.writeLock().unlock();
    }

    public void testReadHoldingWriteLockFair2() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock(true);
        lock.writeLock().lock();
        lock.readLock().lock();
        lock.readLock().unlock();
        Thread t1 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                lock.readLock().lock();
                lock.readLock().unlock();
            }
        });
        Thread t2 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                lock.readLock().lock();
                lock.readLock().unlock();
            }
        });
        this.waitForQueuedThread(lock, t1);
        this.waitForQueuedThread(lock, t2);
        this.assertWriteLockedBy(lock, Thread.currentThread());
        lock.readLock().lock();
        lock.readLock().unlock();
        this.releaseWriteLock(lock);
        this.awaitTermination(t1);
        this.awaitTermination(t2);
    }

    public void testReadHoldingWriteLockFair3() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock(true);
        lock.writeLock().lock();
        lock.readLock().lock();
        lock.readLock().unlock();
        Thread t1 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                lock.writeLock().lock();
                lock.writeLock().unlock();
            }
        });
        Thread t2 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                lock.writeLock().lock();
                lock.writeLock().unlock();
            }
        });
        this.waitForQueuedThread(lock, t1);
        this.waitForQueuedThread(lock, t2);
        this.assertWriteLockedBy(lock, Thread.currentThread());
        lock.readLock().lock();
        lock.readLock().unlock();
        this.releaseWriteLock(lock);
        this.awaitTermination(t1);
        this.awaitTermination(t2);
    }

    public void testWriteHoldingWriteLockFair4() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock(true);
        lock.writeLock().lock();
        Thread t1 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                lock.writeLock().lock();
                lock.writeLock().unlock();
            }
        });
        Thread t2 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                lock.writeLock().lock();
                lock.writeLock().unlock();
            }
        });
        this.waitForQueuedThread(lock, t1);
        this.waitForQueuedThread(lock, t2);
        this.assertWriteLockedBy(lock, Thread.currentThread());
        ReentrantReadWriteLockTest.assertEquals((int)1, (int)lock.getWriteHoldCount());
        lock.writeLock().lock();
        ReentrantReadWriteLockTest.assertEquals((int)2, (int)lock.getWriteHoldCount());
        lock.writeLock().unlock();
        lock.writeLock().lock();
        lock.writeLock().unlock();
        this.releaseWriteLock(lock);
        this.awaitTermination(t1);
        this.awaitTermination(t2);
    }

    public void testTryLockWhenReadLocked() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.readLock().lock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                Assert.assertTrue((boolean)lock.readLock().tryLock());
                lock.readLock().unlock();
            }
        });
        this.awaitTermination(t);
        lock.readLock().unlock();
    }

    public void testWriteTryLockWhenReadLocked() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.readLock().lock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                Assert.assertFalse((boolean)lock.writeLock().tryLock());
            }
        });
        this.awaitTermination(t);
        lock.readLock().unlock();
    }

    public void testTryLockWhenReadLockedFair() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        lock.readLock().lock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                Assert.assertTrue((boolean)lock.readLock().tryLock());
                lock.readLock().unlock();
            }
        });
        this.awaitTermination(t);
        lock.readLock().unlock();
    }

    public void testWriteTryLockWhenReadLockedFair() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        lock.readLock().lock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                Assert.assertFalse((boolean)lock.writeLock().tryLock());
            }
        });
        this.awaitTermination(t);
        lock.readLock().unlock();
    }

    public void testWriteTryLock_Timeout() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.writeLock().lock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                long startTime = System.nanoTime();
                long timeoutMillis = 10L;
                Assert.assertFalse((boolean)lock.writeLock().tryLock(timeoutMillis, TimeUnit.MILLISECONDS));
                Assert.assertTrue((ReentrantReadWriteLockTest.this.millisElapsedSince(startTime) >= timeoutMillis ? 1 : 0) != 0);
            }
        });
        this.awaitTermination(t);
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.writeLock().isHeldByCurrentThread());
        lock.writeLock().unlock();
    }

    public void testReadTryLock_Timeout() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        lock.writeLock().lock();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                long startTime = System.nanoTime();
                long timeoutMillis = 10L;
                Assert.assertFalse((boolean)lock.readLock().tryLock(timeoutMillis, TimeUnit.MILLISECONDS));
                Assert.assertTrue((ReentrantReadWriteLockTest.this.millisElapsedSince(startTime) >= timeoutMillis ? 1 : 0) != 0);
            }
        });
        this.awaitTermination(t);
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.writeLock().isHeldByCurrentThread());
        lock.writeLock().unlock();
    }

    public void testWriteLockInterruptibly() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        lock.writeLock().lockInterruptibly();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.writeLock().lockInterruptibly();
            }
        });
        this.waitForQueuedThread(lock, t);
        t.interrupt();
        this.awaitTermination(t);
        this.releaseWriteLock(lock);
    }

    public void testReadLockInterruptibly() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        lock.writeLock().lockInterruptibly();
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.readLock().lockInterruptibly();
            }
        });
        this.waitForQueuedThread(lock, t);
        t.interrupt();
        this.awaitTermination(t);
        this.releaseWriteLock(lock);
    }

    public void testAwait_IllegalMonitor() throws InterruptedException {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        try {
            c.await();
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException success) {
            // empty catch block
        }
        try {
            c.await(LONG_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException success) {
            // empty catch block
        }
        try {
            c.awaitNanos(100L);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException success) {
            // empty catch block
        }
        try {
            c.awaitUninterruptibly();
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testSignal_IllegalMonitor() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        try {
            c.signal();
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testSignalAll_IllegalMonitor() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        try {
            c.signalAll();
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testAwaitNanos_Timeout() throws InterruptedException {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        lock.writeLock().lock();
        long startTime = System.nanoTime();
        long timeoutMillis = 10L;
        long timeoutNanos = TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
        long nanosRemaining = c.awaitNanos(timeoutNanos);
        ReentrantReadWriteLockTest.assertTrue((nanosRemaining <= 0L ? 1 : 0) != 0);
        ReentrantReadWriteLockTest.assertTrue((this.millisElapsedSince(startTime) >= timeoutMillis ? 1 : 0) != 0);
        lock.writeLock().unlock();
    }

    public void testAwait_Timeout() throws InterruptedException {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        lock.writeLock().lock();
        long startTime = System.nanoTime();
        long timeoutMillis = 10L;
        ReentrantReadWriteLockTest.assertFalse((boolean)c.await(timeoutMillis, TimeUnit.MILLISECONDS));
        ReentrantReadWriteLockTest.assertTrue((this.millisElapsedSince(startTime) >= timeoutMillis ? 1 : 0) != 0);
        lock.writeLock().unlock();
    }

    public void testAwaitUntil_Timeout() throws InterruptedException {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        lock.writeLock().lock();
        long startTime = System.nanoTime();
        long timeoutMillis = 10L;
        Date d = new Date();
        ReentrantReadWriteLockTest.assertFalse((boolean)c.awaitUntil(new Date(d.getTime() + timeoutMillis)));
        ReentrantReadWriteLockTest.assertTrue((this.millisElapsedSince(startTime) >= timeoutMillis ? 1 : 0) != 0);
        lock.writeLock().unlock();
    }

    public void testAwait() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        final Condition c = lock.writeLock().newCondition();
        final CountDownLatch locked = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.writeLock().lock();
                locked.countDown();
                c.await();
                lock.writeLock().unlock();
            }
        });
        locked.await();
        lock.writeLock().lock();
        this.assertHasWaiters(lock, c, t);
        c.signal();
        this.assertHasNoWaiters(lock, c);
        ReentrantReadWriteLockTest.assertTrue((boolean)t.isAlive());
        lock.writeLock().unlock();
        this.awaitTermination(t);
    }

    public void testAwaitUninterruptibly() throws InterruptedException {
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        final Condition c = lock.writeLock().newCondition();
        final CountDownLatch locked = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                lock.writeLock().lock();
                locked.countDown();
                c.awaitUninterruptibly();
                Assert.assertTrue((boolean)Thread.interrupted());
                lock.writeLock().unlock();
            }
        });
        locked.await();
        lock.writeLock().lock();
        lock.writeLock().unlock();
        t.interrupt();
        long timeoutMillis = 10L;
        this.assertThreadJoinTimesOut(t, timeoutMillis);
        lock.writeLock().lock();
        c.signal();
        lock.writeLock().unlock();
        this.awaitTermination(t);
    }

    public void testAwait_Interrupt() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        final Condition c = lock.writeLock().newCondition();
        final CountDownLatch locked = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void realRun() throws InterruptedException {
                lock.writeLock().lock();
                ReentrantReadWriteLockTest.this.assertWriteLockedBy(lock, Thread.currentThread());
                ReentrantReadWriteLockTest.this.assertHasNoWaiters(lock, c);
                locked.countDown();
                try {
                    c.await();
                }
                finally {
                    ReentrantReadWriteLockTest.this.assertWriteLockedBy(lock, Thread.currentThread());
                    ReentrantReadWriteLockTest.this.assertHasNoWaiters(lock, c);
                    lock.writeLock().unlock();
                    Assert.assertFalse((boolean)Thread.interrupted());
                }
            }
        });
        locked.await();
        this.assertHasWaiters(lock, c, t);
        t.interrupt();
        this.awaitTermination(t);
        this.assertNotWriteLocked(lock);
    }

    public void testAwaitNanos_Interrupt() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        final Condition c = lock.writeLock().newCondition();
        final CountDownLatch locked = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void realRun() throws InterruptedException {
                lock.writeLock().lock();
                ReentrantReadWriteLockTest.this.assertWriteLockedBy(lock, Thread.currentThread());
                ReentrantReadWriteLockTest.this.assertHasNoWaiters(lock, c);
                locked.countDown();
                try {
                    c.awaitNanos(TimeUnit.MILLISECONDS.toNanos(2L * JSR166TestCase.LONG_DELAY_MS));
                }
                finally {
                    ReentrantReadWriteLockTest.this.assertWriteLockedBy(lock, Thread.currentThread());
                    ReentrantReadWriteLockTest.this.assertHasNoWaiters(lock, c);
                    lock.writeLock().unlock();
                    Assert.assertFalse((boolean)Thread.interrupted());
                }
            }
        });
        locked.await();
        this.assertHasWaiters(lock, c, t);
        t.interrupt();
        this.awaitTermination(t);
        this.assertNotWriteLocked(lock);
    }

    public void testAwaitUntil_Interrupt() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        final Condition c = lock.writeLock().newCondition();
        final CountDownLatch locked = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void realRun() throws InterruptedException {
                lock.writeLock().lock();
                ReentrantReadWriteLockTest.this.assertWriteLockedBy(lock, Thread.currentThread());
                ReentrantReadWriteLockTest.this.assertHasNoWaiters(lock, c);
                locked.countDown();
                Date d = new Date();
                try {
                    c.awaitUntil(new Date(d.getTime() + 2L * JSR166TestCase.LONG_DELAY_MS));
                }
                finally {
                    ReentrantReadWriteLockTest.this.assertWriteLockedBy(lock, Thread.currentThread());
                    ReentrantReadWriteLockTest.this.assertHasNoWaiters(lock, c);
                    lock.writeLock().unlock();
                    Assert.assertFalse((boolean)Thread.interrupted());
                }
            }
        });
        locked.await();
        this.assertHasWaiters(lock, c, t);
        t.interrupt();
        this.awaitTermination(t);
        this.assertNotWriteLocked(lock);
    }

    public void testSignalAll() throws InterruptedException {
        PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        final Condition c = lock.writeLock().newCondition();
        final CountDownLatch locked = new CountDownLatch(2);
        final ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();
        Thread t1 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                writeLock.lock();
                locked.countDown();
                c.await();
                writeLock.unlock();
            }
        });
        Thread t2 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                writeLock.lock();
                locked.countDown();
                c.await();
                writeLock.unlock();
            }
        });
        locked.await();
        writeLock.lock();
        this.assertHasWaiters(lock, c, t1, t2);
        c.signalAll();
        this.assertHasNoWaiters(lock, c);
        writeLock.unlock();
        this.awaitTermination(t1);
        this.awaitTermination(t2);
    }

    public void testSignalWakesFifo() throws InterruptedException {
        PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        final Condition c = lock.writeLock().newCondition();
        final CountDownLatch locked1 = new CountDownLatch(1);
        final CountDownLatch locked2 = new CountDownLatch(1);
        final ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();
        Thread t1 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                writeLock.lock();
                locked1.countDown();
                c.await();
                writeLock.unlock();
            }
        });
        locked1.await();
        Thread t2 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                writeLock.lock();
                locked2.countDown();
                c.await();
                writeLock.unlock();
            }
        });
        locked2.await();
        writeLock.lock();
        this.assertHasWaiters(lock, c, t1, t2);
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.hasQueuedThreads());
        c.signal();
        this.assertHasWaiters(lock, c, t2);
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.hasQueuedThread(t1));
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.hasQueuedThread(t2));
        c.signal();
        this.assertHasNoWaiters(lock, c);
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.hasQueuedThread(t1));
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.hasQueuedThread(t2));
        writeLock.unlock();
        this.awaitTermination(t1);
        this.awaitTermination(t2);
    }

    public void testAwaitLockCount() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        final Condition c = lock.writeLock().newCondition();
        final CountDownLatch locked = new CountDownLatch(2);
        Thread t1 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.writeLock().lock();
                ReentrantReadWriteLockTest.this.assertWriteLockedBy(lock, Thread.currentThread());
                Assert.assertEquals((int)1, (int)lock.writeLock().getHoldCount());
                locked.countDown();
                c.await();
                ReentrantReadWriteLockTest.this.assertWriteLockedBy(lock, Thread.currentThread());
                Assert.assertEquals((int)1, (int)lock.writeLock().getHoldCount());
                lock.writeLock().unlock();
            }
        });
        Thread t2 = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.writeLock().lock();
                lock.writeLock().lock();
                ReentrantReadWriteLockTest.this.assertWriteLockedBy(lock, Thread.currentThread());
                Assert.assertEquals((int)2, (int)lock.writeLock().getHoldCount());
                locked.countDown();
                c.await();
                ReentrantReadWriteLockTest.this.assertWriteLockedBy(lock, Thread.currentThread());
                Assert.assertEquals((int)2, (int)lock.writeLock().getHoldCount());
                lock.writeLock().unlock();
                lock.writeLock().unlock();
            }
        });
        locked.await();
        lock.writeLock().lock();
        this.assertHasWaiters(lock, c, t1, t2);
        c.signalAll();
        this.assertHasNoWaiters(lock, c);
        lock.writeLock().unlock();
        this.awaitTermination(t1);
        this.awaitTermination(t2);
    }

    public void testSerialization() throws Exception {
        ReentrantReadWriteLock l = new ReentrantReadWriteLock();
        l.readLock().lock();
        l.readLock().unlock();
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(l);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        ReentrantReadWriteLock r = (ReentrantReadWriteLock)in.readObject();
        r.readLock().lock();
        r.readLock().unlock();
    }

    public void testHasQueuedThreads() throws InterruptedException {
        PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        Thread t1 = new Thread(new InterruptedLockRunnable(lock));
        Thread t2 = new Thread(new InterruptibleLockRunnable(lock));
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.hasQueuedThreads());
        lock.writeLock().lock();
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.hasQueuedThreads());
        t1.start();
        this.waitForQueuedThread(lock, t1);
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.hasQueuedThreads());
        t2.start();
        this.waitForQueuedThread(lock, t2);
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.hasQueuedThreads());
        t1.interrupt();
        this.awaitTermination(t1);
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.hasQueuedThreads());
        lock.writeLock().unlock();
        this.awaitTermination(t2);
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.hasQueuedThreads());
    }

    public void testHasQueuedThreadNPE() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        try {
            lock.hasQueuedThread(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testHasQueuedThread() throws InterruptedException {
        PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        Thread t1 = new Thread(new InterruptedLockRunnable(lock));
        Thread t2 = new Thread(new InterruptibleLockRunnable(lock));
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.hasQueuedThread(t1));
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.hasQueuedThread(t2));
        lock.writeLock().lock();
        t1.start();
        this.waitForQueuedThread(lock, t1);
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.hasQueuedThread(t1));
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.hasQueuedThread(t2));
        t2.start();
        this.waitForQueuedThread(lock, t2);
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.hasQueuedThread(t1));
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.hasQueuedThread(t2));
        t1.interrupt();
        this.awaitTermination(t1);
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.hasQueuedThread(t1));
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.hasQueuedThread(t2));
        lock.writeLock().unlock();
        this.awaitTermination(t2);
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.hasQueuedThread(t1));
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.hasQueuedThread(t2));
    }

    public void testGetQueueLength() throws InterruptedException {
        PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        Thread t1 = new Thread(new InterruptedLockRunnable(lock));
        Thread t2 = new Thread(new InterruptibleLockRunnable(lock));
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)lock.getQueueLength());
        lock.writeLock().lock();
        t1.start();
        this.waitForQueuedThread(lock, t1);
        ReentrantReadWriteLockTest.assertEquals((int)1, (int)lock.getQueueLength());
        t2.start();
        this.waitForQueuedThread(lock, t2);
        ReentrantReadWriteLockTest.assertEquals((int)2, (int)lock.getQueueLength());
        t1.interrupt();
        this.awaitTermination(t1);
        ReentrantReadWriteLockTest.assertEquals((int)1, (int)lock.getQueueLength());
        lock.writeLock().unlock();
        this.awaitTermination(t2);
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)lock.getQueueLength());
    }

    public void testGetQueuedThreads() throws InterruptedException {
        PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        Thread t1 = new Thread(new InterruptedLockRunnable(lock));
        Thread t2 = new Thread(new InterruptibleLockRunnable(lock));
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getQueuedThreads().isEmpty());
        lock.writeLock().lock();
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getQueuedThreads().isEmpty());
        t1.start();
        this.waitForQueuedThread(lock, t1);
        ReentrantReadWriteLockTest.assertEquals((int)1, (int)lock.getQueuedThreads().size());
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getQueuedThreads().contains(t1));
        t2.start();
        this.waitForQueuedThread(lock, t2);
        ReentrantReadWriteLockTest.assertEquals((int)2, (int)lock.getQueuedThreads().size());
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getQueuedThreads().contains(t1));
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getQueuedThreads().contains(t2));
        t1.interrupt();
        this.awaitTermination(t1);
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.getQueuedThreads().contains(t1));
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getQueuedThreads().contains(t2));
        ReentrantReadWriteLockTest.assertEquals((int)1, (int)lock.getQueuedThreads().size());
        lock.writeLock().unlock();
        this.awaitTermination(t2);
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getQueuedThreads().isEmpty());
    }

    public void testHasWaitersNPE() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        try {
            lock.hasWaiters(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetWaitQueueLengthNPE() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        try {
            lock.getWaitQueueLength(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetWaitingThreadsNPE() {
        PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        try {
            lock.getWaitingThreads(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testHasWaitersIAE() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        ReentrantReadWriteLock lock2 = new ReentrantReadWriteLock();
        try {
            lock2.hasWaiters(c);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            // empty catch block
        }
    }

    public void testHasWaitersIMSE() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        try {
            lock.hasWaiters(c);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testGetWaitQueueLengthIAE() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        ReentrantReadWriteLock lock2 = new ReentrantReadWriteLock();
        try {
            lock2.getWaitQueueLength(c);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            // empty catch block
        }
    }

    public void testGetWaitQueueLengthIMSE() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        try {
            lock.getWaitQueueLength(c);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testGetWaitingThreadsIAE() {
        PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        PublicReentrantReadWriteLock lock2 = new PublicReentrantReadWriteLock();
        try {
            lock2.getWaitingThreads(c);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            // empty catch block
        }
    }

    public void testGetWaitingThreadsIMSE() {
        PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        Condition c = lock.writeLock().newCondition();
        try {
            lock.getWaitingThreads(c);
            this.shouldThrow();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testHasWaiters() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        final Condition c = lock.writeLock().newCondition();
        final CountDownLatch locked = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.writeLock().lock();
                ReentrantReadWriteLockTest.this.assertHasNoWaiters(lock, c);
                Assert.assertFalse((boolean)lock.hasWaiters(c));
                locked.countDown();
                c.await();
                ReentrantReadWriteLockTest.this.assertHasNoWaiters(lock, c);
                Assert.assertFalse((boolean)lock.hasWaiters(c));
                lock.writeLock().unlock();
            }
        });
        locked.await();
        lock.writeLock().lock();
        this.assertHasWaiters(lock, c, t);
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.hasWaiters(c));
        c.signal();
        this.assertHasNoWaiters(lock, c);
        ReentrantReadWriteLockTest.assertFalse((boolean)lock.hasWaiters(c));
        lock.writeLock().unlock();
        this.awaitTermination(t);
        this.assertHasNoWaiters(lock, c);
    }

    public void testGetWaitQueueLength() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        final Condition c = lock.writeLock().newCondition();
        final CountDownLatch locked = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.writeLock().lock();
                Assert.assertEquals((int)0, (int)lock.getWaitQueueLength(c));
                locked.countDown();
                c.await();
                lock.writeLock().unlock();
            }
        });
        locked.await();
        lock.writeLock().lock();
        this.assertHasWaiters(lock, c, t);
        ReentrantReadWriteLockTest.assertEquals((int)1, (int)lock.getWaitQueueLength(c));
        c.signal();
        this.assertHasNoWaiters(lock, c);
        ReentrantReadWriteLockTest.assertEquals((int)0, (int)lock.getWaitQueueLength(c));
        lock.writeLock().unlock();
        this.awaitTermination(t);
    }

    public void testGetWaitingThreads() throws InterruptedException {
        final PublicReentrantReadWriteLock lock = new PublicReentrantReadWriteLock();
        final Condition c = lock.writeLock().newCondition();
        final CountDownLatch locked1 = new CountDownLatch(1);
        final CountDownLatch locked2 = new CountDownLatch(1);
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.writeLock().lock();
                Assert.assertTrue((boolean)lock.getWaitingThreads(c).isEmpty());
                locked1.countDown();
                c.await();
                lock.writeLock().unlock();
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                lock.writeLock().lock();
                Assert.assertFalse((boolean)lock.getWaitingThreads(c).isEmpty());
                locked2.countDown();
                c.await();
                lock.writeLock().unlock();
            }
        });
        lock.writeLock().lock();
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getWaitingThreads(c).isEmpty());
        lock.writeLock().unlock();
        t1.start();
        locked1.await();
        t2.start();
        locked2.await();
        lock.writeLock().lock();
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.hasWaiters(c));
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getWaitingThreads(c).contains(t1));
        ReentrantReadWriteLockTest.assertTrue((boolean)lock.getWaitingThreads(c).contains(t2));
        ReentrantReadWriteLockTest.assertEquals((int)2, (int)lock.getWaitingThreads(c).size());
        c.signalAll();
        this.assertHasNoWaiters(lock, c);
        lock.writeLock().unlock();
        this.awaitTermination(t1);
        this.awaitTermination(t2);
        this.assertHasNoWaiters(lock, c);
    }

    public void testToString() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        String us = lock.toString();
        ReentrantReadWriteLockTest.assertTrue((us.indexOf("Write locks = 0") >= 0 ? 1 : 0) != 0);
        ReentrantReadWriteLockTest.assertTrue((us.indexOf("Read locks = 0") >= 0 ? 1 : 0) != 0);
        lock.writeLock().lock();
        String ws = lock.toString();
        ReentrantReadWriteLockTest.assertTrue((ws.indexOf("Write locks = 1") >= 0 ? 1 : 0) != 0);
        ReentrantReadWriteLockTest.assertTrue((ws.indexOf("Read locks = 0") >= 0 ? 1 : 0) != 0);
        lock.writeLock().unlock();
        lock.readLock().lock();
        lock.readLock().lock();
        String rs = lock.toString();
        ReentrantReadWriteLockTest.assertTrue((rs.indexOf("Write locks = 0") >= 0 ? 1 : 0) != 0);
        ReentrantReadWriteLockTest.assertTrue((rs.indexOf("Read locks = 2") >= 0 ? 1 : 0) != 0);
    }

    public void testReadLockToString() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        String us = lock.readLock().toString();
        ReentrantReadWriteLockTest.assertTrue((us.indexOf("Read locks = 0") >= 0 ? 1 : 0) != 0);
        lock.readLock().lock();
        lock.readLock().lock();
        String rs = lock.readLock().toString();
        ReentrantReadWriteLockTest.assertTrue((rs.indexOf("Read locks = 2") >= 0 ? 1 : 0) != 0);
    }

    public void testWriteLockToString() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        String us = lock.writeLock().toString();
        ReentrantReadWriteLockTest.assertTrue((us.indexOf("Unlocked") >= 0 ? 1 : 0) != 0);
        lock.writeLock().lock();
        String ls = lock.writeLock().toString();
        ReentrantReadWriteLockTest.assertTrue((ls.indexOf("Locked") >= 0 ? 1 : 0) != 0);
    }

    static class PublicReentrantReadWriteLock
    extends ReentrantReadWriteLock {
        PublicReentrantReadWriteLock() {
        }

        PublicReentrantReadWriteLock(boolean fair) {
            super(fair);
        }

        @Override
        public Thread getOwner() {
            return super.getOwner();
        }

        @Override
        public Collection<Thread> getQueuedThreads() {
            return super.getQueuedThreads();
        }

        @Override
        public Collection<Thread> getWaitingThreads(Condition c) {
            return super.getWaitingThreads(c);
        }
    }

    class InterruptedLockRunnable
    extends JSR166TestCase.CheckedInterruptedRunnable {
        final ReentrantReadWriteLock lock;

        InterruptedLockRunnable(ReentrantReadWriteLock l) {
            this.lock = l;
        }

        @Override
        public void realRun() throws InterruptedException {
            this.lock.writeLock().lockInterruptibly();
        }
    }

    class InterruptibleLockRunnable
    extends JSR166TestCase.CheckedRunnable {
        final ReentrantReadWriteLock lock;

        InterruptibleLockRunnable(ReentrantReadWriteLock l) {
            this.lock = l;
        }

        @Override
        public void realRun() throws InterruptedException {
            this.lock.writeLock().lockInterruptibly();
        }
    }
}

