/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ScheduledExecutorSubclassTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)ScheduledExecutorSubclassTest.suite());
    }

    public static Test suite() {
        return new TestSuite(ScheduledExecutorSubclassTest.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecute() throws InterruptedException {
        CustomExecutor p = new CustomExecutor(1);
        final CountDownLatch done = new CountDownLatch(1);
        JSR166TestCase.CheckedRunnable task = new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                done.countDown();
            }
        };
        try {
            p.execute(task);
            ScheduledExecutorSubclassTest.assertTrue((boolean)done.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSchedule1() throws Exception {
        CustomExecutor p = new CustomExecutor(1);
        final long t0 = System.nanoTime();
        final long timeoutNanos = SHORT_DELAY_MS * 1000L * 1000L;
        final CountDownLatch done = new CountDownLatch(1);
        try {
            JSR166TestCase.CheckedCallable<Boolean> task = new JSR166TestCase.CheckedCallable<Boolean>(){

                @Override
                public Boolean realCall() {
                    done.countDown();
                    Assert.assertTrue((System.nanoTime() - t0 >= timeoutNanos ? 1 : 0) != 0);
                    return Boolean.TRUE;
                }
            };
            ScheduledFuture<Boolean> f = p.schedule(task, SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            ScheduledExecutorSubclassTest.assertEquals((Object)Boolean.TRUE, f.get());
            ScheduledExecutorSubclassTest.assertTrue((System.nanoTime() - t0 >= timeoutNanos ? 1 : 0) != 0);
            ScheduledExecutorSubclassTest.assertTrue((boolean)done.await(0L, TimeUnit.MILLISECONDS));
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSchedule3() throws Exception {
        CustomExecutor p = new CustomExecutor(1);
        final long t0 = System.nanoTime();
        final long timeoutNanos = SHORT_DELAY_MS * 1000L * 1000L;
        final CountDownLatch done = new CountDownLatch(1);
        try {
            JSR166TestCase.CheckedRunnable task = new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() {
                    done.countDown();
                    Assert.assertTrue((System.nanoTime() - t0 >= timeoutNanos ? 1 : 0) != 0);
                }
            };
            ScheduledFuture<?> f = p.schedule(task, SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            ScheduledExecutorSubclassTest.assertNull(f.get());
            ScheduledExecutorSubclassTest.assertTrue((System.nanoTime() - t0 >= timeoutNanos ? 1 : 0) != 0);
            ScheduledExecutorSubclassTest.assertTrue((boolean)done.await(0L, TimeUnit.MILLISECONDS));
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSchedule4() throws InterruptedException {
        CustomExecutor p = new CustomExecutor(1);
        final long t0 = System.nanoTime();
        final long timeoutNanos = SHORT_DELAY_MS * 1000L * 1000L;
        final CountDownLatch done = new CountDownLatch(1);
        try {
            JSR166TestCase.CheckedRunnable task = new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() {
                    done.countDown();
                    Assert.assertTrue((System.nanoTime() - t0 >= timeoutNanos ? 1 : 0) != 0);
                }
            };
            ScheduledFuture<?> f = p.scheduleAtFixedRate(task, SHORT_DELAY_MS, SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            ScheduledExecutorSubclassTest.assertTrue((boolean)done.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ScheduledExecutorSubclassTest.assertTrue((System.nanoTime() - t0 >= timeoutNanos ? 1 : 0) != 0);
            f.cancel(true);
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSchedule5() throws InterruptedException {
        CustomExecutor p = new CustomExecutor(1);
        final long t0 = System.nanoTime();
        final long timeoutNanos = SHORT_DELAY_MS * 1000L * 1000L;
        final CountDownLatch done = new CountDownLatch(1);
        try {
            JSR166TestCase.CheckedRunnable task = new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() {
                    done.countDown();
                    Assert.assertTrue((System.nanoTime() - t0 >= timeoutNanos ? 1 : 0) != 0);
                }
            };
            ScheduledFuture<?> f = p.scheduleWithFixedDelay(task, SHORT_DELAY_MS, SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            ScheduledExecutorSubclassTest.assertTrue((boolean)done.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ScheduledExecutorSubclassTest.assertTrue((System.nanoTime() - t0 >= timeoutNanos ? 1 : 0) != 0);
            f.cancel(true);
        }
        finally {
            this.joinPool(p);
        }
    }

    public void testFixedRateSequence() throws InterruptedException {
        CustomExecutor p = new CustomExecutor(1);
        RunnableCounter counter = new RunnableCounter();
        ScheduledFuture<?> h = p.scheduleAtFixedRate(counter, 0L, 1L, TimeUnit.MILLISECONDS);
        ScheduledExecutorSubclassTest.delay(SMALL_DELAY_MS);
        h.cancel(true);
        int c = counter.count.get();
        ScheduledExecutorSubclassTest.assertTrue(((long)c >= SMALL_DELAY_MS / SHORT_DELAY_MS ? 1 : 0) != 0);
        ScheduledExecutorSubclassTest.assertTrue(((long)c <= SMALL_DELAY_MS + SHORT_DELAY_MS ? 1 : 0) != 0);
        this.joinPool(p);
    }

    public void testFixedDelaySequence() throws InterruptedException {
        CustomExecutor p = new CustomExecutor(1);
        RunnableCounter counter = new RunnableCounter();
        ScheduledFuture<?> h = p.scheduleWithFixedDelay(counter, 0L, 1L, TimeUnit.MILLISECONDS);
        ScheduledExecutorSubclassTest.delay(SMALL_DELAY_MS);
        h.cancel(true);
        int c = counter.count.get();
        ScheduledExecutorSubclassTest.assertTrue(((long)c >= SMALL_DELAY_MS / SHORT_DELAY_MS ? 1 : 0) != 0);
        ScheduledExecutorSubclassTest.assertTrue(((long)c <= SMALL_DELAY_MS + SHORT_DELAY_MS ? 1 : 0) != 0);
        this.joinPool(p);
    }

    public void testExecuteNull() throws InterruptedException {
        CustomExecutor se = new CustomExecutor(1);
        try {
            se.execute(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    public void testScheduleNull() throws InterruptedException {
        CustomExecutor se = new CustomExecutor(1);
        try {
            Callable callable = null;
            ScheduledFuture f = se.schedule(callable, SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    public void testSchedule1_RejectedExecutionException() {
        CustomExecutor se = new CustomExecutor(1);
        try {
            se.shutdown();
            se.schedule(new JSR166TestCase.NoOpRunnable(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (RejectedExecutionException success) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    public void testSchedule2_RejectedExecutionException() {
        CustomExecutor se = new CustomExecutor(1);
        try {
            se.shutdown();
            se.schedule(new JSR166TestCase.NoOpCallable(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (RejectedExecutionException success) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    public void testSchedule3_RejectedExecutionException() {
        CustomExecutor se = new CustomExecutor(1);
        try {
            se.shutdown();
            se.schedule(new JSR166TestCase.NoOpCallable(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (RejectedExecutionException success) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    public void testScheduleAtFixedRate1_RejectedExecutionException() {
        CustomExecutor se = new CustomExecutor(1);
        try {
            se.shutdown();
            se.scheduleAtFixedRate(new JSR166TestCase.NoOpRunnable(), MEDIUM_DELAY_MS, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (RejectedExecutionException success) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    public void testScheduleWithFixedDelay1_RejectedExecutionException() {
        CustomExecutor se = new CustomExecutor(1);
        try {
            se.shutdown();
            se.scheduleWithFixedDelay(new JSR166TestCase.NoOpRunnable(), MEDIUM_DELAY_MS, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (RejectedExecutionException success) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.joinPool(se);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetActiveCount() throws InterruptedException {
        final CustomExecutor p = new CustomExecutor(2);
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final CountDownLatch done = new CountDownLatch(1);
        try {
            ScheduledExecutorSubclassTest.assertEquals((int)0, (int)p.getActiveCount());
            ((ThreadPoolExecutor)p).execute(new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() throws InterruptedException {
                    threadStarted.countDown();
                    Assert.assertEquals((int)1, (int)p.getActiveCount());
                    done.await();
                }
            });
            ScheduledExecutorSubclassTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ScheduledExecutorSubclassTest.assertEquals((int)1, (int)p.getActiveCount());
        }
        finally {
            done.countDown();
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetCompletedTaskCount() throws InterruptedException {
        final CustomExecutor p = new CustomExecutor(2);
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final CountDownLatch threadProceed = new CountDownLatch(1);
        final CountDownLatch threadDone = new CountDownLatch(1);
        try {
            ScheduledExecutorSubclassTest.assertEquals((long)0L, (long)p.getCompletedTaskCount());
            ((ThreadPoolExecutor)p).execute(new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() throws InterruptedException {
                    threadStarted.countDown();
                    Assert.assertEquals((long)0L, (long)p.getCompletedTaskCount());
                    threadProceed.await();
                    threadDone.countDown();
                }
            });
            ScheduledExecutorSubclassTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ScheduledExecutorSubclassTest.assertEquals((long)0L, (long)p.getCompletedTaskCount());
            threadProceed.countDown();
            threadDone.await();
            ScheduledExecutorSubclassTest.delay(SHORT_DELAY_MS);
            ScheduledExecutorSubclassTest.assertEquals((long)1L, (long)p.getCompletedTaskCount());
        }
        finally {
            this.joinPool(p);
        }
    }

    public void testGetCorePoolSize() {
        CustomExecutor p = new CustomExecutor(1);
        ScheduledExecutorSubclassTest.assertEquals((int)1, (int)p.getCorePoolSize());
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetLargestPoolSize() throws InterruptedException {
        int THREADS = 3;
        final CustomExecutor p = new CustomExecutor(3);
        final CountDownLatch threadsStarted = new CountDownLatch(3);
        final CountDownLatch done = new CountDownLatch(1);
        try {
            ScheduledExecutorSubclassTest.assertEquals((int)0, (int)p.getLargestPoolSize());
            for (int i = 0; i < 3; ++i) {
                ((ThreadPoolExecutor)p).execute(new JSR166TestCase.CheckedRunnable(){

                    @Override
                    public void realRun() throws InterruptedException {
                        threadsStarted.countDown();
                        done.await();
                        Assert.assertEquals((int)3, (int)p.getLargestPoolSize());
                    }
                });
            }
            ScheduledExecutorSubclassTest.assertTrue((boolean)threadsStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ScheduledExecutorSubclassTest.assertEquals((int)3, (int)p.getLargestPoolSize());
        }
        finally {
            done.countDown();
            this.joinPool(p);
            ScheduledExecutorSubclassTest.assertEquals((int)3, (int)p.getLargestPoolSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetPoolSize() throws InterruptedException {
        final CustomExecutor p = new CustomExecutor(1);
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final CountDownLatch done = new CountDownLatch(1);
        try {
            ScheduledExecutorSubclassTest.assertEquals((int)0, (int)p.getPoolSize());
            ((ThreadPoolExecutor)p).execute(new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() throws InterruptedException {
                    threadStarted.countDown();
                    Assert.assertEquals((int)1, (int)p.getPoolSize());
                    done.await();
                }
            });
            ScheduledExecutorSubclassTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ScheduledExecutorSubclassTest.assertEquals((int)1, (int)p.getPoolSize());
        }
        finally {
            done.countDown();
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetTaskCount() throws InterruptedException {
        CustomExecutor p = new CustomExecutor(1);
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final CountDownLatch done = new CountDownLatch(1);
        int TASKS = 5;
        try {
            ScheduledExecutorSubclassTest.assertEquals((long)0L, (long)p.getTaskCount());
            for (int i = 0; i < 5; ++i) {
                ((ThreadPoolExecutor)p).execute(new JSR166TestCase.CheckedRunnable(){

                    @Override
                    public void realRun() throws InterruptedException {
                        threadStarted.countDown();
                        done.await();
                    }
                });
            }
            ScheduledExecutorSubclassTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ScheduledExecutorSubclassTest.assertEquals((long)5L, (long)p.getTaskCount());
        }
        finally {
            done.countDown();
            this.joinPool(p);
        }
    }

    public void testGetThreadFactory() {
        JSR166TestCase.SimpleThreadFactory tf = new JSR166TestCase.SimpleThreadFactory();
        CustomExecutor p = new CustomExecutor(1, tf);
        ScheduledExecutorSubclassTest.assertSame((Object)tf, (Object)p.getThreadFactory());
        this.joinPool(p);
    }

    public void testSetThreadFactory() {
        JSR166TestCase.SimpleThreadFactory tf = new JSR166TestCase.SimpleThreadFactory();
        CustomExecutor p = new CustomExecutor(1);
        p.setThreadFactory(tf);
        ScheduledExecutorSubclassTest.assertSame((Object)tf, (Object)p.getThreadFactory());
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetThreadFactoryNull() {
        CustomExecutor p = new CustomExecutor(1);
        try {
            p.setThreadFactory(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsShutdown() {
        CustomExecutor p = new CustomExecutor(1);
        try {
            ScheduledExecutorSubclassTest.assertFalse((boolean)p.isShutdown());
        }
        finally {
            try {
                p.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        ScheduledExecutorSubclassTest.assertTrue((boolean)p.isShutdown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsTerminated() throws InterruptedException {
        final CustomExecutor p = new CustomExecutor(1);
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final CountDownLatch done = new CountDownLatch(1);
        ScheduledExecutorSubclassTest.assertFalse((boolean)p.isTerminated());
        try {
            ((ThreadPoolExecutor)p).execute(new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() throws InterruptedException {
                    Assert.assertFalse((boolean)p.isTerminated());
                    threadStarted.countDown();
                    done.await();
                }
            });
            ScheduledExecutorSubclassTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ScheduledExecutorSubclassTest.assertFalse((boolean)p.isTerminating());
            done.countDown();
        }
        finally {
            try {
                ((ThreadPoolExecutor)p).shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        ScheduledExecutorSubclassTest.assertTrue((boolean)p.awaitTermination(LONG_DELAY_MS, TimeUnit.MILLISECONDS));
        ScheduledExecutorSubclassTest.assertTrue((boolean)p.isTerminated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsTerminating() throws InterruptedException {
        final CustomExecutor p = new CustomExecutor(1);
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final CountDownLatch done = new CountDownLatch(1);
        try {
            ScheduledExecutorSubclassTest.assertFalse((boolean)p.isTerminating());
            ((ThreadPoolExecutor)p).execute(new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() throws InterruptedException {
                    Assert.assertFalse((boolean)p.isTerminating());
                    threadStarted.countDown();
                    done.await();
                }
            });
            ScheduledExecutorSubclassTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ScheduledExecutorSubclassTest.assertFalse((boolean)p.isTerminating());
            done.countDown();
        }
        finally {
            try {
                ((ThreadPoolExecutor)p).shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        ScheduledExecutorSubclassTest.assertTrue((boolean)p.awaitTermination(LONG_DELAY_MS, TimeUnit.MILLISECONDS));
        ScheduledExecutorSubclassTest.assertTrue((boolean)p.isTerminated());
        ScheduledExecutorSubclassTest.assertFalse((boolean)p.isTerminating());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetQueue() throws InterruptedException {
        CustomExecutor p = new CustomExecutor(1);
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final CountDownLatch done = new CountDownLatch(1);
        try {
            ScheduledFuture[] tasks = new ScheduledFuture[5];
            for (int i = 0; i < tasks.length; ++i) {
                JSR166TestCase.CheckedRunnable r = new JSR166TestCase.CheckedRunnable(){

                    @Override
                    public void realRun() throws InterruptedException {
                        threadStarted.countDown();
                        done.await();
                    }
                };
                tasks[i] = p.schedule(r, 1L, TimeUnit.MILLISECONDS);
            }
            ScheduledExecutorSubclassTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            BlockingQueue<Runnable> q = p.getQueue();
            ScheduledExecutorSubclassTest.assertTrue((boolean)q.contains(tasks[tasks.length - 1]));
            ScheduledExecutorSubclassTest.assertFalse((boolean)q.contains(tasks[0]));
        }
        finally {
            done.countDown();
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemove() throws InterruptedException {
        CustomExecutor p = new CustomExecutor(1);
        ScheduledFuture[] tasks = new ScheduledFuture[5];
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final CountDownLatch done = new CountDownLatch(1);
        try {
            for (int i = 0; i < tasks.length; ++i) {
                JSR166TestCase.CheckedRunnable r = new JSR166TestCase.CheckedRunnable(){

                    @Override
                    public void realRun() throws InterruptedException {
                        threadStarted.countDown();
                        done.await();
                    }
                };
                tasks[i] = p.schedule(r, 1L, TimeUnit.MILLISECONDS);
            }
            ScheduledExecutorSubclassTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            BlockingQueue<Runnable> q = p.getQueue();
            ScheduledExecutorSubclassTest.assertFalse((boolean)p.remove((Runnable)((Object)tasks[0])));
            ScheduledExecutorSubclassTest.assertTrue((boolean)q.contains((Runnable)((Object)tasks[4])));
            ScheduledExecutorSubclassTest.assertTrue((boolean)q.contains((Runnable)((Object)tasks[3])));
            ScheduledExecutorSubclassTest.assertTrue((boolean)p.remove((Runnable)((Object)tasks[4])));
            ScheduledExecutorSubclassTest.assertFalse((boolean)p.remove((Runnable)((Object)tasks[4])));
            ScheduledExecutorSubclassTest.assertFalse((boolean)q.contains((Runnable)((Object)tasks[4])));
            ScheduledExecutorSubclassTest.assertTrue((boolean)q.contains((Runnable)((Object)tasks[3])));
            ScheduledExecutorSubclassTest.assertTrue((boolean)p.remove((Runnable)((Object)tasks[3])));
            ScheduledExecutorSubclassTest.assertFalse((boolean)q.contains((Runnable)((Object)tasks[3])));
        }
        finally {
            done.countDown();
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPurge() throws InterruptedException {
        CustomExecutor p = new CustomExecutor(1);
        ScheduledFuture[] tasks = new ScheduledFuture[5];
        for (int i = 0; i < tasks.length; ++i) {
            tasks[i] = p.schedule(new JSR166TestCase.SmallPossiblyInterruptedRunnable(), LONG_DELAY_MS, TimeUnit.MILLISECONDS);
        }
        try {
            int max = tasks.length;
            if (tasks[4].cancel(true)) {
                --max;
            }
            if (tasks[3].cancel(true)) {
                --max;
            }
            long startTime = System.nanoTime();
            do {
                p.purge();
                long count = p.getTaskCount();
                if (count != (long)max) continue;
                return;
            } while (this.millisElapsedSince(startTime) < MEDIUM_DELAY_MS);
            ScheduledExecutorSubclassTest.fail((String)"Purge failed to remove cancelled tasks");
        }
        finally {
            for (ScheduledFuture task : tasks) {
                task.cancel(true);
            }
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShutdownNow() {
        CustomExecutor p = new CustomExecutor(1);
        for (int i = 0; i < 5; ++i) {
            p.schedule(new JSR166TestCase.SmallPossiblyInterruptedRunnable(), LONG_DELAY_MS, TimeUnit.MILLISECONDS);
        }
        try {
            List<Runnable> l = p.shutdownNow();
            ScheduledExecutorSubclassTest.assertTrue((boolean)p.isShutdown());
            ScheduledExecutorSubclassTest.assertEquals((int)5, (int)l.size());
        }
        catch (SecurityException securityException) {
        }
        finally {
            this.joinPool(p);
        }
    }

    public void testShutdown1() throws InterruptedException {
        CustomExecutor p = new CustomExecutor(1);
        ScheduledExecutorSubclassTest.assertTrue((boolean)p.getExecuteExistingDelayedTasksAfterShutdownPolicy());
        ScheduledExecutorSubclassTest.assertFalse((boolean)p.getContinueExistingPeriodicTasksAfterShutdownPolicy());
        ScheduledFuture[] tasks = new ScheduledFuture[5];
        for (int i = 0; i < tasks.length; ++i) {
            tasks[i] = p.schedule(new JSR166TestCase.NoOpRunnable(), SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
        }
        try {
            p.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        BlockingQueue<Runnable> q = p.getQueue();
        for (ScheduledFuture task : tasks) {
            ScheduledExecutorSubclassTest.assertFalse((boolean)task.isDone());
            ScheduledExecutorSubclassTest.assertFalse((boolean)task.isCancelled());
            ScheduledExecutorSubclassTest.assertTrue((boolean)q.contains(task));
        }
        ScheduledExecutorSubclassTest.assertTrue((boolean)p.isShutdown());
        ScheduledExecutorSubclassTest.assertTrue((boolean)p.awaitTermination(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
        ScheduledExecutorSubclassTest.assertTrue((boolean)p.isTerminated());
        for (ScheduledFuture task : tasks) {
            ScheduledExecutorSubclassTest.assertTrue((boolean)task.isDone());
            ScheduledExecutorSubclassTest.assertFalse((boolean)task.isCancelled());
        }
    }

    public void testShutdown2() throws InterruptedException {
        CustomExecutor p = new CustomExecutor(1);
        p.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        ScheduledExecutorSubclassTest.assertFalse((boolean)p.getExecuteExistingDelayedTasksAfterShutdownPolicy());
        ScheduledExecutorSubclassTest.assertFalse((boolean)p.getContinueExistingPeriodicTasksAfterShutdownPolicy());
        ScheduledFuture[] tasks = new ScheduledFuture[5];
        for (int i = 0; i < tasks.length; ++i) {
            tasks[i] = p.schedule(new JSR166TestCase.NoOpRunnable(), SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
        }
        BlockingQueue<Runnable> q = p.getQueue();
        ScheduledExecutorSubclassTest.assertEquals((int)tasks.length, (int)q.size());
        try {
            p.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        ScheduledExecutorSubclassTest.assertTrue((boolean)p.isShutdown());
        ScheduledExecutorSubclassTest.assertTrue((boolean)q.isEmpty());
        ScheduledExecutorSubclassTest.assertTrue((boolean)p.awaitTermination(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
        ScheduledExecutorSubclassTest.assertTrue((boolean)p.isTerminated());
        for (ScheduledFuture task : tasks) {
            ScheduledExecutorSubclassTest.assertTrue((boolean)task.isDone());
            ScheduledExecutorSubclassTest.assertTrue((boolean)task.isCancelled());
        }
    }

    public void testShutdown3() throws InterruptedException {
        CustomExecutor p = new CustomExecutor(1);
        ScheduledExecutorSubclassTest.assertTrue((boolean)p.getExecuteExistingDelayedTasksAfterShutdownPolicy());
        ScheduledExecutorSubclassTest.assertFalse((boolean)p.getContinueExistingPeriodicTasksAfterShutdownPolicy());
        p.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        ScheduledExecutorSubclassTest.assertTrue((boolean)p.getExecuteExistingDelayedTasksAfterShutdownPolicy());
        ScheduledExecutorSubclassTest.assertFalse((boolean)p.getContinueExistingPeriodicTasksAfterShutdownPolicy());
        ScheduledFuture<?> task = p.scheduleAtFixedRate(new JSR166TestCase.NoOpRunnable(), 5L, 5L, TimeUnit.MILLISECONDS);
        try {
            p.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        ScheduledExecutorSubclassTest.assertTrue((boolean)p.isShutdown());
        BlockingQueue<Runnable> q = p.getQueue();
        ScheduledExecutorSubclassTest.assertTrue((boolean)p.getQueue().isEmpty());
        ScheduledExecutorSubclassTest.assertTrue((boolean)task.isDone());
        ScheduledExecutorSubclassTest.assertTrue((boolean)task.isCancelled());
        ScheduledExecutorSubclassTest.assertTrue((boolean)p.awaitTermination(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
        ScheduledExecutorSubclassTest.assertTrue((boolean)p.isTerminated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShutdown4() throws InterruptedException {
        CustomExecutor p = new CustomExecutor(1);
        final CountDownLatch counter = new CountDownLatch(2);
        try {
            p.setContinueExistingPeriodicTasksAfterShutdownPolicy(true);
            ScheduledExecutorSubclassTest.assertTrue((boolean)p.getExecuteExistingDelayedTasksAfterShutdownPolicy());
            ScheduledExecutorSubclassTest.assertTrue((boolean)p.getContinueExistingPeriodicTasksAfterShutdownPolicy());
            JSR166TestCase.CheckedRunnable r = new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() {
                    counter.countDown();
                }
            };
            ScheduledFuture<?> task = p.scheduleAtFixedRate(r, 1L, 1L, TimeUnit.MILLISECONDS);
            ScheduledExecutorSubclassTest.assertFalse((boolean)task.isDone());
            ScheduledExecutorSubclassTest.assertFalse((boolean)task.isCancelled());
            try {
                p.shutdown();
            }
            catch (SecurityException ok) {
                this.joinPool(p);
                return;
            }
            ScheduledExecutorSubclassTest.assertFalse((boolean)task.isCancelled());
            ScheduledExecutorSubclassTest.assertFalse((boolean)p.isTerminated());
            ScheduledExecutorSubclassTest.assertTrue((boolean)p.isShutdown());
            ScheduledExecutorSubclassTest.assertTrue((boolean)counter.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ScheduledExecutorSubclassTest.assertFalse((boolean)task.isCancelled());
            ScheduledExecutorSubclassTest.assertTrue((boolean)task.cancel(false));
            ScheduledExecutorSubclassTest.assertTrue((boolean)task.isDone());
            ScheduledExecutorSubclassTest.assertTrue((boolean)task.isCancelled());
            ScheduledExecutorSubclassTest.assertTrue((boolean)p.awaitTermination(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ScheduledExecutorSubclassTest.assertTrue((boolean)p.isTerminated());
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitCallable() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            Future<String> future = e.submit(new JSR166TestCase.StringTask());
            String result = future.get();
            ScheduledExecutorSubclassTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitRunnable() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            Future<?> future = e.submit(new JSR166TestCase.NoOpRunnable());
            future.get();
            ScheduledExecutorSubclassTest.assertTrue((boolean)future.isDone());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitRunnable2() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            Future<String> future = e.submit(new JSR166TestCase.NoOpRunnable(), "a test string");
            String result = future.get();
            ScheduledExecutorSubclassTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny1() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            e.invokeAny(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny2() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            e.invokeAny(new ArrayList());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny3() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        CustomExecutor e = new CustomExecutor(2);
        ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
        l.add(this.latchAwaitingStringTask(latch));
        l.add(null);
        try {
            e.invokeAny(l);
            this.shouldThrow();
        }
        catch (NullPointerException success) {
        }
        finally {
            latch.countDown();
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny4() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        try {
            e.invokeAny(l);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ScheduledExecutorSubclassTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny5() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            String result = (String)e.invokeAny(l);
            ScheduledExecutorSubclassTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll1() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            e.invokeAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll2() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            List r = e.invokeAll(new ArrayList());
            ScheduledExecutorSubclassTest.assertTrue((boolean)r.isEmpty());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll3() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        l.add(null);
        try {
            e.invokeAll(l);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll4() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        List futures = e.invokeAll(l);
        ScheduledExecutorSubclassTest.assertEquals((int)1, (int)futures.size());
        try {
            futures.get(0).get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ScheduledExecutorSubclassTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll5() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l);
            ScheduledExecutorSubclassTest.assertEquals((int)2, (int)futures.size());
            for (Future future : futures) {
                ScheduledExecutorSubclassTest.assertSame((Object)"a test string", future.get());
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny1() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            e.invokeAny(null, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAnyNullTimeUnit() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny2() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            e.invokeAny(new ArrayList(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny3() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        CustomExecutor e = new CustomExecutor(2);
        ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
        l.add(this.latchAwaitingStringTask(latch));
        l.add(null);
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException success) {
        }
        finally {
            latch.countDown();
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny4() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ScheduledExecutorSubclassTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny5() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            String result = (String)e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ScheduledExecutorSubclassTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll1() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            e.invokeAll(null, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAllNullTimeUnit() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        try {
            e.invokeAll(l, MEDIUM_DELAY_MS, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll2() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            List r = e.invokeAll(new ArrayList(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ScheduledExecutorSubclassTest.assertTrue((boolean)r.isEmpty());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll3() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        l.add(null);
        try {
            e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll4() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        List futures = e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
        ScheduledExecutorSubclassTest.assertEquals((int)1, (int)futures.size());
        try {
            futures.get(0).get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ScheduledExecutorSubclassTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll5() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ScheduledExecutorSubclassTest.assertEquals((int)2, (int)futures.size());
            for (Future future : futures) {
                ScheduledExecutorSubclassTest.assertSame((Object)"a test string", future.get());
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll6() throws Exception {
        CustomExecutor e = new CustomExecutor(2);
        try {
            ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
            l.add(new JSR166TestCase.StringTask());
            l.add(Executors.callable(new JSR166TestCase.MediumPossiblyInterruptedRunnable(), "a test string"));
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l, SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            ScheduledExecutorSubclassTest.assertEquals((int)3, (int)futures.size());
            Iterator it = futures.iterator();
            Future f1 = it.next();
            Future f2 = it.next();
            Future f3 = it.next();
            ScheduledExecutorSubclassTest.assertTrue((boolean)f1.isDone());
            ScheduledExecutorSubclassTest.assertTrue((boolean)f2.isDone());
            ScheduledExecutorSubclassTest.assertTrue((boolean)f3.isDone());
            ScheduledExecutorSubclassTest.assertFalse((boolean)f1.isCancelled());
            ScheduledExecutorSubclassTest.assertTrue((boolean)f2.isCancelled());
        }
        finally {
            this.joinPool(e);
        }
    }

    static class RunnableCounter
    implements Runnable {
        AtomicInteger count = new AtomicInteger(0);

        RunnableCounter() {
        }

        @Override
        public void run() {
            this.count.getAndIncrement();
        }
    }

    public class CustomExecutor
    extends ScheduledThreadPoolExecutor {
        @Override
        protected <V> RunnableScheduledFuture<V> decorateTask(Runnable r, RunnableScheduledFuture<V> task) {
            return new CustomTask<V>(task);
        }

        @Override
        protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> c, RunnableScheduledFuture<V> task) {
            return new CustomTask<V>(task);
        }

        CustomExecutor(int corePoolSize) {
            super(corePoolSize);
        }

        CustomExecutor(int corePoolSize, RejectedExecutionHandler handler) {
            super(corePoolSize, handler);
        }

        CustomExecutor(int corePoolSize, ThreadFactory threadFactory) {
            super(corePoolSize, threadFactory);
        }

        CustomExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, threadFactory, handler);
        }
    }

    static class CustomTask<V>
    implements RunnableScheduledFuture<V> {
        RunnableScheduledFuture<V> task;
        volatile boolean ran;

        CustomTask(RunnableScheduledFuture<V> t) {
            this.task = t;
        }

        @Override
        public boolean isPeriodic() {
            return this.task.isPeriodic();
        }

        @Override
        public void run() {
            this.ran = true;
            this.task.run();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.task.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed t) {
            return this.task.compareTo(((CustomTask)t).task);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.task.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.task.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.task.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            Object v = this.task.get();
            Assert.assertTrue((boolean)this.ran);
            return v;
        }

        @Override
        public V get(long time, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Object v = this.task.get(time, unit);
            Assert.assertTrue((boolean)this.ran);
            return v;
        }
    }
}

