/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SemaphoreTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)SemaphoreTest.suite());
    }

    public static Test suite() {
        return new TestSuite(SemaphoreTest.class);
    }

    public void testConstructor() {
        for (int permits : new int[]{-1, 0, 1}) {
            for (boolean fair : new boolean[]{false, true}) {
                Semaphore s = new Semaphore(permits, fair);
                SemaphoreTest.assertEquals((int)permits, (int)s.availablePermits());
                SemaphoreTest.assertEquals((boolean)fair, (boolean)s.isFair());
            }
        }
    }

    public void testConstructor2() {
        for (int permits : new int[]{-1, 0, 1}) {
            Semaphore s = new Semaphore(permits);
            SemaphoreTest.assertEquals((int)permits, (int)s.availablePermits());
            SemaphoreTest.assertFalse((boolean)s.isFair());
        }
    }

    public void testTryAcquireInSameThread() {
        Semaphore s = new Semaphore(2, false);
        SemaphoreTest.assertEquals((int)2, (int)s.availablePermits());
        SemaphoreTest.assertTrue((boolean)s.tryAcquire());
        SemaphoreTest.assertTrue((boolean)s.tryAcquire());
        SemaphoreTest.assertEquals((int)0, (int)s.availablePermits());
        SemaphoreTest.assertFalse((boolean)s.tryAcquire());
    }

    public void testAcquireReleaseInSameThread() throws InterruptedException {
        Semaphore s = new Semaphore(1, false);
        s.acquire();
        s.release();
        s.acquire();
        s.release();
        s.acquire();
        s.release();
        s.acquire();
        s.release();
        s.acquire();
        s.release();
        SemaphoreTest.assertEquals((int)1, (int)s.availablePermits());
    }

    public void testAcquireUninterruptiblyReleaseInSameThread() throws InterruptedException {
        Semaphore s = new Semaphore(1, false);
        s.acquireUninterruptibly();
        s.release();
        s.acquireUninterruptibly();
        s.release();
        s.acquireUninterruptibly();
        s.release();
        s.acquireUninterruptibly();
        s.release();
        s.acquireUninterruptibly();
        s.release();
        SemaphoreTest.assertEquals((int)1, (int)s.availablePermits());
    }

    public void testTimedAcquireReleaseInSameThread() throws InterruptedException {
        Semaphore s = new Semaphore(1, false);
        SemaphoreTest.assertTrue((boolean)s.tryAcquire(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        s.release();
        SemaphoreTest.assertTrue((boolean)s.tryAcquire(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        s.release();
        SemaphoreTest.assertTrue((boolean)s.tryAcquire(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        s.release();
        SemaphoreTest.assertTrue((boolean)s.tryAcquire(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        s.release();
        SemaphoreTest.assertTrue((boolean)s.tryAcquire(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        s.release();
        SemaphoreTest.assertEquals((int)1, (int)s.availablePermits());
    }

    public void testAcquireReleaseInDifferentThreads() throws InterruptedException {
        final Semaphore s = new Semaphore(0, false);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                s.acquire();
                s.release();
                s.release();
                s.acquire();
            }
        });
        t.start();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        s.release();
        s.release();
        s.acquire();
        s.acquire();
        s.release();
        t.join();
    }

    public void testUninterruptibleAcquireReleaseInDifferentThreads() throws InterruptedException {
        final Semaphore s = new Semaphore(0, false);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                s.acquireUninterruptibly();
                s.release();
                s.release();
                s.acquireUninterruptibly();
            }
        });
        t.start();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        s.release();
        s.release();
        s.acquireUninterruptibly();
        s.acquireUninterruptibly();
        s.release();
        t.join();
    }

    public void testTimedAcquireReleaseInDifferentThreads() throws InterruptedException {
        final Semaphore s = new Semaphore(1, false);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                s.release();
                Assert.assertTrue((boolean)s.tryAcquire(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                s.release();
                Assert.assertTrue((boolean)s.tryAcquire(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
            }
        });
        t.start();
        SemaphoreTest.assertTrue((boolean)s.tryAcquire(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        s.release();
        SemaphoreTest.assertTrue((boolean)s.tryAcquire(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        s.release();
        s.release();
        t.join();
    }

    public void testAcquire_InterruptedException() throws InterruptedException {
        final Semaphore s = new Semaphore(0, false);
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                s.acquire();
            }
        });
        t.start();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTryAcquire_InterruptedException() throws InterruptedException {
        final Semaphore s = new Semaphore(0, false);
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                s.tryAcquire(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        });
        t.start();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testHasQueuedThreads() throws InterruptedException {
        Semaphore lock = new Semaphore(1, false);
        Thread t1 = new Thread(new InterruptedLockRunnable(lock));
        Thread t2 = new Thread(new InterruptibleLockRunnable(lock));
        SemaphoreTest.assertFalse((boolean)lock.hasQueuedThreads());
        lock.acquireUninterruptibly();
        t1.start();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        SemaphoreTest.assertTrue((boolean)lock.hasQueuedThreads());
        t2.start();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        SemaphoreTest.assertTrue((boolean)lock.hasQueuedThreads());
        t1.interrupt();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        SemaphoreTest.assertTrue((boolean)lock.hasQueuedThreads());
        lock.release();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        SemaphoreTest.assertFalse((boolean)lock.hasQueuedThreads());
        t1.join();
        t2.join();
    }

    public void testGetQueueLength() throws InterruptedException {
        Semaphore lock = new Semaphore(1, false);
        Thread t1 = new Thread(new InterruptedLockRunnable(lock));
        Thread t2 = new Thread(new InterruptibleLockRunnable(lock));
        SemaphoreTest.assertEquals((int)0, (int)lock.getQueueLength());
        lock.acquireUninterruptibly();
        t1.start();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        SemaphoreTest.assertEquals((int)1, (int)lock.getQueueLength());
        t2.start();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        SemaphoreTest.assertEquals((int)2, (int)lock.getQueueLength());
        t1.interrupt();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        SemaphoreTest.assertEquals((int)1, (int)lock.getQueueLength());
        lock.release();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        SemaphoreTest.assertEquals((int)0, (int)lock.getQueueLength());
        t1.join();
        t2.join();
    }

    public void testGetQueuedThreads() throws InterruptedException {
        PublicSemaphore lock = new PublicSemaphore(1, false);
        Thread t1 = new Thread(new InterruptedLockRunnable(lock));
        Thread t2 = new Thread(new InterruptibleLockRunnable(lock));
        SemaphoreTest.assertTrue((boolean)lock.getQueuedThreads().isEmpty());
        lock.acquireUninterruptibly();
        SemaphoreTest.assertTrue((boolean)lock.getQueuedThreads().isEmpty());
        t1.start();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        SemaphoreTest.assertTrue((boolean)lock.getQueuedThreads().contains(t1));
        t2.start();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        SemaphoreTest.assertTrue((boolean)lock.getQueuedThreads().contains(t1));
        SemaphoreTest.assertTrue((boolean)lock.getQueuedThreads().contains(t2));
        t1.interrupt();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        SemaphoreTest.assertFalse((boolean)lock.getQueuedThreads().contains(t1));
        SemaphoreTest.assertTrue((boolean)lock.getQueuedThreads().contains(t2));
        lock.release();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        SemaphoreTest.assertTrue((boolean)lock.getQueuedThreads().isEmpty());
        t1.join();
        t2.join();
    }

    public void testDrainPermits() {
        Semaphore s = new Semaphore(0, false);
        SemaphoreTest.assertEquals((int)0, (int)s.availablePermits());
        SemaphoreTest.assertEquals((int)0, (int)s.drainPermits());
        s.release(10);
        SemaphoreTest.assertEquals((int)10, (int)s.availablePermits());
        SemaphoreTest.assertEquals((int)10, (int)s.drainPermits());
        SemaphoreTest.assertEquals((int)0, (int)s.availablePermits());
        SemaphoreTest.assertEquals((int)0, (int)s.drainPermits());
    }

    public void testReducePermits() {
        PublicSemaphore s = new PublicSemaphore(10, false);
        SemaphoreTest.assertEquals((int)10, (int)s.availablePermits());
        s.reducePermits(1);
        SemaphoreTest.assertEquals((int)9, (int)s.availablePermits());
        s.reducePermits(10);
        SemaphoreTest.assertEquals((int)-1, (int)s.availablePermits());
    }

    public void testSerialization() throws Exception {
        Semaphore l = new Semaphore(3, false);
        l.acquire();
        l.release();
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(l);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        Semaphore r = (Semaphore)in.readObject();
        SemaphoreTest.assertEquals((int)3, (int)r.availablePermits());
        SemaphoreTest.assertFalse((boolean)r.isFair());
        r.acquire();
        r.release();
    }

    public void testConstructor_fair() {
        Semaphore s0 = new Semaphore(0, true);
        SemaphoreTest.assertEquals((int)0, (int)s0.availablePermits());
        SemaphoreTest.assertTrue((boolean)s0.isFair());
        Semaphore s1 = new Semaphore(-1, true);
        SemaphoreTest.assertEquals((int)-1, (int)s1.availablePermits());
        Semaphore s2 = new Semaphore(-1, true);
        SemaphoreTest.assertEquals((int)-1, (int)s2.availablePermits());
    }

    public void testTryAcquireInSameThread_fair() {
        Semaphore s = new Semaphore(2, true);
        SemaphoreTest.assertEquals((int)2, (int)s.availablePermits());
        SemaphoreTest.assertTrue((boolean)s.tryAcquire());
        SemaphoreTest.assertTrue((boolean)s.tryAcquire());
        SemaphoreTest.assertEquals((int)0, (int)s.availablePermits());
        SemaphoreTest.assertFalse((boolean)s.tryAcquire());
    }

    public void testTryAcquireNInSameThread_fair() {
        Semaphore s = new Semaphore(2, true);
        SemaphoreTest.assertEquals((int)2, (int)s.availablePermits());
        SemaphoreTest.assertTrue((boolean)s.tryAcquire(2));
        SemaphoreTest.assertEquals((int)0, (int)s.availablePermits());
        SemaphoreTest.assertFalse((boolean)s.tryAcquire());
    }

    public void testAcquireReleaseInSameThread_fair() throws InterruptedException {
        Semaphore s = new Semaphore(1, true);
        s.acquire();
        s.release();
        s.acquire();
        s.release();
        s.acquire();
        s.release();
        s.acquire();
        s.release();
        s.acquire();
        s.release();
        SemaphoreTest.assertEquals((int)1, (int)s.availablePermits());
    }

    public void testAcquireReleaseNInSameThread_fair() throws InterruptedException {
        Semaphore s = new Semaphore(1, true);
        s.release(1);
        s.acquire(1);
        s.release(2);
        s.acquire(2);
        s.release(3);
        s.acquire(3);
        s.release(4);
        s.acquire(4);
        s.release(5);
        s.acquire(5);
        SemaphoreTest.assertEquals((int)1, (int)s.availablePermits());
    }

    public void testAcquireUninterruptiblyReleaseNInSameThread_fair() {
        Semaphore s = new Semaphore(1, true);
        s.release(1);
        s.acquireUninterruptibly(1);
        s.release(2);
        s.acquireUninterruptibly(2);
        s.release(3);
        s.acquireUninterruptibly(3);
        s.release(4);
        s.acquireUninterruptibly(4);
        s.release(5);
        s.acquireUninterruptibly(5);
        SemaphoreTest.assertEquals((int)1, (int)s.availablePermits());
    }

    public void testTimedAcquireReleaseNInSameThread_fair() throws InterruptedException {
        Semaphore s = new Semaphore(1, true);
        s.release(1);
        SemaphoreTest.assertTrue((boolean)s.tryAcquire(1, SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        s.release(2);
        SemaphoreTest.assertTrue((boolean)s.tryAcquire(2, SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        s.release(3);
        SemaphoreTest.assertTrue((boolean)s.tryAcquire(3, SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        s.release(4);
        SemaphoreTest.assertTrue((boolean)s.tryAcquire(4, SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        s.release(5);
        SemaphoreTest.assertTrue((boolean)s.tryAcquire(5, SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        SemaphoreTest.assertEquals((int)1, (int)s.availablePermits());
    }

    public void testTimedAcquireReleaseInSameThread_fair() throws InterruptedException {
        Semaphore s = new Semaphore(1, true);
        SemaphoreTest.assertTrue((boolean)s.tryAcquire(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        s.release();
        SemaphoreTest.assertTrue((boolean)s.tryAcquire(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        s.release();
        SemaphoreTest.assertTrue((boolean)s.tryAcquire(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        s.release();
        SemaphoreTest.assertTrue((boolean)s.tryAcquire(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        s.release();
        SemaphoreTest.assertTrue((boolean)s.tryAcquire(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        s.release();
        SemaphoreTest.assertEquals((int)1, (int)s.availablePermits());
    }

    public void testAcquireReleaseInDifferentThreads_fair() throws InterruptedException {
        final Semaphore s = new Semaphore(0, true);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                s.acquire();
                s.acquire();
                s.acquire();
                s.acquire();
            }
        });
        t.start();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        s.release();
        s.release();
        s.release();
        s.release();
        s.release();
        s.release();
        t.join();
        SemaphoreTest.assertEquals((int)2, (int)s.availablePermits());
    }

    public void testAcquireReleaseNInDifferentThreads_fair() throws InterruptedException {
        final Semaphore s = new Semaphore(0, true);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                s.acquire();
                s.release(2);
                s.acquire();
            }
        });
        t.start();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        s.release(2);
        s.acquire(2);
        s.release(1);
        t.join();
    }

    public void testAcquireReleaseNInDifferentThreads_fair2() throws InterruptedException {
        final Semaphore s = new Semaphore(0, true);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                s.acquire(2);
                s.acquire(2);
                s.release(4);
            }
        });
        t.start();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        s.release(6);
        s.acquire(2);
        s.acquire(2);
        s.release(2);
        t.join();
    }

    public void testTimedAcquireReleaseInDifferentThreads_fair() throws InterruptedException {
        final Semaphore s = new Semaphore(1, true);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertTrue((boolean)s.tryAcquire(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertTrue((boolean)s.tryAcquire(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertTrue((boolean)s.tryAcquire(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertTrue((boolean)s.tryAcquire(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertTrue((boolean)s.tryAcquire(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
            }
        });
        t.start();
        s.release();
        s.release();
        s.release();
        s.release();
        s.release();
        t.join();
    }

    public void testTimedAcquireReleaseNInDifferentThreads_fair() throws InterruptedException {
        final Semaphore s = new Semaphore(2, true);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertTrue((boolean)s.tryAcquire(2, JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                s.release(2);
                Assert.assertTrue((boolean)s.tryAcquire(2, JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                s.release(2);
            }
        });
        t.start();
        SemaphoreTest.assertTrue((boolean)s.tryAcquire(2, SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        s.release(2);
        SemaphoreTest.assertTrue((boolean)s.tryAcquire(2, SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        s.release(2);
        t.join();
    }

    public void testAcquire_InterruptedException_fair() throws InterruptedException {
        final Semaphore s = new Semaphore(0, true);
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                s.acquire();
            }
        });
        t.start();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testAcquireN_InterruptedException_fair() throws InterruptedException {
        final Semaphore s = new Semaphore(2, true);
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                s.acquire(3);
            }
        });
        t.start();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTryAcquire_InterruptedException_fair() throws InterruptedException {
        final Semaphore s = new Semaphore(0, true);
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                s.tryAcquire(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        });
        t.start();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTryAcquireN_InterruptedException_fair() throws InterruptedException {
        final Semaphore s = new Semaphore(1, true);
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                s.tryAcquire(4, JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            }
        });
        t.start();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testGetQueueLength_fair() throws InterruptedException {
        Semaphore lock = new Semaphore(1, true);
        Thread t1 = new Thread(new InterruptedLockRunnable(lock));
        Thread t2 = new Thread(new InterruptibleLockRunnable(lock));
        SemaphoreTest.assertEquals((int)0, (int)lock.getQueueLength());
        lock.acquireUninterruptibly();
        t1.start();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        SemaphoreTest.assertEquals((int)1, (int)lock.getQueueLength());
        t2.start();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        SemaphoreTest.assertEquals((int)2, (int)lock.getQueueLength());
        t1.interrupt();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        SemaphoreTest.assertEquals((int)1, (int)lock.getQueueLength());
        lock.release();
        SemaphoreTest.delay(SHORT_DELAY_MS);
        SemaphoreTest.assertEquals((int)0, (int)lock.getQueueLength());
        t1.join();
        t2.join();
    }

    public void testSerialization_fair() throws Exception {
        Semaphore l = new Semaphore(3, true);
        l.acquire();
        l.release();
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(l);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        Semaphore r = (Semaphore)in.readObject();
        SemaphoreTest.assertEquals((int)3, (int)r.availablePermits());
        SemaphoreTest.assertTrue((boolean)r.isFair());
        r.acquire();
        r.release();
    }

    public void testToString() {
        Semaphore s = new Semaphore(0);
        String us = s.toString();
        SemaphoreTest.assertTrue((us.indexOf("Permits = 0") >= 0 ? 1 : 0) != 0);
        s.release();
        String s1 = s.toString();
        SemaphoreTest.assertTrue((s1.indexOf("Permits = 1") >= 0 ? 1 : 0) != 0);
        s.release();
        String s2 = s.toString();
        SemaphoreTest.assertTrue((s2.indexOf("Permits = 2") >= 0 ? 1 : 0) != 0);
    }

    class InterruptedLockRunnable
    extends JSR166TestCase.CheckedInterruptedRunnable {
        final Semaphore lock;

        InterruptedLockRunnable(Semaphore l) {
            this.lock = l;
        }

        @Override
        public void realRun() throws InterruptedException {
            this.lock.acquire();
        }
    }

    class InterruptibleLockRunnable
    extends JSR166TestCase.CheckedRunnable {
        final Semaphore lock;

        InterruptibleLockRunnable(Semaphore l) {
            this.lock = l;
        }

        @Override
        public void realRun() {
            try {
                this.lock.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static class PublicSemaphore
    extends Semaphore {
        PublicSemaphore(int p, boolean f) {
            super(p, f);
        }

        @Override
        public Collection<Thread> getQueuedThreads() {
            return super.getQueuedThreads();
        }

        @Override
        public void reducePermits(int p) {
            super.reducePermits(p);
        }
    }
}

