/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.Test;
import junit.textui.TestRunner;

public class SynchronousQueueTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)SynchronousQueueTest.suite());
    }

    public static Test suite() {
        return SynchronousQueueTest.newTestSuite(SynchronousQueueTest.class, new Fair().testSuite(), new NonFair().testSuite());
    }

    public void testEmptyFull(SynchronousQueue q) {
        SynchronousQueueTest.assertTrue((boolean)q.isEmpty());
        SynchronousQueueTest.assertEquals((int)0, (int)q.size());
        SynchronousQueueTest.assertEquals((int)0, (int)q.remainingCapacity());
        SynchronousQueueTest.assertFalse((boolean)q.offer(zero));
    }

    public void testEmptyFull() {
        this.testEmptyFull(new SynchronousQueue());
    }

    public void testFairEmptyFull() {
        this.testEmptyFull(new SynchronousQueue(true));
    }

    public void testOfferNull() {
        try {
            SynchronousQueue<Object> q = new SynchronousQueue<Object>();
            q.offer(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddNull() {
        try {
            SynchronousQueue<Object> q = new SynchronousQueue<Object>();
            q.add(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testOffer() {
        SynchronousQueue<Integer> q = new SynchronousQueue<Integer>();
        SynchronousQueueTest.assertFalse((boolean)q.offer(one));
    }

    public void testAdd() {
        try {
            SynchronousQueue<Integer> q = new SynchronousQueue<Integer>();
            SynchronousQueueTest.assertEquals((int)0, (int)q.remainingCapacity());
            q.add(one);
            this.shouldThrow();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testAddAll1() {
        try {
            SynchronousQueue q = new SynchronousQueue();
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAllSelf() {
        try {
            SynchronousQueue q = new SynchronousQueue();
            q.addAll(q);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddAll2() {
        try {
            SynchronousQueue<Integer> q = new SynchronousQueue<Integer>();
            Integer[] ints = new Integer[1];
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll4() {
        try {
            SynchronousQueue<Integer> q = new SynchronousQueue<Integer>();
            Integer[] ints = new Integer[1];
            for (int i = 0; i < 1; ++i) {
                ints[i] = new Integer(i);
            }
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testPutNull() throws InterruptedException {
        try {
            SynchronousQueue<Object> q = new SynchronousQueue<Object>();
            q.put(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBlockingPut() throws InterruptedException {
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                SynchronousQueue<Integer> q = new SynchronousQueue<Integer>();
                q.put(JSR166TestCase.zero);
            }
        });
        t.start();
        SynchronousQueueTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testPutWithTake() throws InterruptedException {
        final SynchronousQueue q = new SynchronousQueue();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                int added = 0;
                try {
                    while (true) {
                        q.put(added);
                        ++added;
                    }
                }
                catch (InterruptedException success) {
                    Assert.assertEquals((int)1, (int)added);
                    return;
                }
            }
        });
        t.start();
        SynchronousQueueTest.delay(SHORT_DELAY_MS);
        SynchronousQueueTest.assertEquals((Object)0, q.take());
        SynchronousQueueTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testTimedOffer(final SynchronousQueue q) throws InterruptedException {
        final CountDownLatch pleaseInterrupt = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                long t0 = System.nanoTime();
                Assert.assertFalse((boolean)q.offer(new Object(), JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertTrue((SynchronousQueueTest.this.millisElapsedSince(t0) >= JSR166TestCase.SHORT_DELAY_MS ? 1 : 0) != 0);
                pleaseInterrupt.countDown();
                t0 = System.nanoTime();
                try {
                    q.offer(new Object(), JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
                    SynchronousQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Assert.assertTrue((SynchronousQueueTest.this.millisElapsedSince(t0) < JSR166TestCase.MEDIUM_DELAY_MS ? 1 : 0) != 0);
            }
        });
        SynchronousQueueTest.assertTrue((boolean)pleaseInterrupt.await(MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
        t.interrupt();
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testTimedOffer() throws InterruptedException {
        this.testTimedOffer(new SynchronousQueue());
    }

    public void testFairTimedOffer() throws InterruptedException {
        this.testTimedOffer(new SynchronousQueue(true));
    }

    public void testFairBlockingPut() throws InterruptedException {
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                SynchronousQueue<Integer> q = new SynchronousQueue<Integer>(true);
                q.put(JSR166TestCase.zero);
            }
        });
        t.start();
        SynchronousQueueTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testFairPutWithTake() throws InterruptedException {
        final SynchronousQueue q = new SynchronousQueue(true);
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                int added = 0;
                try {
                    while (true) {
                        q.put(added);
                        ++added;
                    }
                }
                catch (InterruptedException success) {
                    Assert.assertEquals((int)1, (int)added);
                    return;
                }
            }
        });
        t.start();
        SynchronousQueueTest.delay(SHORT_DELAY_MS);
        SynchronousQueueTest.assertEquals((Object)0, q.take());
        SynchronousQueueTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testFairTakeFromEmpty() throws InterruptedException {
        final SynchronousQueue q = new SynchronousQueue(true);
        Thread t = new Thread(new JSR166TestCase.CheckedInterruptedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                q.take();
            }
        });
        t.start();
        SynchronousQueueTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        t.join();
    }

    public void testPoll() {
        SynchronousQueue q = new SynchronousQueue();
        SynchronousQueueTest.assertNull(q.poll());
    }

    public void testTimedPoll0() throws InterruptedException {
        SynchronousQueue q = new SynchronousQueue();
        SynchronousQueueTest.assertNull(q.poll(0L, TimeUnit.MILLISECONDS));
    }

    public void testTimedPoll() throws InterruptedException {
        SynchronousQueue q = new SynchronousQueue();
        long t0 = System.nanoTime();
        SynchronousQueueTest.assertNull(q.poll(SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        SynchronousQueueTest.assertTrue((this.millisElapsedSince(t0) >= SHORT_DELAY_MS ? 1 : 0) != 0);
    }

    public void testInterruptedTimedPoll(final SynchronousQueue q) throws InterruptedException {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                long t0 = System.nanoTime();
                threadStarted.countDown();
                try {
                    q.poll(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
                    SynchronousQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Assert.assertTrue((SynchronousQueueTest.this.millisElapsedSince(t0) >= JSR166TestCase.SHORT_DELAY_MS ? 1 : 0) != 0);
                Assert.assertTrue((SynchronousQueueTest.this.millisElapsedSince(t0) < JSR166TestCase.MEDIUM_DELAY_MS ? 1 : 0) != 0);
            }
        });
        threadStarted.await();
        SynchronousQueueTest.delay(SHORT_DELAY_MS);
        t.interrupt();
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testInterruptedTimedPoll() throws InterruptedException {
        this.testInterruptedTimedPoll(new SynchronousQueue());
    }

    public void testFairInterruptedTimedPoll() throws InterruptedException {
        this.testInterruptedTimedPoll(new SynchronousQueue(true));
    }

    public void testFairTimedPollWithOffer() throws InterruptedException {
        final SynchronousQueue<Integer> q = new SynchronousQueue<Integer>(true);
        final CountDownLatch pleaseOffer = new CountDownLatch(1);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                long t0 = System.nanoTime();
                Assert.assertNull(q.poll(JSR166TestCase.SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertTrue((SynchronousQueueTest.this.millisElapsedSince(t0) >= JSR166TestCase.SHORT_DELAY_MS ? 1 : 0) != 0);
                pleaseOffer.countDown();
                t0 = System.nanoTime();
                Assert.assertSame((Object)JSR166TestCase.zero, q.poll(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertTrue((SynchronousQueueTest.this.millisElapsedSince(t0) < JSR166TestCase.MEDIUM_DELAY_MS ? 1 : 0) != 0);
                t0 = System.nanoTime();
                try {
                    q.poll(JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS);
                    SynchronousQueueTest.this.shouldThrow();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Assert.assertTrue((SynchronousQueueTest.this.millisElapsedSince(t0) < JSR166TestCase.MEDIUM_DELAY_MS ? 1 : 0) != 0);
            }
        });
        SynchronousQueueTest.assertTrue((boolean)pleaseOffer.await(MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
        long t0 = System.nanoTime();
        SynchronousQueueTest.assertTrue((boolean)q.offer(zero, LONG_DELAY_MS, TimeUnit.MILLISECONDS));
        SynchronousQueueTest.assertTrue((this.millisElapsedSince(t0) < MEDIUM_DELAY_MS ? 1 : 0) != 0);
        t.interrupt();
        this.awaitTermination(t, MEDIUM_DELAY_MS);
    }

    public void testPeek() {
        SynchronousQueue q = new SynchronousQueue();
        SynchronousQueueTest.assertNull(q.peek());
    }

    public void testElement() {
        SynchronousQueue q = new SynchronousQueue();
        try {
            q.element();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemove() {
        SynchronousQueue q = new SynchronousQueue();
        try {
            q.remove();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testRemoveElement() {
        SynchronousQueue q = new SynchronousQueue();
        SynchronousQueueTest.assertFalse((boolean)q.remove(zero));
        SynchronousQueueTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContains() {
        SynchronousQueue q = new SynchronousQueue();
        SynchronousQueueTest.assertFalse((boolean)q.contains(zero));
    }

    public void testClear() {
        SynchronousQueue q = new SynchronousQueue();
        q.clear();
        SynchronousQueueTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContainsAll() {
        SynchronousQueue q = new SynchronousQueue();
        Integer[] empty = new Integer[]{};
        SynchronousQueueTest.assertTrue((boolean)q.containsAll(Arrays.asList(empty)));
        Integer[] ints = new Integer[]{zero};
        SynchronousQueueTest.assertFalse((boolean)q.containsAll(Arrays.asList(ints)));
    }

    public void testRetainAll() {
        SynchronousQueue q = new SynchronousQueue();
        Integer[] empty = new Integer[]{};
        SynchronousQueueTest.assertFalse((boolean)q.retainAll(Arrays.asList(empty)));
        Integer[] ints = new Integer[]{zero};
        SynchronousQueueTest.assertFalse((boolean)q.retainAll(Arrays.asList(ints)));
    }

    public void testRemoveAll() {
        SynchronousQueue q = new SynchronousQueue();
        Integer[] empty = new Integer[]{};
        SynchronousQueueTest.assertFalse((boolean)q.removeAll(Arrays.asList(empty)));
        Integer[] ints = new Integer[]{zero};
        SynchronousQueueTest.assertFalse((boolean)q.containsAll(Arrays.asList(ints)));
    }

    public void testToArray() {
        SynchronousQueue q = new SynchronousQueue();
        Object[] o = q.toArray();
        SynchronousQueueTest.assertEquals((int)o.length, (int)0);
    }

    public void testToArray2() {
        SynchronousQueue q = new SynchronousQueue();
        Integer[] ints = new Integer[1];
        SynchronousQueueTest.assertNull((Object)ints[0]);
    }

    public void testToArray_BadArg() {
        SynchronousQueue q = new SynchronousQueue();
        try {
            T[] o = q.toArray((T[])null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testIterator() {
        SynchronousQueue q = new SynchronousQueue();
        Iterator it = q.iterator();
        SynchronousQueueTest.assertFalse((boolean)it.hasNext());
        try {
            Object x = it.next();
            this.shouldThrow();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testIteratorRemove() {
        SynchronousQueue q = new SynchronousQueue();
        Iterator it = q.iterator();
        try {
            it.remove();
            this.shouldThrow();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testToString() {
        SynchronousQueue q = new SynchronousQueue();
        String s = q.toString();
        SynchronousQueueTest.assertNotNull((Object)s);
    }

    public void testOfferInExecutor() {
        final SynchronousQueue q = new SynchronousQueue();
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertFalse((boolean)q.offer(JSR166TestCase.one));
                Assert.assertTrue((boolean)q.offer(JSR166TestCase.one, JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertEquals((int)0, (int)q.remainingCapacity());
            }
        });
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                JSR166TestCase.delay(JSR166TestCase.SMALL_DELAY_MS);
                Assert.assertSame((Object)JSR166TestCase.one, q.take());
            }
        });
        this.joinPool(executor);
    }

    public void testPollInExecutor() {
        final SynchronousQueue q = new SynchronousQueue();
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                Assert.assertNull(q.poll());
                Assert.assertSame((Object)JSR166TestCase.one, q.poll(JSR166TestCase.MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS));
                Assert.assertTrue((boolean)q.isEmpty());
            }
        });
        executor.execute(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                JSR166TestCase.delay(JSR166TestCase.SHORT_DELAY_MS);
                q.put(JSR166TestCase.one);
            }
        });
        this.joinPool(executor);
    }

    public void testSerialization() throws Exception {
        SynchronousQueue q = new SynchronousQueue();
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        SynchronousQueue r = (SynchronousQueue)in.readObject();
        SynchronousQueueTest.assertEquals((int)q.size(), (int)r.size());
        while (!q.isEmpty()) {
            SynchronousQueueTest.assertEquals(q.remove(), r.remove());
        }
    }

    public void testDrainToNull() {
        SynchronousQueue q = new SynchronousQueue();
        try {
            q.drainTo(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDrainToSelf() {
        SynchronousQueue q = new SynchronousQueue();
        try {
            q.drainTo(q);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDrainTo() {
        SynchronousQueue q = new SynchronousQueue();
        ArrayList l = new ArrayList();
        q.drainTo(l);
        SynchronousQueueTest.assertEquals((int)q.size(), (int)0);
        SynchronousQueueTest.assertEquals((int)l.size(), (int)0);
    }

    public void testDrainToWithActivePut() throws InterruptedException {
        final SynchronousQueue q = new SynchronousQueue();
        Thread t = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                q.put(new Integer(1));
            }
        });
        t.start();
        ArrayList l = new ArrayList();
        SynchronousQueueTest.delay(SHORT_DELAY_MS);
        q.drainTo(l);
        SynchronousQueueTest.assertTrue((l.size() <= 1 ? 1 : 0) != 0);
        if (l.size() > 0) {
            SynchronousQueueTest.assertEquals(l.get(0), (Object)new Integer(1));
        }
        t.join();
        SynchronousQueueTest.assertTrue((l.size() <= 1 ? 1 : 0) != 0);
    }

    public void testDrainToNullN() {
        SynchronousQueue q = new SynchronousQueue();
        try {
            q.drainTo(null, 0);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDrainToSelfN() {
        SynchronousQueue q = new SynchronousQueue();
        try {
            q.drainTo(q, 0);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDrainToN() throws InterruptedException {
        final SynchronousQueue q = new SynchronousQueue();
        Thread t1 = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                q.put(JSR166TestCase.one);
            }
        });
        Thread t2 = new Thread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() throws InterruptedException {
                q.put(JSR166TestCase.two);
            }
        });
        t1.start();
        t2.start();
        ArrayList l = new ArrayList();
        SynchronousQueueTest.delay(SHORT_DELAY_MS);
        q.drainTo(l, 1);
        SynchronousQueueTest.assertEquals((int)1, (int)l.size());
        q.drainTo(l, 1);
        SynchronousQueueTest.assertEquals((int)2, (int)l.size());
        SynchronousQueueTest.assertTrue((boolean)l.contains(one));
        SynchronousQueueTest.assertTrue((boolean)l.contains(two));
        t1.join();
        t2.join();
    }

    public static class NonFair
    extends BlockingQueueTest {
        @Override
        protected BlockingQueue emptyCollection() {
            return new SynchronousQueue(false);
        }
    }

    public static class Fair
    extends BlockingQueueTest {
        @Override
        protected BlockingQueue emptyCollection() {
            return new SynchronousQueue(true);
        }
    }
}

