/*
 * Decompiled with CFR 0.152.
 */
import java.util.concurrent.ThreadLocalRandom;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ThreadLocalRandomTest
extends JSR166TestCase {
    static final int NCALLS = 10000;
    static final int MAX_INT_BOUND = 0x10000000;
    static final long MAX_LONG_BOUND = 0x40000000000L;

    public static void main(String[] args) {
        TestRunner.run((Test)ThreadLocalRandomTest.suite());
    }

    public static Test suite() {
        return new TestSuite(ThreadLocalRandomTest.class);
    }

    public void testSetSeed() {
        try {
            ThreadLocalRandom.current().setSeed(17L);
            this.shouldThrow();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testNextInt() {
        int i;
        int f = ThreadLocalRandom.current().nextInt();
        for (i = 0; i < 10000 && ThreadLocalRandom.current().nextInt() == f; ++i) {
        }
        ThreadLocalRandomTest.assertTrue((i < 10000 ? 1 : 0) != 0);
    }

    public void testNextLong() {
        int i;
        long f = ThreadLocalRandom.current().nextLong();
        for (i = 0; i < 10000 && ThreadLocalRandom.current().nextLong() == f; ++i) {
        }
        ThreadLocalRandomTest.assertTrue((i < 10000 ? 1 : 0) != 0);
    }

    public void testNextBoolean() {
        int i;
        boolean f = ThreadLocalRandom.current().nextBoolean();
        for (i = 0; i < 10000 && ThreadLocalRandom.current().nextBoolean() == f; ++i) {
        }
        ThreadLocalRandomTest.assertTrue((i < 10000 ? 1 : 0) != 0);
    }

    public void testNextFloat() {
        int i;
        float f = ThreadLocalRandom.current().nextFloat();
        for (i = 0; i < 10000 && ThreadLocalRandom.current().nextFloat() == f; ++i) {
        }
        ThreadLocalRandomTest.assertTrue((i < 10000 ? 1 : 0) != 0);
    }

    public void testNextDouble() {
        double i;
        double f = ThreadLocalRandom.current().nextDouble();
        for (i = 0.0; i < 10000.0 && ThreadLocalRandom.current().nextDouble() == f; i += 1.0) {
        }
        ThreadLocalRandomTest.assertTrue((i < 10000.0 ? 1 : 0) != 0);
    }

    public void testNextGaussian() {
        int i;
        double f = ThreadLocalRandom.current().nextGaussian();
        for (i = 0; i < 10000 && ThreadLocalRandom.current().nextGaussian() == f; ++i) {
        }
        ThreadLocalRandomTest.assertTrue((i < 10000 ? 1 : 0) != 0);
    }

    public void testNextIntBoundedNeg() {
        try {
            int f = ThreadLocalRandom.current().nextInt(-17);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNextIntBadBounds() {
        try {
            int f = ThreadLocalRandom.current().nextInt(17, 2);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNextIntBounded() {
        for (int bound = 2; bound < 0x10000000; bound += 524959) {
            int j;
            int i;
            int f = ThreadLocalRandom.current().nextInt(bound);
            ThreadLocalRandomTest.assertTrue((0 <= f && f < bound ? 1 : 0) != 0);
            for (i = 0; i < 10000 && (j = ThreadLocalRandom.current().nextInt(bound)) == f; ++i) {
                ThreadLocalRandomTest.assertTrue((0 <= j && j < bound ? 1 : 0) != 0);
            }
            ThreadLocalRandomTest.assertTrue((i < 10000 ? 1 : 0) != 0);
        }
    }

    public void testNextIntBounded2() {
        for (int least = -15485863; least < 0x10000000; least += 524959) {
            for (int bound = least + 2; bound > least && bound < 0x10000000; bound += 49979687) {
                int j;
                int i;
                int f = ThreadLocalRandom.current().nextInt(least, bound);
                ThreadLocalRandomTest.assertTrue((least <= f && f < bound ? 1 : 0) != 0);
                for (i = 0; i < 10000 && (j = ThreadLocalRandom.current().nextInt(least, bound)) == f; ++i) {
                    ThreadLocalRandomTest.assertTrue((least <= j && j < bound ? 1 : 0) != 0);
                }
                ThreadLocalRandomTest.assertTrue((i < 10000 ? 1 : 0) != 0);
            }
        }
    }

    public void testNextLongBoundedNeg() {
        try {
            long f = ThreadLocalRandom.current().nextLong(-17L);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNextLongBadBounds() {
        try {
            long f = ThreadLocalRandom.current().nextLong(17L, 2L);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNextLongBounded() {
        for (long bound = 2L; bound < 0x40000000000L; bound += 15485863L) {
            long j;
            int i;
            long f = ThreadLocalRandom.current().nextLong(bound);
            ThreadLocalRandomTest.assertTrue((0L <= f && f < bound ? 1 : 0) != 0);
            for (i = 0; i < 10000 && (j = ThreadLocalRandom.current().nextLong(bound)) == f; ++i) {
                ThreadLocalRandomTest.assertTrue((0L <= j && j < bound ? 1 : 0) != 0);
            }
            ThreadLocalRandomTest.assertTrue((i < 10000 ? 1 : 0) != 0);
        }
    }

    public void testNextLongBounded2() {
        for (long least = -86028121L; least < 0x40000000000L; least += 982451653L) {
            for (long bound = least + 2L; bound > least && bound < 0x40000000000L; bound += Math.abs(bound * 7919L)) {
                long j;
                int i;
                long f = ThreadLocalRandom.current().nextLong(least, bound);
                ThreadLocalRandomTest.assertTrue((least <= f && f < bound ? 1 : 0) != 0);
                for (i = 0; i < 10000 && (j = ThreadLocalRandom.current().nextLong(least, bound)) == f; ++i) {
                    ThreadLocalRandomTest.assertTrue((least <= j && j < bound ? 1 : 0) != 0);
                }
                ThreadLocalRandomTest.assertTrue((i < 10000 ? 1 : 0) != 0);
            }
        }
    }

    public void testNextDoubleBounded2() {
        for (double least = 1.0E-4; least < 1.0E20; least *= 8.0) {
            for (double bound = least * 1.001; bound < 1.0E20; bound *= 16.0) {
                double j;
                int i;
                double f = ThreadLocalRandom.current().nextDouble(least, bound);
                ThreadLocalRandomTest.assertTrue((least <= f && f < bound ? 1 : 0) != 0);
                for (i = 0; i < 10000 && (j = ThreadLocalRandom.current().nextDouble(least, bound)) == f; ++i) {
                    ThreadLocalRandomTest.assertTrue((least <= j && j < bound ? 1 : 0) != 0);
                }
                ThreadLocalRandomTest.assertTrue((i < 10000 ? 1 : 0) != 0);
            }
        }
    }
}

