/*
 * Decompiled with CFR 0.152.
 */
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ThreadLocalTest
extends JSR166TestCase {
    static ThreadLocal<Integer> tl = new ThreadLocal<Integer>(){

        @Override
        public Integer initialValue() {
            return JSR166TestCase.one;
        }
    };
    static InheritableThreadLocal<Integer> itl = new InheritableThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return JSR166TestCase.zero;
        }

        @Override
        protected Integer childValue(Integer parentValue) {
            return new Integer(parentValue + 1);
        }
    };

    public static void main(String[] args) {
        TestRunner.run((Test)ThreadLocalTest.suite());
    }

    public static Test suite() {
        return new TestSuite(ThreadLocalTest.class);
    }

    public void testRemove() {
        ThreadLocalTest.assertSame((Object)tl.get(), (Object)one);
        tl.set(two);
        ThreadLocalTest.assertSame((Object)tl.get(), (Object)two);
        tl.remove();
        ThreadLocalTest.assertSame((Object)tl.get(), (Object)one);
    }

    public void testRemoveITL() {
        ThreadLocalTest.assertSame(itl.get(), (Object)zero);
        itl.set(two);
        ThreadLocalTest.assertSame(itl.get(), (Object)two);
        itl.remove();
        ThreadLocalTest.assertSame(itl.get(), (Object)zero);
    }

    public void testGenericITL() throws InterruptedException {
        int threadCount = 10;
        int[] x = new int[10];
        ITLThread progenitor = new ITLThread(x);
        progenitor.start();
        progenitor.join();
        for (int i = 0; i < 10; ++i) {
            ThreadLocalTest.assertEquals((int)i, (int)x[i]);
        }
    }

    private class ITLThread
    extends Thread {
        final int[] x;

        ITLThread(int[] array) {
            this.x = array;
        }

        @Override
        public void run() {
            ITLThread child = null;
            if ((Integer)itl.get() < this.x.length - 1) {
                child = new ITLThread(this.x);
                child.start();
            }
            Thread.currentThread();
            Thread.yield();
            int threadId = (Integer)itl.get();
            for (int j = 0; j < threadId; ++j) {
                int n = threadId;
                this.x[n] = this.x[n] + 1;
                Thread.currentThread();
                Thread.yield();
            }
            if (child != null) {
                try {
                    child.join();
                }
                catch (InterruptedException e) {
                    ThreadLocalTest.this.threadUnexpectedException(e);
                }
            }
        }
    }
}

