/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ThreadPoolExecutorTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)ThreadPoolExecutorTest.suite());
    }

    public static Test suite() {
        return new TestSuite(ThreadPoolExecutorTest.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecute() throws InterruptedException {
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        final CountDownLatch done = new CountDownLatch(1);
        JSR166TestCase.CheckedRunnable task = new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                done.countDown();
            }
        };
        try {
            p.execute(task);
            ThreadPoolExecutorTest.assertTrue((boolean)done.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetActiveCount() throws InterruptedException {
        final ThreadPoolExecutor p = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final CountDownLatch done = new CountDownLatch(1);
        try {
            ThreadPoolExecutorTest.assertEquals((int)0, (int)p.getActiveCount());
            p.execute(new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() throws InterruptedException {
                    threadStarted.countDown();
                    Assert.assertEquals((int)1, (int)p.getActiveCount());
                    done.await();
                }
            });
            ThreadPoolExecutorTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ThreadPoolExecutorTest.assertEquals((int)1, (int)p.getActiveCount());
        }
        finally {
            done.countDown();
            this.joinPool(p);
        }
    }

    public void testPrestartCoreThread() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertEquals((int)0, (int)p.getPoolSize());
        ThreadPoolExecutorTest.assertTrue((boolean)p.prestartCoreThread());
        ThreadPoolExecutorTest.assertEquals((int)1, (int)p.getPoolSize());
        ThreadPoolExecutorTest.assertTrue((boolean)p.prestartCoreThread());
        ThreadPoolExecutorTest.assertEquals((int)2, (int)p.getPoolSize());
        ThreadPoolExecutorTest.assertFalse((boolean)p.prestartCoreThread());
        ThreadPoolExecutorTest.assertEquals((int)2, (int)p.getPoolSize());
        this.joinPool(p);
    }

    public void testPrestartAllCoreThreads() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertEquals((int)0, (int)p.getPoolSize());
        p.prestartAllCoreThreads();
        ThreadPoolExecutorTest.assertEquals((int)2, (int)p.getPoolSize());
        p.prestartAllCoreThreads();
        ThreadPoolExecutorTest.assertEquals((int)2, (int)p.getPoolSize());
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetCompletedTaskCount() throws InterruptedException {
        final ThreadPoolExecutor p = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final CountDownLatch threadProceed = new CountDownLatch(1);
        final CountDownLatch threadDone = new CountDownLatch(1);
        try {
            ThreadPoolExecutorTest.assertEquals((long)0L, (long)p.getCompletedTaskCount());
            p.execute(new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() throws InterruptedException {
                    threadStarted.countDown();
                    Assert.assertEquals((long)0L, (long)p.getCompletedTaskCount());
                    threadProceed.await();
                    threadDone.countDown();
                }
            });
            ThreadPoolExecutorTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ThreadPoolExecutorTest.assertEquals((long)0L, (long)p.getCompletedTaskCount());
            threadProceed.countDown();
            threadDone.await();
            ThreadPoolExecutorTest.delay(SHORT_DELAY_MS);
            ThreadPoolExecutorTest.assertEquals((long)1L, (long)p.getCompletedTaskCount());
        }
        finally {
            this.joinPool(p);
        }
    }

    public void testGetCorePoolSize() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertEquals((int)1, (int)p.getCorePoolSize());
        this.joinPool(p);
    }

    public void testGetKeepAliveTime() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(2, 2, 1000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertEquals((long)1L, (long)p.getKeepAliveTime(TimeUnit.SECONDS));
        this.joinPool(p);
    }

    public void testGetThreadFactory() {
        JSR166TestCase.SimpleThreadFactory tf = new JSR166TestCase.SimpleThreadFactory();
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), tf, new JSR166TestCase.NoOpREHandler());
        ThreadPoolExecutorTest.assertSame((Object)tf, (Object)p.getThreadFactory());
        this.joinPool(p);
    }

    public void testSetThreadFactory() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        JSR166TestCase.SimpleThreadFactory tf = new JSR166TestCase.SimpleThreadFactory();
        p.setThreadFactory(tf);
        ThreadPoolExecutorTest.assertSame((Object)tf, (Object)p.getThreadFactory());
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetThreadFactoryNull() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            p.setThreadFactory(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(p);
        }
    }

    public void testGetRejectedExecutionHandler() {
        JSR166TestCase.NoOpREHandler h = new JSR166TestCase.NoOpREHandler();
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), h);
        ThreadPoolExecutorTest.assertSame((Object)h, (Object)p.getRejectedExecutionHandler());
        this.joinPool(p);
    }

    public void testSetRejectedExecutionHandler() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        JSR166TestCase.NoOpREHandler h = new JSR166TestCase.NoOpREHandler();
        p.setRejectedExecutionHandler(h);
        ThreadPoolExecutorTest.assertSame((Object)h, (Object)p.getRejectedExecutionHandler());
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetRejectedExecutionHandlerNull() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            p.setRejectedExecutionHandler(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetLargestPoolSize() throws InterruptedException {
        int THREADS = 3;
        final ThreadPoolExecutor p = new ThreadPoolExecutor(3, 3, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        final CountDownLatch threadsStarted = new CountDownLatch(3);
        final CountDownLatch done = new CountDownLatch(1);
        try {
            ThreadPoolExecutorTest.assertEquals((int)0, (int)p.getLargestPoolSize());
            for (int i = 0; i < 3; ++i) {
                p.execute(new JSR166TestCase.CheckedRunnable(){

                    @Override
                    public void realRun() throws InterruptedException {
                        threadsStarted.countDown();
                        done.await();
                        Assert.assertEquals((int)3, (int)p.getLargestPoolSize());
                    }
                });
            }
            ThreadPoolExecutorTest.assertTrue((boolean)threadsStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ThreadPoolExecutorTest.assertEquals((int)3, (int)p.getLargestPoolSize());
        }
        finally {
            done.countDown();
            this.joinPool(p);
            ThreadPoolExecutorTest.assertEquals((int)3, (int)p.getLargestPoolSize());
        }
    }

    public void testGetMaximumPoolSize() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(2, 3, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertEquals((int)3, (int)p.getMaximumPoolSize());
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetPoolSize() throws InterruptedException {
        final ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final CountDownLatch done = new CountDownLatch(1);
        try {
            ThreadPoolExecutorTest.assertEquals((int)0, (int)p.getPoolSize());
            p.execute(new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() throws InterruptedException {
                    threadStarted.countDown();
                    Assert.assertEquals((int)1, (int)p.getPoolSize());
                    done.await();
                }
            });
            ThreadPoolExecutorTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ThreadPoolExecutorTest.assertEquals((int)1, (int)p.getPoolSize());
        }
        finally {
            done.countDown();
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetTaskCount() throws InterruptedException {
        final ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final CountDownLatch done = new CountDownLatch(1);
        try {
            ThreadPoolExecutorTest.assertEquals((long)0L, (long)p.getTaskCount());
            p.execute(new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() throws InterruptedException {
                    threadStarted.countDown();
                    Assert.assertEquals((long)1L, (long)p.getTaskCount());
                    done.await();
                }
            });
            ThreadPoolExecutorTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ThreadPoolExecutorTest.assertEquals((long)1L, (long)p.getTaskCount());
        }
        finally {
            done.countDown();
            this.joinPool(p);
        }
    }

    public void testIsShutdown() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertFalse((boolean)p.isShutdown());
        try {
            p.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        ThreadPoolExecutorTest.assertTrue((boolean)p.isShutdown());
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsTerminated() throws InterruptedException {
        final ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final CountDownLatch done = new CountDownLatch(1);
        ThreadPoolExecutorTest.assertFalse((boolean)p.isTerminated());
        try {
            p.execute(new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() throws InterruptedException {
                    Assert.assertFalse((boolean)p.isTerminated());
                    threadStarted.countDown();
                    done.await();
                }
            });
            ThreadPoolExecutorTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ThreadPoolExecutorTest.assertFalse((boolean)p.isTerminating());
            done.countDown();
        }
        finally {
            try {
                p.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        ThreadPoolExecutorTest.assertTrue((boolean)p.awaitTermination(LONG_DELAY_MS, TimeUnit.MILLISECONDS));
        ThreadPoolExecutorTest.assertTrue((boolean)p.isTerminated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsTerminating() throws InterruptedException {
        final ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final CountDownLatch done = new CountDownLatch(1);
        try {
            ThreadPoolExecutorTest.assertFalse((boolean)p.isTerminating());
            p.execute(new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() throws InterruptedException {
                    Assert.assertFalse((boolean)p.isTerminating());
                    threadStarted.countDown();
                    done.await();
                }
            });
            ThreadPoolExecutorTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ThreadPoolExecutorTest.assertFalse((boolean)p.isTerminating());
            done.countDown();
        }
        finally {
            try {
                p.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        ThreadPoolExecutorTest.assertTrue((boolean)p.awaitTermination(LONG_DELAY_MS, TimeUnit.MILLISECONDS));
        ThreadPoolExecutorTest.assertTrue((boolean)p.isTerminated());
        ThreadPoolExecutorTest.assertFalse((boolean)p.isTerminating());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetQueue() throws InterruptedException {
        final ArrayBlockingQueue<Runnable> q = new ArrayBlockingQueue<Runnable>(10);
        final ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, q);
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final CountDownLatch done = new CountDownLatch(1);
        try {
            FutureTask[] tasks = new FutureTask[5];
            for (int i = 0; i < tasks.length; ++i) {
                JSR166TestCase.CheckedCallable<Boolean> task = new JSR166TestCase.CheckedCallable<Boolean>(){

                    @Override
                    public Boolean realCall() throws InterruptedException {
                        threadStarted.countDown();
                        Assert.assertSame((Object)q, p.getQueue());
                        done.await();
                        return Boolean.TRUE;
                    }
                };
                tasks[i] = new FutureTask<Boolean>(task);
                p.execute(tasks[i]);
            }
            ThreadPoolExecutorTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ThreadPoolExecutorTest.assertSame(q, p.getQueue());
            ThreadPoolExecutorTest.assertFalse((boolean)q.contains(tasks[0]));
            ThreadPoolExecutorTest.assertTrue((boolean)q.contains(tasks[tasks.length - 1]));
            ThreadPoolExecutorTest.assertEquals((int)(tasks.length - 1), (int)q.size());
        }
        finally {
            done.countDown();
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemove() throws InterruptedException {
        ArrayBlockingQueue<Runnable> q = new ArrayBlockingQueue<Runnable>(10);
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, q);
        Runnable[] tasks = new Runnable[5];
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final CountDownLatch done = new CountDownLatch(1);
        try {
            for (int i = 0; i < tasks.length; ++i) {
                tasks[i] = new JSR166TestCase.CheckedRunnable(){

                    @Override
                    public void realRun() throws InterruptedException {
                        threadStarted.countDown();
                        done.await();
                    }
                };
                p.execute(tasks[i]);
            }
            ThreadPoolExecutorTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ThreadPoolExecutorTest.assertFalse((boolean)p.remove(tasks[0]));
            ThreadPoolExecutorTest.assertTrue((boolean)q.contains(tasks[4]));
            ThreadPoolExecutorTest.assertTrue((boolean)q.contains(tasks[3]));
            ThreadPoolExecutorTest.assertTrue((boolean)p.remove(tasks[4]));
            ThreadPoolExecutorTest.assertFalse((boolean)p.remove(tasks[4]));
            ThreadPoolExecutorTest.assertFalse((boolean)q.contains(tasks[4]));
            ThreadPoolExecutorTest.assertTrue((boolean)q.contains(tasks[3]));
            ThreadPoolExecutorTest.assertTrue((boolean)p.remove(tasks[3]));
            ThreadPoolExecutorTest.assertFalse((boolean)q.contains(tasks[3]));
        }
        finally {
            done.countDown();
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPurge() throws InterruptedException {
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final CountDownLatch done = new CountDownLatch(1);
        ArrayBlockingQueue<Runnable> q = new ArrayBlockingQueue<Runnable>(10);
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, q);
        FutureTask[] tasks = new FutureTask[5];
        try {
            for (int i = 0; i < tasks.length; ++i) {
                JSR166TestCase.CheckedCallable<Boolean> task = new JSR166TestCase.CheckedCallable<Boolean>(){

                    @Override
                    public Boolean realCall() throws InterruptedException {
                        threadStarted.countDown();
                        done.await();
                        return Boolean.TRUE;
                    }
                };
                tasks[i] = new FutureTask<Boolean>(task);
                p.execute(tasks[i]);
            }
            ThreadPoolExecutorTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            ThreadPoolExecutorTest.assertEquals((long)tasks.length, (long)p.getTaskCount());
            ThreadPoolExecutorTest.assertEquals((int)(tasks.length - 1), (int)q.size());
            ThreadPoolExecutorTest.assertEquals((long)1L, (long)p.getActiveCount());
            ThreadPoolExecutorTest.assertEquals((long)0L, (long)p.getCompletedTaskCount());
            tasks[4].cancel(true);
            tasks[3].cancel(false);
            p.purge();
            ThreadPoolExecutorTest.assertEquals((int)(tasks.length - 3), (int)q.size());
            ThreadPoolExecutorTest.assertEquals((long)(tasks.length - 2), (long)p.getTaskCount());
            p.purge();
            ThreadPoolExecutorTest.assertEquals((int)(tasks.length - 3), (int)q.size());
            ThreadPoolExecutorTest.assertEquals((long)(tasks.length - 2), (long)p.getTaskCount());
        }
        finally {
            done.countDown();
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShutdownNow() {
        List<Runnable> l;
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            for (int i = 0; i < 5; ++i) {
                p.execute(new JSR166TestCase.MediumPossiblyInterruptedRunnable());
            }
        }
        finally {
            try {
                l = p.shutdownNow();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        ThreadPoolExecutorTest.assertTrue((boolean)p.isShutdown());
        ThreadPoolExecutorTest.assertTrue((l.size() <= 4 ? 1 : 0) != 0);
    }

    public void testConstructor1() {
        try {
            new ThreadPoolExecutor(-1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor2() {
        try {
            new ThreadPoolExecutor(1, -1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor3() {
        try {
            new ThreadPoolExecutor(1, 0, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor4() {
        try {
            new ThreadPoolExecutor(1, 2, -1L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor5() {
        try {
            new ThreadPoolExecutor(2, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException() {
        try {
            new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor6() {
        try {
            new ThreadPoolExecutor(-1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor7() {
        try {
            new ThreadPoolExecutor(1, -1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor8() {
        try {
            new ThreadPoolExecutor(1, 0, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor9() {
        try {
            new ThreadPoolExecutor(1, 2, -1L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor10() {
        try {
            new ThreadPoolExecutor(2, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException2() {
        try {
            new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)null, new JSR166TestCase.SimpleThreadFactory());
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException3() {
        try {
            new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), (ThreadFactory)null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor11() {
        try {
            new ThreadPoolExecutor(-1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor12() {
        try {
            new ThreadPoolExecutor(1, -1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor13() {
        try {
            new ThreadPoolExecutor(1, 0, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor14() {
        try {
            new ThreadPoolExecutor(1, 2, -1L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor15() {
        try {
            new ThreadPoolExecutor(2, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException4() {
        try {
            new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)null, new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException5() {
        try {
            new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), (RejectedExecutionHandler)null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor16() {
        try {
            new ThreadPoolExecutor(-1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory(), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor17() {
        try {
            new ThreadPoolExecutor(1, -1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory(), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor18() {
        try {
            new ThreadPoolExecutor(1, 0, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory(), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor19() {
        try {
            new ThreadPoolExecutor(1, 2, -1L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory(), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructor20() {
        try {
            new ThreadPoolExecutor(2, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory(), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException6() {
        try {
            new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, null, new JSR166TestCase.SimpleThreadFactory(), new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException7() {
        try {
            new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new JSR166TestCase.SimpleThreadFactory(), null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructorNullPointerException8() {
        try {
            new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), null, new JSR166TestCase.NoOpREHandler());
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInterruptedSubmit() throws InterruptedException {
        final ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
        final CountDownLatch threadStarted = new CountDownLatch(1);
        final CountDownLatch done = new CountDownLatch(1);
        try {
            Thread t = this.newStartedThread(new JSR166TestCase.CheckedInterruptedRunnable(){

                @Override
                public void realRun() throws Exception {
                    JSR166TestCase.CheckedCallable<Boolean> task = new JSR166TestCase.CheckedCallable<Boolean>(){

                        @Override
                        public Boolean realCall() throws InterruptedException {
                            threadStarted.countDown();
                            done.await();
                            return Boolean.TRUE;
                        }
                    };
                    p.submit(task).get();
                }
            });
            ThreadPoolExecutorTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            t.interrupt();
            this.awaitTermination(t, MEDIUM_DELAY_MS);
        }
        finally {
            done.countDown();
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaturatedExecute() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1));
        final CountDownLatch done = new CountDownLatch(1);
        try {
            int i;
            JSR166TestCase.CheckedRunnable task = new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() throws InterruptedException {
                    done.await();
                }
            };
            for (i = 0; i < 2; ++i) {
                p.execute(task);
            }
            for (i = 0; i < 2; ++i) {
                try {
                    p.execute(task);
                    this.shouldThrow();
                }
                catch (RejectedExecutionException success) {
                    // empty catch block
                }
                ThreadPoolExecutorTest.assertTrue((p.getTaskCount() <= 2L ? 1 : 0) != 0);
            }
        }
        finally {
            done.countDown();
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaturatedSubmitRunnable() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1));
        final CountDownLatch done = new CountDownLatch(1);
        try {
            int i;
            JSR166TestCase.CheckedRunnable task = new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() throws InterruptedException {
                    done.await();
                }
            };
            for (i = 0; i < 2; ++i) {
                p.submit(task);
            }
            for (i = 0; i < 2; ++i) {
                try {
                    p.execute(task);
                    this.shouldThrow();
                }
                catch (RejectedExecutionException success) {
                    // empty catch block
                }
                ThreadPoolExecutorTest.assertTrue((p.getTaskCount() <= 2L ? 1 : 0) != 0);
            }
        }
        finally {
            done.countDown();
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaturatedSubmitCallable() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1));
        final CountDownLatch done = new CountDownLatch(1);
        try {
            int i;
            JSR166TestCase.CheckedRunnable task = new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() throws InterruptedException {
                    done.await();
                }
            };
            for (i = 0; i < 2; ++i) {
                p.submit(Executors.callable(task));
            }
            for (i = 0; i < 2; ++i) {
                try {
                    p.execute(task);
                    this.shouldThrow();
                }
                catch (RejectedExecutionException success) {
                    // empty catch block
                }
                ThreadPoolExecutorTest.assertTrue((p.getTaskCount() <= 2L ? 1 : 0) != 0);
            }
        }
        finally {
            done.countDown();
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaturatedExecute2() {
        ThreadPoolExecutor.CallerRunsPolicy h = new ThreadPoolExecutor.CallerRunsPolicy();
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), h);
        try {
            int i;
            JSR166TestCase.TrackedNoOpRunnable[] tasks = new JSR166TestCase.TrackedNoOpRunnable[5];
            for (int i2 = 0; i2 < tasks.length; ++i2) {
                tasks[i2] = new JSR166TestCase.TrackedNoOpRunnable();
            }
            JSR166TestCase.TrackedLongRunnable mr = new JSR166TestCase.TrackedLongRunnable();
            p.execute(mr);
            for (i = 0; i < tasks.length; ++i) {
                p.execute(tasks[i]);
            }
            for (i = 1; i < tasks.length; ++i) {
                ThreadPoolExecutorTest.assertTrue((boolean)tasks[i].done);
            }
            try {
                p.shutdownNow();
            }
            catch (SecurityException ok) {
                this.joinPool(p);
                return;
            }
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaturatedExecute3() {
        ThreadPoolExecutor.DiscardPolicy h = new ThreadPoolExecutor.DiscardPolicy();
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), h);
        try {
            JSR166TestCase.TrackedNoOpRunnable[] tasks = new JSR166TestCase.TrackedNoOpRunnable[5];
            for (int i = 0; i < tasks.length; ++i) {
                tasks[i] = new JSR166TestCase.TrackedNoOpRunnable();
            }
            p.execute(new JSR166TestCase.TrackedLongRunnable());
            for (JSR166TestCase.TrackedNoOpRunnable task : tasks) {
                p.execute(task);
            }
            for (JSR166TestCase.TrackedNoOpRunnable task : tasks) {
                ThreadPoolExecutorTest.assertFalse((boolean)task.done);
            }
            try {
                p.shutdownNow();
            }
            catch (SecurityException ok) {
                this.joinPool(p);
                return;
            }
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaturatedExecute4() {
        ThreadPoolExecutor.DiscardOldestPolicy h = new ThreadPoolExecutor.DiscardOldestPolicy();
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), h);
        try {
            p.execute(new JSR166TestCase.TrackedLongRunnable());
            JSR166TestCase.TrackedLongRunnable r2 = new JSR166TestCase.TrackedLongRunnable();
            p.execute(r2);
            ThreadPoolExecutorTest.assertTrue((boolean)p.getQueue().contains(r2));
            JSR166TestCase.TrackedNoOpRunnable r3 = new JSR166TestCase.TrackedNoOpRunnable();
            p.execute(r3);
            ThreadPoolExecutorTest.assertFalse((boolean)p.getQueue().contains(r2));
            ThreadPoolExecutorTest.assertTrue((boolean)p.getQueue().contains(r3));
            try {
                p.shutdownNow();
            }
            catch (SecurityException ok) {
                this.joinPool(p);
                return;
            }
        }
        finally {
            this.joinPool(p);
        }
    }

    public void testRejectedExecutionExceptionOnShutdown() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1));
        try {
            p.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        try {
            p.execute(new JSR166TestCase.NoOpRunnable());
            this.shouldThrow();
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCallerRunsOnShutdown() {
        ThreadPoolExecutor.CallerRunsPolicy h = new ThreadPoolExecutor.CallerRunsPolicy();
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), h);
        try {
            p.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        try {
            JSR166TestCase.TrackedNoOpRunnable r = new JSR166TestCase.TrackedNoOpRunnable();
            p.execute(r);
            ThreadPoolExecutorTest.assertFalse((boolean)r.done);
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiscardOnShutdown() {
        ThreadPoolExecutor.DiscardPolicy h = new ThreadPoolExecutor.DiscardPolicy();
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), h);
        try {
            p.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        try {
            JSR166TestCase.TrackedNoOpRunnable r = new JSR166TestCase.TrackedNoOpRunnable();
            p.execute(r);
            ThreadPoolExecutorTest.assertFalse((boolean)r.done);
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiscardOldestOnShutdown() {
        ThreadPoolExecutor.DiscardOldestPolicy h = new ThreadPoolExecutor.DiscardOldestPolicy();
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 1, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), h);
        try {
            p.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        try {
            JSR166TestCase.TrackedNoOpRunnable r = new JSR166TestCase.TrackedNoOpRunnable();
            p.execute(r);
            ThreadPoolExecutorTest.assertFalse((boolean)r.done);
        }
        finally {
            this.joinPool(p);
        }
    }

    public void testExecuteNull() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            p.execute(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCorePoolSizeIllegalArgumentException() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            p.setCorePoolSize(-1);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            try {
                p.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        finally {
            try {
                p.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMaximumPoolSizeIllegalArgumentException() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(2, 3, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            p.setMaximumPoolSize(1);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            try {
                p.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        finally {
            try {
                p.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMaximumPoolSizeIllegalArgumentException2() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(2, 3, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            p.setMaximumPoolSize(-1);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            try {
                p.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        finally {
            try {
                p.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testKeepAliveTimeIllegalArgumentException() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(2, 3, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            p.setKeepAliveTime(-1L, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (IllegalArgumentException success) {
            try {
                p.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        finally {
            try {
                p.shutdown();
            }
            catch (SecurityException ok) {
                return;
            }
        }
        this.joinPool(p);
    }

    public void testTerminated() {
        ExtendedTPE p = new ExtendedTPE();
        try {
            p.shutdown();
        }
        catch (SecurityException ok) {
            return;
        }
        ThreadPoolExecutorTest.assertTrue((boolean)p.terminatedCalled);
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBeforeAfter() throws InterruptedException {
        ExtendedTPE p = new ExtendedTPE();
        try {
            JSR166TestCase.TrackedNoOpRunnable r = new JSR166TestCase.TrackedNoOpRunnable();
            p.execute(r);
            ThreadPoolExecutorTest.delay(SHORT_DELAY_MS);
            ThreadPoolExecutorTest.assertTrue((boolean)r.done);
            ThreadPoolExecutorTest.assertTrue((boolean)p.beforeCalled);
            ThreadPoolExecutorTest.assertTrue((boolean)p.afterCalled);
            try {
                p.shutdown();
            }
            catch (SecurityException ok) {
                this.joinPool(p);
                return;
            }
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitCallable() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            Future<String> future = e.submit(new JSR166TestCase.StringTask());
            String result = future.get();
            ThreadPoolExecutorTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitRunnable() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            Future<?> future = e.submit(new JSR166TestCase.NoOpRunnable());
            future.get();
            ThreadPoolExecutorTest.assertTrue((boolean)future.isDone());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubmitRunnable2() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            Future<String> future = e.submit(new JSR166TestCase.NoOpRunnable(), "a test string");
            String result = future.get();
            ThreadPoolExecutorTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny1() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            e.invokeAny(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny2() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            e.invokeAny(new ArrayList());
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny3() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
        l.add(this.latchAwaitingStringTask(latch));
        l.add(null);
        try {
            e.invokeAny(l);
            this.shouldThrow();
        }
        catch (NullPointerException success) {
        }
        finally {
            latch.countDown();
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny4() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        try {
            e.invokeAny(l);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ThreadPoolExecutorTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAny5() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            String result = (String)e.invokeAny(l);
            ThreadPoolExecutorTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll1() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            e.invokeAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll2() throws InterruptedException {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            List r = e.invokeAll(new ArrayList());
            ThreadPoolExecutorTest.assertTrue((boolean)r.isEmpty());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll3() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        l.add(null);
        try {
            e.invokeAll(l);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll4() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
            l.add(new JSR166TestCase.NPETask());
            List futures = e.invokeAll(l);
            ThreadPoolExecutorTest.assertEquals((int)1, (int)futures.size());
            try {
                futures.get(0).get();
                this.shouldThrow();
            }
            catch (ExecutionException success) {
                ThreadPoolExecutorTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeAll5() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l);
            ThreadPoolExecutorTest.assertEquals((int)2, (int)futures.size());
            for (Future future : futures) {
                ThreadPoolExecutorTest.assertSame((Object)"a test string", future.get());
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny1() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            e.invokeAny(null, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAnyNullTimeUnit() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny2() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            e.invokeAny(new ArrayList(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny3() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
        l.add(this.latchAwaitingStringTask(latch));
        l.add(null);
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException success) {
        }
        finally {
            latch.countDown();
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny4() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        try {
            e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ThreadPoolExecutorTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAny5() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            String result = (String)e.invokeAny(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ThreadPoolExecutorTest.assertSame((Object)"a test string", (Object)result);
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll1() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            e.invokeAll(null, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAllNullTimeUnit() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        try {
            e.invokeAll(l, MEDIUM_DELAY_MS, null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll2() throws InterruptedException {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            List r = e.invokeAll(new ArrayList(), MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ThreadPoolExecutorTest.assertTrue((boolean)r.isEmpty());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll3() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
        l.add(new JSR166TestCase.StringTask());
        l.add(null);
        try {
            e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll4() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ArrayList<JSR166TestCase.NPETask> l = new ArrayList<JSR166TestCase.NPETask>();
        l.add(new JSR166TestCase.NPETask());
        List futures = e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
        ThreadPoolExecutorTest.assertEquals((int)1, (int)futures.size());
        try {
            futures.get(0).get();
            this.shouldThrow();
        }
        catch (ExecutionException success) {
            ThreadPoolExecutorTest.assertTrue((boolean)(success.getCause() instanceof NullPointerException));
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll5() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            ArrayList<JSR166TestCase.StringTask> l = new ArrayList<JSR166TestCase.StringTask>();
            l.add(new JSR166TestCase.StringTask());
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l, MEDIUM_DELAY_MS, TimeUnit.MILLISECONDS);
            ThreadPoolExecutorTest.assertEquals((int)2, (int)futures.size());
            for (Future future : futures) {
                ThreadPoolExecutorTest.assertSame((Object)"a test string", future.get());
            }
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTimedInvokeAll6() throws Exception {
        ThreadPoolExecutor e = new ThreadPoolExecutor(2, 2, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        try {
            ArrayList<Callable<String>> l = new ArrayList<Callable<String>>();
            l.add(new JSR166TestCase.StringTask());
            l.add(Executors.callable(new JSR166TestCase.MediumPossiblyInterruptedRunnable(), "a test string"));
            l.add(new JSR166TestCase.StringTask());
            List futures = e.invokeAll(l, SHORT_DELAY_MS, TimeUnit.MILLISECONDS);
            ThreadPoolExecutorTest.assertEquals((int)3, (int)futures.size());
            Iterator it = futures.iterator();
            Future f1 = it.next();
            Future f2 = it.next();
            Future f3 = it.next();
            ThreadPoolExecutorTest.assertTrue((boolean)f1.isDone());
            ThreadPoolExecutorTest.assertTrue((boolean)f2.isDone());
            ThreadPoolExecutorTest.assertTrue((boolean)f3.isDone());
            ThreadPoolExecutorTest.assertFalse((boolean)f1.isCancelled());
            ThreadPoolExecutorTest.assertTrue((boolean)f2.isCancelled());
        }
        finally {
            this.joinPool(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailingThreadFactory() throws InterruptedException {
        ThreadPoolExecutor e = new ThreadPoolExecutor(100, 100, LONG_DELAY_MS, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new FailingThreadFactory());
        try {
            int TASKS = 100;
            final CountDownLatch done = new CountDownLatch(100);
            for (int k = 0; k < 100; ++k) {
                e.execute(new JSR166TestCase.CheckedRunnable(){

                    @Override
                    public void realRun() {
                        done.countDown();
                    }
                });
            }
            ThreadPoolExecutorTest.assertTrue((boolean)done.await(LONG_DELAY_MS, TimeUnit.MILLISECONDS));
        }
        finally {
            this.joinPool(e);
        }
    }

    public void testAllowsCoreThreadTimeOut() {
        ThreadPoolExecutor p = new ThreadPoolExecutor(2, 2, 1000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        ThreadPoolExecutorTest.assertFalse((boolean)p.allowsCoreThreadTimeOut());
        this.joinPool(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllowCoreThreadTimeOut_true() throws Exception {
        final ThreadPoolExecutor p = new ThreadPoolExecutor(2, 10, SHORT_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        final CountDownLatch threadStarted = new CountDownLatch(1);
        try {
            p.allowCoreThreadTimeOut(true);
            p.execute(new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() throws InterruptedException {
                    threadStarted.countDown();
                    Assert.assertEquals((int)1, (int)p.getPoolSize());
                }
            });
            ThreadPoolExecutorTest.assertTrue((boolean)threadStarted.await(SMALL_DELAY_MS, TimeUnit.MILLISECONDS));
            int i = 0;
            while ((long)i < MEDIUM_DELAY_MS / 10L && p.getPoolSize() != 0) {
                ThreadPoolExecutorTest.delay(10L);
                ++i;
            }
            ThreadPoolExecutorTest.assertEquals((int)0, (int)p.getPoolSize());
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllowCoreThreadTimeOut_false() throws Exception {
        final ThreadPoolExecutor p = new ThreadPoolExecutor(2, 10, SHORT_DELAY_MS, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10));
        final CountDownLatch threadStarted = new CountDownLatch(1);
        try {
            p.allowCoreThreadTimeOut(false);
            p.execute(new JSR166TestCase.CheckedRunnable(){

                @Override
                public void realRun() throws InterruptedException {
                    threadStarted.countDown();
                    Assert.assertTrue((p.getPoolSize() >= 1 ? 1 : 0) != 0);
                }
            });
            ThreadPoolExecutorTest.delay(SMALL_DELAY_MS);
            ThreadPoolExecutorTest.assertTrue((p.getPoolSize() >= 1 ? 1 : 0) != 0);
        }
        finally {
            this.joinPool(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRejectedRecycledTask() throws InterruptedException {
        int nTasks = 1000;
        final CountDownLatch done = new CountDownLatch(1000);
        Runnable recycledTask = new Runnable(){

            @Override
            public void run() {
                done.countDown();
            }
        };
        ThreadPoolExecutor p = new ThreadPoolExecutor(1, 30, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(30));
        try {
            block5: for (int i = 0; i < 1000; ++i) {
                while (true) {
                    try {
                        p.execute(recycledTask);
                        continue block5;
                    }
                    catch (RejectedExecutionException ignore) {
                        continue;
                    }
                    break;
                }
            }
            ThreadPoolExecutorTest.assertTrue((boolean)done.await(1000L * SHORT_DELAY_MS, TimeUnit.MILLISECONDS));
        }
        finally {
            p.shutdown();
        }
    }

    static class FailingThreadFactory
    implements ThreadFactory {
        int calls = 0;

        FailingThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            if (++this.calls > 1) {
                return null;
            }
            return new Thread(r);
        }
    }

    static class ExtendedTPE
    extends ThreadPoolExecutor {
        volatile boolean beforeCalled = false;
        volatile boolean afterCalled = false;
        volatile boolean terminatedCalled = false;

        public ExtendedTPE() {
            super(1, 1, JSR166TestCase.LONG_DELAY_MS, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            this.beforeCalled = true;
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            this.afterCalled = true;
        }

        @Override
        protected void terminated() {
            this.terminatedCalled = true;
        }
    }
}

