/*
 * Decompiled with CFR 0.152.
 */
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ThreadTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)ThreadTest.suite());
    }

    public static Test suite() {
        return new TestSuite(ThreadTest.class);
    }

    public void testGetAndSetUncaughtExceptionHandler() {
        Thread current = Thread.currentThread();
        ThreadGroup tg = current.getThreadGroup();
        MyHandler eh = new MyHandler();
        ThreadTest.assertEquals((Object)tg, (Object)current.getUncaughtExceptionHandler());
        current.setUncaughtExceptionHandler(eh);
        ThreadTest.assertEquals((Object)eh, (Object)current.getUncaughtExceptionHandler());
        current.setUncaughtExceptionHandler(null);
        ThreadTest.assertEquals((Object)tg, (Object)current.getUncaughtExceptionHandler());
    }

    public void testGetAndSetDefaultUncaughtExceptionHandler() {
        ThreadTest.assertEquals(null, (Object)Thread.getDefaultUncaughtExceptionHandler());
        try {
            Thread current = Thread.currentThread();
            ThreadGroup tg = current.getThreadGroup();
            MyHandler eh = new MyHandler();
            Thread.setDefaultUncaughtExceptionHandler(eh);
            ThreadTest.assertEquals((Object)eh, (Object)Thread.getDefaultUncaughtExceptionHandler());
            Thread.setDefaultUncaughtExceptionHandler(null);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        ThreadTest.assertEquals(null, (Object)Thread.getDefaultUncaughtExceptionHandler());
    }

    static class MyHandler
    implements Thread.UncaughtExceptionHandler {
        MyHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            e.printStackTrace();
        }
    }
}

