/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TreeMapTest
extends JSR166TestCase {
    Random rnd = new Random(666L);
    BitSet bs;

    public static void main(String[] args) {
        TestRunner.run((Test)TreeMapTest.suite());
    }

    public static Test suite() {
        return new TestSuite(TreeMapTest.class);
    }

    private static TreeMap map5() {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        TreeMapTest.assertTrue((boolean)map.isEmpty());
        map.put(one, "A");
        map.put(five, "E");
        map.put(three, "C");
        map.put(two, "B");
        map.put(four, "D");
        TreeMapTest.assertFalse((boolean)map.isEmpty());
        TreeMapTest.assertEquals((int)5, (int)map.size());
        return map;
    }

    public void testClear() {
        TreeMap map = TreeMapTest.map5();
        map.clear();
        TreeMapTest.assertEquals((int)map.size(), (int)0);
    }

    public void testConstructFromSorted() {
        TreeMap map = TreeMapTest.map5();
        TreeMap map2 = new TreeMap(map);
        TreeMapTest.assertEquals((Object)map, map2);
    }

    public void testEquals() {
        TreeMap map1 = TreeMapTest.map5();
        TreeMap map2 = TreeMapTest.map5();
        TreeMapTest.assertEquals((Object)map1, (Object)map2);
        TreeMapTest.assertEquals((Object)map2, (Object)map1);
        map1.clear();
        TreeMapTest.assertFalse((boolean)map1.equals(map2));
        TreeMapTest.assertFalse((boolean)map2.equals(map1));
    }

    public void testContainsKey() {
        TreeMap map = TreeMapTest.map5();
        TreeMapTest.assertTrue((boolean)map.containsKey(one));
        TreeMapTest.assertFalse((boolean)map.containsKey(zero));
    }

    public void testContainsValue() {
        TreeMap map = TreeMapTest.map5();
        TreeMapTest.assertTrue((boolean)map.containsValue("A"));
        TreeMapTest.assertFalse((boolean)map.containsValue("Z"));
    }

    public void testGet() {
        TreeMap map = TreeMapTest.map5();
        TreeMapTest.assertEquals((String)"A", (String)((String)map.get(one)));
        TreeMap empty = new TreeMap();
        TreeMapTest.assertNull(empty.get(one));
    }

    public void testIsEmpty() {
        TreeMap empty = new TreeMap();
        TreeMap map = TreeMapTest.map5();
        TreeMapTest.assertTrue((boolean)empty.isEmpty());
        TreeMapTest.assertFalse((boolean)map.isEmpty());
    }

    public void testFirstKey() {
        TreeMap map = TreeMapTest.map5();
        TreeMapTest.assertEquals((Object)one, map.firstKey());
    }

    public void testLastKey() {
        TreeMap map = TreeMapTest.map5();
        TreeMapTest.assertEquals((Object)five, map.lastKey());
    }

    public void testKeySetToArray() {
        TreeMap map = TreeMapTest.map5();
        Set s = map.keySet();
        Object[] ar = s.toArray();
        TreeMapTest.assertTrue((boolean)s.containsAll(Arrays.asList(ar)));
        TreeMapTest.assertEquals((int)5, (int)ar.length);
        ar[0] = m10;
        TreeMapTest.assertFalse((boolean)s.containsAll(Arrays.asList(ar)));
    }

    public void testDescendingKeySetToArray() {
        TreeMap map = TreeMapTest.map5();
        NavigableSet s = map.descendingKeySet();
        Object[] ar = s.toArray();
        TreeMapTest.assertEquals((int)5, (int)ar.length);
        TreeMapTest.assertTrue((boolean)s.containsAll(Arrays.asList(ar)));
        ar[0] = m10;
        TreeMapTest.assertFalse((boolean)s.containsAll(Arrays.asList(ar)));
    }

    public void testKeySet() {
        TreeMap map = TreeMapTest.map5();
        Set s = map.keySet();
        TreeMapTest.assertEquals((int)5, (int)s.size());
        TreeMapTest.assertTrue((boolean)s.contains(one));
        TreeMapTest.assertTrue((boolean)s.contains(two));
        TreeMapTest.assertTrue((boolean)s.contains(three));
        TreeMapTest.assertTrue((boolean)s.contains(four));
        TreeMapTest.assertTrue((boolean)s.contains(five));
    }

    public void testKeySetOrder() {
        TreeMap map = TreeMapTest.map5();
        Set s = map.keySet();
        Iterator i = s.iterator();
        Integer last = (Integer)i.next();
        TreeMapTest.assertEquals((Object)last, (Object)one);
        int count = 1;
        while (i.hasNext()) {
            Integer k = (Integer)i.next();
            TreeMapTest.assertTrue((last.compareTo(k) < 0 ? 1 : 0) != 0);
            last = k;
            ++count;
        }
        TreeMapTest.assertEquals((int)count, (int)5);
    }

    public void testKeySetDescendingIteratorOrder() {
        TreeMap map = TreeMapTest.map5();
        NavigableSet s = map.navigableKeySet();
        Iterator i = s.descendingIterator();
        Integer last = (Integer)i.next();
        TreeMapTest.assertEquals((Object)last, (Object)five);
        int count = 1;
        while (i.hasNext()) {
            Integer k = (Integer)i.next();
            TreeMapTest.assertTrue((last.compareTo(k) > 0 ? 1 : 0) != 0);
            last = k;
            ++count;
        }
        TreeMapTest.assertEquals((int)count, (int)5);
    }

    public void testDescendingKeySetOrder() {
        TreeMap map = TreeMapTest.map5();
        NavigableSet s = map.descendingKeySet();
        Iterator i = s.iterator();
        Integer last = (Integer)i.next();
        TreeMapTest.assertEquals((Object)last, (Object)five);
        int count = 1;
        while (i.hasNext()) {
            Integer k = (Integer)i.next();
            TreeMapTest.assertTrue((last.compareTo(k) > 0 ? 1 : 0) != 0);
            last = k;
            ++count;
        }
        TreeMapTest.assertEquals((int)count, (int)5);
    }

    public void testDescendingKeySetDescendingIteratorOrder() {
        TreeMap map = TreeMapTest.map5();
        NavigableSet s = map.descendingKeySet();
        Iterator i = s.descendingIterator();
        Integer last = (Integer)i.next();
        TreeMapTest.assertEquals((Object)last, (Object)one);
        int count = 1;
        while (i.hasNext()) {
            Integer k = (Integer)i.next();
            TreeMapTest.assertTrue((last.compareTo(k) < 0 ? 1 : 0) != 0);
            last = k;
            ++count;
        }
        TreeMapTest.assertEquals((int)count, (int)5);
    }

    public void testValues() {
        TreeMap map = TreeMapTest.map5();
        Collection s = map.values();
        TreeMapTest.assertEquals((int)5, (int)s.size());
        TreeMapTest.assertTrue((boolean)s.contains("A"));
        TreeMapTest.assertTrue((boolean)s.contains("B"));
        TreeMapTest.assertTrue((boolean)s.contains("C"));
        TreeMapTest.assertTrue((boolean)s.contains("D"));
        TreeMapTest.assertTrue((boolean)s.contains("E"));
    }

    public void testEntrySet() {
        TreeMap map = TreeMapTest.map5();
        Set s = map.entrySet();
        TreeMapTest.assertEquals((int)5, (int)s.size());
        for (Map.Entry e : s) {
            TreeMapTest.assertTrue((e.getKey().equals(one) && e.getValue().equals("A") || e.getKey().equals(two) && e.getValue().equals("B") || e.getKey().equals(three) && e.getValue().equals("C") || e.getKey().equals(four) && e.getValue().equals("D") || e.getKey().equals(five) && e.getValue().equals("E") ? 1 : 0) != 0);
        }
    }

    public void testDescendingEntrySet() {
        TreeMap map = TreeMapTest.map5();
        Set s = map.descendingMap().entrySet();
        TreeMapTest.assertEquals((int)5, (int)s.size());
        for (Map.Entry e : s) {
            TreeMapTest.assertTrue((e.getKey().equals(one) && e.getValue().equals("A") || e.getKey().equals(two) && e.getValue().equals("B") || e.getKey().equals(three) && e.getValue().equals("C") || e.getKey().equals(four) && e.getValue().equals("D") || e.getKey().equals(five) && e.getValue().equals("E") ? 1 : 0) != 0);
        }
    }

    public void testEntrySetToArray() {
        TreeMap map = TreeMapTest.map5();
        Set s = map.entrySet();
        Object[] ar = s.toArray();
        TreeMapTest.assertEquals((int)5, (int)ar.length);
        for (int i = 0; i < 5; ++i) {
            TreeMapTest.assertTrue((boolean)map.containsKey(((Map.Entry)ar[i]).getKey()));
            TreeMapTest.assertTrue((boolean)map.containsValue(((Map.Entry)ar[i]).getValue()));
        }
    }

    public void testDescendingEntrySetToArray() {
        TreeMap map = TreeMapTest.map5();
        Set s = map.descendingMap().entrySet();
        Object[] ar = s.toArray();
        TreeMapTest.assertEquals((int)5, (int)ar.length);
        for (int i = 0; i < 5; ++i) {
            TreeMapTest.assertTrue((boolean)map.containsKey(((Map.Entry)ar[i]).getKey()));
            TreeMapTest.assertTrue((boolean)map.containsValue(((Map.Entry)ar[i]).getValue()));
        }
    }

    public void testPutAll() {
        TreeMap empty = new TreeMap();
        TreeMap map = TreeMapTest.map5();
        empty.putAll(map);
        TreeMapTest.assertEquals((int)5, (int)empty.size());
        TreeMapTest.assertTrue((boolean)empty.containsKey(one));
        TreeMapTest.assertTrue((boolean)empty.containsKey(two));
        TreeMapTest.assertTrue((boolean)empty.containsKey(three));
        TreeMapTest.assertTrue((boolean)empty.containsKey(four));
        TreeMapTest.assertTrue((boolean)empty.containsKey(five));
    }

    public void testRemove() {
        TreeMap map = TreeMapTest.map5();
        map.remove(five);
        TreeMapTest.assertEquals((int)4, (int)map.size());
        TreeMapTest.assertFalse((boolean)map.containsKey(five));
    }

    public void testLowerEntry() {
        TreeMap map = TreeMapTest.map5();
        Map.Entry e1 = map.lowerEntry(three);
        TreeMapTest.assertEquals((Object)two, (Object)e1.getKey());
        Map.Entry e2 = map.lowerEntry(six);
        TreeMapTest.assertEquals((Object)five, (Object)e2.getKey());
        Map.Entry e3 = map.lowerEntry(one);
        TreeMapTest.assertNull(e3);
        Map.Entry e4 = map.lowerEntry(zero);
        TreeMapTest.assertNull(e4);
    }

    public void testHigherEntry() {
        TreeMap map = TreeMapTest.map5();
        Map.Entry e1 = map.higherEntry(three);
        TreeMapTest.assertEquals((Object)four, (Object)e1.getKey());
        Map.Entry e2 = map.higherEntry(zero);
        TreeMapTest.assertEquals((Object)one, (Object)e2.getKey());
        Map.Entry e3 = map.higherEntry(five);
        TreeMapTest.assertNull(e3);
        Map.Entry e4 = map.higherEntry(six);
        TreeMapTest.assertNull(e4);
    }

    public void testFloorEntry() {
        TreeMap map = TreeMapTest.map5();
        Map.Entry e1 = map.floorEntry(three);
        TreeMapTest.assertEquals((Object)three, (Object)e1.getKey());
        Map.Entry e2 = map.floorEntry(six);
        TreeMapTest.assertEquals((Object)five, (Object)e2.getKey());
        Map.Entry e3 = map.floorEntry(one);
        TreeMapTest.assertEquals((Object)one, (Object)e3.getKey());
        Map.Entry e4 = map.floorEntry(zero);
        TreeMapTest.assertNull(e4);
    }

    public void testCeilingEntry() {
        TreeMap map = TreeMapTest.map5();
        Map.Entry e1 = map.ceilingEntry(three);
        TreeMapTest.assertEquals((Object)three, (Object)e1.getKey());
        Map.Entry e2 = map.ceilingEntry(zero);
        TreeMapTest.assertEquals((Object)one, (Object)e2.getKey());
        Map.Entry e3 = map.ceilingEntry(five);
        TreeMapTest.assertEquals((Object)five, (Object)e3.getKey());
        Map.Entry e4 = map.ceilingEntry(six);
        TreeMapTest.assertNull(e4);
    }

    public void testLowerKey() {
        TreeMap q = TreeMapTest.map5();
        Integer e1 = q.lowerKey(three);
        TreeMapTest.assertEquals((Object)two, (Object)e1);
        Integer e2 = q.lowerKey(six);
        TreeMapTest.assertEquals((Object)five, (Object)e2);
        Integer e3 = q.lowerKey(one);
        TreeMapTest.assertNull((Object)e3);
        Integer e4 = q.lowerKey(zero);
        TreeMapTest.assertNull((Object)e4);
    }

    public void testHigherKey() {
        TreeMap q = TreeMapTest.map5();
        Integer e1 = q.higherKey(three);
        TreeMapTest.assertEquals((Object)four, (Object)e1);
        Integer e2 = q.higherKey(zero);
        TreeMapTest.assertEquals((Object)one, (Object)e2);
        Integer e3 = q.higherKey(five);
        TreeMapTest.assertNull((Object)e3);
        Integer e4 = q.higherKey(six);
        TreeMapTest.assertNull((Object)e4);
    }

    public void testFloorKey() {
        TreeMap q = TreeMapTest.map5();
        Integer e1 = q.floorKey(three);
        TreeMapTest.assertEquals((Object)three, (Object)e1);
        Integer e2 = q.floorKey(six);
        TreeMapTest.assertEquals((Object)five, (Object)e2);
        Integer e3 = q.floorKey(one);
        TreeMapTest.assertEquals((Object)one, (Object)e3);
        Integer e4 = q.floorKey(zero);
        TreeMapTest.assertNull((Object)e4);
    }

    public void testCeilingKey() {
        TreeMap q = TreeMapTest.map5();
        Integer e1 = q.ceilingKey(three);
        TreeMapTest.assertEquals((Object)three, (Object)e1);
        Integer e2 = q.ceilingKey(zero);
        TreeMapTest.assertEquals((Object)one, (Object)e2);
        Integer e3 = q.ceilingKey(five);
        TreeMapTest.assertEquals((Object)five, (Object)e3);
        Integer e4 = q.ceilingKey(six);
        TreeMapTest.assertNull((Object)e4);
    }

    public void testPollFirstEntry() {
        TreeMap map = TreeMapTest.map5();
        Map.Entry e = map.pollFirstEntry();
        TreeMapTest.assertEquals((Object)one, e.getKey());
        TreeMapTest.assertEquals((Object)"A", e.getValue());
        e = map.pollFirstEntry();
        TreeMapTest.assertEquals((Object)two, e.getKey());
        map.put(one, "A");
        e = map.pollFirstEntry();
        TreeMapTest.assertEquals((Object)one, e.getKey());
        TreeMapTest.assertEquals((Object)"A", e.getValue());
        e = map.pollFirstEntry();
        TreeMapTest.assertEquals((Object)three, e.getKey());
        map.remove(four);
        e = map.pollFirstEntry();
        TreeMapTest.assertEquals((Object)five, e.getKey());
        try {
            e.setValue("A");
            this.shouldThrow();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        e = map.pollFirstEntry();
        TreeMapTest.assertNull(e);
    }

    public void testPollLastEntry() {
        TreeMap map = TreeMapTest.map5();
        Map.Entry e = map.pollLastEntry();
        TreeMapTest.assertEquals((Object)five, e.getKey());
        TreeMapTest.assertEquals((Object)"E", e.getValue());
        e = map.pollLastEntry();
        TreeMapTest.assertEquals((Object)four, e.getKey());
        map.put(five, "E");
        e = map.pollLastEntry();
        TreeMapTest.assertEquals((Object)five, e.getKey());
        TreeMapTest.assertEquals((Object)"E", e.getValue());
        e = map.pollLastEntry();
        TreeMapTest.assertEquals((Object)three, e.getKey());
        map.remove(two);
        e = map.pollLastEntry();
        TreeMapTest.assertEquals((Object)one, e.getKey());
        try {
            e.setValue("E");
            this.shouldThrow();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        e = map.pollLastEntry();
        TreeMapTest.assertNull(e);
    }

    public void testSize() {
        TreeMap map = TreeMapTest.map5();
        TreeMap empty = new TreeMap();
        TreeMapTest.assertEquals((int)0, (int)empty.size());
        TreeMapTest.assertEquals((int)5, (int)map.size());
    }

    public void testToString() {
        TreeMap map = TreeMapTest.map5();
        String s = map.toString();
        for (int i = 1; i <= 5; ++i) {
            TreeMapTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testGet_NullPointerException() {
        try {
            TreeMap c = TreeMapTest.map5();
            c.get(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testContainsKey_NullPointerException() {
        try {
            TreeMap c = TreeMapTest.map5();
            c.containsKey(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testRemove1_NullPointerException() {
        try {
            TreeMap<String, String> c = new TreeMap<String, String>();
            c.put("sadsdf", "asdads");
            c.remove(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testSerialization() throws Exception {
        TreeMap q = TreeMapTest.map5();
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        TreeMap r = (TreeMap)in.readObject();
        TreeMapTest.assertEquals((int)q.size(), (int)r.size());
        TreeMapTest.assertTrue((boolean)q.equals(r));
        TreeMapTest.assertTrue((boolean)r.equals(q));
    }

    public void testSubMapContents() {
        TreeMap map = TreeMapTest.map5();
        NavigableMap sm = map.subMap(two, true, four, false);
        TreeMapTest.assertEquals((Object)two, sm.firstKey());
        TreeMapTest.assertEquals((Object)three, sm.lastKey());
        TreeMapTest.assertEquals((int)2, (int)sm.size());
        TreeMapTest.assertFalse((boolean)sm.containsKey(one));
        TreeMapTest.assertTrue((boolean)sm.containsKey(two));
        TreeMapTest.assertTrue((boolean)sm.containsKey(three));
        TreeMapTest.assertFalse((boolean)sm.containsKey(four));
        TreeMapTest.assertFalse((boolean)sm.containsKey(five));
        Iterator i = sm.keySet().iterator();
        Integer k = (Integer)i.next();
        TreeMapTest.assertEquals((Object)two, (Object)k);
        k = (Integer)i.next();
        TreeMapTest.assertEquals((Object)three, (Object)k);
        TreeMapTest.assertFalse((boolean)i.hasNext());
        Iterator<Integer> r = sm.descendingKeySet().iterator();
        k = r.next();
        TreeMapTest.assertEquals((Object)three, (Object)k);
        k = r.next();
        TreeMapTest.assertEquals((Object)two, (Object)k);
        TreeMapTest.assertFalse((boolean)r.hasNext());
        Iterator j = sm.keySet().iterator();
        j.next();
        j.remove();
        TreeMapTest.assertFalse((boolean)map.containsKey(two));
        TreeMapTest.assertEquals((int)4, (int)map.size());
        TreeMapTest.assertEquals((int)1, (int)sm.size());
        TreeMapTest.assertEquals((Object)three, sm.firstKey());
        TreeMapTest.assertEquals((Object)three, sm.lastKey());
        TreeMapTest.assertEquals((Object)"C", sm.remove(three));
        TreeMapTest.assertTrue((boolean)sm.isEmpty());
        TreeMapTest.assertEquals((int)3, (int)map.size());
    }

    public void testSubMapContents2() {
        TreeMap map = TreeMapTest.map5();
        NavigableMap sm = map.subMap(two, true, three, false);
        TreeMapTest.assertEquals((int)1, (int)sm.size());
        TreeMapTest.assertEquals((Object)two, sm.firstKey());
        TreeMapTest.assertEquals((Object)two, sm.lastKey());
        TreeMapTest.assertFalse((boolean)sm.containsKey(one));
        TreeMapTest.assertTrue((boolean)sm.containsKey(two));
        TreeMapTest.assertFalse((boolean)sm.containsKey(three));
        TreeMapTest.assertFalse((boolean)sm.containsKey(four));
        TreeMapTest.assertFalse((boolean)sm.containsKey(five));
        Iterator i = sm.keySet().iterator();
        Integer k = (Integer)i.next();
        TreeMapTest.assertEquals((Object)two, (Object)k);
        TreeMapTest.assertFalse((boolean)i.hasNext());
        Iterator<Integer> r = sm.descendingKeySet().iterator();
        k = r.next();
        TreeMapTest.assertEquals((Object)two, (Object)k);
        TreeMapTest.assertFalse((boolean)r.hasNext());
        Iterator j = sm.keySet().iterator();
        j.next();
        j.remove();
        TreeMapTest.assertFalse((boolean)map.containsKey(two));
        TreeMapTest.assertEquals((int)4, (int)map.size());
        TreeMapTest.assertEquals((int)0, (int)sm.size());
        TreeMapTest.assertTrue((boolean)sm.isEmpty());
        TreeMapTest.assertSame(sm.remove(three), null);
        TreeMapTest.assertEquals((int)4, (int)map.size());
    }

    public void testHeadMapContents() {
        TreeMap map = TreeMapTest.map5();
        NavigableMap sm = map.headMap(four, false);
        TreeMapTest.assertTrue((boolean)sm.containsKey(one));
        TreeMapTest.assertTrue((boolean)sm.containsKey(two));
        TreeMapTest.assertTrue((boolean)sm.containsKey(three));
        TreeMapTest.assertFalse((boolean)sm.containsKey(four));
        TreeMapTest.assertFalse((boolean)sm.containsKey(five));
        Iterator i = sm.keySet().iterator();
        Integer k = (Integer)i.next();
        TreeMapTest.assertEquals((Object)one, (Object)k);
        k = (Integer)i.next();
        TreeMapTest.assertEquals((Object)two, (Object)k);
        k = (Integer)i.next();
        TreeMapTest.assertEquals((Object)three, (Object)k);
        TreeMapTest.assertFalse((boolean)i.hasNext());
        sm.clear();
        TreeMapTest.assertTrue((boolean)sm.isEmpty());
        TreeMapTest.assertEquals((int)2, (int)map.size());
        TreeMapTest.assertEquals((Object)four, map.firstKey());
    }

    public void testTailMapContents() {
        TreeMap map = TreeMapTest.map5();
        NavigableMap sm = map.tailMap(two, true);
        TreeMapTest.assertFalse((boolean)sm.containsKey(one));
        TreeMapTest.assertTrue((boolean)sm.containsKey(two));
        TreeMapTest.assertTrue((boolean)sm.containsKey(three));
        TreeMapTest.assertTrue((boolean)sm.containsKey(four));
        TreeMapTest.assertTrue((boolean)sm.containsKey(five));
        Iterator i = sm.keySet().iterator();
        Integer k = (Integer)i.next();
        TreeMapTest.assertEquals((Object)two, (Object)k);
        k = (Integer)i.next();
        TreeMapTest.assertEquals((Object)three, (Object)k);
        k = (Integer)i.next();
        TreeMapTest.assertEquals((Object)four, (Object)k);
        k = (Integer)i.next();
        TreeMapTest.assertEquals((Object)five, (Object)k);
        TreeMapTest.assertFalse((boolean)i.hasNext());
        Iterator<Integer> r = sm.descendingKeySet().iterator();
        k = r.next();
        TreeMapTest.assertEquals((Object)five, (Object)k);
        k = r.next();
        TreeMapTest.assertEquals((Object)four, (Object)k);
        k = r.next();
        TreeMapTest.assertEquals((Object)three, (Object)k);
        k = r.next();
        TreeMapTest.assertEquals((Object)two, (Object)k);
        TreeMapTest.assertFalse((boolean)r.hasNext());
        Iterator ei = sm.entrySet().iterator();
        Map.Entry e = ei.next();
        TreeMapTest.assertEquals((Object)two, e.getKey());
        TreeMapTest.assertEquals((Object)"B", e.getValue());
        e = ei.next();
        TreeMapTest.assertEquals((Object)three, e.getKey());
        TreeMapTest.assertEquals((Object)"C", e.getValue());
        e = ei.next();
        TreeMapTest.assertEquals((Object)four, e.getKey());
        TreeMapTest.assertEquals((Object)"D", e.getValue());
        e = ei.next();
        TreeMapTest.assertEquals((Object)five, e.getKey());
        TreeMapTest.assertEquals((Object)"E", e.getValue());
        TreeMapTest.assertFalse((boolean)i.hasNext());
        NavigableMap ssm = sm.tailMap(four, true);
        TreeMapTest.assertEquals((Object)four, ssm.firstKey());
        TreeMapTest.assertEquals((Object)five, ssm.lastKey());
        TreeMapTest.assertEquals((Object)"D", ssm.remove(four));
        TreeMapTest.assertEquals((int)1, (int)ssm.size());
        TreeMapTest.assertEquals((int)3, (int)sm.size());
        TreeMapTest.assertEquals((int)4, (int)map.size());
    }

    public void testRecursiveSubMaps() throws Exception {
        int mapSize = expensiveTests ? 1000 : 100;
        Class<TreeMap> cl = TreeMap.class;
        NavigableMap<Integer, Integer> map = TreeMapTest.newMap(cl);
        this.bs = new BitSet(mapSize);
        this.populate(map, mapSize);
        this.check(map, 0, mapSize - 1, true);
        this.check(map.descendingMap(), 0, mapSize - 1, false);
        this.mutateMap(map, 0, mapSize - 1);
        this.check(map, 0, mapSize - 1, true);
        this.check(map.descendingMap(), 0, mapSize - 1, false);
        this.bashSubMap(map.subMap(0, true, mapSize, false), 0, mapSize - 1, true);
    }

    static NavigableMap<Integer, Integer> newMap(Class cl) throws Exception {
        NavigableMap result = (NavigableMap)cl.newInstance();
        TreeMapTest.assertEquals((int)result.size(), (int)0);
        TreeMapTest.assertFalse((boolean)result.keySet().iterator().hasNext());
        return result;
    }

    void populate(NavigableMap<Integer, Integer> map, int limit) {
        int n = 2 * limit / 3;
        for (int i = 0; i < n; ++i) {
            int key = this.rnd.nextInt(limit);
            this.put(map, key);
        }
    }

    void mutateMap(NavigableMap<Integer, Integer> map, int min, int max) {
        int size = map.size();
        int rangeSize = max - min + 1;
        int n = rangeSize / 2;
        for (int i = 0; i < n; ++i) {
            this.remove(map, min - 5 + this.rnd.nextInt(rangeSize + 10));
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            if (!this.rnd.nextBoolean()) continue;
            this.bs.clear((Integer)it.next());
            it.remove();
        }
        while (map.size() < size) {
            int key = min + this.rnd.nextInt(rangeSize);
            TreeMapTest.assertTrue((key >= min && key <= max ? 1 : 0) != 0);
            this.put(map, key);
        }
    }

    void mutateSubMap(NavigableMap<Integer, Integer> map, int min, int max) {
        int size = map.size();
        int rangeSize = max - min + 1;
        int n = rangeSize / 2;
        for (int i = 0; i < n; ++i) {
            this.remove(map, min - 5 + this.rnd.nextInt(rangeSize + 10));
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            if (!this.rnd.nextBoolean()) continue;
            this.bs.clear((Integer)it.next());
            it.remove();
        }
        while (map.size() < size) {
            int key = min - 5 + this.rnd.nextInt(rangeSize + 10);
            if (key >= min && key <= max) {
                this.put(map, key);
                continue;
            }
            try {
                map.put(key, 2 * key);
                this.shouldThrow();
            }
            catch (IllegalArgumentException success) {}
        }
    }

    void put(NavigableMap<Integer, Integer> map, int key) {
        if (map.put(key, 2 * key) == null) {
            this.bs.set(key);
        }
    }

    void remove(NavigableMap<Integer, Integer> map, int key) {
        if (map.remove(key) != null) {
            this.bs.clear(key);
        }
    }

    void bashSubMap(NavigableMap<Integer, Integer> map, int min, int max, boolean ascending) {
        this.check(map, min, max, ascending);
        this.check(map.descendingMap(), min, max, !ascending);
        this.mutateSubMap(map, min, max);
        this.check(map, min, max, ascending);
        this.check(map.descendingMap(), min, max, !ascending);
        if (max - min < 2) {
            return;
        }
        int midPoint = (min + max) / 2;
        boolean incl = this.rnd.nextBoolean();
        NavigableMap<Integer, Integer> hm = map.headMap(midPoint, incl);
        if (ascending) {
            if (this.rnd.nextBoolean()) {
                this.bashSubMap(hm, min, midPoint - (incl ? 0 : 1), true);
            } else {
                this.bashSubMap(hm.descendingMap(), min, midPoint - (incl ? 0 : 1), false);
            }
        } else if (this.rnd.nextBoolean()) {
            this.bashSubMap(hm, midPoint + (incl ? 0 : 1), max, false);
        } else {
            this.bashSubMap(hm.descendingMap(), midPoint + (incl ? 0 : 1), max, true);
        }
        incl = this.rnd.nextBoolean();
        NavigableMap<Integer, Integer> tm = map.tailMap(midPoint, incl);
        if (ascending) {
            if (this.rnd.nextBoolean()) {
                this.bashSubMap(tm, midPoint + (incl ? 0 : 1), max, true);
            } else {
                this.bashSubMap(tm.descendingMap(), midPoint + (incl ? 0 : 1), max, false);
            }
        } else if (this.rnd.nextBoolean()) {
            this.bashSubMap(tm, min, midPoint - (incl ? 0 : 1), false);
        } else {
            this.bashSubMap(tm.descendingMap(), min, midPoint - (incl ? 0 : 1), true);
        }
        int rangeSize = max - min + 1;
        int[] endpoints = new int[]{min + this.rnd.nextInt(rangeSize), min + this.rnd.nextInt(rangeSize)};
        Arrays.sort(endpoints);
        boolean lowIncl = this.rnd.nextBoolean();
        boolean highIncl = this.rnd.nextBoolean();
        if (ascending) {
            NavigableMap<Integer, Integer> sm = map.subMap(endpoints[0], lowIncl, endpoints[1], highIncl);
            if (this.rnd.nextBoolean()) {
                this.bashSubMap(sm, endpoints[0] + (lowIncl ? 0 : 1), endpoints[1] - (highIncl ? 0 : 1), true);
            } else {
                this.bashSubMap(sm.descendingMap(), endpoints[0] + (lowIncl ? 0 : 1), endpoints[1] - (highIncl ? 0 : 1), false);
            }
        } else {
            NavigableMap<Integer, Integer> sm = map.subMap(endpoints[1], highIncl, endpoints[0], lowIncl);
            if (this.rnd.nextBoolean()) {
                this.bashSubMap(sm, endpoints[0] + (lowIncl ? 0 : 1), endpoints[1] - (highIncl ? 0 : 1), false);
            } else {
                this.bashSubMap(sm.descendingMap(), endpoints[0] + (lowIncl ? 0 : 1), endpoints[1] - (highIncl ? 0 : 1), true);
            }
        }
    }

    void check(NavigableMap<Integer, Integer> map, final int min, final int max, final boolean ascending) {
        class ReferenceSet {
            ReferenceSet() {
            }

            int lower(int key) {
                return ascending ? this.lowerAscending(key) : this.higherAscending(key);
            }

            int floor(int key) {
                return ascending ? this.floorAscending(key) : this.ceilingAscending(key);
            }

            int ceiling(int key) {
                return ascending ? this.ceilingAscending(key) : this.floorAscending(key);
            }

            int higher(int key) {
                return ascending ? this.higherAscending(key) : this.lowerAscending(key);
            }

            int first() {
                return ascending ? this.firstAscending() : this.lastAscending();
            }

            int last() {
                return ascending ? this.lastAscending() : this.firstAscending();
            }

            int lowerAscending(int key) {
                return this.floorAscending(key - 1);
            }

            int floorAscending(int key) {
                if (key < min) {
                    return -1;
                }
                if (key > max) {
                    key = max;
                }
                while (key >= min) {
                    if (TreeMapTest.this.bs.get(key)) {
                        return key;
                    }
                    --key;
                }
                return -1;
            }

            int ceilingAscending(int key) {
                if (key < min) {
                    key = min;
                } else if (key > max) {
                    return -1;
                }
                int result = TreeMapTest.this.bs.nextSetBit(key);
                return result > max ? -1 : result;
            }

            int higherAscending(int key) {
                return this.ceilingAscending(key + 1);
            }

            private int firstAscending() {
                int result = this.ceilingAscending(min);
                return result > max ? -1 : result;
            }

            private int lastAscending() {
                int result = this.floorAscending(max);
                return result < min ? -1 : result;
            }
        }
        ReferenceSet rs = new ReferenceSet();
        int size = 0;
        for (int i = min; i <= max; ++i) {
            boolean bsContainsI = this.bs.get(i);
            TreeMapTest.assertEquals((boolean)bsContainsI, (boolean)map.containsKey(i));
            if (!bsContainsI) continue;
            ++size;
        }
        TreeMapTest.assertEquals((int)map.size(), (int)size);
        int size2 = 0;
        int previousKey = -1;
        Iterator i$ = map.keySet().iterator();
        while (i$.hasNext()) {
            int key = (Integer)i$.next();
            TreeMapTest.assertTrue((boolean)this.bs.get(key));
            ++size2;
            TreeMapTest.assertTrue((previousKey < 0 || (ascending ? key - previousKey > 0 : key - previousKey < 0) ? 1 : 0) != 0);
            previousKey = key;
        }
        TreeMapTest.assertEquals((int)size2, (int)size);
        for (int key = min - 1; key <= max + 1; ++key) {
            TreeMapTest.assertEq(map.lowerKey(key), rs.lower(key));
            TreeMapTest.assertEq(map.floorKey(key), rs.floor(key));
            TreeMapTest.assertEq(map.higherKey(key), rs.higher(key));
            TreeMapTest.assertEq(map.ceilingKey(key), rs.ceiling(key));
        }
        if (map.size() != 0) {
            TreeMapTest.assertEq((Integer)map.firstKey(), rs.first());
            TreeMapTest.assertEq((Integer)map.lastKey(), rs.last());
        } else {
            TreeMapTest.assertEq(rs.first(), -1);
            TreeMapTest.assertEq(rs.last(), -1);
            try {
                map.firstKey();
                this.shouldThrow();
            }
            catch (NoSuchElementException success) {
                // empty catch block
            }
            try {
                map.lastKey();
                this.shouldThrow();
            }
            catch (NoSuchElementException success) {
                // empty catch block
            }
        }
    }

    static void assertEq(Integer i, int j) {
        if (i == null) {
            TreeMapTest.assertEquals((int)j, (int)-1);
        } else {
            TreeMapTest.assertEquals((int)i, (int)j);
        }
    }

    static boolean eq(Integer i, int j) {
        return i == null ? j == -1 : i == j;
    }
}

