/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TreeSetTest
extends JSR166TestCase {
    static final int SIZE = 20;
    Random rnd = new Random(666L);
    BitSet bs;

    public static void main(String[] args) {
        TestRunner.run((Test)TreeSetTest.suite());
    }

    public static Test suite() {
        return new TestSuite(TreeSetTest.class);
    }

    private TreeSet<Integer> populatedSet(int n) {
        int i;
        TreeSet<Integer> q = new TreeSet<Integer>();
        TreeSetTest.assertTrue((boolean)q.isEmpty());
        for (i = n - 1; i >= 0; i -= 2) {
            TreeSetTest.assertTrue((boolean)q.add(new Integer(i)));
        }
        for (i = n & 1; i < n; i += 2) {
            TreeSetTest.assertTrue((boolean)q.add(new Integer(i)));
        }
        TreeSetTest.assertFalse((boolean)q.isEmpty());
        TreeSetTest.assertEquals((int)n, (int)q.size());
        return q;
    }

    private TreeSet set5() {
        TreeSet<Integer> q = new TreeSet<Integer>();
        TreeSetTest.assertTrue((boolean)q.isEmpty());
        q.add(one);
        q.add(two);
        q.add(three);
        q.add(four);
        q.add(five);
        TreeSetTest.assertEquals((int)5, (int)q.size());
        return q;
    }

    public void testConstructor1() {
        TreeSetTest.assertEquals((int)0, (int)new TreeSet().size());
    }

    public void testConstructor3() {
        try {
            TreeSet q = new TreeSet((Collection)null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor4() {
        try {
            Integer[] ints = new Integer[20];
            TreeSet<Integer> q = new TreeSet<Integer>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor5() {
        try {
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            TreeSet<Integer> q = new TreeSet<Integer>(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor6() {
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        TreeSet<Integer> q = new TreeSet<Integer>(Arrays.asList(ints));
        for (int i = 0; i < 20; ++i) {
            TreeSetTest.assertEquals((Object)ints[i], (Object)q.pollFirst());
        }
    }

    public void testConstructor7() {
        int i;
        MyReverseComparator cmp = new MyReverseComparator();
        TreeSet<Integer> q = new TreeSet<Integer>(cmp);
        TreeSetTest.assertEquals((Object)cmp, q.comparator());
        Integer[] ints = new Integer[20];
        for (i = 0; i < 20; ++i) {
            ints[i] = new Integer(i);
        }
        q.addAll(Arrays.asList(ints));
        for (i = 19; i >= 0; --i) {
            TreeSetTest.assertEquals((Object)ints[i], q.pollFirst());
        }
    }

    public void testEmpty() {
        TreeSet<Integer> q = new TreeSet<Integer>();
        TreeSetTest.assertTrue((boolean)q.isEmpty());
        q.add(new Integer(1));
        TreeSetTest.assertFalse((boolean)q.isEmpty());
        q.add(new Integer(2));
        q.pollFirst();
        q.pollFirst();
        TreeSetTest.assertTrue((boolean)q.isEmpty());
    }

    public void testSize() {
        int i;
        TreeSet<Integer> q = this.populatedSet(20);
        for (i = 0; i < 20; ++i) {
            TreeSetTest.assertEquals((int)(20 - i), (int)q.size());
            q.pollFirst();
        }
        for (i = 0; i < 20; ++i) {
            TreeSetTest.assertEquals((int)i, (int)q.size());
            q.add(new Integer(i));
        }
    }

    public void testAddNull() {
        try {
            TreeSet<Integer> q = this.populatedSet(20);
            q.add(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAdd() {
        TreeSet<Integer> q = new TreeSet<Integer>();
        TreeSetTest.assertTrue((boolean)q.add(zero));
        TreeSetTest.assertTrue((boolean)q.add(one));
    }

    public void testAddDup() {
        TreeSet<Integer> q = new TreeSet<Integer>();
        TreeSetTest.assertTrue((boolean)q.add(zero));
        TreeSetTest.assertFalse((boolean)q.add(zero));
    }

    public void testAddNonComparable() {
        try {
            TreeSet<Object> q = new TreeSet<Object>();
            q.add(new Object());
            q.add(new Object());
            q.add(new Object());
            this.shouldThrow();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testAddAll1() {
        try {
            TreeSet q = new TreeSet();
            q.addAll(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll2() {
        try {
            TreeSet<Integer> q = new TreeSet<Integer>();
            Integer[] ints = new Integer[20];
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll3() {
        try {
            TreeSet<Integer> q = new TreeSet<Integer>();
            Integer[] ints = new Integer[20];
            for (int i = 0; i < 19; ++i) {
                ints[i] = new Integer(i);
            }
            q.addAll(Arrays.asList(ints));
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddAll5() {
        Integer[] empty = new Integer[]{};
        Integer[] ints = new Integer[20];
        for (int i = 0; i < 20; ++i) {
            ints[i] = new Integer(19 - i);
        }
        TreeSet<Integer> q = new TreeSet<Integer>();
        TreeSetTest.assertFalse((boolean)q.addAll(Arrays.asList(empty)));
        TreeSetTest.assertTrue((boolean)q.addAll(Arrays.asList(ints)));
        for (int i = 0; i < 20; ++i) {
            TreeSetTest.assertEquals((Object)new Integer(i), q.pollFirst());
        }
    }

    public void testPollFirst() {
        TreeSet<Integer> q = this.populatedSet(20);
        for (int i = 0; i < 20; ++i) {
            TreeSetTest.assertEquals((Object)i, (Object)q.pollFirst());
        }
        TreeSetTest.assertNull((Object)q.pollFirst());
    }

    public void testPollLast() {
        TreeSet<Integer> q = this.populatedSet(20);
        for (int i = 19; i >= 0; --i) {
            TreeSetTest.assertEquals((Object)i, (Object)q.pollLast());
        }
        TreeSetTest.assertNull((Object)q.pollFirst());
    }

    public void testRemoveElement() {
        int i;
        TreeSet<Integer> q = this.populatedSet(20);
        for (i = 1; i < 20; i += 2) {
            TreeSetTest.assertTrue((boolean)q.contains(i));
            TreeSetTest.assertTrue((boolean)q.remove(i));
            TreeSetTest.assertFalse((boolean)q.contains(i));
            TreeSetTest.assertTrue((boolean)q.contains(i - 1));
        }
        for (i = 0; i < 20; i += 2) {
            TreeSetTest.assertTrue((boolean)q.contains(i));
            TreeSetTest.assertTrue((boolean)q.remove(i));
            TreeSetTest.assertFalse((boolean)q.contains(i));
            TreeSetTest.assertFalse((boolean)q.remove(i + 1));
            TreeSetTest.assertFalse((boolean)q.contains(i + 1));
        }
        TreeSetTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContains() {
        TreeSet<Integer> q = this.populatedSet(20);
        for (int i = 0; i < 20; ++i) {
            TreeSetTest.assertTrue((boolean)q.contains(new Integer(i)));
            q.pollFirst();
            TreeSetTest.assertFalse((boolean)q.contains(new Integer(i)));
        }
    }

    public void testClear() {
        TreeSet<Integer> q = this.populatedSet(20);
        q.clear();
        TreeSetTest.assertTrue((boolean)q.isEmpty());
        TreeSetTest.assertEquals((int)0, (int)q.size());
        q.add(new Integer(1));
        TreeSetTest.assertFalse((boolean)q.isEmpty());
        q.clear();
        TreeSetTest.assertTrue((boolean)q.isEmpty());
    }

    public void testContainsAll() {
        TreeSet<Integer> q = this.populatedSet(20);
        TreeSet<Integer> p = new TreeSet<Integer>();
        for (int i = 0; i < 20; ++i) {
            TreeSetTest.assertTrue((boolean)q.containsAll(p));
            TreeSetTest.assertFalse((boolean)p.containsAll(q));
            p.add(new Integer(i));
        }
        TreeSetTest.assertTrue((boolean)p.containsAll(q));
    }

    public void testRetainAll() {
        TreeSet<Integer> q = this.populatedSet(20);
        TreeSet<Integer> p = this.populatedSet(20);
        for (int i = 0; i < 20; ++i) {
            boolean changed = q.retainAll(p);
            if (i == 0) {
                TreeSetTest.assertFalse((boolean)changed);
            } else {
                TreeSetTest.assertTrue((boolean)changed);
            }
            TreeSetTest.assertTrue((boolean)q.containsAll(p));
            TreeSetTest.assertEquals((int)(20 - i), (int)q.size());
            p.pollFirst();
        }
    }

    public void testRemoveAll() {
        for (int i = 1; i < 20; ++i) {
            TreeSet<Integer> q = this.populatedSet(20);
            TreeSet<Integer> p = this.populatedSet(i);
            TreeSetTest.assertTrue((boolean)q.removeAll(p));
            TreeSetTest.assertEquals((int)(20 - i), (int)q.size());
            for (int j = 0; j < i; ++j) {
                Integer I = p.pollFirst();
                TreeSetTest.assertFalse((boolean)q.contains(I));
            }
        }
    }

    public void testLower() {
        TreeSet q = this.set5();
        Integer e1 = q.lower(three);
        TreeSetTest.assertEquals((Object)two, (Object)e1);
        Integer e2 = q.lower(six);
        TreeSetTest.assertEquals((Object)five, (Object)e2);
        Integer e3 = q.lower(one);
        TreeSetTest.assertNull((Object)e3);
        Integer e4 = q.lower(zero);
        TreeSetTest.assertNull((Object)e4);
    }

    public void testHigher() {
        TreeSet q = this.set5();
        Integer e1 = q.higher(three);
        TreeSetTest.assertEquals((Object)four, (Object)e1);
        Integer e2 = q.higher(zero);
        TreeSetTest.assertEquals((Object)one, (Object)e2);
        Integer e3 = q.higher(five);
        TreeSetTest.assertNull((Object)e3);
        Integer e4 = q.higher(six);
        TreeSetTest.assertNull((Object)e4);
    }

    public void testFloor() {
        TreeSet q = this.set5();
        Integer e1 = q.floor(three);
        TreeSetTest.assertEquals((Object)three, (Object)e1);
        Integer e2 = q.floor(six);
        TreeSetTest.assertEquals((Object)five, (Object)e2);
        Integer e3 = q.floor(one);
        TreeSetTest.assertEquals((Object)one, (Object)e3);
        Integer e4 = q.floor(zero);
        TreeSetTest.assertNull((Object)e4);
    }

    public void testCeiling() {
        TreeSet q = this.set5();
        Integer e1 = q.ceiling(three);
        TreeSetTest.assertEquals((Object)three, (Object)e1);
        Integer e2 = q.ceiling(zero);
        TreeSetTest.assertEquals((Object)one, (Object)e2);
        Integer e3 = q.ceiling(five);
        TreeSetTest.assertEquals((Object)five, (Object)e3);
        Integer e4 = q.ceiling(six);
        TreeSetTest.assertNull((Object)e4);
    }

    public void testToArray() {
        TreeSet<Integer> q = this.populatedSet(20);
        Object[] o = q.toArray();
        for (int i = 0; i < o.length; ++i) {
            TreeSetTest.assertSame((Object)o[i], (Object)q.pollFirst());
        }
    }

    public void testToArray2() {
        TreeSet<Integer> q = this.populatedSet(20);
        Integer[] ints = new Integer[20];
        Integer[] array = q.toArray(ints);
        TreeSetTest.assertSame((Object)ints, (Object)array);
        for (int i = 0; i < ints.length; ++i) {
            TreeSetTest.assertSame((Object)ints[i], (Object)q.pollFirst());
        }
    }

    public void testIterator() {
        TreeSet<Integer> q = this.populatedSet(20);
        int i = 0;
        Iterator<Integer> it = q.iterator();
        while (it.hasNext()) {
            TreeSetTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        TreeSetTest.assertEquals((int)i, (int)20);
    }

    public void testEmptyIterator() {
        TreeSet q = new TreeSet();
        int i = 0;
        Iterator it = q.iterator();
        while (it.hasNext()) {
            TreeSetTest.assertTrue((boolean)q.contains(it.next()));
            ++i;
        }
        TreeSetTest.assertEquals((int)i, (int)0);
    }

    public void testIteratorRemove() {
        TreeSet<Integer> q = new TreeSet<Integer>();
        q.add(new Integer(2));
        q.add(new Integer(1));
        q.add(new Integer(3));
        Iterator it = q.iterator();
        it.next();
        it.remove();
        it = q.iterator();
        TreeSetTest.assertEquals(it.next(), (Object)new Integer(2));
        TreeSetTest.assertEquals(it.next(), (Object)new Integer(3));
        TreeSetTest.assertFalse((boolean)it.hasNext());
    }

    public void testToString() {
        TreeSet<Integer> q = this.populatedSet(20);
        String s = q.toString();
        for (int i = 0; i < 20; ++i) {
            TreeSetTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testSerialization() throws Exception {
        TreeSet<Integer> q = this.populatedSet(20);
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        TreeSet r = (TreeSet)in.readObject();
        TreeSetTest.assertEquals((int)q.size(), (int)r.size());
        while (!q.isEmpty()) {
            TreeSetTest.assertEquals((Object)q.pollFirst(), r.pollFirst());
        }
    }

    public void testSubSetContents() {
        TreeSet set = this.set5();
        SortedSet<Integer> sm = set.subSet(two, four);
        TreeSetTest.assertEquals((Object)two, (Object)sm.first());
        TreeSetTest.assertEquals((Object)three, (Object)sm.last());
        TreeSetTest.assertEquals((int)2, (int)sm.size());
        TreeSetTest.assertFalse((boolean)sm.contains(one));
        TreeSetTest.assertTrue((boolean)sm.contains(two));
        TreeSetTest.assertTrue((boolean)sm.contains(three));
        TreeSetTest.assertFalse((boolean)sm.contains(four));
        TreeSetTest.assertFalse((boolean)sm.contains(five));
        Iterator i = sm.iterator();
        Integer k = (Integer)i.next();
        TreeSetTest.assertEquals((Object)two, (Object)k);
        k = (Integer)i.next();
        TreeSetTest.assertEquals((Object)three, (Object)k);
        TreeSetTest.assertFalse((boolean)i.hasNext());
        Iterator j = sm.iterator();
        j.next();
        j.remove();
        TreeSetTest.assertFalse((boolean)set.contains(two));
        TreeSetTest.assertEquals((int)4, (int)set.size());
        TreeSetTest.assertEquals((int)1, (int)sm.size());
        TreeSetTest.assertEquals((Object)three, (Object)sm.first());
        TreeSetTest.assertEquals((Object)three, (Object)sm.last());
        TreeSetTest.assertTrue((boolean)sm.remove(three));
        TreeSetTest.assertTrue((boolean)sm.isEmpty());
        TreeSetTest.assertEquals((int)3, (int)set.size());
    }

    public void testSubSetContents2() {
        TreeSet set = this.set5();
        SortedSet<Integer> sm = set.subSet(two, three);
        TreeSetTest.assertEquals((int)1, (int)sm.size());
        TreeSetTest.assertEquals((Object)two, (Object)sm.first());
        TreeSetTest.assertEquals((Object)two, (Object)sm.last());
        TreeSetTest.assertFalse((boolean)sm.contains(one));
        TreeSetTest.assertTrue((boolean)sm.contains(two));
        TreeSetTest.assertFalse((boolean)sm.contains(three));
        TreeSetTest.assertFalse((boolean)sm.contains(four));
        TreeSetTest.assertFalse((boolean)sm.contains(five));
        Iterator i = sm.iterator();
        Integer k = (Integer)i.next();
        TreeSetTest.assertEquals((Object)two, (Object)k);
        TreeSetTest.assertFalse((boolean)i.hasNext());
        Iterator j = sm.iterator();
        j.next();
        j.remove();
        TreeSetTest.assertFalse((boolean)set.contains(two));
        TreeSetTest.assertEquals((int)4, (int)set.size());
        TreeSetTest.assertEquals((int)0, (int)sm.size());
        TreeSetTest.assertTrue((boolean)sm.isEmpty());
        TreeSetTest.assertFalse((boolean)sm.remove(three));
        TreeSetTest.assertEquals((int)4, (int)set.size());
    }

    public void testHeadSetContents() {
        TreeSet set = this.set5();
        SortedSet<Integer> sm = set.headSet(four);
        TreeSetTest.assertTrue((boolean)sm.contains(one));
        TreeSetTest.assertTrue((boolean)sm.contains(two));
        TreeSetTest.assertTrue((boolean)sm.contains(three));
        TreeSetTest.assertFalse((boolean)sm.contains(four));
        TreeSetTest.assertFalse((boolean)sm.contains(five));
        Iterator i = sm.iterator();
        Integer k = (Integer)i.next();
        TreeSetTest.assertEquals((Object)one, (Object)k);
        k = (Integer)i.next();
        TreeSetTest.assertEquals((Object)two, (Object)k);
        k = (Integer)i.next();
        TreeSetTest.assertEquals((Object)three, (Object)k);
        TreeSetTest.assertFalse((boolean)i.hasNext());
        sm.clear();
        TreeSetTest.assertTrue((boolean)sm.isEmpty());
        TreeSetTest.assertEquals((int)2, (int)set.size());
        TreeSetTest.assertEquals((Object)four, set.first());
    }

    public void testTailSetContents() {
        TreeSet set = this.set5();
        SortedSet<Integer> sm = set.tailSet(two);
        TreeSetTest.assertFalse((boolean)sm.contains(one));
        TreeSetTest.assertTrue((boolean)sm.contains(two));
        TreeSetTest.assertTrue((boolean)sm.contains(three));
        TreeSetTest.assertTrue((boolean)sm.contains(four));
        TreeSetTest.assertTrue((boolean)sm.contains(five));
        Iterator i = sm.iterator();
        Integer k = (Integer)i.next();
        TreeSetTest.assertEquals((Object)two, (Object)k);
        k = (Integer)i.next();
        TreeSetTest.assertEquals((Object)three, (Object)k);
        k = (Integer)i.next();
        TreeSetTest.assertEquals((Object)four, (Object)k);
        k = (Integer)i.next();
        TreeSetTest.assertEquals((Object)five, (Object)k);
        TreeSetTest.assertFalse((boolean)i.hasNext());
        SortedSet<Integer> ssm = sm.tailSet(four);
        TreeSetTest.assertEquals((Object)four, (Object)ssm.first());
        TreeSetTest.assertEquals((Object)five, (Object)ssm.last());
        TreeSetTest.assertTrue((boolean)ssm.remove(four));
        TreeSetTest.assertEquals((int)1, (int)ssm.size());
        TreeSetTest.assertEquals((int)3, (int)sm.size());
        TreeSetTest.assertEquals((int)4, (int)set.size());
    }

    public void testRecursiveSubSets() throws Exception {
        int setSize = expensiveTests ? 1000 : 100;
        Class<TreeSet> cl = TreeSet.class;
        NavigableSet<Integer> set = TreeSetTest.newSet(cl);
        this.bs = new BitSet(setSize);
        this.populate(set, setSize);
        this.check(set, 0, setSize - 1, true);
        this.check(set.descendingSet(), 0, setSize - 1, false);
        this.mutateSet(set, 0, setSize - 1);
        this.check(set, 0, setSize - 1, true);
        this.check(set.descendingSet(), 0, setSize - 1, false);
        this.bashSubSet(set.subSet(0, true, setSize, false), 0, setSize - 1, true);
    }

    static NavigableSet<Integer> newSet(Class cl) throws Exception {
        NavigableSet result = (NavigableSet)cl.newInstance();
        TreeSetTest.assertEquals((int)result.size(), (int)0);
        TreeSetTest.assertFalse((boolean)result.iterator().hasNext());
        return result;
    }

    void populate(NavigableSet<Integer> set, int limit) {
        int n = 2 * limit / 3;
        for (int i = 0; i < n; ++i) {
            int element = this.rnd.nextInt(limit);
            this.put(set, element);
        }
    }

    void mutateSet(NavigableSet<Integer> set, int min, int max) {
        int size = set.size();
        int rangeSize = max - min + 1;
        int n = rangeSize / 2;
        for (int i = 0; i < n; ++i) {
            this.remove(set, min - 5 + this.rnd.nextInt(rangeSize + 10));
        }
        Iterator<Integer> it = set.iterator();
        while (it.hasNext()) {
            if (!this.rnd.nextBoolean()) continue;
            this.bs.clear(it.next());
            it.remove();
        }
        while (set.size() < size) {
            int element = min + this.rnd.nextInt(rangeSize);
            TreeSetTest.assertTrue((element >= min && element <= max ? 1 : 0) != 0);
            this.put(set, element);
        }
    }

    void mutateSubSet(NavigableSet<Integer> set, int min, int max) {
        int size = set.size();
        int rangeSize = max - min + 1;
        int n = rangeSize / 2;
        for (int i = 0; i < n; ++i) {
            this.remove(set, min - 5 + this.rnd.nextInt(rangeSize + 10));
        }
        Iterator<Integer> it = set.iterator();
        while (it.hasNext()) {
            if (!this.rnd.nextBoolean()) continue;
            this.bs.clear(it.next());
            it.remove();
        }
        while (set.size() < size) {
            int element = min - 5 + this.rnd.nextInt(rangeSize + 10);
            if (element >= min && element <= max) {
                this.put(set, element);
                continue;
            }
            try {
                set.add(element);
                this.shouldThrow();
            }
            catch (IllegalArgumentException success) {}
        }
    }

    void put(NavigableSet<Integer> set, int element) {
        if (set.add(element)) {
            this.bs.set(element);
        }
    }

    void remove(NavigableSet<Integer> set, int element) {
        if (set.remove(element)) {
            this.bs.clear(element);
        }
    }

    void bashSubSet(NavigableSet<Integer> set, int min, int max, boolean ascending) {
        this.check(set, min, max, ascending);
        this.check(set.descendingSet(), min, max, !ascending);
        this.mutateSubSet(set, min, max);
        this.check(set, min, max, ascending);
        this.check(set.descendingSet(), min, max, !ascending);
        if (max - min < 2) {
            return;
        }
        int midPoint = (min + max) / 2;
        boolean incl = this.rnd.nextBoolean();
        NavigableSet<Integer> hm = set.headSet(midPoint, incl);
        if (ascending) {
            if (this.rnd.nextBoolean()) {
                this.bashSubSet(hm, min, midPoint - (incl ? 0 : 1), true);
            } else {
                this.bashSubSet(hm.descendingSet(), min, midPoint - (incl ? 0 : 1), false);
            }
        } else if (this.rnd.nextBoolean()) {
            this.bashSubSet(hm, midPoint + (incl ? 0 : 1), max, false);
        } else {
            this.bashSubSet(hm.descendingSet(), midPoint + (incl ? 0 : 1), max, true);
        }
        incl = this.rnd.nextBoolean();
        NavigableSet<Integer> tm = set.tailSet(midPoint, incl);
        if (ascending) {
            if (this.rnd.nextBoolean()) {
                this.bashSubSet(tm, midPoint + (incl ? 0 : 1), max, true);
            } else {
                this.bashSubSet(tm.descendingSet(), midPoint + (incl ? 0 : 1), max, false);
            }
        } else if (this.rnd.nextBoolean()) {
            this.bashSubSet(tm, min, midPoint - (incl ? 0 : 1), false);
        } else {
            this.bashSubSet(tm.descendingSet(), min, midPoint - (incl ? 0 : 1), true);
        }
        int rangeSize = max - min + 1;
        int[] endpoints = new int[]{min + this.rnd.nextInt(rangeSize), min + this.rnd.nextInt(rangeSize)};
        Arrays.sort(endpoints);
        boolean lowIncl = this.rnd.nextBoolean();
        boolean highIncl = this.rnd.nextBoolean();
        if (ascending) {
            NavigableSet<Integer> sm = set.subSet(endpoints[0], lowIncl, endpoints[1], highIncl);
            if (this.rnd.nextBoolean()) {
                this.bashSubSet(sm, endpoints[0] + (lowIncl ? 0 : 1), endpoints[1] - (highIncl ? 0 : 1), true);
            } else {
                this.bashSubSet(sm.descendingSet(), endpoints[0] + (lowIncl ? 0 : 1), endpoints[1] - (highIncl ? 0 : 1), false);
            }
        } else {
            NavigableSet<Integer> sm = set.subSet(endpoints[1], highIncl, endpoints[0], lowIncl);
            if (this.rnd.nextBoolean()) {
                this.bashSubSet(sm, endpoints[0] + (lowIncl ? 0 : 1), endpoints[1] - (highIncl ? 0 : 1), false);
            } else {
                this.bashSubSet(sm.descendingSet(), endpoints[0] + (lowIncl ? 0 : 1), endpoints[1] - (highIncl ? 0 : 1), true);
            }
        }
    }

    void check(NavigableSet<Integer> set, final int min, final int max, final boolean ascending) {
        class ReferenceSet {
            ReferenceSet() {
            }

            int lower(int element) {
                return ascending ? this.lowerAscending(element) : this.higherAscending(element);
            }

            int floor(int element) {
                return ascending ? this.floorAscending(element) : this.ceilingAscending(element);
            }

            int ceiling(int element) {
                return ascending ? this.ceilingAscending(element) : this.floorAscending(element);
            }

            int higher(int element) {
                return ascending ? this.higherAscending(element) : this.lowerAscending(element);
            }

            int first() {
                return ascending ? this.firstAscending() : this.lastAscending();
            }

            int last() {
                return ascending ? this.lastAscending() : this.firstAscending();
            }

            int lowerAscending(int element) {
                return this.floorAscending(element - 1);
            }

            int floorAscending(int element) {
                if (element < min) {
                    return -1;
                }
                if (element > max) {
                    element = max;
                }
                while (element >= min) {
                    if (TreeSetTest.this.bs.get(element)) {
                        return element;
                    }
                    --element;
                }
                return -1;
            }

            int ceilingAscending(int element) {
                if (element < min) {
                    element = min;
                } else if (element > max) {
                    return -1;
                }
                int result = TreeSetTest.this.bs.nextSetBit(element);
                return result > max ? -1 : result;
            }

            int higherAscending(int element) {
                return this.ceilingAscending(element + 1);
            }

            private int firstAscending() {
                int result = this.ceilingAscending(min);
                return result > max ? -1 : result;
            }

            private int lastAscending() {
                int result = this.floorAscending(max);
                return result < min ? -1 : result;
            }
        }
        ReferenceSet rs = new ReferenceSet();
        int size = 0;
        for (int i = min; i <= max; ++i) {
            boolean bsContainsI = this.bs.get(i);
            TreeSetTest.assertEquals((boolean)bsContainsI, (boolean)set.contains(i));
            if (!bsContainsI) continue;
            ++size;
        }
        TreeSetTest.assertEquals((int)set.size(), (int)size);
        int size2 = 0;
        int previousElement = -1;
        for (int element : set) {
            TreeSetTest.assertTrue((boolean)this.bs.get(element));
            ++size2;
            TreeSetTest.assertTrue((previousElement < 0 || (ascending ? element - previousElement > 0 : element - previousElement < 0) ? 1 : 0) != 0);
            previousElement = element;
        }
        TreeSetTest.assertEquals((int)size2, (int)size);
        for (int element = min - 1; element <= max + 1; ++element) {
            TreeSetTest.assertEq(set.lower(element), rs.lower(element));
            TreeSetTest.assertEq(set.floor(element), rs.floor(element));
            TreeSetTest.assertEq(set.higher(element), rs.higher(element));
            TreeSetTest.assertEq(set.ceiling(element), rs.ceiling(element));
        }
        if (set.size() != 0) {
            TreeSetTest.assertEq((Integer)set.first(), rs.first());
            TreeSetTest.assertEq((Integer)set.last(), rs.last());
        } else {
            TreeSetTest.assertEq(rs.first(), -1);
            TreeSetTest.assertEq(rs.last(), -1);
            try {
                set.first();
                this.shouldThrow();
            }
            catch (NoSuchElementException success) {
                // empty catch block
            }
            try {
                set.last();
                this.shouldThrow();
            }
            catch (NoSuchElementException success) {
                // empty catch block
            }
        }
    }

    static void assertEq(Integer i, int j) {
        if (i == null) {
            TreeSetTest.assertEquals((int)j, (int)-1);
        } else {
            TreeSetTest.assertEquals((int)i, (int)j);
        }
    }

    static boolean eq(Integer i, int j) {
        return i == null ? j == -1 : i == j;
    }

    static class MyReverseComparator
    implements Comparator {
        MyReverseComparator() {
        }

        public int compare(Object x, Object y) {
            return ((Comparable)y).compareTo(x);
        }
    }
}

