/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TreeSubMapTest
extends JSR166TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)TreeSubMapTest.suite());
    }

    public static Test suite() {
        return new TestSuite(TreeSubMapTest.class);
    }

    private static NavigableMap map5() {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        TreeSubMapTest.assertTrue((boolean)map.isEmpty());
        map.put(zero, "Z");
        map.put(one, "A");
        map.put(five, "E");
        map.put(three, "C");
        map.put(two, "B");
        map.put(four, "D");
        map.put(seven, "F");
        TreeSubMapTest.assertFalse((boolean)map.isEmpty());
        TreeSubMapTest.assertEquals((int)7, (int)map.size());
        return map.subMap(one, true, seven, false);
    }

    private static NavigableMap map0() {
        TreeMap map = new TreeMap();
        TreeSubMapTest.assertTrue((boolean)map.isEmpty());
        return map.tailMap(one, true);
    }

    private static NavigableMap dmap5() {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        TreeSubMapTest.assertTrue((boolean)map.isEmpty());
        map.put(m1, "A");
        map.put(m5, "E");
        map.put(m3, "C");
        map.put(m2, "B");
        map.put(m4, "D");
        TreeSubMapTest.assertFalse((boolean)map.isEmpty());
        TreeSubMapTest.assertEquals((int)5, (int)map.size());
        return map.descendingMap();
    }

    private static NavigableMap dmap0() {
        TreeMap map = new TreeMap();
        TreeSubMapTest.assertTrue((boolean)map.isEmpty());
        return map;
    }

    public void testClear() {
        NavigableMap map = TreeSubMapTest.map5();
        map.clear();
        TreeSubMapTest.assertEquals((int)map.size(), (int)0);
    }

    public void testEquals() {
        NavigableMap map1 = TreeSubMapTest.map5();
        NavigableMap map2 = TreeSubMapTest.map5();
        TreeSubMapTest.assertEquals((Object)map1, (Object)map2);
        TreeSubMapTest.assertEquals((Object)map2, (Object)map1);
        map1.clear();
        TreeSubMapTest.assertFalse((boolean)map1.equals(map2));
        TreeSubMapTest.assertFalse((boolean)map2.equals(map1));
    }

    public void testContainsKey() {
        NavigableMap map = TreeSubMapTest.map5();
        TreeSubMapTest.assertTrue((boolean)map.containsKey(one));
        TreeSubMapTest.assertFalse((boolean)map.containsKey(zero));
    }

    public void testContainsValue() {
        NavigableMap map = TreeSubMapTest.map5();
        TreeSubMapTest.assertTrue((boolean)map.containsValue("A"));
        TreeSubMapTest.assertFalse((boolean)map.containsValue("Z"));
    }

    public void testGet() {
        NavigableMap map = TreeSubMapTest.map5();
        TreeSubMapTest.assertEquals((String)"A", (String)((String)map.get(one)));
        NavigableMap empty = TreeSubMapTest.map0();
        TreeSubMapTest.assertNull(empty.get(one));
    }

    public void testIsEmpty() {
        NavigableMap empty = TreeSubMapTest.map0();
        NavigableMap map = TreeSubMapTest.map5();
        TreeSubMapTest.assertTrue((boolean)empty.isEmpty());
        TreeSubMapTest.assertFalse((boolean)map.isEmpty());
    }

    public void testFirstKey() {
        NavigableMap map = TreeSubMapTest.map5();
        TreeSubMapTest.assertEquals((Object)one, map.firstKey());
    }

    public void testLastKey() {
        NavigableMap map = TreeSubMapTest.map5();
        TreeSubMapTest.assertEquals((Object)five, map.lastKey());
    }

    public void testKeySet() {
        NavigableMap map = TreeSubMapTest.map5();
        Set s = map.keySet();
        TreeSubMapTest.assertEquals((int)5, (int)s.size());
        TreeSubMapTest.assertTrue((boolean)s.contains(one));
        TreeSubMapTest.assertTrue((boolean)s.contains(two));
        TreeSubMapTest.assertTrue((boolean)s.contains(three));
        TreeSubMapTest.assertTrue((boolean)s.contains(four));
        TreeSubMapTest.assertTrue((boolean)s.contains(five));
    }

    public void testKeySetOrder() {
        NavigableMap map = TreeSubMapTest.map5();
        Set s = map.keySet();
        Iterator i = s.iterator();
        Integer last = (Integer)i.next();
        TreeSubMapTest.assertEquals((Object)last, (Object)one);
        while (i.hasNext()) {
            Integer k = (Integer)i.next();
            TreeSubMapTest.assertTrue((last.compareTo(k) < 0 ? 1 : 0) != 0);
            last = k;
        }
    }

    public void testValues() {
        NavigableMap map = TreeSubMapTest.map5();
        Collection s = map.values();
        TreeSubMapTest.assertEquals((int)5, (int)s.size());
        TreeSubMapTest.assertTrue((boolean)s.contains("A"));
        TreeSubMapTest.assertTrue((boolean)s.contains("B"));
        TreeSubMapTest.assertTrue((boolean)s.contains("C"));
        TreeSubMapTest.assertTrue((boolean)s.contains("D"));
        TreeSubMapTest.assertTrue((boolean)s.contains("E"));
    }

    public void testEntrySet() {
        NavigableMap map = TreeSubMapTest.map5();
        Set s = map.entrySet();
        TreeSubMapTest.assertEquals((int)5, (int)s.size());
        for (Map.Entry e : s) {
            TreeSubMapTest.assertTrue((e.getKey().equals(one) && e.getValue().equals("A") || e.getKey().equals(two) && e.getValue().equals("B") || e.getKey().equals(three) && e.getValue().equals("C") || e.getKey().equals(four) && e.getValue().equals("D") || e.getKey().equals(five) && e.getValue().equals("E") ? 1 : 0) != 0);
        }
    }

    public void testPutAll() {
        NavigableMap empty = TreeSubMapTest.map0();
        NavigableMap map = TreeSubMapTest.map5();
        empty.putAll(map);
        TreeSubMapTest.assertEquals((int)5, (int)empty.size());
        TreeSubMapTest.assertTrue((boolean)empty.containsKey(one));
        TreeSubMapTest.assertTrue((boolean)empty.containsKey(two));
        TreeSubMapTest.assertTrue((boolean)empty.containsKey(three));
        TreeSubMapTest.assertTrue((boolean)empty.containsKey(four));
        TreeSubMapTest.assertTrue((boolean)empty.containsKey(five));
    }

    public void testRemove() {
        NavigableMap map = TreeSubMapTest.map5();
        map.remove(five);
        TreeSubMapTest.assertEquals((int)4, (int)map.size());
        TreeSubMapTest.assertFalse((boolean)map.containsKey(five));
    }

    public void testLowerEntry() {
        NavigableMap map = TreeSubMapTest.map5();
        Map.Entry e1 = map.lowerEntry(three);
        TreeSubMapTest.assertEquals((Object)two, (Object)e1.getKey());
        Map.Entry e2 = map.lowerEntry(six);
        TreeSubMapTest.assertEquals((Object)five, (Object)e2.getKey());
        Map.Entry e3 = map.lowerEntry(one);
        TreeSubMapTest.assertNull(e3);
        Map.Entry e4 = map.lowerEntry(zero);
        TreeSubMapTest.assertNull(e4);
    }

    public void testHigherEntry() {
        NavigableMap map = TreeSubMapTest.map5();
        Map.Entry e1 = map.higherEntry(three);
        TreeSubMapTest.assertEquals((Object)four, (Object)e1.getKey());
        Map.Entry e2 = map.higherEntry(zero);
        TreeSubMapTest.assertEquals((Object)one, (Object)e2.getKey());
        Map.Entry e3 = map.higherEntry(five);
        TreeSubMapTest.assertNull(e3);
        Map.Entry e4 = map.higherEntry(six);
        TreeSubMapTest.assertNull(e4);
    }

    public void testFloorEntry() {
        NavigableMap map = TreeSubMapTest.map5();
        Map.Entry e1 = map.floorEntry(three);
        TreeSubMapTest.assertEquals((Object)three, (Object)e1.getKey());
        Map.Entry e2 = map.floorEntry(six);
        TreeSubMapTest.assertEquals((Object)five, (Object)e2.getKey());
        Map.Entry e3 = map.floorEntry(one);
        TreeSubMapTest.assertEquals((Object)one, (Object)e3.getKey());
        Map.Entry e4 = map.floorEntry(zero);
        TreeSubMapTest.assertNull(e4);
    }

    public void testCeilingEntry() {
        NavigableMap map = TreeSubMapTest.map5();
        Map.Entry e1 = map.ceilingEntry(three);
        TreeSubMapTest.assertEquals((Object)three, (Object)e1.getKey());
        Map.Entry e2 = map.ceilingEntry(zero);
        TreeSubMapTest.assertEquals((Object)one, (Object)e2.getKey());
        Map.Entry e3 = map.ceilingEntry(five);
        TreeSubMapTest.assertEquals((Object)five, (Object)e3.getKey());
        Map.Entry e4 = map.ceilingEntry(six);
        TreeSubMapTest.assertNull(e4);
    }

    public void testPollFirstEntry() {
        NavigableMap map = TreeSubMapTest.map5();
        Map.Entry e = map.pollFirstEntry();
        TreeSubMapTest.assertEquals((Object)one, e.getKey());
        TreeSubMapTest.assertEquals((Object)"A", e.getValue());
        e = map.pollFirstEntry();
        TreeSubMapTest.assertEquals((Object)two, e.getKey());
        map.put(one, "A");
        e = map.pollFirstEntry();
        TreeSubMapTest.assertEquals((Object)one, e.getKey());
        TreeSubMapTest.assertEquals((Object)"A", e.getValue());
        e = map.pollFirstEntry();
        TreeSubMapTest.assertEquals((Object)three, e.getKey());
        map.remove(four);
        e = map.pollFirstEntry();
        TreeSubMapTest.assertEquals((Object)five, e.getKey());
        try {
            e.setValue("A");
            this.shouldThrow();
        }
        catch (UnsupportedOperationException success) {
            // empty catch block
        }
        TreeSubMapTest.assertTrue((boolean)map.isEmpty());
        Map.Entry f = map.firstEntry();
        TreeSubMapTest.assertNull(f);
        e = map.pollFirstEntry();
        TreeSubMapTest.assertNull(e);
    }

    public void testPollLastEntry() {
        NavigableMap map = TreeSubMapTest.map5();
        Map.Entry e = map.pollLastEntry();
        TreeSubMapTest.assertEquals((Object)five, e.getKey());
        TreeSubMapTest.assertEquals((Object)"E", e.getValue());
        e = map.pollLastEntry();
        TreeSubMapTest.assertEquals((Object)four, e.getKey());
        map.put(five, "E");
        e = map.pollLastEntry();
        TreeSubMapTest.assertEquals((Object)five, e.getKey());
        TreeSubMapTest.assertEquals((Object)"E", e.getValue());
        e = map.pollLastEntry();
        TreeSubMapTest.assertEquals((Object)three, e.getKey());
        map.remove(two);
        e = map.pollLastEntry();
        TreeSubMapTest.assertEquals((Object)one, e.getKey());
        try {
            e.setValue("E");
            this.shouldThrow();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        e = map.pollLastEntry();
        TreeSubMapTest.assertNull(e);
    }

    public void testSize() {
        NavigableMap map = TreeSubMapTest.map5();
        NavigableMap empty = TreeSubMapTest.map0();
        TreeSubMapTest.assertEquals((int)0, (int)empty.size());
        TreeSubMapTest.assertEquals((int)5, (int)map.size());
    }

    public void testToString() {
        NavigableMap map = TreeSubMapTest.map5();
        String s = map.toString();
        for (int i = 1; i <= 5; ++i) {
            TreeSubMapTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testGet_NullPointerException() {
        try {
            NavigableMap c = TreeSubMapTest.map5();
            c.get(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testContainsKey_NullPointerException() {
        try {
            NavigableMap c = TreeSubMapTest.map5();
            c.containsKey(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPut1_NullPointerException() {
        try {
            NavigableMap c = TreeSubMapTest.map5();
            c.put(null, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testRemove1_NullPointerException() {
        try {
            NavigableMap c = TreeSubMapTest.map5();
            c.remove(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testSerialization() throws Exception {
        NavigableMap q = TreeSubMapTest.map5();
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        NavigableMap r = (NavigableMap)in.readObject();
        TreeSubMapTest.assertFalse((boolean)r.isEmpty());
        TreeSubMapTest.assertEquals((int)q.size(), (int)r.size());
        TreeSubMapTest.assertTrue((boolean)q.equals(r));
        TreeSubMapTest.assertTrue((boolean)r.equals(q));
    }

    public void testSubMapContents() {
        NavigableMap map = TreeSubMapTest.map5();
        SortedMap sm = map.subMap(two, four);
        TreeSubMapTest.assertEquals((Object)two, (Object)sm.firstKey());
        TreeSubMapTest.assertEquals((Object)three, (Object)sm.lastKey());
        TreeSubMapTest.assertEquals((int)2, (int)sm.size());
        TreeSubMapTest.assertFalse((boolean)sm.containsKey(one));
        TreeSubMapTest.assertTrue((boolean)sm.containsKey(two));
        TreeSubMapTest.assertTrue((boolean)sm.containsKey(three));
        TreeSubMapTest.assertFalse((boolean)sm.containsKey(four));
        TreeSubMapTest.assertFalse((boolean)sm.containsKey(five));
        Iterator<Integer> i = sm.keySet().iterator();
        Integer k = i.next();
        TreeSubMapTest.assertEquals((Object)two, (Object)k);
        k = i.next();
        TreeSubMapTest.assertEquals((Object)three, (Object)k);
        TreeSubMapTest.assertFalse((boolean)i.hasNext());
        Iterator<Integer> j = sm.keySet().iterator();
        j.next();
        j.remove();
        TreeSubMapTest.assertFalse((boolean)map.containsKey(two));
        TreeSubMapTest.assertEquals((int)4, (int)map.size());
        TreeSubMapTest.assertEquals((int)1, (int)sm.size());
        TreeSubMapTest.assertEquals((Object)three, (Object)sm.firstKey());
        TreeSubMapTest.assertEquals((Object)three, (Object)sm.lastKey());
        TreeSubMapTest.assertEquals((Object)"C", sm.remove(three));
        TreeSubMapTest.assertTrue((boolean)sm.isEmpty());
        TreeSubMapTest.assertEquals((int)3, (int)map.size());
    }

    public void testSubMapContents2() {
        NavigableMap map = TreeSubMapTest.map5();
        SortedMap sm = map.subMap(two, three);
        TreeSubMapTest.assertEquals((int)1, (int)sm.size());
        TreeSubMapTest.assertEquals((Object)two, (Object)sm.firstKey());
        TreeSubMapTest.assertEquals((Object)two, (Object)sm.lastKey());
        TreeSubMapTest.assertFalse((boolean)sm.containsKey(one));
        TreeSubMapTest.assertTrue((boolean)sm.containsKey(two));
        TreeSubMapTest.assertFalse((boolean)sm.containsKey(three));
        TreeSubMapTest.assertFalse((boolean)sm.containsKey(four));
        TreeSubMapTest.assertFalse((boolean)sm.containsKey(five));
        Iterator<Integer> i = sm.keySet().iterator();
        Integer k = i.next();
        TreeSubMapTest.assertEquals((Object)two, (Object)k);
        TreeSubMapTest.assertFalse((boolean)i.hasNext());
        Iterator<Integer> j = sm.keySet().iterator();
        j.next();
        j.remove();
        TreeSubMapTest.assertFalse((boolean)map.containsKey(two));
        TreeSubMapTest.assertEquals((int)4, (int)map.size());
        TreeSubMapTest.assertEquals((int)0, (int)sm.size());
        TreeSubMapTest.assertTrue((boolean)sm.isEmpty());
        TreeSubMapTest.assertSame(sm.remove(three), null);
        TreeSubMapTest.assertEquals((int)4, (int)map.size());
    }

    public void testHeadMapContents() {
        NavigableMap map = TreeSubMapTest.map5();
        SortedMap sm = map.headMap(four);
        TreeSubMapTest.assertTrue((boolean)sm.containsKey(one));
        TreeSubMapTest.assertTrue((boolean)sm.containsKey(two));
        TreeSubMapTest.assertTrue((boolean)sm.containsKey(three));
        TreeSubMapTest.assertFalse((boolean)sm.containsKey(four));
        TreeSubMapTest.assertFalse((boolean)sm.containsKey(five));
        Iterator<Integer> i = sm.keySet().iterator();
        Integer k = i.next();
        TreeSubMapTest.assertEquals((Object)one, (Object)k);
        k = i.next();
        TreeSubMapTest.assertEquals((Object)two, (Object)k);
        k = i.next();
        TreeSubMapTest.assertEquals((Object)three, (Object)k);
        TreeSubMapTest.assertFalse((boolean)i.hasNext());
        sm.clear();
        TreeSubMapTest.assertTrue((boolean)sm.isEmpty());
        TreeSubMapTest.assertEquals((int)2, (int)map.size());
        TreeSubMapTest.assertEquals((Object)four, map.firstKey());
    }

    public void testTailMapContents() {
        NavigableMap map = TreeSubMapTest.map5();
        SortedMap sm = map.tailMap(two);
        TreeSubMapTest.assertFalse((boolean)sm.containsKey(one));
        TreeSubMapTest.assertTrue((boolean)sm.containsKey(two));
        TreeSubMapTest.assertTrue((boolean)sm.containsKey(three));
        TreeSubMapTest.assertTrue((boolean)sm.containsKey(four));
        TreeSubMapTest.assertTrue((boolean)sm.containsKey(five));
        Iterator<Integer> i = sm.keySet().iterator();
        Integer k = i.next();
        TreeSubMapTest.assertEquals((Object)two, (Object)k);
        k = i.next();
        TreeSubMapTest.assertEquals((Object)three, (Object)k);
        k = i.next();
        TreeSubMapTest.assertEquals((Object)four, (Object)k);
        k = i.next();
        TreeSubMapTest.assertEquals((Object)five, (Object)k);
        TreeSubMapTest.assertFalse((boolean)i.hasNext());
        Iterator ei = sm.entrySet().iterator();
        Map.Entry e = ei.next();
        TreeSubMapTest.assertEquals((Object)two, (Object)e.getKey());
        TreeSubMapTest.assertEquals((Object)"B", e.getValue());
        e = ei.next();
        TreeSubMapTest.assertEquals((Object)three, (Object)e.getKey());
        TreeSubMapTest.assertEquals((Object)"C", e.getValue());
        e = ei.next();
        TreeSubMapTest.assertEquals((Object)four, (Object)e.getKey());
        TreeSubMapTest.assertEquals((Object)"D", e.getValue());
        e = ei.next();
        TreeSubMapTest.assertEquals((Object)five, (Object)e.getKey());
        TreeSubMapTest.assertEquals((Object)"E", e.getValue());
        TreeSubMapTest.assertFalse((boolean)i.hasNext());
        SortedMap ssm = sm.tailMap(four);
        TreeSubMapTest.assertEquals((Object)four, (Object)ssm.firstKey());
        TreeSubMapTest.assertEquals((Object)five, (Object)ssm.lastKey());
        TreeSubMapTest.assertEquals((Object)"D", ssm.remove(four));
        TreeSubMapTest.assertEquals((int)1, (int)ssm.size());
        TreeSubMapTest.assertEquals((int)3, (int)sm.size());
        TreeSubMapTest.assertEquals((int)4, (int)map.size());
    }

    public void testDescendingClear() {
        NavigableMap map = TreeSubMapTest.dmap5();
        map.clear();
        TreeSubMapTest.assertEquals((int)map.size(), (int)0);
    }

    public void testDescendingEquals() {
        NavigableMap map1 = TreeSubMapTest.dmap5();
        NavigableMap map2 = TreeSubMapTest.dmap5();
        TreeSubMapTest.assertEquals((Object)map1, (Object)map2);
        TreeSubMapTest.assertEquals((Object)map2, (Object)map1);
        map1.clear();
        TreeSubMapTest.assertFalse((boolean)map1.equals(map2));
        TreeSubMapTest.assertFalse((boolean)map2.equals(map1));
    }

    public void testDescendingContainsKey() {
        NavigableMap map = TreeSubMapTest.dmap5();
        TreeSubMapTest.assertTrue((boolean)map.containsKey(m1));
        TreeSubMapTest.assertFalse((boolean)map.containsKey(zero));
    }

    public void testDescendingContainsValue() {
        NavigableMap map = TreeSubMapTest.dmap5();
        TreeSubMapTest.assertTrue((boolean)map.containsValue("A"));
        TreeSubMapTest.assertFalse((boolean)map.containsValue("Z"));
    }

    public void testDescendingGet() {
        NavigableMap map = TreeSubMapTest.dmap5();
        TreeSubMapTest.assertEquals((String)"A", (String)((String)map.get(m1)));
        NavigableMap empty = TreeSubMapTest.dmap0();
        TreeSubMapTest.assertNull(empty.get(m1));
    }

    public void testDescendingIsEmpty() {
        NavigableMap empty = TreeSubMapTest.dmap0();
        NavigableMap map = TreeSubMapTest.dmap5();
        TreeSubMapTest.assertTrue((boolean)empty.isEmpty());
        TreeSubMapTest.assertFalse((boolean)map.isEmpty());
    }

    public void testDescendingFirstKey() {
        NavigableMap map = TreeSubMapTest.dmap5();
        TreeSubMapTest.assertEquals((Object)m1, map.firstKey());
    }

    public void testDescendingLastKey() {
        NavigableMap map = TreeSubMapTest.dmap5();
        TreeSubMapTest.assertEquals((Object)m5, map.lastKey());
    }

    public void testDescendingKeySet() {
        NavigableMap map = TreeSubMapTest.dmap5();
        Set s = map.keySet();
        TreeSubMapTest.assertEquals((int)5, (int)s.size());
        TreeSubMapTest.assertTrue((boolean)s.contains(m1));
        TreeSubMapTest.assertTrue((boolean)s.contains(m2));
        TreeSubMapTest.assertTrue((boolean)s.contains(m3));
        TreeSubMapTest.assertTrue((boolean)s.contains(m4));
        TreeSubMapTest.assertTrue((boolean)s.contains(m5));
    }

    public void testDescendingKeySetOrder() {
        NavigableMap map = TreeSubMapTest.dmap5();
        Set s = map.keySet();
        Iterator i = s.iterator();
        Integer last = (Integer)i.next();
        TreeSubMapTest.assertEquals((Object)last, (Object)m1);
        while (i.hasNext()) {
            Integer k = (Integer)i.next();
            TreeSubMapTest.assertTrue((last.compareTo(k) > 0 ? 1 : 0) != 0);
            last = k;
        }
    }

    public void testDescendingValues() {
        NavigableMap map = TreeSubMapTest.dmap5();
        Collection s = map.values();
        TreeSubMapTest.assertEquals((int)5, (int)s.size());
        TreeSubMapTest.assertTrue((boolean)s.contains("A"));
        TreeSubMapTest.assertTrue((boolean)s.contains("B"));
        TreeSubMapTest.assertTrue((boolean)s.contains("C"));
        TreeSubMapTest.assertTrue((boolean)s.contains("D"));
        TreeSubMapTest.assertTrue((boolean)s.contains("E"));
    }

    public void testDescendingAscendingKeySetToArray() {
        NavigableMap map = TreeSubMapTest.dmap5();
        Set s = map.keySet();
        Object[] ar = s.toArray();
        TreeSubMapTest.assertTrue((boolean)s.containsAll(Arrays.asList(ar)));
        TreeSubMapTest.assertEquals((int)5, (int)ar.length);
        ar[0] = m10;
        TreeSubMapTest.assertFalse((boolean)s.containsAll(Arrays.asList(ar)));
    }

    public void testDescendingDescendingKeySetToArray() {
        NavigableMap map = TreeSubMapTest.dmap5();
        NavigableSet s = map.descendingKeySet();
        Object[] ar = s.toArray();
        TreeSubMapTest.assertEquals((int)5, (int)ar.length);
        TreeSubMapTest.assertTrue((boolean)s.containsAll(Arrays.asList(ar)));
        ar[0] = m10;
        TreeSubMapTest.assertFalse((boolean)s.containsAll(Arrays.asList(ar)));
    }

    public void testDescendingValuesToArray() {
        NavigableMap map = TreeSubMapTest.dmap5();
        Collection v = map.values();
        Object[] ar = v.toArray();
        ArrayList<Object> s = new ArrayList<Object>(Arrays.asList(ar));
        TreeSubMapTest.assertEquals((int)5, (int)ar.length);
        TreeSubMapTest.assertTrue((boolean)s.contains("A"));
        TreeSubMapTest.assertTrue((boolean)s.contains("B"));
        TreeSubMapTest.assertTrue((boolean)s.contains("C"));
        TreeSubMapTest.assertTrue((boolean)s.contains("D"));
        TreeSubMapTest.assertTrue((boolean)s.contains("E"));
    }

    public void testDescendingEntrySet() {
        NavigableMap map = TreeSubMapTest.dmap5();
        Set s = map.entrySet();
        TreeSubMapTest.assertEquals((int)5, (int)s.size());
        for (Map.Entry e : s) {
            TreeSubMapTest.assertTrue((e.getKey().equals(m1) && e.getValue().equals("A") || e.getKey().equals(m2) && e.getValue().equals("B") || e.getKey().equals(m3) && e.getValue().equals("C") || e.getKey().equals(m4) && e.getValue().equals("D") || e.getKey().equals(m5) && e.getValue().equals("E") ? 1 : 0) != 0);
        }
    }

    public void testDescendingPutAll() {
        NavigableMap empty = TreeSubMapTest.dmap0();
        NavigableMap map = TreeSubMapTest.dmap5();
        empty.putAll(map);
        TreeSubMapTest.assertEquals((int)5, (int)empty.size());
        TreeSubMapTest.assertTrue((boolean)empty.containsKey(m1));
        TreeSubMapTest.assertTrue((boolean)empty.containsKey(m2));
        TreeSubMapTest.assertTrue((boolean)empty.containsKey(m3));
        TreeSubMapTest.assertTrue((boolean)empty.containsKey(m4));
        TreeSubMapTest.assertTrue((boolean)empty.containsKey(m5));
    }

    public void testDescendingRemove() {
        NavigableMap map = TreeSubMapTest.dmap5();
        map.remove(m5);
        TreeSubMapTest.assertEquals((int)4, (int)map.size());
        TreeSubMapTest.assertFalse((boolean)map.containsKey(m5));
    }

    public void testDescendingLowerEntry() {
        NavigableMap map = TreeSubMapTest.dmap5();
        Map.Entry e1 = map.lowerEntry(m3);
        TreeSubMapTest.assertEquals((Object)m2, (Object)e1.getKey());
        Map.Entry e2 = map.lowerEntry(m6);
        TreeSubMapTest.assertEquals((Object)m5, (Object)e2.getKey());
        Map.Entry e3 = map.lowerEntry(m1);
        TreeSubMapTest.assertNull(e3);
        Map.Entry e4 = map.lowerEntry(zero);
        TreeSubMapTest.assertNull(e4);
    }

    public void testDescendingHigherEntry() {
        NavigableMap map = TreeSubMapTest.dmap5();
        Map.Entry e1 = map.higherEntry(m3);
        TreeSubMapTest.assertEquals((Object)m4, (Object)e1.getKey());
        Map.Entry e2 = map.higherEntry(zero);
        TreeSubMapTest.assertEquals((Object)m1, (Object)e2.getKey());
        Map.Entry e3 = map.higherEntry(m5);
        TreeSubMapTest.assertNull(e3);
        Map.Entry e4 = map.higherEntry(m6);
        TreeSubMapTest.assertNull(e4);
    }

    public void testDescendingFloorEntry() {
        NavigableMap map = TreeSubMapTest.dmap5();
        Map.Entry e1 = map.floorEntry(m3);
        TreeSubMapTest.assertEquals((Object)m3, (Object)e1.getKey());
        Map.Entry e2 = map.floorEntry(m6);
        TreeSubMapTest.assertEquals((Object)m5, (Object)e2.getKey());
        Map.Entry e3 = map.floorEntry(m1);
        TreeSubMapTest.assertEquals((Object)m1, (Object)e3.getKey());
        Map.Entry e4 = map.floorEntry(zero);
        TreeSubMapTest.assertNull(e4);
    }

    public void testDescendingCeilingEntry() {
        NavigableMap map = TreeSubMapTest.dmap5();
        Map.Entry e1 = map.ceilingEntry(m3);
        TreeSubMapTest.assertEquals((Object)m3, (Object)e1.getKey());
        Map.Entry e2 = map.ceilingEntry(zero);
        TreeSubMapTest.assertEquals((Object)m1, (Object)e2.getKey());
        Map.Entry e3 = map.ceilingEntry(m5);
        TreeSubMapTest.assertEquals((Object)m5, (Object)e3.getKey());
        Map.Entry e4 = map.ceilingEntry(m6);
        TreeSubMapTest.assertNull(e4);
    }

    public void testDescendingPollFirstEntry() {
        NavigableMap map = TreeSubMapTest.dmap5();
        Map.Entry e = map.pollFirstEntry();
        TreeSubMapTest.assertEquals((Object)m1, e.getKey());
        TreeSubMapTest.assertEquals((Object)"A", e.getValue());
        e = map.pollFirstEntry();
        TreeSubMapTest.assertEquals((Object)m2, e.getKey());
        map.put(m1, "A");
        e = map.pollFirstEntry();
        TreeSubMapTest.assertEquals((Object)m1, e.getKey());
        TreeSubMapTest.assertEquals((Object)"A", e.getValue());
        e = map.pollFirstEntry();
        TreeSubMapTest.assertEquals((Object)m3, e.getKey());
        map.remove(m4);
        e = map.pollFirstEntry();
        TreeSubMapTest.assertEquals((Object)m5, e.getKey());
        try {
            e.setValue("A");
            this.shouldThrow();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        e = map.pollFirstEntry();
        TreeSubMapTest.assertNull(e);
    }

    public void testDescendingPollLastEntry() {
        NavigableMap map = TreeSubMapTest.dmap5();
        Map.Entry e = map.pollLastEntry();
        TreeSubMapTest.assertEquals((Object)m5, e.getKey());
        TreeSubMapTest.assertEquals((Object)"E", e.getValue());
        e = map.pollLastEntry();
        TreeSubMapTest.assertEquals((Object)m4, e.getKey());
        map.put(m5, "E");
        e = map.pollLastEntry();
        TreeSubMapTest.assertEquals((Object)m5, e.getKey());
        TreeSubMapTest.assertEquals((Object)"E", e.getValue());
        e = map.pollLastEntry();
        TreeSubMapTest.assertEquals((Object)m3, e.getKey());
        map.remove(m2);
        e = map.pollLastEntry();
        TreeSubMapTest.assertEquals((Object)m1, e.getKey());
        try {
            e.setValue("E");
            this.shouldThrow();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        e = map.pollLastEntry();
        TreeSubMapTest.assertNull(e);
    }

    public void testDescendingSize() {
        NavigableMap map = TreeSubMapTest.dmap5();
        NavigableMap empty = TreeSubMapTest.dmap0();
        TreeSubMapTest.assertEquals((int)0, (int)empty.size());
        TreeSubMapTest.assertEquals((int)5, (int)map.size());
    }

    public void testDescendingToString() {
        NavigableMap map = TreeSubMapTest.dmap5();
        String s = map.toString();
        for (int i = 1; i <= 5; ++i) {
            TreeSubMapTest.assertTrue((s.indexOf(String.valueOf(i)) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testDescendingGet_NullPointerException() {
        try {
            NavigableMap c = TreeSubMapTest.dmap5();
            c.get(null);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDescendingPut1_NullPointerException() {
        try {
            NavigableMap c = TreeSubMapTest.dmap5();
            c.put(null, "whatever");
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testDescendingSerialization() throws Exception {
        NavigableMap q = TreeSubMapTest.dmap5();
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(bout));
        out.writeObject(q);
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(bin));
        NavigableMap r = (NavigableMap)in.readObject();
        TreeSubMapTest.assertEquals((int)q.size(), (int)r.size());
        TreeSubMapTest.assertTrue((boolean)q.equals(r));
        TreeSubMapTest.assertTrue((boolean)r.equals(q));
    }

    public void testDescendingSubMapContents() {
        NavigableMap map = TreeSubMapTest.dmap5();
        SortedMap sm = map.subMap(m2, m4);
        TreeSubMapTest.assertEquals((Object)m2, (Object)sm.firstKey());
        TreeSubMapTest.assertEquals((Object)m3, (Object)sm.lastKey());
        TreeSubMapTest.assertEquals((int)2, (int)sm.size());
        TreeSubMapTest.assertFalse((boolean)sm.containsKey(m1));
        TreeSubMapTest.assertTrue((boolean)sm.containsKey(m2));
        TreeSubMapTest.assertTrue((boolean)sm.containsKey(m3));
        TreeSubMapTest.assertFalse((boolean)sm.containsKey(m4));
        TreeSubMapTest.assertFalse((boolean)sm.containsKey(m5));
        Iterator<Integer> i = sm.keySet().iterator();
        Integer k = i.next();
        TreeSubMapTest.assertEquals((Object)m2, (Object)k);
        k = i.next();
        TreeSubMapTest.assertEquals((Object)m3, (Object)k);
        TreeSubMapTest.assertFalse((boolean)i.hasNext());
        Iterator<Integer> j = sm.keySet().iterator();
        j.next();
        j.remove();
        TreeSubMapTest.assertFalse((boolean)map.containsKey(m2));
        TreeSubMapTest.assertEquals((int)4, (int)map.size());
        TreeSubMapTest.assertEquals((int)1, (int)sm.size());
        TreeSubMapTest.assertEquals((Object)m3, (Object)sm.firstKey());
        TreeSubMapTest.assertEquals((Object)m3, (Object)sm.lastKey());
        TreeSubMapTest.assertEquals((Object)"C", sm.remove(m3));
        TreeSubMapTest.assertTrue((boolean)sm.isEmpty());
        TreeSubMapTest.assertEquals((int)3, (int)map.size());
    }

    public void testDescendingSubMapContents2() {
        NavigableMap map = TreeSubMapTest.dmap5();
        SortedMap sm = map.subMap(m2, m3);
        TreeSubMapTest.assertEquals((int)1, (int)sm.size());
        TreeSubMapTest.assertEquals((Object)m2, (Object)sm.firstKey());
        TreeSubMapTest.assertEquals((Object)m2, (Object)sm.lastKey());
        TreeSubMapTest.assertFalse((boolean)sm.containsKey(m1));
        TreeSubMapTest.assertTrue((boolean)sm.containsKey(m2));
        TreeSubMapTest.assertFalse((boolean)sm.containsKey(m3));
        TreeSubMapTest.assertFalse((boolean)sm.containsKey(m4));
        TreeSubMapTest.assertFalse((boolean)sm.containsKey(m5));
        Iterator<Integer> i = sm.keySet().iterator();
        Integer k = i.next();
        TreeSubMapTest.assertEquals((Object)m2, (Object)k);
        TreeSubMapTest.assertFalse((boolean)i.hasNext());
        Iterator<Integer> j = sm.keySet().iterator();
        j.next();
        j.remove();
        TreeSubMapTest.assertFalse((boolean)map.containsKey(m2));
        TreeSubMapTest.assertEquals((int)4, (int)map.size());
        TreeSubMapTest.assertEquals((int)0, (int)sm.size());
        TreeSubMapTest.assertTrue((boolean)sm.isEmpty());
        TreeSubMapTest.assertSame(sm.remove(m3), null);
        TreeSubMapTest.assertEquals((int)4, (int)map.size());
    }

    public void testDescendingHeadMapContents() {
        NavigableMap map = TreeSubMapTest.dmap5();
        SortedMap sm = map.headMap(m4);
        TreeSubMapTest.assertTrue((boolean)sm.containsKey(m1));
        TreeSubMapTest.assertTrue((boolean)sm.containsKey(m2));
        TreeSubMapTest.assertTrue((boolean)sm.containsKey(m3));
        TreeSubMapTest.assertFalse((boolean)sm.containsKey(m4));
        TreeSubMapTest.assertFalse((boolean)sm.containsKey(m5));
        Iterator<Integer> i = sm.keySet().iterator();
        Integer k = i.next();
        TreeSubMapTest.assertEquals((Object)m1, (Object)k);
        k = i.next();
        TreeSubMapTest.assertEquals((Object)m2, (Object)k);
        k = i.next();
        TreeSubMapTest.assertEquals((Object)m3, (Object)k);
        TreeSubMapTest.assertFalse((boolean)i.hasNext());
        sm.clear();
        TreeSubMapTest.assertTrue((boolean)sm.isEmpty());
        TreeSubMapTest.assertEquals((int)2, (int)map.size());
        TreeSubMapTest.assertEquals((Object)m4, map.firstKey());
    }

    public void testDescendingTailMapContents() {
        NavigableMap map = TreeSubMapTest.dmap5();
        SortedMap sm = map.tailMap(m2);
        TreeSubMapTest.assertFalse((boolean)sm.containsKey(m1));
        TreeSubMapTest.assertTrue((boolean)sm.containsKey(m2));
        TreeSubMapTest.assertTrue((boolean)sm.containsKey(m3));
        TreeSubMapTest.assertTrue((boolean)sm.containsKey(m4));
        TreeSubMapTest.assertTrue((boolean)sm.containsKey(m5));
        Iterator<Integer> i = sm.keySet().iterator();
        Integer k = i.next();
        TreeSubMapTest.assertEquals((Object)m2, (Object)k);
        k = i.next();
        TreeSubMapTest.assertEquals((Object)m3, (Object)k);
        k = i.next();
        TreeSubMapTest.assertEquals((Object)m4, (Object)k);
        k = i.next();
        TreeSubMapTest.assertEquals((Object)m5, (Object)k);
        TreeSubMapTest.assertFalse((boolean)i.hasNext());
        Iterator ei = sm.entrySet().iterator();
        Map.Entry e = ei.next();
        TreeSubMapTest.assertEquals((Object)m2, (Object)e.getKey());
        TreeSubMapTest.assertEquals((Object)"B", e.getValue());
        e = ei.next();
        TreeSubMapTest.assertEquals((Object)m3, (Object)e.getKey());
        TreeSubMapTest.assertEquals((Object)"C", e.getValue());
        e = ei.next();
        TreeSubMapTest.assertEquals((Object)m4, (Object)e.getKey());
        TreeSubMapTest.assertEquals((Object)"D", e.getValue());
        e = ei.next();
        TreeSubMapTest.assertEquals((Object)m5, (Object)e.getKey());
        TreeSubMapTest.assertEquals((Object)"E", e.getValue());
        TreeSubMapTest.assertFalse((boolean)i.hasNext());
        SortedMap ssm = sm.tailMap(m4);
        TreeSubMapTest.assertEquals((Object)m4, (Object)ssm.firstKey());
        TreeSubMapTest.assertEquals((Object)m5, (Object)ssm.lastKey());
        TreeSubMapTest.assertEquals((Object)"D", ssm.remove(m4));
        TreeSubMapTest.assertEquals((int)1, (int)ssm.size());
        TreeSubMapTest.assertEquals((int)3, (int)sm.size());
        TreeSubMapTest.assertEquals((int)4, (int)map.size());
    }
}

