/*
 * Decompiled with CFR 0.152.
 */
package com.jtstand.visa;

import com.jtstand.visa.Instrument;
import com.jtstand.visa.Visa;
import com.jtstand.visa.VisaInst;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VisaInstrument
implements Instrument {
    private Visa visa = new Visa();
    private VisaInst inst;

    public VisaInstrument(String instAddress) {
        this.inst = (VisaInst)this.visa.open(instAddress);
        if (this.inst == null) {
            System.out.println("could name open instrument at address:" + instAddress);
        }
    }

    @Override
    public String getIdn() throws IOException {
        return this.getResponseString(1000, "*IDN?\n");
    }

    @Override
    public void send(String command) throws IOException {
        System.out.println("<" + command);
        this.inst.write(command);
    }

    @Override
    public void send(byte[] data) throws IOException {
        this.inst.writeBytes(data);
    }

    @Override
    public String getResponseString(int timeout, String command) throws IOException {
        this.inst.write(command);
        this.inst.setAttribute(Visa.getVI_ATTR_TMO_VALUE(), timeout);
        this.inst.setAttribute(Visa.getVI_ATTR_TERMCHAR(), 10);
        this.inst.setAttribute(Visa.getVI_ATTR_TERMCHAR_EN(), 1);
        return this.inst.read();
    }

    @Override
    public String getResponseStringTrimmed(int timeout, String command) throws IOException {
        String response = this.getResponseString(timeout, command).trim();
        int space = response.lastIndexOf(" ");
        if (space >= 0) {
            return response.substring(space + 1);
        }
        return response.startsWith("+") ? response.substring(1) : response;
    }

    @Override
    public int getResponseInteger(int timeout, String command) throws IOException {
        return Integer.parseInt(this.getResponseStringTrimmed(timeout, command));
    }

    @Override
    public double getResponseDouble(int timeout, String command) throws IOException {
        return Double.parseDouble(this.getResponseStringTrimmed(timeout, command));
    }

    @Override
    public byte[] getResponseBytes(int timeout, String command, int length) throws IOException {
        this.inst.write(command);
        return this.readBytes(timeout, length);
    }

    @Override
    public byte[] getResponseBytes(int timeout, String command, byte[] retval) throws IOException {
        this.inst.write(command);
        return this.readBytes(timeout, retval);
    }

    @Override
    public byte[] readBytes(int timeout, int length) throws IOException {
        return this.readBytes(timeout, new byte[length]);
    }

    @Override
    public byte[] readBytes(int timeout, byte[] retval) throws IOException {
        this.inst.setAttribute(Visa.getVI_ATTR_TMO_VALUE(), timeout);
        this.inst.setAttribute(Visa.getVI_ATTR_TERMCHAR_EN(), 0);
        return this.inst.readBytes(retval);
    }

    @Override
    public void close() throws IOException {
        this.inst.close();
    }

    public static void main(String[] args) {
        VisaInstrument i = new VisaInstrument("USB0::0x0957::0x2007::MY49001053::0::INSTR");
        try {
            System.out.println("ID:" + i.getIdn());
        }
        catch (IOException ex) {
            Logger.getLogger(VisaInstrument.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

