/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.jfree.text.TextUtilities;
import org.jfree.ui.TextAnchor;

public class DrawStringPanel
extends JPanel {
    private static final Dimension PREFERRED_SIZE = new Dimension(500, 300);
    private boolean rotate;
    private String text = "Hello World";
    private TextAnchor anchor = TextAnchor.TOP_LEFT;
    private TextAnchor rotationAnchor = TextAnchor.TOP_LEFT;
    private Font font = new Font("Serif", 0, 12);
    private double angle;

    public DrawStringPanel(String text, boolean rotate) {
        this.text = text;
        this.rotate = rotate;
    }

    @Override
    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    public void setAnchor(TextAnchor anchor) {
        this.anchor = anchor;
    }

    public void setRotationAnchor(TextAnchor anchor) {
        this.rotationAnchor = anchor;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        Rectangle2D.Double available = new Rectangle2D.Double(insets.left, insets.top, size.getWidth() - (double)insets.left - (double)insets.right, size.getHeight() - (double)insets.top - (double)insets.bottom);
        double x = available.getCenterX();
        double y = available.getCenterY();
        Line2D.Double line1 = new Line2D.Double(x - 2.0, y + 2.0, x + 2.0, y - 2.0);
        Line2D.Double line2 = new Line2D.Double(x - 2.0, y - 2.0, x + 2.0, y + 2.0);
        g2.setPaint(Color.red);
        g2.draw(line1);
        g2.draw(line2);
        g2.setFont(this.font);
        g2.setPaint(Color.black);
        if (this.rotate) {
            TextUtilities.drawRotatedString(this.text, g2, (float)x, (float)y, this.anchor, this.angle, this.rotationAnchor);
        } else {
            TextUtilities.drawAlignedString(this.text, g2, (float)x, (float)y, this.anchor);
        }
    }
}

