/*
 * Copyright (c) 2009 Albert Kurucz. 
 *
 * This file, LogTarget.java is part of JTStand.
 *
 * JTStand is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JTStand is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with GTStand.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.jfree.util;

/**
 * An interface that defines a log target (a consumer of log messages).  Classes which
 * implement this interface can be registered with the {@link org.jfree.util.Log} class
 * and will then receive logging messages generated by the code.
 *
 * @author Thomas Morgner
 */
public interface LogTarget {

    /**
     * Loglevel ERROR.
     */
    public static final int ERROR = 0;

    /**
     * Loglevel WARN.
     */
    public static final int WARN = 1;

    /**
     * Loglevel INFO.
     */
    public static final int INFO = 2;

    /**
     * Loglevel DEBUG.
     */
    public static final int DEBUG = 3;

    /** Strings for the log levels. */
    public static final String[] LEVELS =
        {
            "ERROR: ",
            "WARN:  ",
            "INFO:  ",
            "DEBUG: "
        };

    /**
     * Logs a message at a specified log level.
     *
     * @param level  the log level.
     * @param message  the log message.
     */
    public void log(int level, Object message);

    /**
     * Logs a message at a specified log level.
     *
     * @param level  the log level.
     * @param message  the log message.
     * @param e  the exception
     */
    public void log(int level, Object message, Exception e);
}
