/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.awt.geom.Dimension2D;
import org.jfree.ui.FloatDimension;
import org.jfree.xml.factory.objects.AbstractObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class Dimension2DObjectDescription
extends AbstractObjectDescription {
    public Dimension2DObjectDescription() {
        super(Dimension2D.class);
        this.setParameterDefinition("width", Float.class);
        this.setParameterDefinition("height", Float.class);
    }

    @Override
    public Object createObject() {
        FloatDimension dim = new FloatDimension();
        float width = this.getFloatParameter("width");
        float height = this.getFloatParameter("height");
        ((Dimension2D)dim).setSize(width, height);
        return dim;
    }

    private float getFloatParameter(String param) {
        Float p = (Float)this.getParameter(param);
        if (p == null) {
            return 0.0f;
        }
        return p.floatValue();
    }

    @Override
    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (!(o instanceof Dimension2D)) {
            throw new ObjectFactoryException("The given object is no java.awt.geom.Dimension2D.");
        }
        Dimension2D dim = (Dimension2D)o;
        float width = (float)dim.getWidth();
        float height = (float)dim.getHeight();
        this.setParameter("width", new Float(width));
        this.setParameter("height", new Float(height));
    }
}

