/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.io.IOException;
import java.io.Writer;
import org.jfree.xml.generator.model.ClassDescription;
import org.jfree.xml.generator.model.Comments;
import org.jfree.xml.generator.model.DescriptionModel;
import org.jfree.xml.generator.model.IgnoredPropertyInfo;
import org.jfree.xml.generator.model.ManualMappingInfo;
import org.jfree.xml.generator.model.MultiplexMappingInfo;
import org.jfree.xml.generator.model.PropertyInfo;
import org.jfree.xml.generator.model.PropertyType;
import org.jfree.xml.generator.model.TypeInfo;
import org.jfree.xml.writer.AttributeList;
import org.jfree.xml.writer.SafeTagList;
import org.jfree.xml.writer.XMLWriterSupport;

public class ModelWriter {
    private static SafeTagList safeTags;
    private XMLWriterSupport writerSupport = new XMLWriterSupport(ModelWriter.getSafeTags(), 0);
    private DescriptionModel model;

    public static SafeTagList getSafeTags() {
        if (safeTags == null) {
            safeTags = new SafeTagList();
            safeTags.add("objects");
            safeTags.add("object");
            safeTags.add("constructor");
            safeTags.add("element-property");
            safeTags.add("lookup");
            safeTags.add("attribute-property");
            safeTags.add("parameter");
            safeTags.add("include");
            safeTags.add("ignore");
            safeTags.add("manual");
            safeTags.add("mapping");
            safeTags.add("type");
        }
        return safeTags;
    }

    public DescriptionModel getModel() {
        return this.model;
    }

    public void setModel(DescriptionModel model) {
        this.model = model;
    }

    public static void writeXMLHeader(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.write(XMLWriterSupport.getLineSeparator());
    }

    protected void writeStandardComment(Writer writer, Comments comments) throws IOException {
        if (comments == null || comments.getOpenTagComment() == null) {
            writer.write("<!-- CVSTag: $Id: ModelWriter.java,v 1.3 2005/10/18 13:32:20 mungady Exp $ " + comments + " -->");
            writer.write(XMLWriterSupport.getLineSeparator());
        } else {
            this.writeComment(writer, comments.getOpenTagComment());
        }
    }

    protected void writeComment(Writer writer, String[] comments) throws IOException {
        if (comments == null) {
            return;
        }
        for (int i = 0; i < comments.length; ++i) {
            this.writerSupport.indent(writer, 3);
            writer.write("<!--");
            writer.write(comments[i]);
            writer.write("-->");
            writer.write(XMLWriterSupport.getLineSeparator());
        }
    }

    protected void writeOpenComment(Writer writer, Comments comments) throws IOException {
        if (comments == null) {
            return;
        }
        if (comments.getOpenTagComment() == null) {
            return;
        }
        this.writeComment(writer, comments.getOpenTagComment());
    }

    protected void writeCloseComment(Writer writer, Comments comments) throws IOException {
        if (comments == null) {
            return;
        }
        if (comments.getCloseTagComment() == null) {
            return;
        }
        this.writeComment(writer, comments.getCloseTagComment());
    }

    protected void writeTag(Writer writer, String tagName, AttributeList attributes, Comments comments) throws IOException {
        if (comments == null) {
            this.writerSupport.writeTag(writer, tagName, attributes, true);
        } else {
            this.writeOpenComment(writer, comments);
            if (comments.getCloseTagComment() != null) {
                this.writerSupport.writeTag(writer, tagName, attributes, false);
                this.writeCloseComment(writer, comments);
                this.writerSupport.writeCloseTag(writer, tagName);
            } else {
                this.writerSupport.writeTag(writer, tagName, attributes, true);
            }
        }
    }

    protected void writeTag(Writer writer, String tagName, String attribute, String value, Comments comments) throws IOException {
        if (comments == null) {
            this.writerSupport.writeTag(writer, tagName, attribute, value, true);
        } else {
            this.writeOpenComment(writer, comments);
            if (comments.getCloseTagComment() != null) {
                this.writerSupport.writeTag(writer, tagName, attribute, value, false);
                this.writeCloseComment(writer, comments);
                this.writerSupport.writeCloseTag(writer, tagName);
            } else {
                this.writerSupport.writeTag(writer, tagName, attribute, value, true);
            }
        }
    }

    public void write(Writer writer) throws IOException {
        int i;
        this.writeStandardComment(writer, this.model.getModelComments());
        this.writerSupport.writeTag(writer, "objects");
        String[] sources = this.model.getSources();
        for (i = 0; i < sources.length; ++i) {
            Comments comments = this.model.getIncludeComment(sources[i]);
            this.writeTag(writer, "include", "src", sources[i], comments);
        }
        for (i = 0; i < this.model.size(); ++i) {
            ClassDescription cd = this.model.get(i);
            this.writeClassDescription(writer, cd);
        }
        ManualMappingInfo[] mappings = this.getModel().getMappingModel().getManualMapping();
        for (int i2 = 0; i2 < mappings.length; ++i2) {
            ManualMappingInfo mi = mappings[i2];
            this.writeManualMapping(writer, mi);
        }
        MultiplexMappingInfo[] mmappings = this.getModel().getMappingModel().getMultiplexMapping();
        for (int i3 = 0; i3 < mmappings.length; ++i3) {
            MultiplexMappingInfo mi = mmappings[i3];
            this.writeMultiplexMapping(writer, mi);
        }
        this.writeCloseComment(writer, this.model.getModelComments());
        this.writerSupport.writeCloseTag(writer, "objects");
    }

    protected void writeManualMapping(Writer writer, ManualMappingInfo mi) throws IOException {
        AttributeList al = new AttributeList();
        al.setAttribute("class", mi.getBaseClass().getName());
        al.setAttribute("read-handler", mi.getReadHandler().getName());
        al.setAttribute("write-handler", mi.getWriteHandler().getName());
        this.writeTag(writer, "manual", al, mi.getComments());
    }

    protected void writeMultiplexMapping(Writer writer, MultiplexMappingInfo mi) throws IOException {
        TypeInfo[] tis = mi.getChildClasses();
        AttributeList al = new AttributeList();
        al.setAttribute("base-class", mi.getBaseClass().getName());
        al.setAttribute("type-attribute", mi.getTypeAttribute());
        this.getWriterSupport().writeTag(writer, "mapping", al, false);
        for (int j = 0; j < tis.length; ++j) {
            AttributeList tiAttr = new AttributeList();
            tiAttr.setAttribute("name", tis[j].getName());
            tiAttr.setAttribute("class", tis[j].getType().getName());
            this.writeTag(writer, "type", tiAttr, tis[j].getComments());
        }
        this.getWriterSupport().writeCloseTag(writer, "mapping");
    }

    protected void writeClassDescription(Writer writer, ClassDescription cd) throws IOException {
        if (cd.isUndefined()) {
            return;
        }
        AttributeList al = new AttributeList();
        al.setAttribute("class", cd.getName());
        if (cd.getRegisterKey() != null) {
            al.setAttribute("register-name", cd.getRegisterKey());
        }
        if (cd.isPreserve()) {
            al.setAttribute("ignore", "true");
        }
        this.writerSupport.writeTag(writer, "object", al, false);
        TypeInfo[] constructorInfo = cd.getConstructorDescription();
        if (constructorInfo != null && constructorInfo.length != 0) {
            this.writerSupport.writeTag(writer, "constructor");
            for (int i = 0; i < constructorInfo.length; ++i) {
                AttributeList constructorList = new AttributeList();
                constructorList.setAttribute("class", constructorInfo[i].getType().getName());
                constructorList.setAttribute("property", constructorInfo[i].getName());
                this.writeTag(writer, "parameter", constructorList, constructorInfo[i].getComments());
            }
            this.writerSupport.writeCloseTag(writer, "constructor");
        }
        PropertyInfo[] properties = cd.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            this.writePropertyInfo(writer, properties[i]);
        }
        this.writerSupport.writeCloseTag(writer, "object");
    }

    private void writePropertyInfo(Writer writer, PropertyInfo ipi) throws IOException {
        AttributeList props = new AttributeList();
        props.setAttribute("name", ipi.getName());
        if (ipi instanceof IgnoredPropertyInfo) {
            this.writeTag(writer, "ignore", props, ipi.getComments());
            return;
        }
        if (ipi.getPropertyType().equals(PropertyType.ATTRIBUTE)) {
            props.setAttribute("attribute", ipi.getXmlName());
            props.setAttribute("handler", ipi.getXmlHandler());
            this.writeTag(writer, "attribute-property", props, ipi.getComments());
        } else if (ipi.getPropertyType().equals(PropertyType.ELEMENT)) {
            if (ipi.getComments() == null || ipi.getComments().getOpenTagComment() == null) {
                this.writerSupport.indent(writer, 3);
                writer.write("<!-- property type is " + ipi.getType() + " -->");
                writer.write(System.getProperty("line.separator", "\n"));
            }
            props.setAttribute("element", ipi.getXmlName());
            this.writeTag(writer, "element-property", props, ipi.getComments());
        } else {
            props.setAttribute("lookup", ipi.getXmlName());
            this.writeTag(writer, "lookup", props, ipi.getComments());
        }
    }

    public XMLWriterSupport getWriterSupport() {
        return this.writerSupport;
    }
}

