/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.demo.DrawStringPanel;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.FontChooserPanel;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class DrawStringDemo
extends ApplicationFrame
implements ActionListener,
ChangeListener {
    private JComboBox combo1;
    private JComboBox combo2;
    private JComboBox combo3;
    private JSlider slider;
    private DrawStringPanel drawStringPanel1;
    private DrawStringPanel drawStringPanel2;

    public DrawStringDemo(String title) {
        super(title);
        this.setContentPane(this.createContentPane());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("fontButton.clicked")) {
            this.displayFontDialog();
        }
        if (event.getActionCommand().equals("combo1.changed")) {
            this.handleCombo1Change();
        }
        if (event.getActionCommand().equals("combo2.changed")) {
            this.handleCombo2Change();
        }
        if (event.getActionCommand().equals("combo3.changed")) {
            this.handleCombo3Change();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        int r = this.slider.getValue();
        double angle = Math.PI * 2 * ((double)r / 360.0);
        this.drawStringPanel2.setAngle(angle);
        this.drawStringPanel2.invalidate();
        this.drawStringPanel2.repaint();
    }

    private void handleCombo1Change() {
        String text = this.combo1.getSelectedItem().toString();
        this.drawStringPanel1.setAnchor(this.convertStringToAnchor(text));
        this.drawStringPanel1.invalidate();
        this.drawStringPanel1.repaint();
    }

    private void handleCombo2Change() {
        String text = this.combo2.getSelectedItem().toString();
        this.drawStringPanel2.setAnchor(this.convertStringToAnchor(text));
        this.drawStringPanel2.invalidate();
        this.drawStringPanel2.repaint();
    }

    private void handleCombo3Change() {
        String text = this.combo3.getSelectedItem().toString();
        this.drawStringPanel2.setRotationAnchor(this.convertStringToAnchor(text));
        this.drawStringPanel2.invalidate();
        this.drawStringPanel2.repaint();
    }

    private JPanel createContentPane() {
        JPanel content = new JPanel(new BorderLayout());
        JTabbedPane tabs = new JTabbedPane();
        tabs.add("Alignment", this.createTab1Content());
        tabs.add("Rotation", this.createTab2Content());
        content.add(tabs);
        return content;
    }

    private JPanel createTab1Content() {
        JPanel content = new JPanel(new BorderLayout());
        this.combo1 = new JComboBox();
        this.combo1.setActionCommand("combo1.changed");
        this.populateTextAnchorCombo(this.combo1);
        this.combo1.addActionListener(this);
        JPanel controls = new JPanel();
        controls.add(this.combo1);
        JButton fontButton = new JButton("Select Font...");
        fontButton.setActionCommand("fontButton.clicked");
        fontButton.addActionListener(this);
        controls.add(fontButton);
        content.add((Component)controls, "North");
        this.drawStringPanel1 = new DrawStringPanel("0123456789", false);
        content.add(this.drawStringPanel1);
        return content;
    }

    private JPanel createTab2Content() {
        JPanel content = new JPanel(new BorderLayout());
        JPanel controls = new JPanel();
        controls.add(new JLabel("Text anchor: "));
        this.combo2 = new JComboBox();
        this.populateTextAnchorCombo(this.combo2);
        this.combo2.setActionCommand("combo2.changed");
        this.combo2.addActionListener(this);
        controls.add(this.combo2);
        controls.add(new JLabel("Rotation anchor: "));
        this.combo3 = new JComboBox();
        this.populateTextAnchorCombo(this.combo3);
        this.combo3.setActionCommand("combo3.changed");
        this.combo3.addActionListener(this);
        controls.add(this.combo3);
        this.slider = new JSlider(1, 0, 360, 0);
        this.slider.setMajorTickSpacing(45);
        this.slider.setMinorTickSpacing(5);
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.setPaintTrack(true);
        this.slider.addChangeListener(this);
        content.add((Component)controls, "North");
        content.add((Component)this.slider, "West");
        this.drawStringPanel2 = new DrawStringPanel("Rotated Text", true);
        content.add(this.drawStringPanel2);
        return content;
    }

    private void displayFontDialog() {
        FontChooserPanel panel = new FontChooserPanel(this.drawStringPanel1.getFont());
        int result = JOptionPane.showConfirmDialog(this, panel, "Font Selection", 2, -1);
        if (result == 0) {
            this.drawStringPanel1.setFont(panel.getSelectedFont());
            this.drawStringPanel2.setFont(panel.getSelectedFont());
        }
    }

    private void populateTextAnchorCombo(JComboBox combo) {
        combo.addItem("TextAnchor.TOP_LEFT");
        combo.addItem("TextAnchor.TOP_CENTER");
        combo.addItem("TextAnchor.TOP_RIGHT");
        combo.addItem("TextAnchor.HALF_ASCENT_LEFT");
        combo.addItem("TextAnchor.HALF_ASCENT_CENTER");
        combo.addItem("TextAnchor.HALF_ASCENT_RIGHT");
        combo.addItem("TextAnchor.CENTER_LEFT");
        combo.addItem("TextAnchor.CENTER");
        combo.addItem("TextAnchor.CENTER_RIGHT");
        combo.addItem("TextAnchor.BASELINE_LEFT");
        combo.addItem("TextAnchor.BASELINE_CENTER");
        combo.addItem("TextAnchor.BASELINE_RIGHT");
        combo.addItem("TextAnchor.BOTTOM_LEFT");
        combo.addItem("TextAnchor.BOTTOM_CENTER");
        combo.addItem("TextAnchor.BOTTOM_RIGHT");
    }

    private TextAnchor convertStringToAnchor(String text) {
        if (text.equals("TextAnchor.TOP_LEFT")) {
            return TextAnchor.TOP_LEFT;
        }
        if (text.equals("TextAnchor.TOP_CENTER")) {
            return TextAnchor.TOP_CENTER;
        }
        if (text.equals("TextAnchor.TOP_RIGHT")) {
            return TextAnchor.TOP_RIGHT;
        }
        if (text.equals("TextAnchor.CENTER_LEFT")) {
            return TextAnchor.CENTER_LEFT;
        }
        if (text.equals("TextAnchor.CENTER")) {
            return TextAnchor.CENTER;
        }
        if (text.equals("TextAnchor.CENTER_RIGHT")) {
            return TextAnchor.CENTER_RIGHT;
        }
        if (text.equals("TextAnchor.HALF_ASCENT_LEFT")) {
            return TextAnchor.HALF_ASCENT_LEFT;
        }
        if (text.equals("TextAnchor.HALF_ASCENT_CENTER")) {
            return TextAnchor.HALF_ASCENT_CENTER;
        }
        if (text.equals("TextAnchor.HALF_ASCENT_RIGHT")) {
            return TextAnchor.HALF_ASCENT_RIGHT;
        }
        if (text.equals("TextAnchor.BASELINE_LEFT")) {
            return TextAnchor.BASELINE_LEFT;
        }
        if (text.equals("TextAnchor.BASELINE_CENTER")) {
            return TextAnchor.BASELINE_CENTER;
        }
        if (text.equals("TextAnchor.BASELINE_RIGHT")) {
            return TextAnchor.BASELINE_RIGHT;
        }
        if (text.equals("TextAnchor.BOTTOM_LEFT")) {
            return TextAnchor.BOTTOM_LEFT;
        }
        if (text.equals("TextAnchor.BOTTOM_CENTER")) {
            return TextAnchor.BOTTOM_CENTER;
        }
        if (text.equals("TextAnchor.BOTTOM_RIGHT")) {
            return TextAnchor.BOTTOM_RIGHT;
        }
        return null;
    }

    public static void main(String[] args) {
        DrawStringDemo demo = new DrawStringDemo("DrawString Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

