/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import org.jfree.util.Log;
import org.jfree.xml.generator.JavaSourceCollector;
import org.jfree.xml.generator.ModelBuilder;
import org.jfree.xml.generator.ModelWriter;
import org.jfree.xml.generator.SplittingModelWriter;
import org.jfree.xml.generator.model.DescriptionModel;

public final class DescriptionGenerator {
    private static Properties loadProperties(URL propertyURL) {
        Properties p = new Properties();
        try {
            BufferedInputStream in = new BufferedInputStream(propertyURL.openStream());
            p.load(in);
            ((InputStream)in).close();
        }
        catch (Exception e) {
            System.err.println("Unable to load properties from " + propertyURL);
        }
        return p;
    }

    public static DescriptionModel generate(String source, Properties configuration, DescriptionModel model) {
        JavaSourceCollector jsc = new JavaSourceCollector(new File(source));
        for (String string : configuration.keySet()) {
            if (string.startsWith("ignore.baseclass.")) {
                jsc.addIgnoredBaseClass(configuration.getProperty(string));
                continue;
            }
            if (!string.startsWith("ignore.package.")) continue;
            jsc.addIgnoredPackage(configuration.getProperty(string));
        }
        jsc.collectFiles();
        return ModelBuilder.getInstance().buildModel(jsc, model);
    }

    public static void writeSingleFile(String target, DescriptionModel model) throws IOException {
        Log.debug("Writing ...");
        ModelWriter writer = new ModelWriter();
        writer.setModel(model);
        BufferedWriter w = new BufferedWriter(new FileWriter(target));
        writer.write(w);
        ((Writer)w).close();
    }

    public static void writeMultiFile(String target, DescriptionModel model) throws IOException {
        Log.debug("Writing multiple files ...");
        SplittingModelWriter writer = new SplittingModelWriter();
        writer.setModel(model);
        writer.write(target);
    }
}

