/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.net.URL;
import java.util.ArrayList;
import org.jfree.io.IOUtils;
import org.jfree.xml.generator.ModelBuilder;
import org.jfree.xml.generator.model.ClassDescription;
import org.jfree.xml.generator.model.Comments;
import org.jfree.xml.generator.model.DescriptionModel;
import org.jfree.xml.generator.model.IgnoredPropertyInfo;
import org.jfree.xml.generator.model.ManualMappingInfo;
import org.jfree.xml.generator.model.MultiplexMappingInfo;
import org.jfree.xml.generator.model.PropertyInfo;
import org.jfree.xml.generator.model.PropertyType;
import org.jfree.xml.generator.model.TypeInfo;
import org.jfree.xml.util.AbstractModelReader;
import org.jfree.xml.util.ObjectDescriptionException;

public class DefaultModelReader
extends AbstractModelReader {
    private DescriptionModel model;
    private ClassDescription currentClassDescription;
    private BeanInfo currentBeanInfo;
    private URL baseURL;
    private String source;
    private MultiplexMappingInfo multiplexInfo;
    private ArrayList multiplexTypeInfos;
    private ArrayList propertyList;
    private ArrayList constructorList;

    protected void fillSuperClasses() {
        for (int i = 0; i < this.model.size(); ++i) {
            ClassDescription superCD;
            ClassDescription cd = this.model.get(i);
            Class parent = cd.getObjectClass().getSuperclass();
            if (parent == null || (superCD = this.model.get(parent)) == null) continue;
            cd.setSuperClass(superCD.getObjectClass());
        }
    }

    @Override
    protected boolean startObjectDefinition(String className, String register, boolean ignore) {
        Class c = this.loadClass(className);
        if (c == null) {
            return false;
        }
        this.currentClassDescription = new ClassDescription(c);
        this.currentClassDescription.setPreserve(ignore);
        this.currentClassDescription.setRegisterKey(register);
        try {
            this.currentBeanInfo = Introspector.getBeanInfo(c, Object.class);
        }
        catch (IntrospectionException ie) {
            return false;
        }
        this.propertyList = new ArrayList();
        this.constructorList = new ArrayList();
        return true;
    }

    @Override
    protected void endObjectDefinition() throws ObjectDescriptionException {
        PropertyInfo[] pis = this.propertyList.toArray(new PropertyInfo[this.propertyList.size()]);
        this.currentClassDescription.setProperties(pis);
        TypeInfo[] tis = this.constructorList.toArray(new TypeInfo[this.constructorList.size()]);
        this.currentClassDescription.setConstructorDescription(tis);
        this.currentClassDescription.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        this.currentClassDescription.setSource(this.source);
        this.model.addClassDescription(this.currentClassDescription);
        this.propertyList = null;
        this.currentBeanInfo = null;
        this.currentClassDescription = null;
    }

    @Override
    protected void handleAttributeDefinition(String name, String attribName, String handlerClass) throws ObjectDescriptionException {
        PropertyInfo propertyInfo = ModelBuilder.getInstance().createSimplePropertyInfo(this.getPropertyDescriptor(name));
        if (propertyInfo == null) {
            throw new ObjectDescriptionException("Unable to load property " + name);
        }
        propertyInfo.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        propertyInfo.setPropertyType(PropertyType.ATTRIBUTE);
        propertyInfo.setXmlName(attribName);
        propertyInfo.setXmlHandler(handlerClass);
        this.propertyList.add(propertyInfo);
    }

    @Override
    protected void handleConstructorDefinition(String tagName, String parameterClass) throws ObjectDescriptionException {
        Class c = this.loadClass(parameterClass);
        if (c == null) {
            throw new ObjectDescriptionException("Failed to load class " + parameterClass);
        }
        TypeInfo ti = new TypeInfo(tagName, c);
        ti.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        this.constructorList.add(ti);
    }

    @Override
    protected void handleElementDefinition(String name, String element) throws ObjectDescriptionException {
        PropertyInfo propertyInfo = ModelBuilder.getInstance().createSimplePropertyInfo(this.getPropertyDescriptor(name));
        if (propertyInfo == null) {
            throw new ObjectDescriptionException("Unable to load property " + name);
        }
        propertyInfo.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        propertyInfo.setPropertyType(PropertyType.ELEMENT);
        propertyInfo.setXmlName(element);
        propertyInfo.setXmlHandler(null);
        this.propertyList.add(propertyInfo);
    }

    @Override
    protected void handleLookupDefinition(String name, String lookupKey) throws ObjectDescriptionException {
        PropertyInfo propertyInfo = ModelBuilder.getInstance().createSimplePropertyInfo(this.getPropertyDescriptor(name));
        if (propertyInfo == null) {
            throw new ObjectDescriptionException("Unable to load property " + name);
        }
        propertyInfo.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        propertyInfo.setPropertyType(PropertyType.LOOKUP);
        propertyInfo.setXmlName(lookupKey);
        propertyInfo.setXmlHandler(null);
        this.propertyList.add(propertyInfo);
    }

    protected PropertyDescriptor getPropertyDescriptor(String propertyName) {
        PropertyDescriptor[] pds = this.currentBeanInfo.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            if (!pds[i].getName().equals(propertyName)) continue;
            return pds[i];
        }
        return null;
    }

    @Override
    protected void handleIgnoredProperty(String name) {
        IgnoredPropertyInfo propertyInfo = new IgnoredPropertyInfo(name);
        propertyInfo.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        this.propertyList.add(propertyInfo);
    }

    @Override
    protected boolean handleManualMapping(String className, String readHandler, String writeHandler) throws ObjectDescriptionException {
        ManualMappingInfo manualMappingInfo = new ManualMappingInfo(this.loadClass(className), this.loadClass(readHandler), this.loadClass(writeHandler));
        manualMappingInfo.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        manualMappingInfo.setSource(this.source);
        this.model.getMappingModel().addManualMapping(manualMappingInfo);
        return true;
    }

    @Override
    protected void startMultiplexMapping(String className, String typeAttr) {
        this.multiplexInfo = new MultiplexMappingInfo(this.loadClass(className), typeAttr);
        this.multiplexInfo.setSource(this.source);
        this.multiplexTypeInfos = new ArrayList();
    }

    @Override
    protected void handleMultiplexMapping(String typeName, String className) throws ObjectDescriptionException {
        TypeInfo info = new TypeInfo(typeName, this.loadClass(className));
        info.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        this.multiplexTypeInfos.add(info);
    }

    @Override
    protected void endMultiplexMapping() throws ObjectDescriptionException {
        TypeInfo[] typeInfos = this.multiplexTypeInfos.toArray(new TypeInfo[this.multiplexTypeInfos.size()]);
        this.multiplexInfo.setComments(new Comments(this.getOpenComment(), this.getCloseComment()));
        this.multiplexInfo.setChildClasses(typeInfos);
        this.model.getMappingModel().addMultiplexMapping(this.multiplexInfo);
        this.multiplexInfo = null;
    }

    @Override
    protected void startIncludeHandling(URL resource) {
        this.source = IOUtils.getInstance().createRelativeURL(resource, this.baseURL);
        this.model.addSource(this.source);
        this.model.addIncludeComment(this.source, new Comments(this.getOpenComment(), this.getCloseComment()));
    }

    @Override
    protected void endIncludeHandling() {
        this.source = "";
    }

    @Override
    protected void startRootDocument() {
        this.source = "";
    }

    @Override
    protected void endRootDocument() {
        this.model.setModelComments(new Comments(this.getOpenComment(), this.getCloseComment()));
    }
}

