/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.jfree.xml.parser.AbstractXmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.jfree.xml.util.Base64;
import org.xml.sax.SAXException;

public class Base64ReadHandler
extends AbstractXmlReadHandler {
    private String encodedObject;

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.encodedObject = new String(ch, start, length);
    }

    @Override
    public Object getObject() throws XmlReaderException {
        try {
            byte[] bytes = Base64.decode(this.encodedObject.toCharArray());
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
            return in.readObject();
        }
        catch (IOException e) {
            throw new XmlReaderException("Can't read class for <" + this.getTagName() + ">", e);
        }
        catch (ClassNotFoundException e) {
            throw new XmlReaderException("Class not found for <" + this.getTagName() + ">", e);
        }
    }
}

