/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.jfree.xml.factory.objects.BeanObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class DecimalFormatObjectDescription
extends BeanObjectDescription {
    public DecimalFormatObjectDescription() {
        this(DecimalFormat.class);
    }

    public DecimalFormatObjectDescription(Class className) {
        super(className, false);
        this.setParameterDefinition("localizedPattern", String.class);
        this.setParameterDefinition("pattern", String.class);
        this.setParameterDefinition("decimalFormatSymbols", DecimalFormatSymbols.class);
        this.setParameterDefinition("decimalSeparatorAlwaysShown", Boolean.TYPE);
        this.setParameterDefinition("groupingSize", Integer.TYPE);
        this.setParameterDefinition("groupingUsed", Boolean.TYPE);
        this.setParameterDefinition("maximumFractionDigits", Integer.TYPE);
        this.setParameterDefinition("maximumIntegerDigits", Integer.TYPE);
        this.setParameterDefinition("minimumFractionDigits", Integer.TYPE);
        this.setParameterDefinition("minimumIntegerDigits", Integer.TYPE);
        this.setParameterDefinition("multiplier", Integer.TYPE);
        this.setParameterDefinition("negativePrefix", String.class);
        this.setParameterDefinition("negativeSuffix", String.class);
        this.setParameterDefinition("parseIntegerOnly", Boolean.TYPE);
        this.setParameterDefinition("positivePrefix", String.class);
        this.setParameterDefinition("positiveSuffix", String.class);
        this.ignoreParameter("localizedPattern");
        this.ignoreParameter("pattern");
    }

    public DecimalFormatObjectDescription(Class className, boolean init) {
        this(className);
    }

    @Override
    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        super.setParameterFromObject(o);
        DecimalFormat format = (DecimalFormat)o;
        this.setParameter("localizedPattern", format.toLocalizedPattern());
        this.setParameter("pattern", format.toPattern());
    }

    @Override
    public Object createObject() {
        DecimalFormat format = (DecimalFormat)super.createObject();
        if (this.getParameter("pattern") != null) {
            format.applyPattern((String)this.getParameter("pattern"));
        }
        if (this.getParameter("localizedPattern") != null) {
            format.applyLocalizedPattern((String)this.getParameter("localizedPattern"));
        }
        return format;
    }
}

