/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.awt.geom.Line2D;
import org.jfree.xml.factory.objects.AbstractObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class Line2DObjectDescription
extends AbstractObjectDescription {
    public Line2DObjectDescription() {
        super(Line2D.class);
        this.setParameterDefinition("x1", Float.class);
        this.setParameterDefinition("x2", Float.class);
        this.setParameterDefinition("y1", Float.class);
        this.setParameterDefinition("y2", Float.class);
    }

    @Override
    public Object createObject() {
        Line2D.Float line = new Line2D.Float();
        float x1 = this.getFloatParameter("x1");
        float x2 = this.getFloatParameter("x2");
        float y1 = this.getFloatParameter("y1");
        float y2 = this.getFloatParameter("y2");
        ((Line2D)line).setLine(x1, y1, x2, y2);
        return line;
    }

    private float getFloatParameter(String param) {
        Float p = (Float)this.getParameter(param);
        if (p == null) {
            return 0.0f;
        }
        return p.floatValue();
    }

    @Override
    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (!(o instanceof Line2D)) {
            throw new ObjectFactoryException("The given object is no java.awt.geom.Line2D.");
        }
        Line2D line = (Line2D)o;
        float x1 = (float)line.getX1();
        float x2 = (float)line.getX2();
        float y1 = (float)line.getY1();
        float y2 = (float)line.getY2();
        this.setParameter("x1", new Float(x1));
        this.setParameter("x2", new Float(x2));
        this.setParameter("y1", new Float(y1));
        this.setParameter("y2", new Float(y2));
    }
}

