/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.util.Arrays;
import javax.swing.SizeSequence;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.PipelineEvent;
import org.jdesktop.swingx.decorator.PipelineListener;

public class SizeSequenceMapper {
    private SizeSequence viewSizes;
    private SizeSequence modelSizes;
    private FilterPipeline pipeline;
    private PipelineListener pipelineListener;
    private int defaultHeight;

    public SizeSequenceMapper() {
    }

    public SizeSequenceMapper(FilterPipeline pipeline) {
        this();
        this.setFilters(pipeline);
    }

    public SizeSequenceMapper(FilterPipeline pipeline, SizeSequence selection, int defaultHeight) {
        this();
        this.setViewSizeSequence(selection, defaultHeight);
        this.setFilters(pipeline);
    }

    public void setViewSizeSequence(SizeSequence selection, int height) {
        SizeSequence old = this.viewSizes;
        if (old != null) {
            this.clearModelSizes();
        }
        this.viewSizes = selection;
        this.defaultHeight = height;
        this.mapTowardsModel();
    }

    public SizeSequence getViewSizeSequence() {
        return this.viewSizes;
    }

    public void setFilters(FilterPipeline pipeline) {
        FilterPipeline old = this.pipeline;
        if (old != null) {
            old.removePipelineListener(this.pipelineListener);
        }
        this.pipeline = pipeline;
        if (pipeline != null) {
            pipeline.addPipelineListener(this.getPipelineListener());
        }
        this.restoreSelection();
    }

    public void clearModelSizes() {
        this.modelSizes = null;
    }

    public void insertIndexInterval(int start, int length, int value) {
        if (this.modelSizes == null) {
            return;
        }
        this.modelSizes.insertEntries(start, length, value);
    }

    public void removeIndexInterval(int start, int length) {
        if (this.modelSizes == null) {
            return;
        }
        this.modelSizes.removeEntries(start, length);
    }

    public void restoreSelection() {
        if (this.viewSizes == null) {
            return;
        }
        int[] sizes = new int[this.getOutputSize()];
        Arrays.fill(sizes, this.defaultHeight);
        this.viewSizes.setSizes(sizes);
        int[] selected = this.modelSizes.getSizes();
        for (int i = 0; i < selected.length; ++i) {
            int index = this.convertToView(i);
            if (index < 0) continue;
            this.viewSizes.setSize(index, selected[i]);
        }
    }

    private void mapTowardsModel() {
        if (this.viewSizes == null) {
            return;
        }
        this.modelSizes = new SizeSequence(this.getInputSize(), this.defaultHeight);
        int[] selected = this.viewSizes.getSizes();
        for (int i = 0; i < selected.length; ++i) {
            int modelIndex = this.convertToModel(i);
            this.modelSizes.setSize(modelIndex, selected[i]);
        }
    }

    private int getInputSize() {
        return this.pipeline != null ? this.pipeline.getInputSize() : 0;
    }

    private int getOutputSize() {
        return this.pipeline != null ? this.pipeline.getOutputSize() : 0;
    }

    private int convertToModel(int index) {
        return this.pipeline != null ? this.pipeline.convertRowIndexToModel(index) : index;
    }

    private int convertToView(int index) {
        return this.pipeline != null ? this.pipeline.convertRowIndexToView(index) : index;
    }

    protected void updateFromPipelineChanged() {
        this.restoreSelection();
    }

    private PipelineListener getPipelineListener() {
        if (this.pipelineListener == null) {
            this.pipelineListener = new PipelineListener(){

                @Override
                public void contentsChanged(PipelineEvent e) {
                    SizeSequenceMapper.this.updateFromPipelineChanged();
                }
            };
        }
        return this.pipelineListener;
    }
}

