/*
 * Copyright (c) 2009 Albert Kurucz.
 *
 * This file, package-info.java is part of JTStand.
 *
 * JTStand is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JTStand is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with JTStand.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * Provides pluggable look-and-feel for SwingX components together with a
 * mechanism to support custom component look-and-feels.
 * <p>
 * JXComponents and their L&F implementations: <table border="1">
 * <tr>
 * <th>Component<th>
 * <th>Basic</th>
 * <th>Metal</th>
 * <th>Linux (GTK)</th>
 * <th>Motif</th>
 * <th>Mac OSX</th>
 * <th>Nimbus</th>
 * <th>Windows XP</th>
 * <th>Windows 2000</th>
 * </tr>
 * <tr>
 * <td>JXDatePicker<td>
 * <td>X</td>
 * <td>Basic</td>
 * <td>X</td>
 * <td>Basic</td>
 * <td>X</td>
 * <td>Basic</td>
 * <td>X</td>
 * <td>X</td>
 * </tr>
 * <tr>
 * <td>JXErrorPane<td>
 * <td>X</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>X</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * </tr>
 * <tr>
 * <td>JXHeader<td>
 * <td>X</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>X</td>
 * <td>X</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * </tr>
 * <tr>
 * <td>JXHyperlink<td>
 * <td>X</td>
 * <td>Basic</td>
 * <td>Windows XP</td>
 * <td>Windows XP</td>
 * <td>Windows XP</td>
 * <td>Windows XP</td>
 * <td>X</td>
 * <td>Windows XP</td>
 * </tr>
 * <tr>
 * <td>JXLoginPane<td>
 * <td>X</td>
 * <td>X</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>X</td>
 * <td>Windows XP</td>
 * </tr>
 * <tr>
 * <td>JXMonthView<td>
 * <td>X</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * </tr>
 * <tr>
 * <td>JXMultiThumbSlider<td>
 * <td>X</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * </tr>
 * <tr>
 * <td>JXSatusBar<td>
 * <td>X</td>
 * <td>X</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>X</td>
 * <td>Basic</td>
 * <td>X</td>
 * <td>X</td>
 * </tr>
 * <tr>
 * <td>JXTaskPane<td>
 * <td>X</td>
 * <td>X</td>
 * <td>X</td>
 * <td>Basic</td>
 * <td>X</td>
 * <td>Basic</td>
 * <td>X</td>
 * <td>X</td>
 * </tr>
 * <tr>
 * <td>JXTaskPaneContainer<td>
 * <td>X</td>
 * <td>X</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>X</td>
 * <td>Basic</td>
 * <td>X</td>
 * <td>X</td>
 * </tr>
 * <tr>
 * <td>JXTipOfTheDay<td>
 * <td>X</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>X</td>
 * <td>Windows XP</td>
 * </tr>
 * <tr>
 * <td>JXTitledPanel<td>
 * <td>X</td>
 * <td>X</td>
 * <td>X</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>Basic</td>
 * <td>X</td>
 * <td>Windows XP</td>
 * </tr>
 * </table>
 */
package org.jdesktop.swingx.plaf;

