/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLEditorKit;
import org.jdesktop.swingx.JXEditorPane;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorLevel;
import org.jdesktop.swingx.error.ErrorReporter;
import org.jdesktop.swingx.plaf.ErrorPaneUI;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.util.WindowUtils;

public class BasicErrorPaneUI
extends ErrorPaneUI {
    protected static final String CLASS_NAME = "JXErrorPane";
    protected JXErrorPane pane;
    protected JEditorPane errorMessage;
    protected JScrollPane errorScrollPane;
    protected JXEditorPane details;
    protected AbstractButton detailButton;
    protected JButton closeButton;
    protected JLabel iconLabel;
    protected AbstractButton reportButton;
    protected JPanel detailsPanel;
    protected JScrollPane detailsScrollPane;
    protected JButton copyToClipboardButton;
    protected PropertyChangeListener errorPaneListener;
    protected ActionListener detailListener;
    protected ActionListener copyToClipboardListener;
    private int collapsedHeight = 0;
    private int expandedHeight = 0;

    public static ComponentUI createUI(JComponent c) {
        return new BasicErrorPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.pane = (JXErrorPane)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        Action a = c.getActionMap().get("report-action");
        if (a == null) {
            final JXErrorPane pane = (JXErrorPane)c;
            AbstractActionExt reportAction = new AbstractActionExt(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ErrorReporter reporter = pane.getErrorReporter();
                    if (reporter != null) {
                        reporter.reportError(pane.getErrorInfo());
                    }
                }
            };
            this.configureReportAction(reportAction);
            c.getActionMap().put("report-action", reportAction);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
    }

    protected void installDefaults() {
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.pane);
    }

    protected void installListeners() {
        this.errorPaneListener = new ErrorPaneListener();
        this.pane.addPropertyChangeListener(this.errorPaneListener);
    }

    protected void uninstallListeners() {
        this.pane.removePropertyChangeListener(this.errorPaneListener);
    }

    protected void installComponents() {
        this.iconLabel = new JLabel(this.pane.getIcon());
        this.errorMessage = new JEditorPane();
        this.errorMessage.setEditable(false);
        this.errorMessage.setContentType("text/html");
        this.errorMessage.setEditorKitForContentType("text/plain", new StyledEditorKit());
        this.errorMessage.setEditorKitForContentType("text/html", new HTMLEditorKit());
        this.errorMessage.setOpaque(false);
        this.errorMessage.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.closeButton = new JButton(UIManagerExt.getString("JXErrorPane.ok_button_text", this.errorMessage.getLocale()));
        this.reportButton = new EqualSizeJButton(this.pane.getActionMap().get("report-action"));
        this.detailButton = new EqualSizeJButton(UIManagerExt.getString("JXErrorPane.details_expand_text", this.errorMessage.getLocale()));
        this.details = new JXEditorPane();
        this.details.setContentType("text/html");
        this.details.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.details.setTransferHandler(this.createDetailsTransferHandler(this.details));
        this.detailsScrollPane = new JScrollPane(this.details);
        this.detailsScrollPane.setPreferredSize(new Dimension(10, 250));
        this.details.setEditable(false);
        this.detailsPanel = new JPanel();
        this.detailsPanel.setVisible(false);
        this.copyToClipboardButton = new JButton(UIManagerExt.getString("JXErrorPane.copy_to_clipboard_button_text", this.errorMessage.getLocale()));
        this.copyToClipboardListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BasicErrorPaneUI.this.details.copy();
            }
        };
        this.copyToClipboardButton.addActionListener(this.copyToClipboardListener);
        this.detailsPanel.setLayout(this.createDetailPanelLayout());
        this.detailsPanel.add(this.detailsScrollPane);
        this.detailsPanel.add(this.copyToClipboardButton);
        this.errorScrollPane = new JScrollPane(this.errorMessage);
        this.errorScrollPane.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.errorScrollPane.setOpaque(false);
        this.errorScrollPane.getViewport().setOpaque(false);
        this.pane.setLayout(this.createErrorPaneLayout());
        Insets borderInsets = new Insets(16, 24, 16, 17);
        this.pane.setBorder(BorderFactory.createEmptyBorder(borderInsets.top, borderInsets.left, borderInsets.bottom, borderInsets.right));
        this.pane.add(this.iconLabel);
        this.pane.add(this.errorScrollPane);
        this.pane.add(this.closeButton);
        this.pane.add(this.reportButton);
        this.reportButton.setVisible(false);
        this.pane.add(this.detailButton);
        this.pane.add(this.detailsPanel);
        EqualSizeJButton[] buttons = new EqualSizeJButton[]{(EqualSizeJButton)this.detailButton, (EqualSizeJButton)this.reportButton};
        ((EqualSizeJButton)this.reportButton).setGroup(buttons);
        ((EqualSizeJButton)this.detailButton).setGroup(buttons);
        this.reportButton.setMinimumSize(this.reportButton.getPreferredSize());
        this.detailButton.setMinimumSize(this.detailButton.getPreferredSize());
        this.detailListener = new DetailsClickEvent();
        this.detailButton.addActionListener(this.detailListener);
    }

    protected void uninstallComponents() {
        this.iconLabel = null;
        this.errorMessage = null;
        this.closeButton = null;
        this.reportButton = null;
        this.detailButton.removeActionListener(this.detailListener);
        this.detailButton = null;
        this.details.setTransferHandler(null);
        this.details = null;
        this.detailsScrollPane.removeAll();
        this.detailsScrollPane = null;
        this.detailsPanel.setLayout(null);
        this.detailsPanel.removeAll();
        this.detailsPanel = null;
        this.copyToClipboardButton.removeActionListener(this.copyToClipboardListener);
        this.copyToClipboardButton = null;
        this.pane.removeAll();
        this.pane.setLayout(null);
        this.pane.setBorder(null);
    }

    @Override
    public JFrame getErrorFrame(Component owner) {
        this.reinit();
        this.expandedHeight = 0;
        this.collapsedHeight = 0;
        JXErrorFrame frame = new JXErrorFrame(this.pane);
        BasicErrorPaneUI.centerWindow(frame, owner);
        return frame;
    }

    @Override
    public JDialog getErrorDialog(Component owner) {
        this.reinit();
        this.expandedHeight = 0;
        this.collapsedHeight = 0;
        Window w = WindowUtils.findWindow(owner);
        JXErrorDialog dlg = null;
        dlg = w instanceof Dialog ? new JXErrorDialog((Dialog)w, this.pane) : (w instanceof Frame ? new JXErrorDialog((Frame)w, this.pane) : new JXErrorDialog(JOptionPane.getRootFrame(), this.pane));
        BasicErrorPaneUI.centerWindow(dlg, owner);
        return dlg;
    }

    @Override
    public JInternalFrame getErrorInternalFrame(Component owner) {
        this.reinit();
        this.expandedHeight = 0;
        this.collapsedHeight = 0;
        JXInternalErrorFrame frame = new JXInternalErrorFrame(this.pane);
        BasicErrorPaneUI.centerWindow(frame, owner);
        return frame;
    }

    protected LayoutManager createErrorPaneLayout() {
        return new ErrorPaneLayout();
    }

    protected LayoutManager createDetailPanelLayout() {
        GridBagLayout layout = new GridBagLayout();
        layout.addLayoutComponent(this.detailsScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 0, 0, 0), 0, 0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 22;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(6, 0, 6, 0);
        layout.addLayoutComponent(this.copyToClipboardButton, gbc);
        return layout;
    }

    @Override
    public Dimension calculatePreferredSize() {
        return new Dimension(this.iconLabel.getPreferredSize().width + this.errorMessage.getPreferredSize().width, 206);
    }

    protected int getDetailsHeight() {
        return 300;
    }

    protected void configureReportAction(AbstractActionExt reportAction) {
        reportAction.setName(UIManagerExt.getString("JXErrorPane.report_button_text", this.pane.getLocale()));
    }

    private TransferHandler createDetailsTransferHandler(JTextComponent detailComponent) {
        return new DetailsTransferHandler(detailComponent);
    }

    protected Icon getDefaultErrorIcon() {
        try {
            Icon icon = UIManager.getIcon("JXErrorPane.errorIcon");
            return icon == null ? UIManager.getIcon("OptionPane.errorIcon") : icon;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Icon getDefaultWarningIcon() {
        try {
            Icon icon = UIManager.getIcon("JXErrorPane.warningIcon");
            return icon == null ? UIManager.getIcon("OptionPane.warningIcon") : icon;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setDetails(String details) {
        if (details == null || details.equals("")) {
            this.detailButton.setVisible(false);
        } else {
            this.details.setText(details);
            this.detailButton.setVisible(true);
        }
    }

    protected void configureDetailsButton(boolean expanded) {
        if (expanded) {
            this.detailButton.setText(UIManagerExt.getString("JXErrorPane.details_contract_text", this.detailButton.getLocale()));
        } else {
            this.detailButton.setText(UIManagerExt.getString("JXErrorPane.details_expand_text", this.detailButton.getLocale()));
        }
    }

    private void setDetailsVisible(boolean b) {
        if (b) {
            this.collapsedHeight = this.pane.getHeight();
            this.pane.setSize(this.pane.getWidth(), this.expandedHeight == 0 ? this.collapsedHeight + this.getDetailsHeight() : this.expandedHeight);
            this.detailsPanel.setVisible(true);
            this.configureDetailsButton(true);
            this.detailsPanel.applyComponentOrientation(this.detailButton.getComponentOrientation());
            this.details.setText(this.details.getText());
            this.details.setCaretPosition(0);
        } else if (this.collapsedHeight != 0) {
            this.expandedHeight = this.pane.getHeight();
            this.detailsPanel.setVisible(false);
            this.configureDetailsButton(false);
            this.errorMessage.setSize(0, 0);
            this.errorMessage.setSize(this.errorMessage.getPreferredSize());
            this.pane.setSize(this.pane.getWidth(), this.collapsedHeight);
        } else {
            this.detailsPanel.setVisible(false);
        }
        this.pane.doLayout();
    }

    private void setErrorMessage(String errorMessage) {
        if (BasicHTML.isHTMLString(errorMessage)) {
            this.errorMessage.setContentType("text/html");
        } else {
            this.errorMessage.setContentType("text/plain");
        }
        this.errorMessage.setText(errorMessage);
        this.errorMessage.setCaretPosition(0);
    }

    protected void reinit() {
        this.setDetailsVisible(false);
        Action reportAction = this.pane.getActionMap().get("report-action");
        this.reportButton.setAction(reportAction);
        this.reportButton.setVisible(reportAction != null && reportAction.isEnabled() && this.pane.getErrorReporter() != null);
        this.reportButton.setEnabled(this.reportButton.isVisible());
        ErrorInfo errorInfo = this.pane.getErrorInfo();
        if (errorInfo == null) {
            this.iconLabel.setIcon(this.pane.getIcon());
            this.setErrorMessage("");
            this.closeButton.setText(UIManagerExt.getString("JXErrorPane.ok_button_text", this.closeButton.getLocale()));
            this.setDetails("");
        } else {
            if (errorInfo.getErrorLevel() == ErrorLevel.FATAL) {
                this.closeButton.setText(UIManagerExt.getString("JXErrorPane.fatal_button_text", this.closeButton.getLocale()));
            } else {
                this.closeButton.setText(UIManagerExt.getString("JXErrorPane.ok_button_text", this.closeButton.getLocale()));
            }
            Icon icon = this.pane.getIcon();
            if (icon == null || icon instanceof UIResource) {
                icon = errorInfo.getErrorLevel().intValue() <= Level.WARNING.intValue() ? this.getDefaultWarningIcon() : this.getDefaultErrorIcon();
            }
            this.iconLabel.setIcon(icon);
            this.setErrorMessage(errorInfo.getBasicErrorMessage());
            String details = errorInfo.getDetailedErrorMessage();
            if (details == null) {
                details = this.getDetailsAsHTML(errorInfo);
            }
            this.setDetails(details);
        }
    }

    protected String getDetailsAsHTML(ErrorInfo errorInfo) {
        if (errorInfo.getErrorException() != null) {
            StringBuffer html = new StringBuffer("<html>");
            html.append("<h2>" + BasicErrorPaneUI.escapeXml(errorInfo.getTitle()) + "</h2>");
            html.append("<HR size='1' noshade>");
            html.append("<div></div>");
            html.append("<b>Message:</b>");
            html.append("<pre>");
            html.append("    " + BasicErrorPaneUI.escapeXml(errorInfo.getErrorException().toString()));
            html.append("</pre>");
            html.append("<b>Level:</b>");
            html.append("<pre>");
            html.append("    " + errorInfo.getErrorLevel());
            html.append("</pre>");
            html.append("<b>Stack Trace:</b>");
            for (Throwable ex = errorInfo.getErrorException(); ex != null; ex = ex.getCause()) {
                html.append("<h4>" + ex.getMessage() + "</h4>");
                html.append("<pre>");
                for (StackTraceElement el : ex.getStackTrace()) {
                    html.append("    " + el.toString().replace("<init>", "&lt;init&gt;") + "\n");
                }
                html.append("</pre>");
            }
            html.append("</html>");
            return html.toString();
        }
        return null;
    }

    private void initWindow(Window w, JXErrorPane pane) {
        ActionListener[] list;
        w.setLayout(new BorderLayout());
        w.add((Component)pane, "Center");
        final CloseAction closeAction = new CloseAction(w);
        this.closeButton.addActionListener(closeAction);
        final ResizeWindow resizeListener = new ResizeWindow(w);
        for (ActionListener a : list = this.detailButton.getActionListeners()) {
            this.detailButton.removeActionListener(a);
        }
        this.detailButton.addActionListener(resizeListener);
        for (ActionListener a : list) {
            this.detailButton.addActionListener(a);
        }
        if (w instanceof JFrame) {
            JFrame f = (JFrame)w;
            f.getRootPane().setDefaultButton(this.closeButton);
            f.setResizable(true);
            f.setDefaultCloseOperation(2);
            KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
            f.getRootPane().registerKeyboardAction(closeAction, ks, 2);
        } else if (w instanceof JDialog) {
            JDialog d = (JDialog)w;
            d.getRootPane().setDefaultButton(this.closeButton);
            d.setResizable(true);
            d.setDefaultCloseOperation(2);
            KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
            d.getRootPane().registerKeyboardAction(closeAction, ks, 2);
        }
        w.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                BasicErrorPaneUI.this.closeButton.removeActionListener(closeAction);
                BasicErrorPaneUI.this.detailButton.removeActionListener(resizeListener);
                BasicErrorPaneUI.this.exitIfFatal();
            }
        });
        w.pack();
    }

    private void exitIfFatal() {
        ErrorInfo info = this.pane.getErrorInfo();
        if (info != null && info.getErrorLevel() == ErrorLevel.FATAL) {
            Action fatalAction = this.pane.getActionMap().get("fatal-action");
            if (fatalAction == null) {
                System.exit(1);
            } else {
                ActionEvent ae = new ActionEvent(this.closeButton, -1, "fatal");
                fatalAction.actionPerformed(ae);
            }
        }
    }

    private static void centerWindow(Window w, Component owner) {
        if (owner != null) {
            Point p = owner.getLocation();
            p.x += owner.getWidth() / 2;
            p.y += owner.getHeight() / 2;
            SwingUtilities.convertPointToScreen(p, owner);
            w.setLocation(p);
        } else {
            w.setLocation(WindowUtils.getPointForCentering(w));
        }
    }

    private static void centerWindow(JInternalFrame w, Component owner) {
        if (owner != null) {
            Point p = owner.getLocation();
            p.x += owner.getWidth() / 2;
            p.y += owner.getHeight() / 2;
            SwingUtilities.convertPointToScreen(p, owner);
            w.setLocation(p);
        } else {
            w.setLocation(WindowUtils.getPointForCentering(w));
        }
    }

    private static String escapeXml(String input) {
        String s = input == null ? "" : input.replace("&", "&amp;");
        s = s.replace("<", "&lt;");
        s = s.replace(">", "&gt;");
        return s;
    }

    private final class ErrorPaneLayout
    implements LayoutManager {
        private JEditorPane dummy = new JEditorPane();

        private ErrorPaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int prefWidth = parent.getWidth();
            int prefHeight = parent.getHeight();
            Insets insets = parent.getInsets();
            int pw = BasicErrorPaneUI.this.detailButton.isVisible() ? BasicErrorPaneUI.this.detailButton.getPreferredSize().width : 0;
            pw += BasicErrorPaneUI.this.detailButton.isVisible() ? BasicErrorPaneUI.this.detailButton.getPreferredSize().width : 0;
            pw += BasicErrorPaneUI.this.reportButton.isVisible() ? 5 + BasicErrorPaneUI.this.reportButton.getPreferredSize().width : 0;
            prefWidth = Math.max(prefWidth, pw += BasicErrorPaneUI.this.closeButton.isVisible() ? 5 + BasicErrorPaneUI.this.closeButton.getPreferredSize().width : 0) + insets.left + insets.right;
            if (BasicErrorPaneUI.this.errorMessage != null) {
                this.dummy.setContentType(BasicErrorPaneUI.this.errorMessage.getContentType());
                this.dummy.setEditorKit(BasicErrorPaneUI.this.errorMessage.getEditorKit());
                this.dummy.setText(BasicErrorPaneUI.this.errorMessage.getText());
                this.dummy.setSize(prefWidth, 20);
                int errorMessagePrefHeight = this.dummy.getPreferredSize().height;
                prefHeight = Math.max(errorMessagePrefHeight, BasicErrorPaneUI.this.iconLabel.getPreferredSize().height) + 10 + BasicErrorPaneUI.this.closeButton.getPreferredSize().height;
                if (BasicErrorPaneUI.this.detailsPanel.isVisible()) {
                    prefHeight += BasicErrorPaneUI.this.getDetailsHeight();
                }
            }
            if (BasicErrorPaneUI.this.iconLabel != null && BasicErrorPaneUI.this.iconLabel.getIcon() != null) {
                prefWidth += BasicErrorPaneUI.this.iconLabel.getIcon().getIconWidth();
                prefHeight += 10;
            }
            return new Dimension(prefWidth + insets.left + insets.right, prefHeight + insets.top + insets.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int x = insets.left;
            int y = insets.top;
            if (BasicErrorPaneUI.this.iconLabel != null) {
                int rightEdge;
                Dimension dim = BasicErrorPaneUI.this.iconLabel.getPreferredSize();
                BasicErrorPaneUI.this.iconLabel.setBounds(x, y, dim.width, dim.height);
                int leftEdge = x += dim.width + 17;
                this.dummy.setContentType(BasicErrorPaneUI.this.errorMessage.getContentType());
                this.dummy.setText(BasicErrorPaneUI.this.errorMessage.getText());
                this.dummy.setSize(parent.getWidth() - leftEdge - insets.right, 20);
                dim = this.dummy.getPreferredSize();
                int spx = x;
                int spy = y;
                Dimension spDim = new Dimension(parent.getWidth() - leftEdge - insets.right, dim.height);
                x = rightEdge = parent.getWidth() - insets.right;
                dim = BasicErrorPaneUI.this.detailButton.getPreferredSize();
                int buttonY = (y += dim.height + 10) + 5;
                if (BasicErrorPaneUI.this.detailButton.isVisible()) {
                    dim = BasicErrorPaneUI.this.detailButton.getPreferredSize();
                    BasicErrorPaneUI.this.detailButton.setBounds(x -= dim.width, buttonY, dim.width, dim.height);
                }
                if (BasicErrorPaneUI.this.detailButton.isVisible()) {
                    BasicErrorPaneUI.this.detailButton.setBounds(x, buttonY, dim.width, dim.height);
                }
                BasicErrorPaneUI.this.errorScrollPane.setBounds(spx, spy, spDim.width, buttonY - spy);
                if (BasicErrorPaneUI.this.reportButton.isVisible()) {
                    dim = BasicErrorPaneUI.this.reportButton.getPreferredSize();
                    x -= dim.width;
                    BasicErrorPaneUI.this.reportButton.setBounds(x -= 5, buttonY, dim.width, dim.height);
                }
                dim = BasicErrorPaneUI.this.closeButton.getPreferredSize();
                x -= dim.width;
                BasicErrorPaneUI.this.closeButton.setBounds(x -= 5, buttonY, dim.width, dim.height);
                if (BasicErrorPaneUI.this.detailsPanel.isVisible()) {
                    y = buttonY + dim.height + 6;
                    x = leftEdge;
                    int width = rightEdge - x;
                    BasicErrorPaneUI.this.detailsPanel.setBounds(x, y, width, parent.getHeight() - (y + insets.bottom));
                }
            }
        }
    }

    private final class ErrorPaneListener
    implements PropertyChangeListener {
        private ErrorPaneListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            BasicErrorPaneUI.this.reinit();
        }
    }

    private final class JXInternalErrorFrame
    extends JInternalFrame {
        public JXInternalErrorFrame(JXErrorPane p) {
            this.setTitle(p.getErrorInfo().getTitle());
            this.setLayout(new BorderLayout());
            this.add((Component)p, "Center");
            final AbstractAction closeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JXInternalErrorFrame.this.setVisible(false);
                    JXInternalErrorFrame.this.dispose();
                }
            };
            BasicErrorPaneUI.this.closeButton.addActionListener(closeAction);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    BasicErrorPaneUI.this.closeButton.removeActionListener(closeAction);
                    BasicErrorPaneUI.this.exitIfFatal();
                }
            });
            this.getRootPane().setDefaultButton(BasicErrorPaneUI.this.closeButton);
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
            KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
            this.getRootPane().registerKeyboardAction(closeAction, ks, 2);
        }
    }

    private final class JXErrorFrame
    extends JFrame {
        public JXErrorFrame(JXErrorPane p) {
            this.setTitle(p.getErrorInfo().getTitle());
            BasicErrorPaneUI.this.initWindow(this, p);
        }
    }

    private final class JXErrorDialog
    extends JDialog {
        public JXErrorDialog(Frame parent, JXErrorPane p) {
            super(parent, true);
            this.init(p);
        }

        public JXErrorDialog(Dialog parent, JXErrorPane p) {
            super(parent, true);
            this.init(p);
        }

        protected void init(JXErrorPane p) {
            this.setTitle(p.getErrorInfo() == null ? null : p.getErrorInfo().getTitle());
            BasicErrorPaneUI.this.initWindow(this, p);
        }
    }

    private static final class DetailsTransferHandler
    extends TransferHandler {
        private JTextComponent details;

        private DetailsTransferHandler(JTextComponent detailComponent) {
            if (detailComponent == null) {
                throw new NullPointerException("detail component cannot be null");
            }
            this.details = detailComponent;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            String text = this.details.getSelectedText();
            if (text == null || text.equals("")) {
                this.details.selectAll();
                text = this.details.getSelectedText();
                this.details.select(-1, -1);
            }
            return new StringSelection(text);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }

    private static final class EqualSizeJButton
    extends JButton {
        private EqualSizeJButton[] group;

        public EqualSizeJButton() {
        }

        public EqualSizeJButton(String text) {
            super(text);
        }

        public EqualSizeJButton(Action a) {
            super(a);
        }

        public void setGroup(EqualSizeJButton[] group) {
            this.group = group;
        }

        private Dimension getRealPreferredSize() {
            return super.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            int width = 0;
            int height = 0;
            for (int iter = 0; iter < this.group.length; ++iter) {
                Dimension size = this.group[iter].getRealPreferredSize();
                width = Math.max(size.width, width);
                height = Math.max(size.height, height);
            }
            return new Dimension(width, height);
        }
    }

    private final class ResizeWindow
    implements ActionListener {
        private Window w;

        private ResizeWindow(Window w) {
            if (w == null) {
                throw new NullPointerException();
            }
            this.w = w;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Dimension contentSize = null;
            contentSize = this.w instanceof JDialog ? ((JDialog)this.w).getContentPane().getSize() : ((JFrame)this.w).getContentPane().getSize();
            Dimension dialogSize = this.w.getSize();
            int ydiff = dialogSize.height - contentSize.height;
            Dimension paneSize = BasicErrorPaneUI.this.pane.getSize();
            this.w.setSize(new Dimension(dialogSize.width, paneSize.height + ydiff));
            this.w.validate();
            this.w.repaint();
        }
    }

    private final class DetailsClickEvent
    implements ActionListener {
        private DetailsClickEvent() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicErrorPaneUI.this.setDetailsVisible(!BasicErrorPaneUI.this.detailsPanel.isVisible());
        }
    }

    private static final class CloseAction
    extends AbstractAction {
        private Window w;

        private CloseAction(Window w) {
            if (w == null) {
                throw new NullPointerException("Window cannot be null");
            }
            this.w = w;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.w.setVisible(false);
            this.w.dispose();
        }
    }
}

