/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.awt.Point;
import java.awt.event.ActionEvent;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.hyperlink.AbstractHyperlinkAction;
import org.jdesktop.swingx.renderer.CellContext;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.JXRendererHyperlink;
import org.jdesktop.swingx.rollover.RolloverRenderer;

public class HyperlinkProvider
extends ComponentProvider<JXHyperlink>
implements RolloverRenderer {
    private AbstractHyperlinkAction<Object> linkAction;
    protected Class<?> targetClass;

    public HyperlinkProvider() {
        this(null, null);
    }

    public HyperlinkProvider(AbstractHyperlinkAction linkAction) {
        this(linkAction, null);
    }

    public HyperlinkProvider(AbstractHyperlinkAction linkAction, Class targetClass) {
        this.setLinkAction(linkAction, targetClass);
    }

    public void setTargetClass(Class targetClass) {
        this.targetClass = targetClass;
    }

    public void setLinkAction(AbstractHyperlinkAction linkAction) {
        this.setLinkAction(linkAction, null);
    }

    public void setLinkAction(AbstractHyperlinkAction linkAction, Class targetClass) {
        if (linkAction == null) {
            linkAction = this.createDefaultLinkAction();
        }
        this.setTargetClass(targetClass);
        this.linkAction = linkAction;
        ((JXHyperlink)this.rendererComponent).setAction(linkAction);
    }

    public boolean isTargetable(Object target) {
        if (this.targetClass == null) {
            return true;
        }
        if (target == null) {
            return true;
        }
        return this.targetClass.isAssignableFrom(target.getClass());
    }

    protected AbstractHyperlinkAction createDefaultLinkAction() {
        return new AbstractHyperlinkAction<Object>(null){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void doClick() {
        ((JXHyperlink)this.rendererComponent).doClick();
    }

    @Override
    public String getString(Object value) {
        if (this.isTargetable(value)) {
            Object oldTarget = this.linkAction.getTarget();
            this.linkAction.setTarget(value);
            String text = this.linkAction.getName();
            this.linkAction.setTarget(oldTarget);
            return text;
        }
        return super.getString(value);
    }

    @Override
    protected void configureState(CellContext context) {
        if (context.getComponent() != null) {
            Point p = (Point)context.getComponent().getClientProperty("swingx.rollover");
            if (p != null && p.x >= 0 && p.x == context.getColumn() && p.y == context.getRow()) {
                if (!((JXHyperlink)this.rendererComponent).getModel().isRollover()) {
                    ((JXHyperlink)this.rendererComponent).getModel().setRollover(true);
                }
            } else if (((JXHyperlink)this.rendererComponent).getModel().isRollover()) {
                ((JXHyperlink)this.rendererComponent).getModel().setRollover(false);
            }
        }
    }

    @Override
    protected void format(CellContext context) {
        Object value = context.getValue();
        if (this.isTargetable(value)) {
            this.linkAction.setTarget(value);
        } else {
            this.linkAction.setTarget(null);
        }
        if (!context.isSelected()) {
            ((JXHyperlink)this.rendererComponent).setForeground(this.linkAction.isVisited() ? ((JXHyperlink)this.rendererComponent).getClickedColor() : ((JXHyperlink)this.rendererComponent).getUnclickedColor());
        } else {
            ((JXHyperlink)this.rendererComponent).setForeground(context.getSelectionForeground());
        }
    }

    @Override
    protected JXHyperlink createRendererComponent() {
        return new JXRendererHyperlink();
    }
}

