/*
 * Copyright (c) 2009 Albert Kurucz.
 *
 * This file, CSSTokenMaker.java is part of JTStand.
 *
 * JTStand is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JTStand is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with JTStand.  If not, see <http://www.gnu.org/licenses/>.
 */

/* The following code was generated by JFlex 1.4.1 on 12/14/05 10:11 AM */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * This class splits up text into tokens representing a CSS file.<p>
 *
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4_5; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated CSSTokenMaker.java</code> file will contain 2
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.4
 *
 */

public class CSSTokenMaker extends AbstractJFlexTokenMaker implements TokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int CD_COMMENT = 3;
  public static final int STRING = 1;
  public static final int CHAR_LITERAL = 2;
  public static final int YYINITIAL = 0;
  public static final int C_STYLE_COMMENT = 4;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\2\1\6\1\34\1\2\1\10\1\7\22\2\1\6\1\22\1\32"+
    "\1\13\1\2\1\14\1\2\1\33\1\27\1\24\1\26\1\16\1\2"+
    "\1\1\1\11\1\25\12\5\1\2\1\24\1\21\1\31\1\23\1\20"+
    "\1\12\6\17\16\0\1\15\5\0\1\24\1\3\1\24\1\2\1\0"+
    "\1\2\6\4\24\0\1\24\1\30\1\24\1\30\1\2\uff80\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\5\0\4\1\1\2\1\3\5\1\1\4\2\1\1\5"+
    "\1\6\1\7\1\10\1\11\1\7\1\12\1\13\2\7"+
    "\1\14\2\7\1\15\1\0\1\16\1\1\1\17\3\0"+
    "\1\17\1\2\1\20\4\0\1\21\1\22\1\0\1\23"+
    "\1\1\1\17\1\20\1\16\1\0\1\24\1\1\1\17"+
    "\1\20\1\0\1\16\1\25\1\1\1\17\1\20\2\16"+
    "\1\1\1\17\1\20\2\16\1\1\1\17\1\20\2\16"+
    "\1\17\1\20\3\16";

  private static int [] zzUnpackAction() {
    int [] result = new int[83];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\35\0\72\0\127\0\164\0\221\0\256\0\313"+
    "\0\350\0\u0105\0\u0122\0\u013f\0\u015c\0\u0179\0\u0196\0\u01b3"+
    "\0\313\0\u01d0\0\u01ed\0\313\0\313\0\u020a\0\313\0\313"+
    "\0\u0227\0\313\0\313\0\u0244\0\u0261\0\313\0\u027e\0\u029b"+
    "\0\313\0\350\0\313\0\u02b8\0\u02d5\0\u02f2\0\u030f\0\u013f"+
    "\0\313\0\u032c\0\u0179\0\u0349\0\u0366\0\u0383\0\u03a0\0\313"+
    "\0\313\0\u03bd\0\313\0\u03da\0\u03f7\0\u0414\0\u0431\0\u044e"+
    "\0\313\0\u046b\0\u0488\0\u04a5\0\u04c2\0\u04df\0\313\0\u04fc"+
    "\0\u0519\0\u0536\0\u0553\0\u0570\0\u058d\0\u05aa\0\u05c7\0\u05e4"+
    "\0\u0601\0\u061e\0\u063b\0\u0658\0\u0675\0\u0692\0\u06af\0\u06cc"+
    "\0\u06e9\0\u0706\0\u0723";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[83];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\6\1\7\1\10\1\11\1\6\1\12\1\13\1\10"+
    "\1\13\1\14\1\15\1\16\1\10\1\17\1\10\1\6"+
    "\1\10\1\20\2\10\1\21\1\22\1\10\1\21\1\23"+
    "\1\10\1\24\1\25\1\13\32\26\1\27\1\26\1\30"+
    "\33\31\1\32\1\33\1\34\1\35\32\34\1\36\26\37"+
    "\1\40\5\37\1\41\2\6\1\0\1\42\2\6\7\0"+
    "\1\6\1\0\1\6\7\0\1\43\5\0\1\6\2\0"+
    "\1\42\1\6\10\0\1\6\1\0\1\6\52\0\4\6"+
    "\2\44\1\6\2\0\23\6\1\0\1\45\1\46\1\0"+
    "\1\47\1\45\1\12\3\0\1\50\2\0\1\51\1\45"+
    "\1\0\1\45\23\0\1\13\1\0\1\13\23\0\1\13"+
    "\5\0\1\52\27\0\1\53\1\54\1\0\1\55\1\53"+
    "\10\0\1\53\1\0\1\53\15\0\2\53\1\0\1\55"+
    "\2\53\7\0\1\53\1\0\1\53\15\0\2\6\1\0"+
    "\1\42\2\6\7\0\1\6\1\56\1\6\7\0\1\43"+
    "\27\0\1\57\40\0\1\60\37\0\1\61\3\0\32\26"+
    "\1\0\1\26\1\0\33\31\2\0\1\34\1\0\32\34"+
    "\2\0\1\62\33\0\26\37\1\0\5\37\26\0\1\63"+
    "\7\0\2\6\1\0\1\42\2\64\1\6\1\0\1\6"+
    "\4\0\1\6\1\0\1\6\7\0\1\43\4\0\1\6"+
    "\2\45\1\0\1\47\2\45\7\0\1\45\1\0\1\45"+
    "\15\0\1\45\2\0\1\47\1\45\10\0\1\45\1\0"+
    "\1\45\15\0\4\45\2\65\1\45\2\0\23\45\1\0"+
    "\1\45\1\46\1\0\1\47\1\45\1\52\6\0\1\51"+
    "\1\45\1\0\1\45\15\0\1\53\2\0\1\55\1\53"+
    "\10\0\1\53\1\0\1\53\15\0\4\53\2\66\1\53"+
    "\2\0\23\53\6\0\1\67\11\0\2\67\15\0\1\70"+
    "\56\0\1\71\11\0\2\6\1\0\1\42\2\72\1\6"+
    "\1\0\1\6\4\0\1\6\1\0\1\6\7\0\1\43"+
    "\4\0\1\6\2\45\1\0\1\47\2\73\1\45\1\0"+
    "\1\45\4\0\1\45\1\0\1\45\14\0\1\45\2\53"+
    "\1\0\1\55\2\74\1\53\1\0\1\53\4\0\1\53"+
    "\1\0\1\53\14\0\1\53\1\0\1\75\3\0\1\76"+
    "\11\0\2\76\15\0\1\77\33\0\2\6\1\0\1\42"+
    "\2\100\1\6\1\0\1\6\4\0\1\6\1\0\1\6"+
    "\7\0\1\43\4\0\1\6\2\45\1\0\1\47\2\101"+
    "\1\45\1\0\1\45\4\0\1\45\1\0\1\45\14\0"+
    "\1\45\2\53\1\0\1\55\2\102\1\53\1\0\1\53"+
    "\4\0\1\53\1\0\1\53\14\0\1\53\5\0\1\103"+
    "\11\0\1\103\16\0\1\75\3\0\1\104\11\0\2\104"+
    "\14\0\2\6\1\0\1\42\2\105\1\6\1\0\1\6"+
    "\4\0\1\6\1\0\1\6\7\0\1\43\4\0\1\6"+
    "\2\45\1\0\1\47\2\106\1\45\1\0\1\45\4\0"+
    "\1\45\1\0\1\45\14\0\1\45\2\53\1\0\1\55"+
    "\2\107\1\53\1\0\1\53\4\0\1\53\1\0\1\53"+
    "\14\0\1\53\5\0\1\110\11\0\1\110\16\0\1\75"+
    "\3\0\1\111\11\0\2\111\14\0\2\6\1\0\1\42"+
    "\2\112\1\6\1\0\1\6\4\0\1\6\1\0\1\6"+
    "\7\0\1\43\4\0\1\6\2\45\1\0\1\47\2\113"+
    "\1\45\1\0\1\45\4\0\1\45\1\0\1\45\14\0"+
    "\1\45\2\53\1\0\1\55\2\114\1\53\1\0\1\53"+
    "\4\0\1\53\1\0\1\53\14\0\1\53\5\0\1\115"+
    "\11\0\1\115\16\0\1\75\3\0\1\116\11\0\2\116"+
    "\14\0\2\6\1\0\1\42\3\6\1\0\1\6\4\0"+
    "\1\6\1\0\1\6\7\0\1\43\4\0\1\6\2\45"+
    "\1\0\1\47\2\117\1\45\1\0\1\45\4\0\1\45"+
    "\1\0\1\45\14\0\1\45\2\53\1\0\1\55\2\120"+
    "\1\53\1\0\1\53\4\0\1\53\1\0\1\53\14\0"+
    "\1\53\5\0\1\121\11\0\1\121\16\0\1\75\3\0"+
    "\1\122\11\0\2\122\14\0\2\45\1\0\1\47\3\45"+
    "\1\0\1\45\4\0\1\45\1\0\1\45\14\0\1\45"+
    "\2\53\1\0\1\55\3\53\1\0\1\53\4\0\1\53"+
    "\1\0\1\53\14\0\1\53\5\0\1\123\11\0\1\123"+
    "\16\0\1\75\40\0\1\43\11\0\1\43\15\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[1856];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\5\0\2\1\1\11\10\1\1\11\2\1\2\11\1\1"+
    "\2\11\1\1\2\11\2\1\1\11\2\1\1\11\1\0"+
    "\1\11\2\1\3\0\1\11\2\1\4\0\2\11\1\0"+
    "\1\11\4\1\1\0\1\11\3\1\1\0\1\1\1\11"+
    "\24\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[83];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */


	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public CSSTokenMaker() {
		super();
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;

		// Start off in the proper state.
		int state = Token.NULL;
		switch (initialTokenType) {
			case Token.LITERAL_STRING_DOUBLE_QUOTE:
				state = STRING;
				start = text.offset;
				break;
			case Token.LITERAL_CHAR:
				state = CHAR_LITERAL;
				start = text.offset;
				break;
			case Token.COMMENT_MULTILINE:
				state = C_STYLE_COMMENT;
				start = text.offset;
				break;
			case Token.COMMENT_DOCUMENTATION:
				state = CD_COMMENT;
				start = text.offset;
				break;
			default:
				state = Token.NULL;
		}

		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new DefaultToken();
		}

	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 * @exception   IOException  if any I/O-Error occurs.
	 */
	private boolean zzRefill() throws java.io.IOException {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream 
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream 
	 */
	public final void yyreset(java.io.Reader reader) throws java.io.IOException {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public CSSTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public CSSTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 98) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }

  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }

  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 6: 
          { start = zzMarkedPos-1; yybegin(CHAR_LITERAL);
          }
        case 22: break;
        case 20: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead+2, Token.COMMENT_DOCUMENTATION);
          }
        case 23: break;
        case 19: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.COMMENT_MULTILINE);
          }
        case 24: break;
        case 11: 
          { addToken(start,zzStartRead-1, Token.ERROR_CHAR); addNullToken(); return firstToken;
          }
        case 25: break;
        case 21: 
          { start = zzMarkedPos-4; yybegin(CD_COMMENT);
          }
        case 26: break;
        case 3: 
          { addToken(Token.WHITESPACE);
          }
        case 27: break;
        case 10: 
          { addToken(start,zzStartRead, Token.LITERAL_CHAR); yybegin(YYINITIAL);
          }
        case 28: break;
        case 4: 
          { addToken(Token.SEPARATOR);
          }
        case 29: break;
        case 16: 
          { addToken(Token.VARIABLE);
          }
        case 30: break;
        case 1: 
          { addToken(Token.IDENTIFIER);
          }
        case 31: break;
        case 8: 
          { addToken(start,zzStartRead, Token.LITERAL_STRING_DOUBLE_QUOTE); yybegin(YYINITIAL);
          }
        case 32: break;
        case 14: 
          { addToken(Token.FUNCTION);
          }
        case 33: break;
        case 15: 
          { addToken(Token.DATA_TYPE);
          }
        case 34: break;
        case 12: 
          { addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); return firstToken;
          }
        case 35: break;
        case 17: 
          { start = zzMarkedPos-2; yybegin(C_STYLE_COMMENT);
          }
        case 36: break;
        case 5: 
          { start = zzMarkedPos-1; yybegin(STRING);
          }
        case 37: break;
        case 18: 
          { addToken(Token.OPERATOR);
          }
        case 38: break;
        case 2: 
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 39: break;
        case 7: 
          { 
          }
        case 40: break;
        case 13: 
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); return firstToken;
          }
        case 41: break;
        case 9: 
          { addToken(start,zzStartRead-1, Token.ERROR_STRING_DOUBLE); addNullToken(); return firstToken;
          }
        case 42: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case CD_COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); return firstToken;
            }
            case 84: break;
            case STRING: {
              addToken(start,zzStartRead-1, Token.ERROR_STRING_DOUBLE); return firstToken;
            }
            case 85: break;
            case CHAR_LITERAL: {
              addToken(start,zzStartRead-1, Token.ERROR_CHAR); return firstToken;
            }
            case 86: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 87: break;
            case C_STYLE_COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); return firstToken;
            }
            case 88: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
