/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import org.fife.ui.rsyntaxtextarea.CodeTemplateManager;
import org.fife.ui.rsyntaxtextarea.DefaultToken;
import org.fife.ui.rsyntaxtextarea.MarkOccurrencesSupport;
import org.fife.ui.rsyntaxtextarea.Parser;
import org.fife.ui.rsyntaxtextarea.ParserManager;
import org.fife.ui.rsyntaxtextarea.ParserNotice;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaUI;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.RtfGenerator;
import org.fife.ui.rsyntaxtextarea.RtfTransferable;
import org.fife.ui.rsyntaxtextarea.SquiggleUnderlineHighlightPainter;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.SyntaxView;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaBase;
import org.fife.ui.rtextarea.RTextAreaUI;

public class RSyntaxTextArea
extends RTextArea
implements SyntaxConstants {
    public static final String ANTIALIAS_PROPERTY = "RSTA.antiAlias";
    public static final String AUTO_INDENT_PROPERTY = "RSTA.autoIndent";
    public static final String BRACKET_MATCHING_PROPERTY = "RSTA.bracketMatching";
    public static final String CLEAR_WHITESPACE_LINES_PROPERTY = "RSTA.clearWhitespaceLines";
    public static final String FRACTIONAL_FONTMETRICS_PROPERTY = "RSTA.fractionalFontMetrics";
    public static final String HYPERLINKS_ENABLED_PROPERTY = "RSTA.hyperlinksEnabled";
    public static final String SYNTAX_SCHEME_PROPERTY = "RSTA.syntaxScheme";
    public static final String SYNTAX_STYLE_PROPERTY = "RSTA.syntaxStyle";
    public static final String VISIBLE_WHITESPACE_PROPERTY = "RSTA.visibleWhitespace";
    private static final Color DEFAULT_BRACKET_MATCH_BG_COLOR = new Color(234, 234, 255);
    private static final Color DEFAULT_BRACKET_MATCH_BORDER_COLOR = new Color(0, 0, 128);
    private static final Color DEFAULT_SELECTION_COLOR = new Color(200, 200, 255);
    private String syntaxStyleKey;
    private SyntaxScheme syntaxScheme;
    private static CodeTemplateManager codeTemplateManager;
    private static boolean templatesEnabled;
    Rectangle match;
    private Color matchedBracketBGColor;
    private Color matchedBracketBorderColor;
    private boolean bracketMatchingEnabled;
    private boolean autoIndentEnabled;
    private boolean clearWhitespaceLines;
    private boolean whitespaceVisible;
    private boolean hyperlinksEnabled;
    private Color hyperlinkFG;
    private int linkScanningMask;
    private RtfGenerator rtfGenerator;
    private MarkOccurrencesSupport markOccurrencesSupport;
    private Color markOccurrencesColor;
    private FontMetrics defaultFontMetrics;
    private ParserManager parserManager;
    private List parserNoticeHighlights;
    private boolean isScanningForLinks;
    private int hoveredOverLinkOffset;
    private SquiggleUnderlineHighlightPainter parserErrorHighlightPainter = new SquiggleUnderlineHighlightPainter(Color.RED);
    private int lineHeight;
    private int maxAscent;
    private String aaHintFieldName;
    private Object aaHint;
    private boolean fractionalFontMetricsEnabled;

    @Override
    public int getMaxAscent() {
        return this.maxAscent;
    }

    public RSyntaxTextArea() {
        this.init();
    }

    public RSyntaxTextArea(RSyntaxDocument doc) {
        super(doc);
        this.init();
    }

    public RSyntaxTextArea(String text) {
        super(text);
        this.init();
    }

    public RSyntaxTextArea(int rows, int cols) {
        super(rows, cols);
        this.init();
    }

    public RSyntaxTextArea(String text, int rows, int cols) {
        super(text, rows, cols);
        this.init();
    }

    public RSyntaxTextArea(RSyntaxDocument doc, String text, int rows, int cols) {
        super(doc, text, rows, cols);
        this.init();
    }

    public RSyntaxTextArea(int textMode) {
        super(textMode);
        this.init();
    }

    public void addHyperlinkListener(HyperlinkListener l) {
        this.listenerList.add(HyperlinkListener.class, l);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
    }

    private void calculateLineHeight() {
        int ascent;
        this.maxAscent = 0;
        this.lineHeight = 0;
        for (int i = 0; i < this.syntaxScheme.styles.length; ++i) {
            int ascent2;
            Style ss = this.syntaxScheme.styles[i];
            if (ss == null || ss.font == null) continue;
            FontMetrics fm = this.getFontMetrics(ss.font);
            int height = fm.getHeight();
            if (height > this.lineHeight) {
                this.lineHeight = height;
            }
            if ((ascent2 = fm.getMaxAscent()) <= this.maxAscent) continue;
            this.maxAscent = ascent2;
        }
        Font temp = this.getFont();
        FontMetrics fm = this.getFontMetrics(temp);
        int height = fm.getHeight();
        if (height > this.lineHeight) {
            this.lineHeight = height;
        }
        if ((ascent = fm.getMaxAscent()) > this.maxAscent) {
            this.maxAscent = ascent;
        }
    }

    protected void clearParserNoticeHighlights() {
        Highlighter h = this.getHighlighter();
        if (h != null && this.parserNoticeHighlights != null) {
            int count = this.parserNoticeHighlights.size();
            for (int i = 0; i < count; ++i) {
                h.removeHighlight(this.parserNoticeHighlights.get(i));
            }
            this.parserNoticeHighlights.clear();
        }
        this.repaint();
    }

    private Token cloneTokenList(Token t) {
        if (t == null) {
            return null;
        }
        DefaultToken clone = new DefaultToken();
        clone.copyFrom(t);
        DefaultToken cloneEnd = clone;
        while ((t = t.getNextToken()) != null) {
            DefaultToken temp = new DefaultToken();
            temp.copyFrom(t);
            cloneEnd.setNextToken(temp);
            cloneEnd = temp;
        }
        return clone;
    }

    public void copyAsRtf() {
        Token tokenList;
        int selEnd;
        int selStart = this.getSelectionStart();
        if (selStart == (selEnd = this.getSelectionEnd())) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkSystemClipboardAccess();
            }
            catch (SecurityException se) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                return;
            }
        }
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        RtfGenerator gen = this.getRTFGenerator();
        for (Token t = tokenList = this.getTokenListFor(selStart, selEnd); t != null; t = t.getNextToken()) {
            if (!t.isPaintable()) continue;
            if (t.textCount == 1 && t.text[t.textOffset] == '\n') {
                gen.appendNewline();
                continue;
            }
            Font font = this.getFontForTokenType(t.type);
            Color bg = this.getBackgroundForTokenType(t.type);
            boolean underline = this.getUnderlineForToken(t);
            if (t.isWhitespace()) {
                gen.appendToDocNoFG(t.getLexeme(), font, bg, underline);
                continue;
            }
            Color fg = this.getForegroundForToken(t);
            gen.appendToDoc(t.getLexeme(), font, fg, bg, underline);
        }
        RtfTransferable contents = new RtfTransferable(gen.getRtf().getBytes());
        try {
            cb.setContents(contents, null);
        }
        catch (IllegalStateException ise) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
    }

    @Override
    protected Document createDefaultModel() {
        return new RSyntaxDocument("text/plain");
    }

    @Override
    protected RTextAreaBase.RTAMouseListener createMouseListener() {
        return new RSyntaxTextAreaMutableCaretEvent((RTextArea)this);
    }

    @Override
    protected RTextAreaUI createRTextAreaUI() {
        return new RSyntaxTextAreaUI(this);
    }

    protected final void doBracketMatching() {
        int pos;
        if (this.match != null) {
            this.repaint(this.match);
        }
        if ((pos = RSyntaxUtilities.getMatchingBracketPosition(this)) > -1) {
            try {
                this.match = this.modelToView(pos);
                if (this.match != null) {
                    this.repaint(this.match);
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        } else {
            this.match = null;
        }
    }

    @Override
    protected void fireCaretUpdate(CaretEvent e) {
        super.fireCaretUpdate(e);
        if (this.bracketMatchingEnabled) {
            this.doBracketMatching();
        }
    }

    public void fireHyperlinkUpdate(HyperlinkEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != HyperlinkListener.class) continue;
            ((HyperlinkListener)listeners[i + 1]).hyperlinkUpdate(e);
        }
    }

    public Color getBackgroundForTokenType(int type) {
        return this.syntaxScheme.styles[type].background;
    }

    public static synchronized CodeTemplateManager getCodeTemplateManager() {
        if (codeTemplateManager == null) {
            codeTemplateManager = new CodeTemplateManager();
        }
        return codeTemplateManager;
    }

    public static final Color getDefaultBracketMatchBGColor() {
        return DEFAULT_BRACKET_MATCH_BG_COLOR;
    }

    public static final Color getDefaultBracketMatchBorderColor() {
        return DEFAULT_BRACKET_MATCH_BORDER_COLOR;
    }

    public static Color getDefaultSelectionColor() {
        return DEFAULT_SELECTION_COLOR;
    }

    public SyntaxScheme getDefaultSyntaxScheme() {
        return new SyntaxScheme(true);
    }

    public Font getFontForTokenType(int type) {
        Font f = this.syntaxScheme.styles[type].font;
        return f != null ? f : this.getFont();
    }

    public FontMetrics getFontMetricsForTokenType(int type) {
        FontMetrics fm = this.syntaxScheme.styles[type].fontMetrics;
        return fm != null ? fm : this.defaultFontMetrics;
    }

    public Color getForegroundForToken(Token t) {
        if (this.getHyperlinksEnabled() && t.isHyperlink() && this.hoveredOverLinkOffset == t.offset) {
            return this.hyperlinkFG;
        }
        Color fg = this.syntaxScheme.styles[t.type].foreground;
        return fg != null ? fg : this.getForeground();
    }

    public boolean getFractionalFontMetricsEnabled() {
        return this.fractionalFontMetricsEnabled;
    }

    private final Graphics2D getGraphics2D(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.aaHint != null) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.aaHint);
        }
        if (this.fractionalFontMetricsEnabled) {
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        return g2d;
    }

    public Color getHyperlinkForeground() {
        return this.hyperlinkFG;
    }

    public boolean getHyperlinksEnabled() {
        return this.hyperlinksEnabled;
    }

    @Override
    public int getLineHeight() {
        return this.lineHeight;
    }

    public boolean getMarkOccurrences() {
        return this.markOccurrencesSupport != null;
    }

    public Color getMarkOccurrencesColor() {
        return this.markOccurrencesColor;
    }

    boolean getMarkOccurrencesOfTokenType(int type) {
        RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
        return doc.getMarkOccurrencesOfTokenType(type);
    }

    public Color getMatchedBracketBGColor() {
        return this.matchedBracketBGColor;
    }

    public Color getMatchedBracketBorderColor() {
        return this.matchedBracketBorderColor;
    }

    public final Rectangle getMatchRectangle() {
        return this.match;
    }

    private RtfGenerator getRTFGenerator() {
        if (this.rtfGenerator == null) {
            this.rtfGenerator = new RtfGenerator();
        } else {
            this.rtfGenerator.reset();
        }
        return this.rtfGenerator;
    }

    public boolean getShouldIndentNextLine(int line) {
        if (this.isAutoIndentEnabled()) {
            RSyntaxDocument doc = (RSyntaxDocument)this.getDocument();
            return doc.getShouldIndentNextLine(line);
        }
        return false;
    }

    public String getSyntaxEditingStyle() {
        return this.syntaxStyleKey;
    }

    public SyntaxScheme getSyntaxScheme() {
        return this.syntaxScheme;
    }

    public static synchronized boolean getTemplatesEnabled() {
        return templatesEnabled;
    }

    public String getTextAntiAliasHint() {
        return this.aaHintFieldName;
    }

    private Token getTokenListFor(int startOffs, int endOffs) {
        Token temp;
        Token tokenList = null;
        Token lastToken = null;
        Element map = this.getDocument().getDefaultRootElement();
        int startLine = map.getElementIndex(startOffs);
        int endLine = map.getElementIndex(endOffs);
        for (int line = startLine; line <= endLine; ++line) {
            Token t = this.getTokenListForLine(line);
            t = this.cloneTokenList(t);
            if (tokenList == null) {
                lastToken = tokenList = t;
                while (lastToken.getNextToken() != null && lastToken.getNextToken().isPaintable()) {
                    lastToken = lastToken.getNextToken();
                }
            } else {
                lastToken.setNextToken(t);
                while (lastToken.getNextToken() != null && lastToken.getNextToken().isPaintable()) {
                    lastToken = lastToken.getNextToken();
                }
            }
            if (line >= endLine) continue;
            int docOffs = map.getElement(line).getEndOffset() - 1;
            t = new DefaultToken(new char[]{'\n'}, 0, 0, docOffs, 16);
            lastToken.setNextToken(t);
            lastToken = t;
        }
        if (startOffs >= tokenList.offset) {
            while (!tokenList.containsPosition(startOffs)) {
                tokenList = tokenList.getNextToken();
            }
            tokenList.makeStartAt(startOffs);
        }
        for (temp = tokenList; temp != null && !temp.containsPosition(endOffs); temp = temp.getNextToken()) {
        }
        if (temp != null) {
            temp.textCount = endOffs - temp.offset;
            temp.setNextToken(null);
        }
        return tokenList;
    }

    public Token getTokenListForLine(int line) {
        return ((RSyntaxDocument)this.getDocument()).getTokenListForLine(line);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String toolTip = this.parserManager == null ? null : this.parserManager.getToolTipText(e);
        return toolTip != null ? toolTip : super.getToolTipText(e);
    }

    public boolean getUnderlineForToken(Token t) {
        return t.isHyperlink() && this.getHyperlinksEnabled() || this.syntaxScheme.styles[t.type].underline;
    }

    protected void init() {
        Font font = this.getFont();
        this.setFont(new Font("Monospaced", font.getStyle(), font.getSize()));
        this.syntaxStyleKey = "text/plain";
        this.setMatchedBracketBGColor(RSyntaxTextArea.getDefaultBracketMatchBGColor());
        this.setMatchedBracketBorderColor(RSyntaxTextArea.getDefaultBracketMatchBorderColor());
        this.setBracketMatchingEnabled(true);
        this.setSelectionColor(RSyntaxTextArea.getDefaultSelectionColor());
        this.setAutoIndentEnabled(true);
        this.setClearWhitespaceLinesEnabled(true);
        this.setHyperlinksEnabled(true);
        this.setLinkScanningMask(128);
        this.setHyperlinkForeground(Color.BLUE);
        this.isScanningForLinks = false;
        this.restoreDefaultSyntaxScheme();
    }

    public boolean isAutoIndentEnabled() {
        return this.autoIndentEnabled;
    }

    public final boolean isBracketMatchingEnabled() {
        return this.bracketMatchingEnabled;
    }

    public boolean isClearWhitespaceLinesEnabled() {
        return this.clearWhitespaceLines;
    }

    public boolean isWhitespaceVisible() {
        return this.whitespaceVisible;
    }

    private Token modelToToken(int offs) {
        if (offs >= 0) {
            try {
                int line = this.getLineOfOffset(offs);
                for (Token t = this.getTokenListForLine(line); t != null && t.isPaintable(); t = t.getNextToken()) {
                    if (!t.containsPosition(offs)) continue;
                    return t;
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(this.getGraphics2D(g));
    }

    private void refreshFontMetrics(Graphics2D g2d) {
        this.defaultFontMetrics = g2d.getFontMetrics(this.getFont());
        this.syntaxScheme.refreshFontMetrics(g2d);
        if (!this.getLineWrap()) {
            SyntaxView sv = (SyntaxView)this.getUI().getRootView(this).getView(0);
            sv.calculateLongestLine();
        }
    }

    void refreshParserNoticeHighlights(Iterator parserNoticeIterator) {
        this.clearParserNoticeHighlights();
        if (this.parserNoticeHighlights == null) {
            this.parserNoticeHighlights = new ArrayList();
        }
        if (parserNoticeIterator != null) {
            Highlighter h = this.getHighlighter();
            while (parserNoticeIterator.hasNext()) {
                ParserNotice notice = (ParserNotice)parserNoticeIterator.next();
                int start = notice.getOffset();
                int length = notice.getLength();
                try {
                    this.parserNoticeHighlights.add(h.addHighlight(start, start + length, this.parserErrorHighlightPainter));
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        }
    }

    public void removeHyperlinkListener(HyperlinkListener l) {
        this.listenerList.remove(HyperlinkListener.class, l);
    }

    @Override
    public void removeNotify() {
        if (this.parserManager != null) {
            this.parserManager.setParser(null);
        }
        super.removeNotify();
    }

    public void restoreDefaultSyntaxScheme() {
        this.setSyntaxScheme(this.getDefaultSyntaxScheme());
    }

    public static synchronized boolean saveTemplates() {
        if (!RSyntaxTextArea.getTemplatesEnabled()) {
            return false;
        }
        return RSyntaxTextArea.getCodeTemplateManager().saveTemplates();
    }

    public void setAutoIndentEnabled(boolean enabled) {
        if (this.autoIndentEnabled != enabled) {
            this.autoIndentEnabled = enabled;
            this.firePropertyChange(AUTO_INDENT_PROPERTY, !enabled, enabled);
        }
    }

    public void setBracketMatchingEnabled(boolean enabled) {
        if (enabled != this.bracketMatchingEnabled) {
            this.bracketMatchingEnabled = enabled;
            this.repaint();
            this.firePropertyChange(BRACKET_MATCHING_PROPERTY, !enabled, enabled);
        }
    }

    public void setClearWhitespaceLinesEnabled(boolean enabled) {
        if (enabled != this.clearWhitespaceLines) {
            this.clearWhitespaceLines = enabled;
            this.firePropertyChange(CLEAR_WHITESPACE_LINES_PROPERTY, !enabled, enabled);
        }
    }

    @Override
    public void setDocument(Document document) {
        if (!(document instanceof RSyntaxDocument)) {
            throw new IllegalArgumentException("Documents for RSyntaxTextArea must be instances of RSyntaxDocument!");
        }
        super.setDocument(document);
    }

    @Override
    public void setFont(Font font) {
        Font old = super.getFont();
        super.setFont(font);
        if (this.isDisplayable()) {
            this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            this.calculateLineHeight();
            this.updateMarginLineX();
            this.forceCurrentLineHighlightRepaint();
            this.firePropertyChange("font", old, font);
            this.revalidate();
        }
    }

    public void setFractionalFontMetricsEnabled(boolean enabled) {
        if (this.fractionalFontMetricsEnabled != enabled) {
            this.fractionalFontMetricsEnabled = enabled;
            if (this.isDisplayable()) {
                this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            }
            this.firePropertyChange(FRACTIONAL_FONTMETRICS_PROPERTY, !enabled, enabled);
        }
    }

    @Override
    public void setHighlighter(Highlighter h) {
        if (!(h instanceof RSyntaxTextAreaHighlighter)) {
            throw new IllegalArgumentException("RSyntaxTextArea requires an RSyntaxTextAreaHighlighter for its Highlighter");
        }
        super.setHighlighter(h);
    }

    public void setHyperlinkForeground(Color fg) {
        if (fg == null) {
            throw new NullPointerException("fg cannot be null");
        }
        this.hyperlinkFG = fg;
    }

    public void setHyperlinksEnabled(boolean enabled) {
        if (this.hyperlinksEnabled != enabled) {
            this.hyperlinksEnabled = enabled;
            this.repaint();
            this.firePropertyChange(HYPERLINKS_ENABLED_PROPERTY, !enabled, enabled);
        }
    }

    public void setLinkScanningMask(int mask) {
        if (mask == 128 || mask == 256 || mask == 512 || mask == 64) {
            this.linkScanningMask = mask;
        }
    }

    public void setMarkOccurrences(boolean markOccurrences) {
        if (markOccurrences) {
            if (this.markOccurrencesSupport == null) {
                this.markOccurrencesSupport = new MarkOccurrencesSupport();
                this.markOccurrencesSupport.install(this);
            }
        } else if (this.markOccurrencesSupport != null) {
            this.markOccurrencesSupport.uninstall();
            this.markOccurrencesSupport = null;
        }
    }

    public void setMarkOccurrencesColor(Color color) {
        this.markOccurrencesColor = color;
        if (this.markOccurrencesSupport != null) {
            this.markOccurrencesSupport.setColor(color);
        }
    }

    public void setMatchedBracketBGColor(Color color) {
        this.matchedBracketBGColor = color;
        if (this.match != null) {
            this.repaint();
        }
    }

    public void setMatchedBracketBorderColor(Color color) {
        this.matchedBracketBorderColor = color;
        if (this.match != null) {
            this.repaint();
        }
    }

    public void setParser(Parser parser) {
        if (this.parserManager == null) {
            this.parserManager = new ParserManager(this);
        }
        this.clearParserNoticeHighlights();
        this.parserManager.setParser(parser);
    }

    public void setSyntaxEditingStyle(String styleKey) {
        if (styleKey == null) {
            styleKey = "text/plain";
        }
        if (!styleKey.equals(this.syntaxStyleKey)) {
            String oldStyle = this.syntaxStyleKey;
            this.syntaxStyleKey = styleKey;
            ((RSyntaxDocument)this.getDocument()).setSyntaxStyle(styleKey);
            this.firePropertyChange(SYNTAX_STYLE_PROPERTY, oldStyle, styleKey);
        }
    }

    public void setSyntaxScheme(SyntaxScheme scheme) {
        SyntaxScheme old = this.syntaxScheme;
        this.syntaxScheme = scheme;
        this.calculateLineHeight();
        if (this.isDisplayable()) {
            this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
        }
        this.updateMarginLineX();
        this.forceCurrentLineHighlightRepaint();
        this.revalidate();
        this.firePropertyChange(SYNTAX_SCHEME_PROPERTY, old, this.syntaxScheme);
    }

    public static synchronized boolean setTemplateDirectory(String dir) {
        if (RSyntaxTextArea.getTemplatesEnabled() && dir != null) {
            File directory = new File(dir);
            if (directory.isDirectory()) {
                return RSyntaxTextArea.getCodeTemplateManager().setTemplateDirectory(directory) > -1;
            }
            boolean created = directory.mkdir();
            if (created) {
                return RSyntaxTextArea.getCodeTemplateManager().setTemplateDirectory(directory) > -1;
            }
        }
        return false;
    }

    public static synchronized void setTemplatesEnabled(boolean enabled) {
        templatesEnabled = enabled;
    }

    public void setTextAntiAliasHint(String aaHintFieldName) {
        if (aaHintFieldName == null && this.aaHintFieldName != null) {
            String old = this.aaHintFieldName;
            this.aaHint = null;
            this.aaHintFieldName = null;
            if (this.isDisplayable()) {
                this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            }
            this.firePropertyChange(ANTIALIAS_PROPERTY, old, null);
            this.repaint();
        } else if (aaHintFieldName != null && !aaHintFieldName.equals(this.aaHintFieldName)) {
            String old = this.aaHintFieldName;
            try {
                Field f = RenderingHints.class.getDeclaredField(aaHintFieldName);
                this.aaHint = f.get(null);
                this.aaHintFieldName = aaHintFieldName;
            }
            catch (RuntimeException re) {
            }
            catch (Exception e) {
                this.aaHint = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
                this.aaHintFieldName = "VALUE_TEXT_ANTIALIAS_OFF";
            }
            if (this.isDisplayable()) {
                this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            }
            this.firePropertyChange(ANTIALIAS_PROPERTY, old, this.aaHintFieldName);
            this.repaint();
        }
    }

    public void setWhitespaceVisible(boolean visible) {
        if (this.whitespaceVisible != visible) {
            this.whitespaceVisible = visible;
            ((RSyntaxDocument)this.getDocument()).setWhitespaceVisible(visible, this);
            this.repaint();
            this.firePropertyChange(VISIBLE_WHITESPACE_PROPERTY, !visible, visible);
        }
    }

    private Token viewToToken(Point p) {
        return this.modelToToken(this.viewToModel(p));
    }

    private class RSyntaxTextAreaMutableCaretEvent
    extends RTextArea.RTextAreaMutableCaretEvent {
        protected RSyntaxTextAreaMutableCaretEvent(RTextArea textArea) {
            super(textArea);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (RSyntaxTextArea.this.getHyperlinksEnabled() && RSyntaxTextArea.this.isScanningForLinks && RSyntaxTextArea.this.hoveredOverLinkOffset > -1) {
                Token t = RSyntaxTextArea.this.modelToToken(RSyntaxTextArea.this.hoveredOverLinkOffset);
                URL url = null;
                String desc = null;
                try {
                    String temp = t.getLexeme();
                    if (temp.startsWith("www.")) {
                        temp = "http://" + temp;
                    }
                    url = new URL(temp);
                }
                catch (MalformedURLException mue) {
                    desc = mue.getMessage();
                }
                HyperlinkEvent he = new HyperlinkEvent(this, HyperlinkEvent.EventType.ACTIVATED, url, desc);
                RSyntaxTextArea.this.fireHyperlinkUpdate(he);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            if (RSyntaxTextArea.this.getHyperlinksEnabled()) {
                if ((e.getModifiersEx() & RSyntaxTextArea.this.linkScanningMask) != 0) {
                    RSyntaxTextArea.this.isScanningForLinks = true;
                    Token t = RSyntaxTextArea.this.viewToToken(e.getPoint());
                    Cursor c2 = null;
                    if (t != null && t.isHyperlink()) {
                        RSyntaxTextArea.this.hoveredOverLinkOffset = t.offset;
                        c2 = Cursor.getPredefinedCursor(12);
                    } else {
                        c2 = Cursor.getPredefinedCursor(2);
                        RSyntaxTextArea.this.hoveredOverLinkOffset = -1;
                    }
                    if (RSyntaxTextArea.this.getCursor() != c2) {
                        RSyntaxTextArea.this.setCursor(c2);
                        RSyntaxTextArea.this.repaint();
                    }
                } else if (RSyntaxTextArea.this.isScanningForLinks) {
                    Cursor c = RSyntaxTextArea.this.getCursor();
                    RSyntaxTextArea.this.isScanningForLinks = false;
                    RSyntaxTextArea.this.hoveredOverLinkOffset = -1;
                    if (c != null && c.getType() == 12) {
                        RSyntaxTextArea.this.setCursor(Cursor.getPredefinedCursor(2));
                        RSyntaxTextArea.this.repaint();
                    }
                }
            }
        }
    }
}

