/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import javax.swing.text.StyleContext;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Style;

public class SyntaxScheme
implements Cloneable {
    public Style[] styles = new Style[24];

    public SyntaxScheme(boolean useDefaults) {
        if (useDefaults) {
            this.restoreDefaults();
        }
    }

    public Object clone() {
        SyntaxScheme shcs = null;
        try {
            shcs = (SyntaxScheme)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            return null;
        }
        shcs.styles = new Style[24];
        for (int i = 0; i < 24; ++i) {
            Style s = this.styles[i];
            if (s == null) continue;
            shcs.styles[i] = (Style)s.clone();
        }
        return shcs;
    }

    public boolean equals(Object otherScheme) {
        if (!(otherScheme instanceof SyntaxScheme)) {
            return false;
        }
        Style[] otherSchemes = ((SyntaxScheme)otherScheme).styles;
        int length = this.styles.length;
        for (int i = 0; i < length; ++i) {
            if (!(this.styles[i] == null ? otherSchemes[i] != null : !this.styles[i].equals(otherSchemes[i]))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        int count = this.styles.length;
        for (int i = 0; i < count; ++i) {
            if (this.styles[i] == null) continue;
            hashCode = this.styles[i].hashCode();
            break;
        }
        return hashCode;
    }

    public static SyntaxScheme loadFromString(String string) {
        SyntaxScheme scheme = new SyntaxScheme(true);
        try {
            if (string != null) {
                int tokenTypeCount = 24;
                int tokenCount = tokenTypeCount * 7;
                String[] tokens = string.split(",", -1);
                if (tokens.length != tokenCount) {
                    throw new Exception("Not enough tokens in packed color scheme: expected " + tokenCount + ", found " + tokens.length);
                }
                for (int i = 0; i < tokenTypeCount; ++i) {
                    int pos = i * 7;
                    int integer = Integer.parseInt(tokens[pos]);
                    if (integer != i) {
                        throw new Exception("Expected " + i + ", found " + integer);
                    }
                    Color fg = null;
                    String temp = tokens[pos + 1];
                    fg = "-".equals(temp) ? null : new Color(Integer.parseInt(temp));
                    Color bg = null;
                    temp = tokens[pos + 2];
                    bg = "-".equals(temp) ? null : new Color(Integer.parseInt(temp));
                    temp = tokens[pos + 3];
                    if (!"t".equals(temp) && !"f".equals(temp)) {
                        throw new Exception("Expected 't' or 'f', found " + temp);
                    }
                    boolean underline = "t".equals(temp);
                    Font font = null;
                    String family = tokens[pos + 4];
                    if (!"-".equals(family)) {
                        font = new Font(family, Integer.parseInt(tokens[pos + 5]), Integer.parseInt(tokens[pos + 6]));
                    }
                    scheme.styles[i] = new Style(fg, bg, font, underline);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return scheme;
    }

    void refreshFontMetrics(Graphics2D g2d) {
        for (int i = 0; i < this.styles.length; ++i) {
            Style s = this.styles[i];
            if (s == null) continue;
            s.fontMetrics = s.font == null ? null : g2d.getFontMetrics(s.font);
        }
    }

    public void restoreDefaults() {
        Font italicFont;
        Color comment = new Color(0, 128, 0);
        Color docComment = new Color(164, 0, 0);
        Color keyword = Color.BLUE;
        Color function = new Color(173, 128, 0);
        Color literalNumber = new Color(100, 0, 200);
        Color literalString = new Color(220, 0, 156);
        Color error = new Color(148, 148, 0);
        Font temp = RSyntaxTextArea.getDefaultFont();
        StyleContext sc = StyleContext.getDefaultStyleContext();
        Font boldFont = sc.getFont(temp.getFamily(), 1, temp.getSize());
        Font commentFont = italicFont = sc.getFont(temp.getFamily(), 2, temp.getSize());
        Font keywordFont = boldFont;
        this.styles[1] = new Style(comment, null, commentFont);
        this.styles[2] = new Style(comment, null, commentFont);
        this.styles[3] = new Style(docComment, null, commentFont);
        this.styles[4] = new Style(keyword, null, keywordFont);
        this.styles[5] = new Style(function, null);
        this.styles[6] = new Style(literalNumber, null);
        this.styles[7] = new Style(literalNumber, null);
        this.styles[8] = new Style(literalNumber, null);
        this.styles[9] = new Style(literalNumber, null);
        this.styles[10] = new Style(literalString, null);
        this.styles[11] = new Style(literalString, null);
        this.styles[12] = new Style(literalString, null);
        this.styles[13] = new Style(new Color(0, 128, 128), null);
        this.styles[14] = new Style(new Color(255, 153, 0), null);
        this.styles[15] = new Style(null, null);
        this.styles[16] = new Style(null, null);
        this.styles[17] = new Style(Color.RED, null);
        this.styles[18] = new Style(new Color(128, 64, 64), null);
        this.styles[19] = new Style(new Color(128, 128, 128), null);
        this.styles[20] = new Style(error, null);
        this.styles[21] = new Style(error, null);
        this.styles[22] = new Style(error, null);
        this.styles[23] = new Style(error, null);
    }

    public void setStyle(int type, Style style) {
        this.styles[type] = style;
    }

    public String toCommaSeparatedString() {
        String retVal = "";
        for (int i = 0; i < 24; ++i) {
            retVal = retVal + i + ",";
            Style ss = this.styles[i];
            if (ss == null) {
                retVal = retVal + "-,-,f,-,,,";
                continue;
            }
            Color c = ss.foreground;
            retVal = retVal + (c != null ? c.getRGB() + "," : "-,");
            c = ss.background;
            retVal = retVal + (c != null ? c.getRGB() + "," : "-,");
            retVal = retVal + (ss.underline ? "t," : "f,");
            Font font = ss.font;
            retVal = font != null ? retVal + font.getFamily() + "," + font.getStyle() + "," + font.getSize() + "," : retVal + "-,,,";
        }
        return retVal.substring(0, retVal.length() - 1);
    }
}

