/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fife.ui.rsyntaxtextarea.Parser;
import org.fife.ui.rsyntaxtextarea.ParserNotice;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
implements Parser {
    private SAXParserFactory spf;
    private RSyntaxTextArea textArea;
    private ArrayList noticeList = new ArrayList(1);

    public XMLParser(RSyntaxTextArea textArea) {
        this.textArea = textArea;
        try {
            this.spf = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError fce) {
            fce.printStackTrace();
        }
    }

    @Override
    public Iterator getNoticeIterator() {
        return this.noticeList.iterator();
    }

    @Override
    public void parse(Reader r) {
        this.noticeList.clear();
        if (this.spf == null) {
            return;
        }
        try {
            SAXParser sp = this.spf.newSAXParser();
            Handler handler = new Handler();
            InputSource input = new InputSource(r);
            sp.parse(input, (DefaultHandler)handler);
        }
        catch (SAXParseException spe) {
        }
        catch (Exception e) {
            e.printStackTrace();
            this.noticeList.add(new ParserNotice("Error parsing XML: " + e.getMessage(), -1, -1));
        }
    }

    private class Handler
    extends DefaultHandler {
        private Handler() {
        }

        private void doError(SAXParseException e) {
            int line = e.getLineNumber() - 1;
            try {
                int offs = XMLParser.this.textArea.getLineStartOffset(line);
                int len = XMLParser.this.textArea.getLineEndOffset(line) - offs + 1;
                ParserNotice pn = new ParserNotice(e.getMessage(), offs, len, e.getLineNumber(), e.getColumnNumber());
                XMLParser.this.noticeList.add(pn);
                System.err.println(">>> " + offs + "-" + len + " -> " + pn);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.doError(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.doError(e);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            this.doError(e);
        }
    }
}

