/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.fife.ui.rtextarea.RegExReplaceInfo;

public class SearchEngine {
    private SearchEngine() {
    }

    public static boolean find(JTextArea textArea, String text, boolean forward, boolean matchCase, boolean wholeWord, boolean regex) throws PatternSyntaxException {
        Caret c = textArea.getCaret();
        int start = forward ? Math.max(c.getDot(), c.getMark()) : Math.min(c.getDot(), c.getMark());
        String findIn = SearchEngine.getFindInText(textArea, start, forward);
        if (findIn == null || findIn.length() == 0) {
            return false;
        }
        if (!regex) {
            int pos = SearchEngine.getNextMatchPos(text, findIn, forward, matchCase, wholeWord);
            findIn = null;
            if (pos != -1) {
                c.setSelectionVisible(true);
                pos = forward ? start + pos : pos;
                c.setDot(pos);
                c.moveDot(pos + text.length());
                return true;
            }
        } else {
            Point regExPos = SearchEngine.getNextMatchPosRegEx(text, findIn, forward, matchCase, wholeWord);
            findIn = null;
            if (regExPos != null) {
                c.setSelectionVisible(true);
                if (forward) {
                    regExPos.translate(start, start);
                }
                c.setDot(regExPos.x);
                c.moveDot(regExPos.y);
                return true;
            }
        }
        return false;
    }

    protected static String getFindInText(JTextArea textArea, int start, boolean forward) {
        String findIn = null;
        if (forward) {
            try {
                findIn = textArea.getText(start, textArea.getDocument().getLength() - start);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        } else {
            try {
                findIn = textArea.getText(0, start);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
        return findIn;
    }

    protected static List getMatches(Matcher m, String replaceStr) {
        ArrayList<Object> matches = new ArrayList<Object>();
        while (m.find()) {
            Point loc = new Point(m.start(), m.end());
            if (replaceStr == null) {
                matches.add(loc);
                continue;
            }
            matches.add(new RegExReplaceInfo(m.group(0), loc.x, loc.y, SearchEngine.getReplacementText(m, replaceStr)));
        }
        return matches;
    }

    public static final int getNextMatchPos(String searchFor, String searchIn, boolean forward, boolean matchCase, boolean wholeWord) {
        if (!matchCase) {
            return SearchEngine.getNextMatchPosImpl(searchFor.toLowerCase(), searchIn.toLowerCase(), forward, matchCase, wholeWord);
        }
        return SearchEngine.getNextMatchPosImpl(searchFor, searchIn, forward, matchCase, wholeWord);
    }

    protected static final int getNextMatchPosImpl(String searchFor, String searchIn, boolean goForward, boolean matchCase, boolean wholeWord) {
        if (wholeWord) {
            int len = searchFor.length();
            int temp = goForward ? 0 : searchIn.length();
            int tempChange = goForward ? 1 : -1;
            while ((temp = goForward ? searchIn.indexOf(searchFor, temp) : searchIn.lastIndexOf(searchFor, temp)) != -1) {
                if (SearchEngine.isWholeWord(searchIn, temp, len)) {
                    return temp;
                }
                temp += tempChange;
            }
            return temp;
        }
        return goForward ? searchIn.indexOf(searchFor) : searchIn.lastIndexOf(searchFor);
    }

    public static Point getNextMatchPosRegEx(String regEx, CharSequence searchIn, boolean goForward, boolean matchCase, boolean wholeWord) {
        return (Point)SearchEngine.getNextMatchPosRegExImpl(regEx, searchIn, goForward, matchCase, wholeWord, null);
    }

    protected static Object getNextMatchPosRegExImpl(String regEx, CharSequence searchIn, boolean goForward, boolean matchCase, boolean wholeWord, String replaceStr) {
        int flags = 8;
        Pattern pattern = Pattern.compile(regEx, flags |= matchCase ? 0 : 66);
        Matcher m = pattern.matcher(searchIn);
        if (goForward) {
            if (!wholeWord) {
                if (m.find()) {
                    if (replaceStr == null) {
                        return new Point(m.start(), m.end());
                    }
                    return new RegExReplaceInfo(m.group(0), m.start(), m.end(), SearchEngine.getReplacementText(m, replaceStr));
                }
            } else {
                while (m.find()) {
                    Point loc = new Point(m.start(), m.end());
                    if (!SearchEngine.isWholeWord(searchIn, loc.x, loc.y - loc.x)) continue;
                    if (replaceStr == null) {
                        return loc;
                    }
                    return new RegExReplaceInfo(m.group(0), loc.x, loc.y, SearchEngine.getReplacementText(m, replaceStr));
                }
            }
        } else {
            int pos;
            List matches = SearchEngine.getMatches(m, replaceStr);
            if (matches.isEmpty()) {
                return null;
            }
            if (!wholeWord) {
                if (replaceStr == null) {
                    return matches.get(pos);
                }
                return matches.get(pos);
            }
            for (pos = matches.size() - 1; pos >= 0; --pos) {
                int y;
                Object matchObj = matches.get(pos);
                if (replaceStr == null) {
                    Point loc = (Point)matchObj;
                    if (!SearchEngine.isWholeWord(searchIn, loc.x, loc.y - loc.x)) continue;
                    return matchObj;
                }
                RegExReplaceInfo info = (RegExReplaceInfo)matchObj;
                int x = info.getStartIndex();
                if (!SearchEngine.isWholeWord(searchIn, x, (y = info.getEndIndex()) - x)) continue;
                return matchObj;
            }
        }
        return null;
    }

    protected static RegExReplaceInfo getRegExReplaceInfo(String regEx, String searchIn, boolean goForward, boolean matchCase, boolean wholeWord, String replacement) {
        if (replacement == null) {
            replacement = "";
        }
        return (RegExReplaceInfo)SearchEngine.getNextMatchPosRegExImpl(regEx, searchIn, goForward, matchCase, wholeWord, replacement);
    }

    public static String getReplacementText(Matcher m, CharSequence template) {
        int cursor = 0;
        StringBuffer result = new StringBuffer();
        while (cursor < template.length()) {
            char nextChar = template.charAt(cursor);
            if (nextChar == '\\') {
                nextChar = template.charAt(++cursor);
                switch (nextChar) {
                    case 'n': {
                        nextChar = '\n';
                        break;
                    }
                    case 't': {
                        nextChar = '\t';
                    }
                }
                result.append(nextChar);
                ++cursor;
                continue;
            }
            if (nextChar == '$') {
                int nextDigit;
                int refNum;
                if ((refNum = template.charAt(++cursor) - 48) < 0 || refNum > 9) {
                    throw new IndexOutOfBoundsException("No group " + template.charAt(cursor));
                }
                ++cursor;
                boolean done = false;
                while (!done && cursor < template.length() && (nextDigit = template.charAt(cursor) - 48) >= 0 && nextDigit <= 9) {
                    int newRefNum = refNum * 10 + nextDigit;
                    if (m.groupCount() < newRefNum) {
                        done = true;
                        continue;
                    }
                    refNum = newRefNum;
                    ++cursor;
                }
                if (m.group(refNum) == null) continue;
                result.append(m.group(refNum));
                continue;
            }
            result.append(nextChar);
            ++cursor;
        }
        return result.toString();
    }

    private static final boolean isWholeWord(CharSequence searchIn, int offset, int len) {
        boolean wsAfter;
        boolean wsBefore;
        try {
            wsBefore = Character.isWhitespace(searchIn.charAt(offset - 1));
        }
        catch (IndexOutOfBoundsException e) {
            wsBefore = true;
        }
        try {
            wsAfter = Character.isWhitespace(searchIn.charAt(offset + len));
        }
        catch (IndexOutOfBoundsException e) {
            wsAfter = true;
        }
        return wsBefore && wsAfter;
    }

    protected static int makeMarkAndDotEqual(JTextArea textArea, boolean forward) {
        Caret c = textArea.getCaret();
        int val = forward ? Math.min(c.getDot(), c.getMark()) : Math.max(c.getDot(), c.getMark());
        c.setDot(val);
        return val;
    }

    protected static boolean regexReplace(JTextArea textArea, String toFind, String replaceWith, boolean forward, boolean matchCase, boolean wholeWord) throws PatternSyntaxException {
        Caret c = textArea.getCaret();
        int start = SearchEngine.makeMarkAndDotEqual(textArea, forward);
        String findIn = SearchEngine.getFindInText(textArea, start, forward);
        if (findIn == null) {
            return false;
        }
        RegExReplaceInfo info = SearchEngine.getRegExReplaceInfo(toFind, findIn, forward, matchCase, wholeWord, replaceWith);
        findIn = null;
        if (info != null) {
            c.setSelectionVisible(true);
            int matchStart = info.getStartIndex();
            int matchEnd = info.getEndIndex();
            if (forward) {
                matchStart += start;
                matchEnd += start;
            }
            c.setDot(matchStart);
            c.moveDot(matchEnd);
            textArea.replaceSelection(info.getReplacement());
            return true;
        }
        return false;
    }

    public static boolean replace(JTextArea textArea, String toFind, String replaceWith, boolean forward, boolean matchCase, boolean wholeWord, boolean regex) throws PatternSyntaxException {
        if (regex) {
            return SearchEngine.regexReplace(textArea, toFind, replaceWith, forward, matchCase, wholeWord);
        }
        SearchEngine.makeMarkAndDotEqual(textArea, forward);
        if (SearchEngine.find(textArea, toFind, forward, matchCase, wholeWord, false)) {
            textArea.replaceSelection(replaceWith);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int replaceAll(JTextArea textArea, String toFind, String replaceWith, boolean matchCase, boolean wholeWord, boolean regex) throws PatternSyntaxException {
        int count = 0;
        if (regex) {
            StringBuffer sb = new StringBuffer();
            String findIn = textArea.getText();
            int lastEnd = 0;
            Pattern p = Pattern.compile(toFind);
            Matcher m = p.matcher(findIn);
            try {
                while (m.find()) {
                    sb.append(findIn.substring(lastEnd, m.start()));
                    sb.append(SearchEngine.getReplacementText(m, replaceWith));
                    lastEnd = m.end();
                    ++count;
                }
                sb.append(findIn.substring(lastEnd));
                textArea.setText(sb.toString());
            }
            finally {
                findIn = null;
            }
        } else {
            textArea.setCaretPosition(0);
            while (SearchEngine.find(textArea, toFind, true, matchCase, wholeWord, false)) {
                textArea.replaceSelection(replaceWith);
                ++count;
            }
        }
        return count;
    }
}

