/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.MarkOccurrencesHighlightPainter;
import org.fife.ui.rtextarea.RTextArea;

public class RSyntaxTextAreaHighlighter
extends BasicTextUI.BasicHighlighter {
    private RTextArea textArea;
    private List markedOccurrences = new ArrayList();

    Object addMarkedOccurrenceHighlight(int start, int end, MarkOccurrencesHighlightPainter p) throws BadLocationException {
        Document doc = this.textArea.getDocument();
        TextUI mapper = this.textArea.getUI();
        HighlightInfo i = this.getDrawsLayeredHighlights() ? new LayeredHighlightInfo() : new HighlightInfo();
        i.painter = p;
        i.p0 = doc.createPosition(start);
        i.p1 = doc.createPosition(end - 1);
        this.markedOccurrences.add(i);
        mapper.damageRange(this.textArea, start, end);
        return i;
    }

    @Override
    public void deinstall(JTextComponent c) {
        this.textArea = null;
        this.markedOccurrences.clear();
    }

    @Override
    public void install(JTextComponent c) {
        super.install(c);
        this.textArea = (RTextArea)c;
    }

    @Override
    public void paint(Graphics g) {
        int len = this.markedOccurrences.size();
        for (int i = 0; i < len; ++i) {
            HighlightInfo info = (HighlightInfo)this.markedOccurrences.get(i);
            if (info instanceof LayeredHighlightInfo) continue;
            Rectangle a = this.textArea.getBounds();
            Insets insets = this.textArea.getInsets();
            a.x = insets.left;
            a.y = insets.top;
            a.width -= insets.left + insets.right;
            a.height -= insets.top + insets.bottom;
            while (i < len) {
                info = (HighlightInfo)this.markedOccurrences.get(i);
                if (!(info instanceof LayeredHighlightInfo)) {
                    Highlighter.HighlightPainter p = info.getPainter();
                    p.paint(g, info.getStartOffset(), info.getEndOffset(), a, this.textArea);
                }
                ++i;
            }
        }
        super.paint(g);
    }

    @Override
    public void paintLayeredHighlights(Graphics g, int p0, int p1, Shape viewBounds, JTextComponent editor, View view) {
        for (int i = this.markedOccurrences.size() - 1; i >= 0; --i) {
            Object tag = this.markedOccurrences.get(i);
            if (!(tag instanceof LayeredHighlightInfo)) continue;
            LayeredHighlightInfo lhi = (LayeredHighlightInfo)tag;
            int start = lhi.getStartOffset();
            int end = lhi.getEndOffset();
            if ((p0 >= start || p1 <= start) && (p0 < start || p0 >= end)) continue;
            lhi.paintLayeredHighlights(g, p0, p1, viewBounds, editor, view);
        }
        super.paintLayeredHighlights(g, p0, p1, viewBounds, editor, view);
    }

    void removeMarkOccurrencesHighlight(Object tag) {
        if (tag instanceof LayeredHighlightInfo) {
            LayeredHighlightInfo lhi = (LayeredHighlightInfo)tag;
            if (lhi.width > 0 && lhi.height > 0) {
                this.textArea.repaint(lhi.x, lhi.y, lhi.width, lhi.height);
            }
        } else {
            HighlightInfo info = (HighlightInfo)tag;
            TextUI ui = this.textArea.getUI();
            ui.damageRange(this.textArea, info.getStartOffset(), info.getEndOffset());
        }
        this.markedOccurrences.remove(tag);
    }

    private static class LayeredHighlightInfo
    extends HighlightInfo {
        private int x;
        private int y;
        private int width;
        private int height;

        private LayeredHighlightInfo() {
        }

        void union(Shape bounds) {
            Rectangle alloc;
            if (bounds == null) {
                return;
            }
            Rectangle rectangle = alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            if (this.width == 0 || this.height == 0) {
                this.x = alloc.x;
                this.y = alloc.y;
                this.width = alloc.width;
                this.height = alloc.height;
            } else {
                this.width = Math.max(this.x + this.width, alloc.x + alloc.width);
                this.height = Math.max(this.y + this.height, alloc.y + alloc.height);
                this.x = Math.min(this.x, alloc.x);
                this.width -= this.x;
                this.y = Math.min(this.y, alloc.y);
                this.height -= this.y;
            }
        }

        void paintLayeredHighlights(Graphics g, int p0, int p1, Shape viewBounds, JTextComponent editor, View view) {
            int start = this.getStartOffset();
            int end = this.getEndOffset();
            p0 = Math.max(start, p0);
            p1 = Math.min(end, p1);
            this.union(((LayeredHighlighter.LayerPainter)this.painter).paintLayer(g, p0, p1, viewBounds, editor, view));
        }
    }

    private static class HighlightInfo
    implements Highlighter.Highlight {
        private Position p0;
        private Position p1;
        protected Highlighter.HighlightPainter painter;

        private HighlightInfo() {
        }

        @Override
        public int getStartOffset() {
            return this.p0.getOffset();
        }

        @Override
        public int getEndOffset() {
            return this.p1.getOffset();
        }

        @Override
        public Highlighter.HighlightPainter getPainter() {
            return this.painter;
        }
    }
}

