/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.fife.ui.rtextarea.AbstractGutterComponent;
import org.fife.ui.rtextarea.GutterIconInfo;
import org.fife.ui.rtextarea.LineNumberList;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaUI;

class IconRowHeader
extends AbstractGutterComponent
implements MouseListener {
    private List trackingIcons;
    private int width = 16;
    private boolean bookmarkingEnabled;
    private Icon bookmarkIcon;
    private Rectangle visibleRect = new Rectangle();
    private Insets textAreaInsets;

    public IconRowHeader(RTextArea textArea) {
        super(textArea);
        this.addMouseListener(this);
    }

    public GutterIconInfo addOffsetTrackingIcon(int offs, Icon icon) throws BadLocationException {
        int index;
        Position pos = this.textArea.getDocument().createPosition(offs);
        GutterIconImpl ti = new GutterIconImpl(icon, pos);
        if (this.trackingIcons == null) {
            this.trackingIcons = new ArrayList(1);
        }
        if ((index = Collections.binarySearch(this.trackingIcons, ti)) < 0) {
            index = -(index + 1);
        }
        this.trackingIcons.add(index, ti);
        this.repaint();
        return ti;
    }

    public Icon getBookmarkIcon() {
        return this.bookmarkIcon;
    }

    public GutterIconInfo[] getBookmarks() {
        ArrayList<GutterIconImpl> retVal = new ArrayList<GutterIconImpl>(1);
        if (this.trackingIcons != null) {
            for (int i = 0; i < this.trackingIcons.size(); ++i) {
                GutterIconImpl ti = this.getTrackingIcon(i);
                if (ti.getIcon() != this.bookmarkIcon) continue;
                retVal.add(ti);
            }
        }
        GutterIconInfo[] array = new GutterIconInfo[retVal.size()];
        return retVal.toArray(array);
    }

    @Override
    void handleDocumentEvent(DocumentEvent e) {
        int newLineCount = this.textArea.getLineCount();
        if (newLineCount != this.currentLineCount) {
            this.currentLineCount = newLineCount;
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int h = this.textArea != null ? this.textArea.getHeight() : 100;
        return new Dimension(this.width, h);
    }

    private GutterIconImpl getTrackingIcon(int index) {
        return (GutterIconImpl)this.trackingIcons.get(index);
    }

    public GutterIconImpl[] getTrackingIcons(int line) throws BadLocationException {
        ArrayList<GutterIconImpl> retVal = new ArrayList<GutterIconImpl>(1);
        if (this.trackingIcons != null) {
            int start = this.textArea.getLineStartOffset(line);
            int end = this.textArea.getLineEndOffset(line);
            if (line == this.textArea.getLineCount() - 1) {
                ++end;
            }
            for (int i = 0; i < this.trackingIcons.size(); ++i) {
                GutterIconImpl ti = this.getTrackingIcon(i);
                int offs = ti.getMarkedOffset();
                if (offs >= start && offs < end) {
                    retVal.add(ti);
                    continue;
                }
                if (offs >= end) break;
            }
        }
        GutterIconImpl[] array = new GutterIconImpl[retVal.size()];
        return retVal.toArray(array);
    }

    public boolean isBookmarkingEnabled() {
        return this.bookmarkingEnabled;
    }

    @Override
    void lineHeightsChanged() {
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.bookmarkingEnabled && this.bookmarkIcon != null) {
            try {
                int offs = this.textArea.viewToModel(e.getPoint());
                if (offs > -1) {
                    int line = this.textArea.getLineOfOffset(offs);
                    this.toggleBookmark(line);
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.textArea == null) {
            return;
        }
        this.visibleRect = g.getClipBounds(this.visibleRect);
        if (this.visibleRect == null) {
            this.visibleRect = this.getVisibleRect();
        }
        if (this.visibleRect == null) {
            return;
        }
        g.setColor(this.getBackground());
        g.fillRect(0, this.visibleRect.y, this.width, this.visibleRect.height);
        if (this.textArea.getLineWrap()) {
            this.paintComponentWrapped(g);
            return;
        }
        Document doc = this.textArea.getDocument();
        Element root = doc.getDefaultRootElement();
        int cellHeight = this.textArea.getLineHeight();
        int topLine = this.visibleRect.y / cellHeight;
        int bottomLine = Math.min(topLine + this.visibleRect.height / cellHeight, root.getElementCount());
        int y = topLine * cellHeight;
        this.textAreaInsets = this.textArea.getInsets(this.textAreaInsets);
        if (this.textAreaInsets != null) {
            y += this.textAreaInsets.top;
        }
        if (this.trackingIcons != null) {
            int lastLine = bottomLine;
            for (int i = this.trackingIcons.size() - 1; i >= 0; --i) {
                GutterIconImpl ti = this.getTrackingIcon(i);
                int offs = ti.getMarkedOffset();
                if (offs < 0 || offs > doc.getLength()) continue;
                int line = root.getElementIndex(offs);
                if (line <= lastLine && line > topLine - 1) {
                    Icon icon = ti.getIcon();
                    if (icon == null) continue;
                    int y2 = y + (line - topLine) * cellHeight;
                    ti.getIcon().paintIcon(this, g, 0, y2 += (cellHeight - icon.getIconHeight()) / 2);
                    lastLine = line - 1;
                    continue;
                }
                if (line <= topLine - 1) break;
            }
        }
    }

    private void paintComponentWrapped(Graphics g) {
        RTextAreaUI ui = (RTextAreaUI)this.textArea.getUI();
        View v = ui.getRootView(this.textArea).getView(0);
        Document doc = this.textArea.getDocument();
        Element root = doc.getDefaultRootElement();
        int lineCount = root.getElementCount();
        int topPosition = this.textArea.viewToModel(new Point(this.visibleRect.x, this.visibleRect.y));
        int topLine = root.getElementIndex(topPosition);
        Rectangle visibleEditorRect = ui.getVisibleEditorRect();
        Rectangle r = IconRowHeader.getChildViewBounds(v, topLine, visibleEditorRect);
        int y = r.y;
        int visibleBottom = this.visibleRect.y + this.visibleRect.height;
        int currentIcon = -1;
        if (this.trackingIcons != null) {
            for (int i = 0; i < this.trackingIcons.size(); ++i) {
                int line;
                GutterIconImpl icon = this.getTrackingIcon(i);
                int offs = icon.getMarkedOffset();
                if (offs < 0 || offs > doc.getLength() || (line = root.getElementIndex(offs)) < topLine) continue;
                currentIcon = i;
                break;
            }
        }
        g.setColor(this.getForeground());
        int cellHeight = this.textArea.getLineHeight();
        while (y < visibleBottom) {
            r = LineNumberList.getChildViewBounds(v, topLine, visibleEditorRect);
            if (currentIcon > -1) {
                Icon icon;
                GutterIconImpl toPaint = null;
                while (currentIcon < this.trackingIcons.size()) {
                    GutterIconImpl ti = this.getTrackingIcon(currentIcon);
                    int offs = ti.getMarkedOffset();
                    if (offs >= 0 && offs <= doc.getLength()) {
                        int line = root.getElementIndex(offs);
                        if (line == topLine) {
                            toPaint = ti;
                        } else if (line > topLine) break;
                    }
                    ++currentIcon;
                }
                if (toPaint != null && (icon = toPaint.getIcon()) != null) {
                    int y2 = y + (cellHeight - icon.getIconHeight()) / 2;
                    icon.paintIcon(this, g, 0, y2);
                }
            }
            y += r.height;
            if (++topLine < lineCount) continue;
            break;
        }
    }

    public void removeTrackingIcon(Object tag) {
        if (this.trackingIcons != null && this.trackingIcons.remove(tag)) {
            this.repaint();
        }
    }

    public void removeAllTrackingIcons() {
        if (this.trackingIcons != null && this.trackingIcons.size() > 0) {
            this.trackingIcons.clear();
            this.repaint();
        }
    }

    private void removeBookmarkTrackingIcons() {
        if (this.trackingIcons != null) {
            Iterator i = this.trackingIcons.iterator();
            while (i.hasNext()) {
                GutterIconImpl ti = (GutterIconImpl)i.next();
                if (ti.getIcon() != this.bookmarkIcon) continue;
                i.remove();
            }
        }
    }

    public void setBookmarkIcon(Icon icon) {
        this.removeBookmarkTrackingIcons();
        this.bookmarkIcon = icon;
        this.repaint();
    }

    public void setBookmarkingEnabled(boolean enabled) {
        if (enabled != this.bookmarkingEnabled) {
            this.bookmarkingEnabled = enabled;
            if (!enabled) {
                this.removeBookmarkTrackingIcons();
            }
            this.repaint();
        }
    }

    @Override
    public void setTextArea(RTextArea textArea) {
        this.removeAllTrackingIcons();
        super.setTextArea(textArea);
    }

    public boolean toggleBookmark(int line) throws BadLocationException {
        if (!this.isBookmarkingEnabled() || this.getBookmarkIcon() == null) {
            return false;
        }
        GutterIconImpl[] icons = this.getTrackingIcons(line);
        if (icons.length == 0) {
            int offs = this.textArea.getLineStartOffset(line);
            this.addOffsetTrackingIcon(offs, this.bookmarkIcon);
            return true;
        }
        boolean found = false;
        for (int i = 0; i < icons.length; ++i) {
            if (icons[i].getIcon() != this.bookmarkIcon) continue;
            this.removeTrackingIcon(icons[i]);
            found = true;
        }
        if (!found) {
            int offs = this.textArea.getLineStartOffset(line);
            this.addOffsetTrackingIcon(offs, this.bookmarkIcon);
        }
        return !found;
    }

    private static class GutterIconImpl
    implements GutterIconInfo,
    Comparable {
        private Icon icon;
        private Position pos;

        public GutterIconImpl(Icon icon, Position pos) {
            this.icon = icon;
            this.pos = pos;
        }

        public int compareTo(Object o) {
            if (o instanceof GutterIconImpl) {
                return this.pos.getOffset() - ((GutterIconImpl)o).getMarkedOffset();
            }
            return -1;
        }

        public boolean equals(Object o) {
            return o == this;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public int getMarkedOffset() {
            return this.pos.getOffset();
        }

        public int hashCode() {
            return this.icon.hashCode();
        }
    }
}

