/*
 * Copyright (c) 2009 Albert Kurucz.
 *
 * This file, HTMLTokenMaker.java is part of JTStand.
 *
 * JTStand is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JTStand is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with JTStand.  If not, see <http://www.gnu.org/licenses/>.
 */

/* The following code was generated by JFlex 1.4.1 on 2/21/09 12:25 AM */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * Scanner for HTML files.
 *
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated HTMLTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.4
 *
 */

public class HTMLTokenMaker extends AbstractJFlexTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int JS_MLC = 11;
  public static final int INTAG_SCRIPT = 7;
  public static final int INATTR_DOUBLE_SCRIPT = 8;
  public static final int INATTR_SINGLE_SCRIPT = 9;
  public static final int DTD = 3;
  public static final int INATTR_SINGLE = 6;
  public static final int INATTR_DOUBLE = 5;
  public static final int YYINITIAL = 0;
  public static final int INTAG = 4;
  public static final int COMMENT = 1;
  public static final int JAVASCRIPT = 10;
  public static final int PI = 2;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\4\1\2\1\0\1\1\1\36\22\0\1\4\1\53\1\27"+
    "\1\0\1\20\1\52\1\5\1\26\2\47\1\37\1\51\1\50\1\45"+
    "\1\46\1\10\1\22\3\35\3\76\1\24\2\21\1\55\1\6\1\3"+
    "\1\7\1\17\1\54\1\0\1\62\1\23\1\12\1\67\1\44\1\42"+
    "\1\70\1\75\1\14\1\77\1\72\1\41\1\66\1\64\1\63\1\15"+
    "\1\73\1\13\1\11\1\16\1\71\1\74\1\20\1\40\1\65\1\20"+
    "\1\47\1\25\1\47\1\52\1\20\1\0\1\101\1\34\1\57\1\104"+
    "\1\100\1\43\1\112\1\107\1\60\1\77\1\102\1\105\1\113\1\33"+
    "\1\103\1\61\1\73\1\31\1\56\1\32\1\30\1\111\1\106\1\114"+
    "\1\110\1\115\1\47\1\52\1\47\1\55\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\5\0\2\1\1\0\2\1\2\0\2\2\1\3\1\4"+
    "\1\5\1\6\1\1\1\7\2\1\1\10\2\1\1\11"+
    "\1\12\2\2\1\13\2\14\1\2\2\14\1\2\1\15"+
    "\1\14\1\16\1\17\1\14\4\2\1\14\4\2\1\14"+
    "\2\2\1\1\1\20\1\1\1\21\1\14\1\22\1\23"+
    "\1\24\1\25\1\26\1\27\1\30\2\13\1\2\2\13"+
    "\2\2\1\13\2\31\1\32\1\33\5\2\1\27\1\2"+
    "\1\13\1\2\1\34\1\13\14\2\1\1\1\35\1\1"+
    "\1\36\1\37\1\0\1\6\1\0\1\40\30\2\1\14"+
    "\7\2\1\14\5\2\1\14\22\2\1\41\2\0\1\42"+
    "\1\43\1\27\1\2\1\13\1\44\1\31\1\45\1\44"+
    "\1\45\1\44\1\46\1\44\2\47\1\32\1\47\1\33"+
    "\1\50\31\2\2\14\15\2\1\14\5\2\1\51\2\0"+
    "\1\52\12\2\1\14\44\2\2\0\1\27\1\2\1\45"+
    "\1\0\2\46\1\32\1\53\2\47\1\32\3\33\32\2"+
    "\1\6\31\2\1\54\1\0\15\2\1\14\14\2\1\0"+
    "\1\55\1\27\1\2\1\32\1\33\1\56\1\50\1\33"+
    "\1\2\1\57\6\2\1\6\22\2\1\60\7\2\1\0"+
    "\10\2\1\14\5\2\1\0\1\27\1\2\1\32\1\33"+
    "\2\2\1\14\3\2\1\14\17\2\1\0\7\2\1\0"+
    "\1\27\1\2\1\32\1\33\16\2\1\61\2\2\1\0"+
    "\7\2\1\0\3\2\1\62\1\2";

  private static int [] zzUnpackAction() {
    int [] result = new int[511];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\116\0\234\0\352\0\u0138\0\u0186\0\u01d4\0\u0222"+
    "\0\u0270\0\u02be\0\u030c\0\u035a\0\u03a8\0\u03f6\0\u0444\0\u0492"+
    "\0\u04e0\0\u052e\0\u057c\0\u0444\0\u05ca\0\u0618\0\u0444\0\u0666"+
    "\0\u06b4\0\u0444\0\u0444\0\u0702\0\u0750\0\u0444\0\u0444\0\u079e"+
    "\0\u07ec\0\u083a\0\u0888\0\u08d6\0\u0444\0\u0924\0\u0444\0\u0444"+
    "\0\u0972\0\u09c0\0\u0a0e\0\u0a5c\0\u0aaa\0\u0af8\0\u0b46\0\u0b94"+
    "\0\u0be2\0\u0c30\0\u0702\0\u0c7e\0\u0ccc\0\u0d1a\0\u0444\0\u0d68"+
    "\0\u0444\0\u0db6\0\u0444\0\u0444\0\u0444\0\u0444\0\u0444\0\u0e04"+
    "\0\u0444\0\u0e52\0\u0ea0\0\u0444\0\u0eee\0\u0f3c\0\u0f8a\0\u0fd8"+
    "\0\u1026\0\u1074\0\u10c2\0\u1110\0\u115e\0\u11ac\0\u11fa\0\u1248"+
    "\0\u1296\0\u12e4\0\u0444\0\u1332\0\u1380\0\u13ce\0\u0444\0\u141c"+
    "\0\u146a\0\u14b8\0\u1506\0\u1554\0\u15a2\0\u15f0\0\u163e\0\u168c"+
    "\0\u16da\0\u1728\0\u1776\0\u17c4\0\u1812\0\u0444\0\u1860\0\u18ae"+
    "\0\u0444\0\u18fc\0\u0444\0\u194a\0\u0444\0\u1998\0\u19e6\0\u1a34"+
    "\0\u1a82\0\u1ad0\0\u1b1e\0\u1b6c\0\u1bba\0\u1c08\0\u1c56\0\u1ca4"+
    "\0\u1cf2\0\u1d40\0\u1d8e\0\u1ddc\0\u1e2a\0\u1e78\0\u1ec6\0\u1f14"+
    "\0\u1f62\0\u1fb0\0\u1ffe\0\u204c\0\u209a\0\u20e8\0\u2136\0\u2184"+
    "\0\u21d2\0\u2220\0\u226e\0\u22bc\0\u230a\0\u2358\0\u23a6\0\u23f4"+
    "\0\u2442\0\u2490\0\u24de\0\u252c\0\u257a\0\u25c8\0\u2616\0\u2664"+
    "\0\u26b2\0\u2700\0\u274e\0\u279c\0\u27ea\0\u2838\0\u2886\0\u28d4"+
    "\0\u0972\0\u2922\0\u2970\0\u29be\0\u2a0c\0\u2a5a\0\u0444\0\u0eee"+
    "\0\u2aa8\0\u2af6\0\u2b44\0\u2b92\0\u2be0\0\u2c2e\0\u2c7c\0\u2c7c"+
    "\0\u2c7c\0\u2cca\0\u2d18\0\u2d66\0\u2db4\0\u2e02\0\u2e50\0\u2e9e"+
    "\0\u2eec\0\u0444\0\u2f3a\0\u0444\0\u2f88\0\u2fd6\0\u3024\0\u3072"+
    "\0\u30c0\0\u310e\0\u315c\0\u31aa\0\u31f8\0\u3246\0\u3294\0\u32e2"+
    "\0\u3330\0\u337e\0\u33cc\0\u341a\0\u3468\0\u34b6\0\u3504\0\u3552"+
    "\0\u35a0\0\u35ee\0\u363c\0\u368a\0\u36d8\0\u3726\0\u0f8a\0\u3774"+
    "\0\u37c2\0\u3810\0\u385e\0\u38ac\0\u38fa\0\u3948\0\u3996\0\u39e4"+
    "\0\u3a32\0\u3a80\0\u3ace\0\u3b1c\0\u3b6a\0\u3bb8\0\u3c06\0\u3c54"+
    "\0\u3ca2\0\u3cf0\0\u0444\0\u3d3e\0\u3d8c\0\u0444\0\u3dda\0\u3e28"+
    "\0\u3e76\0\u3ec4\0\u3f12\0\u3f60\0\u3fae\0\u3ffc\0\u404a\0\u4098"+
    "\0\u40e6\0\u4134\0\u4182\0\u41d0\0\u421e\0\u426c\0\u42ba\0\u4308"+
    "\0\u4356\0\u43a4\0\u43f2\0\u2358\0\u4440\0\u448e\0\u44dc\0\u452a"+
    "\0\u4578\0\u45c6\0\u4614\0\u4662\0\u46b0\0\u46fe\0\u474c\0\u479a"+
    "\0\u47e8\0\u4836\0\u4884\0\u48d2\0\u4920\0\u496e\0\u49bc\0\u4a0a"+
    "\0\u4a58\0\u4aa6\0\u4af4\0\u4b42\0\u4b90\0\u4bde\0\u4c2c\0\u4c7a"+
    "\0\u4cc8\0\u4d16\0\u4d64\0\u2c7c\0\u4db2\0\u4e00\0\u0444\0\u4e4e"+
    "\0\u4e9c\0\u4eea\0\u4f38\0\u4f86\0\u4fd4\0\u5022\0\u5070\0\u50be"+
    "\0\u510c\0\u515a\0\u51a8\0\u51f6\0\u5244\0\u5292\0\u52e0\0\u532e"+
    "\0\u537c\0\u53ca\0\u5418\0\u5466\0\u54b4\0\u5502\0\u5550\0\u559e"+
    "\0\u55ec\0\u563a\0\u5688\0\u56d6\0\u5724\0\u5772\0\u57c0\0\u580e"+
    "\0\u585c\0\u58aa\0\u58f8\0\u5946\0\u5994\0\u59e2\0\u5a30\0\u5a7e"+
    "\0\u5acc\0\u5b1a\0\u5b68\0\u5bb6\0\u5c04\0\u5c52\0\u5ca0\0\u5cee"+
    "\0\u5d3c\0\u5d8a\0\u5dd8\0\u5e26\0\u5e74\0\u5ec2\0\u5f10\0\u5f5e"+
    "\0\u5fac\0\u0444\0\u5ffa\0\u6048\0\u6096\0\u60e4\0\u6132\0\u6180"+
    "\0\u61ce\0\u621c\0\u626a\0\u62b8\0\u6306\0\u6354\0\u63a2\0\u63f0"+
    "\0\u643e\0\u648c\0\u64da\0\u252c\0\u6528\0\u6576\0\u65c4\0\u6612"+
    "\0\u6660\0\u66ae\0\u66fc\0\u674a\0\u6798\0\u67e6\0\u0444\0\u6834"+
    "\0\u6882\0\u68d0\0\u691e\0\u0444\0\u4f38\0\u696c\0\u69ba\0\u0f8a"+
    "\0\u6a08\0\u6a56\0\u6aa4\0\u6af2\0\u6b40\0\u6b8e\0\u0f8a\0\u6bdc"+
    "\0\u6c2a\0\u6c78\0\u6cc6\0\u6d14\0\u6d62\0\u6db0\0\u6dfe\0\u6e4c"+
    "\0\u6e9a\0\u6ee8\0\u6f36\0\u6f84\0\u6fd2\0\u7020\0\u706e\0\u70bc"+
    "\0\u710a\0\u0f8a\0\u7158\0\u71a6\0\u71f4\0\u7242\0\u7290\0\u72de"+
    "\0\u732c\0\u737a\0\u73c8\0\u7416\0\u7464\0\u74b2\0\u7500\0\u754e"+
    "\0\u759c\0\u75ea\0\u7638\0\u7638\0\u7686\0\u76d4\0\u7722\0\u7770"+
    "\0\u77be\0\u780c\0\u785a\0\u78a8\0\u78f6\0\u7944\0\u7992\0\u51a8"+
    "\0\u79e0\0\u7a2e\0\u7a7c\0\u7aca\0\u7b18\0\u7b66\0\u7bb4\0\u7c02"+
    "\0\u7c50\0\u7c9e\0\u7cec\0\u7d3a\0\u7d88\0\u7dd6\0\u7e24\0\u7e72"+
    "\0\u7ec0\0\u7f0e\0\u7f5c\0\u7faa\0\u7ff8\0\u8046\0\u8094\0\u80e2"+
    "\0\u8130\0\u817e\0\u81cc\0\u821a\0\u8268\0\u82b6\0\u8304\0\u8352"+
    "\0\u83a0\0\u83ee\0\u843c\0\u848a\0\u84d8\0\u8526\0\u8574\0\u85c2"+
    "\0\u8610\0\u865e\0\u86ac\0\u86fa\0\u8748\0\u8796\0\u0444\0\u87e4"+
    "\0\u8832\0\u8880\0\u88ce\0\u891c\0\u896a\0\u89b8\0\u8a06\0\u8a54"+
    "\0\u8aa2\0\u8af0\0\u8b3e\0\u8b8c\0\u8bda\0\u0444\0\u8c28";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[511];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\15\1\16\1\17\1\20\1\21\1\22\110\15\2\23"+
    "\1\24\42\23\1\25\50\23\2\26\1\27\51\26\1\30"+
    "\41\26\2\31\1\32\14\31\1\33\76\31\1\34\1\35"+
    "\1\0\1\34\1\21\2\34\1\36\1\37\1\40\1\41"+
    "\1\34\1\42\1\43\1\44\1\45\3\34\1\46\2\34"+
    "\1\47\1\50\1\51\1\34\1\44\1\52\1\46\4\34"+
    "\1\53\2\54\1\55\11\34\1\40\1\41\1\42\1\43"+
    "\1\56\1\57\1\52\1\34\1\60\1\61\1\34\1\51"+
    "\1\62\1\63\1\64\1\65\2\34\1\55\1\56\1\62"+
    "\1\57\1\61\1\53\1\34\1\65\1\34\1\64\1\34"+
    "\1\60\2\34\27\66\1\67\66\66\26\70\1\71\67\70"+
    "\1\34\1\35\1\0\1\34\1\21\2\34\1\36\1\72"+
    "\6\34\1\73\6\34\1\74\1\75\66\34\27\66\1\76"+
    "\66\66\26\70\1\77\67\70\1\100\1\21\1\101\1\102"+
    "\1\21\1\103\1\104\1\105\1\106\3\107\1\110\2\107"+
    "\1\111\1\107\1\112\1\113\1\107\1\112\1\100\1\114"+
    "\1\115\1\116\1\117\1\120\1\121\1\122\1\112\1\123"+
    "\1\105\3\107\1\124\1\107\1\125\1\126\1\127\1\104"+
    "\1\130\2\105\2\36\1\131\1\132\1\133\1\134\2\107"+
    "\1\135\11\107\1\112\1\107\1\136\1\137\2\107\1\140"+
    "\1\141\1\142\2\107\1\143\1\144\3\107\2\145\1\146"+
    "\34\145\1\147\56\145\2\15\4\0\111\15\1\16\2\0"+
    "\1\21\1\0\110\15\171\0\1\150\1\151\1\0\1\152"+
    "\40\0\1\21\2\0\1\21\111\0\4\22\1\0\1\22"+
    "\1\153\107\22\2\23\1\0\42\23\1\0\50\23\45\0"+
    "\1\154\50\0\2\26\1\0\51\26\1\0\41\26\17\0"+
    "\1\155\76\0\2\31\1\0\14\31\1\0\76\31\2\34"+
    "\1\0\1\34\1\0\2\34\2\0\6\34\1\0\6\34"+
    "\2\0\67\34\1\35\1\0\1\34\1\21\2\34\2\0"+
    "\6\34\1\0\6\34\2\0\70\34\1\0\1\34\1\0"+
    "\2\34\2\0\1\34\1\156\2\34\1\157\1\160\1\0"+
    "\6\34\2\0\1\161\1\34\1\160\11\34\1\162\12\34"+
    "\1\156\1\34\1\157\1\163\3\34\1\164\2\34\1\161"+
    "\6\34\1\162\1\163\11\34\1\164\4\34\1\0\1\34"+
    "\1\0\2\34\2\0\3\34\1\165\2\34\1\0\6\34"+
    "\2\0\14\34\1\166\13\34\1\165\1\34\1\167\1\170"+
    "\14\34\1\166\1\167\1\34\1\170\14\34\1\0\1\34"+
    "\1\0\2\34\2\0\1\171\5\34\1\0\6\34\2\0"+
    "\3\34\1\172\5\34\1\173\2\174\12\34\1\171\5\34"+
    "\1\172\1\34\1\175\16\34\1\173\5\34\1\175\4\34"+
    "\1\0\1\34\1\0\2\34\2\0\2\34\1\176\3\34"+
    "\1\0\6\34\2\0\1\34\1\176\7\34\1\177\20\34"+
    "\1\200\16\34\1\200\3\34\1\177\12\34\1\0\1\34"+
    "\1\0\2\34\2\0\2\34\1\63\1\201\1\34\1\63"+
    "\1\0\3\34\1\202\2\34\2\0\1\34\2\63\1\34"+
    "\1\202\5\34\2\203\1\204\13\34\1\201\1\34\1\205"+
    "\4\34\1\63\5\34\1\206\2\34\1\204\1\205\2\34"+
    "\1\63\2\34\1\206\10\34\1\0\1\34\1\0\2\34"+
    "\2\0\2\34\1\63\1\175\2\34\1\0\6\34\2\0"+
    "\1\207\1\63\7\34\1\210\16\34\1\175\1\34\1\211"+
    "\1\212\3\34\1\213\1\214\1\207\7\34\1\211\1\34"+
    "\1\212\1\213\1\210\4\34\1\214\5\34\1\0\1\34"+
    "\1\0\2\34\2\0\6\34\1\0\6\34\2\0\11\34"+
    "\1\63\43\34\1\63\12\34\1\0\1\34\1\0\2\34"+
    "\2\0\6\34\1\0\6\34\2\0\33\34\1\215\17\34"+
    "\1\215\14\34\1\0\1\34\1\0\2\34\2\0\3\34"+
    "\1\216\2\34\1\0\6\34\2\0\14\34\1\217\13\34"+
    "\1\216\1\34\1\220\15\34\1\217\1\220\16\34\1\0"+
    "\1\34\1\0\2\34\2\0\2\34\1\221\1\222\2\34"+
    "\1\0\6\34\2\0\1\34\1\221\26\34\1\222\2\34"+
    "\1\223\17\34\1\223\14\34\1\0\1\34\1\0\2\34"+
    "\2\0\6\34\1\0\6\34\2\0\36\34\1\224\24\34"+
    "\1\224\4\34\1\0\1\34\1\0\2\34\2\0\1\34"+
    "\1\225\1\226\1\34\1\227\1\34\1\0\3\34\1\230"+
    "\2\34\2\0\1\34\1\226\2\34\1\230\22\34\1\225"+
    "\1\34\1\227\5\34\1\231\14\34\1\231\13\34\1\0"+
    "\1\34\1\0\2\34\2\0\4\34\1\232\1\34\1\0"+
    "\3\34\1\233\2\34\2\0\4\34\1\233\4\34\1\63"+
    "\17\34\1\232\23\34\1\63\12\34\1\0\1\34\1\0"+
    "\2\34\2\0\6\34\1\0\6\34\2\0\1\234\13\34"+
    "\1\235\15\34\1\236\6\34\1\234\6\34\1\235\1\236"+
    "\16\34\1\0\1\34\1\0\2\34\2\0\3\34\1\237"+
    "\1\34\1\63\1\0\6\34\2\0\2\34\1\63\6\34"+
    "\1\63\2\240\1\241\13\34\1\237\6\34\1\63\10\34"+
    "\1\241\3\34\2\63\12\34\1\0\1\34\1\0\2\34"+
    "\2\0\6\34\1\0\3\34\1\242\2\34\2\0\4\34"+
    "\1\242\7\34\1\243\33\34\1\243\17\34\1\0\1\34"+
    "\1\0\2\34\2\0\6\34\1\0\6\34\2\0\32\34"+
    "\1\244\16\34\1\244\16\34\1\0\1\34\1\0\2\34"+
    "\2\0\2\34\1\63\2\34\1\245\1\0\6\34\2\0"+
    "\1\34\1\63\1\245\2\34\1\63\6\34\1\246\31\34"+
    "\1\63\1\34\1\246\15\34\27\66\1\0\66\66\26\70"+
    "\1\0\67\70\17\0\1\247\76\0\1\100\10\0\6\100"+
    "\1\0\6\100\2\0\6\100\2\0\5\100\11\0\40\100"+
    "\3\0\1\250\3\0\1\36\1\251\112\0\1\36\1\0"+
    "\1\36\115\0\1\36\115\0\1\36\1\252\26\0\1\253"+
    "\56\0\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\6\107\2\0\5\107\11\0\40\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\3\107\1\255\2\107\2\0"+
    "\5\107\11\0\40\107\7\0\1\36\7\0\1\256\76\0"+
    "\1\257\10\0\6\257\1\0\1\257\2\112\1\257\1\112"+
    "\1\257\2\0\5\257\1\112\2\0\1\257\1\260\2\261"+
    "\1\262\1\0\1\263\7\0\11\257\1\261\6\257\1\112"+
    "\1\257\1\262\3\257\1\261\1\260\11\257\10\0\6\257"+
    "\1\0\1\257\1\264\1\265\1\257\1\265\1\257\2\0"+
    "\5\257\1\265\2\0\1\266\1\260\2\261\1\262\1\0"+
    "\1\263\7\0\11\257\1\261\6\257\1\265\1\257\1\262"+
    "\3\257\1\261\1\260\6\257\1\266\1\257\2\267\1\270"+
    "\22\267\1\271\1\272\67\267\2\115\1\0\22\115\1\273"+
    "\1\115\1\274\66\115\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\3\107\1\275\2\107\2\0\5\107\11\0"+
    "\40\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\6\107\2\0\5\107\11\0\22\107\1\276\15\107\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\1\107\1\277"+
    "\4\107\2\0\5\107\11\0\31\107\1\300\1\301\5\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\1\302"+
    "\5\107\2\0\5\107\11\0\22\107\1\303\1\304\14\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\1\107"+
    "\1\305\4\107\2\0\5\107\11\0\25\107\1\306\4\107"+
    "\1\307\5\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\1\310\5\107\2\0\5\107\11\0\2\107\1\311"+
    "\20\107\1\312\1\107\1\313\1\107\1\314\10\107\7\0"+
    "\1\36\35\0\1\36\71\0\2\263\1\0\1\263\10\0"+
    "\1\263\40\0\1\263\26\0\1\36\41\0\1\36\44\0"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\1\315"+
    "\1\107\1\316\3\107\2\0\5\107\11\0\30\107\1\317"+
    "\1\320\1\321\5\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\6\107\2\0\5\107\11\0\23\107\1\322"+
    "\1\107\1\323\1\107\1\324\1\107\1\325\6\107\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\3\107\1\326"+
    "\2\107\2\0\3\107\1\327\1\107\11\0\1\330\34\107"+
    "\1\331\2\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\1\332\1\333\4\107\2\0\5\107\11\0\23\107"+
    "\1\334\14\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\5\107\11\0\23\107\1\335\14\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\3\107"+
    "\1\336\2\107\2\0\5\107\11\0\1\337\26\107\1\340"+
    "\3\107\1\341\2\107\1\342\1\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\4\107\1\343\1\107\2\0"+
    "\5\107\11\0\40\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\6\107\2\0\5\107\11\0\22\107\1\344"+
    "\2\107\1\345\12\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\6\107\2\0\5\107\11\0\25\107\1\346"+
    "\12\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\6\107\2\0\5\107\11\0\2\107\1\347\26\107\1\350"+
    "\6\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\6\107\2\0\5\107\11\0\23\107\1\313\1\107\1\351"+
    "\12\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\6\107\2\0\5\107\11\0\25\107\1\352\12\107\2\145"+
    "\1\0\34\145\1\0\56\145\10\0\1\353\152\0\1\354"+
    "\127\0\1\355\55\0\1\356\76\0\2\34\1\0\1\34"+
    "\1\0\2\34\2\0\2\34\1\357\3\34\1\0\6\34"+
    "\2\0\1\34\1\357\66\34\1\0\1\34\1\0\2\34"+
    "\2\0\6\34\1\0\6\34\2\0\32\34\1\360\16\34"+
    "\1\360\16\34\1\0\1\34\1\0\2\34\2\0\2\34"+
    "\1\361\3\34\1\0\6\34\2\0\1\34\1\361\33\34"+
    "\1\362\22\34\1\362\7\34\1\0\1\34\1\0\2\34"+
    "\2\0\4\34\1\63\1\34\1\0\3\34\1\63\2\34"+
    "\2\0\4\34\1\63\24\34\1\63\36\34\1\0\1\34"+
    "\1\0\2\34\2\0\2\34\1\363\3\34\1\0\6\34"+
    "\2\0\1\34\1\363\7\34\1\364\43\34\1\364\12\34"+
    "\1\0\1\34\1\0\2\34\2\0\6\34\1\0\6\34"+
    "\2\0\36\34\1\365\24\34\1\365\4\34\1\0\1\34"+
    "\1\0\2\34\2\0\6\34\1\0\6\34\2\0\32\34"+
    "\1\366\16\34\1\366\16\34\1\0\1\34\1\0\2\34"+
    "\2\0\5\34\1\176\1\0\6\34\2\0\2\34\1\176"+
    "\65\34\1\0\1\34\1\0\2\34\2\0\6\34\1\0"+
    "\6\34\2\0\3\34\1\367\30\34\1\367\33\34\1\0"+
    "\1\34\1\0\2\34\2\0\4\34\1\370\1\34\1\0"+
    "\6\34\2\0\31\34\1\370\36\34\1\0\1\34\1\0"+
    "\2\34\2\0\6\34\1\0\6\34\2\0\11\34\1\371"+
    "\24\34\1\372\1\176\14\34\1\176\1\371\5\34\1\372"+
    "\4\34\1\0\1\34\1\0\2\34\2\0\3\34\1\373"+
    "\2\34\1\0\6\34\2\0\30\34\1\373\37\34\1\0"+
    "\1\34\1\0\2\34\2\0\1\63\3\34\1\374\1\34"+
    "\1\0\6\34\2\0\26\34\1\63\2\34\1\374\36\34"+
    "\1\0\1\34\1\0\2\34\2\0\6\34\1\0\6\34"+
    "\2\0\32\34\1\375\16\34\1\375\16\34\1\0\1\34"+
    "\1\0\2\34\2\0\2\34\1\376\3\34\1\0\6\34"+
    "\2\0\1\34\1\376\66\34\1\0\1\34\1\0\2\34"+
    "\2\0\6\34\1\0\6\34\2\0\40\34\1\63\21\34"+
    "\1\63\5\34\1\0\1\34\1\0\2\34\2\0\6\34"+
    "\1\0\6\34\2\0\14\34\1\63\33\34\1\63\17\34"+
    "\1\0\1\34\1\0\2\34\2\0\6\34\1\0\6\34"+
    "\2\0\32\34\1\377\16\34\1\377\16\34\1\0\1\34"+
    "\1\0\2\34\2\0\2\34\1\u0100\3\34\1\0\6\34"+
    "\2\0\1\34\1\u0100\66\34\1\0\1\34\1\0\2\34"+
    "\2\0\5\34\1\362\1\0\6\34\2\0\2\34\1\362"+
    "\65\34\1\0\1\34\1\0\2\34\2\0\6\34\1\0"+
    "\6\34\2\0\33\34\1\212\17\34\1\212\14\34\1\0"+
    "\1\34\1\0\2\34\2\0\6\34\1\0\6\34\2\0"+
    "\33\34\1\u0101\17\34\1\u0101\14\34\1\0\1\34\1\0"+
    "\2\34\2\0\6\34\1\0\6\34\2\0\10\34\1\u0102"+
    "\53\34\1\u0102\3\34\1\0\1\34\1\0\2\34\2\0"+
    "\6\34\1\0\3\34\1\362\2\34\2\0\4\34\1\362"+
    "\63\34\1\0\1\34\1\0\2\34\2\0\6\34\1\0"+
    "\6\34\2\0\14\34\1\246\33\34\1\246\17\34\1\0"+
    "\1\34\1\0\2\34\2\0\5\34\1\u0103\1\0\6\34"+
    "\2\0\2\34\1\u0103\65\34\1\0\1\34\1\0\2\34"+
    "\2\0\3\34\1\u0104\2\34\1\0\6\34\2\0\30\34"+
    "\1\u0104\2\34\1\u0105\17\34\1\u0105\14\34\1\0\1\34"+
    "\1\0\2\34\2\0\1\u0106\5\34\1\0\6\34\2\0"+
    "\26\34\1\u0106\41\34\1\0\1\34\1\0\2\34\2\0"+
    "\6\34\1\0\6\34\2\0\37\34\1\u0107\14\34\1\u0107"+
    "\13\34\1\0\1\34\1\0\2\34\2\0\6\34\1\0"+
    "\6\34\2\0\33\34\1\63\17\34\1\63\14\34\1\0"+
    "\1\34\1\0\2\34\2\0\1\u0108\5\34\1\0\6\34"+
    "\2\0\26\34\1\u0108\41\34\1\0\1\34\1\0\2\34"+
    "\2\0\1\u0109\5\34\1\0\3\34\1\244\2\34\2\0"+
    "\4\34\1\244\4\34\1\173\2\u010a\1\u010b\11\34\1\u0109"+
    "\21\34\1\u010b\4\34\1\173\12\34\1\0\1\34\1\0"+
    "\2\34\2\0\6\34\1\0\6\34\2\0\3\34\1\u010c"+
    "\30\34\1\u010c\33\34\1\0\1\34\1\0\2\34\2\0"+
    "\6\34\1\0\6\34\2\0\40\34\1\u010d\21\34\1\u010d"+
    "\5\34\1\0\1\34\1\0\2\34\2\0\6\34\1\0"+
    "\3\34\1\u010e\2\34\2\0\4\34\1\u010e\30\34\1\u010f"+
    "\22\34\1\u010f\7\34\1\0\1\34\1\0\2\34\2\0"+
    "\6\34\1\0\6\34\2\0\32\34\1\u0110\16\34\1\u0110"+
    "\16\34\1\0\1\34\1\0\2\34\2\0\6\34\1\0"+
    "\6\34\2\0\14\34\1\u0111\33\34\1\u0111\17\34\1\0"+
    "\1\34\1\0\2\34\2\0\2\34\1\u0112\3\34\1\0"+
    "\6\34\2\0\1\34\1\u0112\1\34\1\u0113\30\34\1\u0113"+
    "\33\34\1\0\1\34\1\0\2\34\2\0\6\34\1\0"+
    "\3\34\1\u0114\2\34\2\0\4\34\1\u0114\63\34\1\0"+
    "\1\34\1\0\2\34\2\0\2\34\1\u0115\3\34\1\0"+
    "\6\34\2\0\1\34\1\u0115\66\34\1\0\1\34\1\0"+
    "\2\34\2\0\6\34\1\0\6\34\2\0\14\34\1\u0116"+
    "\33\34\1\u0116\17\34\1\0\1\34\1\0\2\34\2\0"+
    "\4\34\1\u0117\1\34\1\0\6\34\2\0\31\34\1\u0117"+
    "\36\34\1\0\1\34\1\0\2\34\2\0\6\34\1\0"+
    "\3\34\1\244\2\34\2\0\4\34\1\244\63\34\1\0"+
    "\1\34\1\0\2\34\2\0\6\34\1\0\6\34\2\0"+
    "\37\34\1\u0118\14\34\1\u0118\13\34\1\0\1\34\1\0"+
    "\2\34\2\0\5\34\1\u0119\1\0\6\34\2\0\2\34"+
    "\1\u0119\65\34\1\0\1\34\1\0\2\34\2\0\6\34"+
    "\1\0\6\34\2\0\47\34\1\364\20\34\1\0\1\34"+
    "\1\0\2\34\2\0\6\34\1\0\6\34\2\0\11\34"+
    "\1\u011a\43\34\1\u011a\12\34\1\0\1\34\1\0\2\34"+
    "\2\0\5\34\1\u0116\1\0\6\34\2\0\2\34\1\u0116"+
    "\1\u011b\30\34\1\u011b\33\34\1\0\1\34\1\0\2\34"+
    "\2\0\2\34\1\u011c\1\34\1\63\1\34\1\0\6\34"+
    "\2\0\1\34\1\u011c\27\34\1\63\36\34\1\0\1\34"+
    "\1\0\2\34\2\0\2\34\1\63\3\34\1\0\6\34"+
    "\2\0\1\34\1\63\42\34\1\63\14\34\1\63\6\34"+
    "\1\0\1\34\1\0\2\34\2\0\6\34\1\0\6\34"+
    "\2\0\3\34\1\63\30\34\1\63\33\34\1\0\1\34"+
    "\1\0\2\34\2\0\6\34\1\0\6\34\2\0\37\34"+
    "\1\63\14\34\1\63\13\34\1\0\1\34\1\0\2\34"+
    "\2\0\6\34\1\0\6\34\2\0\35\34\1\u011d\22\34"+
    "\1\u011d\7\34\1\0\1\34\1\0\2\34\2\0\2\34"+
    "\1\63\3\34\1\0\6\34\2\0\1\34\1\63\66\34"+
    "\1\0\1\34\1\0\2\34\2\0\6\34\1\0\6\34"+
    "\2\0\36\34\1\241\24\34\1\241\4\34\1\0\1\34"+
    "\1\0\2\34\2\0\6\34\1\0\6\34\2\0\32\34"+
    "\1\242\16\34\1\242\14\34\11\0\1\u011e\44\0\1\u011e"+
    "\37\0\2\252\1\0\113\252\37\0\1\u011f\56\0\1\100"+
    "\10\0\6\100\1\0\6\100\2\0\1\u0120\5\100\2\0"+
    "\5\100\11\0\41\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\3\107\1\u0121\1\107\11\0\40\107"+
    "\7\0\1\36\7\0\1\105\76\0\1\257\10\0\6\257"+
    "\1\0\6\257\2\0\6\257\2\0\5\257\11\0\41\257"+
    "\10\0\6\257\1\0\1\257\2\u0122\1\257\1\u0122\1\257"+
    "\2\0\5\257\1\u0122\2\0\5\257\1\u0123\3\0\1\u0123"+
    "\4\0\20\257\1\u0122\20\257\10\0\6\257\1\0\1\257"+
    "\2\263\1\257\1\263\1\257\2\0\5\257\1\263\2\0"+
    "\2\257\2\261\1\262\11\0\11\257\1\261\6\257\1\263"+
    "\1\257\1\262\3\257\1\261\12\257\10\0\6\257\1\0"+
    "\1\257\2\264\1\257\1\264\1\257\2\0\5\257\1\264"+
    "\2\0\2\257\2\261\1\262\1\0\1\263\7\0\11\257"+
    "\1\261\6\257\1\264\1\257\1\262\3\257\1\261\12\257"+
    "\10\0\6\257\1\0\1\257\1\264\1\265\1\257\1\265"+
    "\1\257\2\0\5\257\1\265\2\0\1\257\1\u0124\2\261"+
    "\1\262\1\0\1\263\7\0\11\257\1\261\6\257\1\265"+
    "\1\257\1\262\3\257\1\261\1\u0124\11\257\10\0\1\257"+
    "\1\u0125\4\257\1\0\1\257\4\u0125\1\257\2\0\4\257"+
    "\2\u0125\2\0\2\257\3\u0125\11\0\1\257\1\u0125\2\257"+
    "\1\u0125\4\257\1\u0125\6\257\1\u0125\1\257\2\u0125\2\257"+
    "\1\u0125\11\257\2\u0126\1\0\23\u0126\1\u0127\67\u0126\26\0"+
    "\1\u0127\67\0\2\u0126\1\0\17\u0126\1\u0128\1\u0126\1\u0129"+
    "\1\267\1\270\1\267\1\u012a\4\267\1\u0128\5\u0126\1\267"+
    "\32\u0126\1\u0129\17\u0126\2\u012b\1\0\17\u012b\1\115\1\u012b"+
    "\1\115\1\u012c\2\115\1\u012d\5\115\5\u012b\1\115\32\u012b"+
    "\1\115\17\u012b\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\5\107\11\0\22\107\1\u012e\15\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\2\107"+
    "\1\u012f\3\107\2\0\5\107\11\0\40\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\1\u0130\5\107\2\0"+
    "\5\107\11\0\23\107\1\u0131\6\107\1\327\5\107\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\1\107\1\u0132"+
    "\4\107\2\0\5\107\11\0\2\107\1\u0133\35\107\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\6\107\2\0"+
    "\5\107\11\0\3\107\1\u0134\34\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\6\107\2\0\5\107\11\0"+
    "\27\107\1\u0135\10\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\6\107\2\0\5\107\11\0\30\107\1\327"+
    "\7\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\2\107\1\u0136\3\107\2\0\5\107\11\0\40\107\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\6\107\2\0"+
    "\5\107\11\0\22\107\1\u0137\15\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\6\107\2\0\5\107\11\0"+
    "\25\107\1\u0138\12\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\2\107\1\u0139\3\107\2\0\5\107\11\0"+
    "\40\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\3\107\1\u013a\2\107\2\0\5\107\11\0\40\107\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\3\107\1\u013b"+
    "\2\107\2\0\5\107\11\0\40\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\6\107\2\0\5\107\11\0"+
    "\27\107\1\u013c\10\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\1\107\1\327\4\107\2\0\5\107\11\0"+
    "\40\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\6\107\2\0\5\107\11\0\25\107\1\u013d\12\107\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\6\107\2\0"+
    "\5\107\11\0\3\107\1\u013e\34\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\6\107\2\0\5\107\11\0"+
    "\23\107\1\u013f\14\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\6\107\2\0\5\107\11\0\2\107\1\u0140"+
    "\35\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\6\107\2\0\5\107\11\0\25\107\1\u0141\12\107\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\3\107\1\u0142"+
    "\2\107\2\0\5\107\11\0\40\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\2\107\1\u0143\3\107\2\0"+
    "\5\107\11\0\1\u0144\37\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\3\107\1\u0145\2\107\2\0\5\107"+
    "\11\0\40\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\5\107\11\0\23\107\1\u0146\14\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\6\107"+
    "\2\0\5\107\11\0\23\107\1\u0147\14\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\2\107\1\u0148\3\107"+
    "\2\0\5\107\11\0\1\u0149\37\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\6\107\2\0\2\107\1\u014a"+
    "\2\107\11\0\6\107\1\u014b\31\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\6\107\2\0\5\107\11\0"+
    "\3\107\1\u014c\34\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\4\107\1\u014d\1\107\2\0\5\107\11\0"+
    "\40\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\6\107\2\0\5\107\11\0\2\107\1\u014e\22\107\1\u014f"+
    "\12\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\1\107\1\u0150\4\107\2\0\5\107\11\0\1\107\1\u0151"+
    "\36\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\6\107\2\0\5\107\11\0\6\107\1\327\31\107\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\1\u0152\5\107"+
    "\2\0\5\107\11\0\40\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\6\107\2\0\5\107\11\0\1\107"+
    "\1\u0153\36\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\5\107\11\0\1\u0144\37\107\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\6\107\2\0"+
    "\5\107\11\0\23\107\1\u0154\14\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\2\107\1\u0155\3\107\2\0"+
    "\5\107\11\0\3\107\1\u0156\34\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\6\107\2\0\5\107\11\0"+
    "\1\u0157\37\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\4\107\1\u0158\1\107\2\0\3\107\1\u0159\1\107"+
    "\11\0\27\107\1\u015a\10\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\1\u015b\5\107\2\0\5\107\11\0"+
    "\40\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\3\107\1\u015c\2\107\2\0\5\107\11\0\40\107\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\2\107\1\u015d"+
    "\3\107\2\0\5\107\11\0\40\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\6\107\2\0\5\107\11\0"+
    "\2\107\1\u015e\35\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\6\107\2\0\5\107\11\0\2\107\1\u015f"+
    "\24\107\1\u0160\10\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\2\107\1\u0161\3\107\2\0\5\107\11\0"+
    "\40\107\45\0\1\u0162\101\0\1\u0163\64\0\2\34\1\0"+
    "\1\34\1\0\2\34\2\0\3\34\1\u0164\2\34\1\0"+
    "\6\34\2\0\30\34\1\u0164\37\34\1\0\1\34\1\0"+
    "\2\34\2\0\1\34\1\u010f\4\34\1\0\6\34\2\0"+
    "\3\34\1\63\23\34\1\u010f\4\34\1\63\33\34\1\0"+
    "\1\34\1\0\2\34\2\0\3\34\1\u0165\2\34\1\0"+
    "\6\34\2\0\30\34\1\u0165\2\34\1\u0166\17\34\1\u0166"+
    "\14\34\1\0\1\34\1\0\2\34\2\0\6\34\1\0"+
    "\6\34\2\0\11\34\1\176\43\34\1\176\12\34\1\0"+
    "\1\34\1\0\2\34\2\0\6\34\1\0\6\34\2\0"+
    "\44\34\1\u010f\14\34\1\u010f\6\34\1\0\1\34\1\0"+
    "\2\34\2\0\6\34\1\0\6\34\2\0\14\34\1\u0167"+
    "\33\34\1\u0167\17\34\1\0\1\34\1\0\2\34\2\0"+
    "\4\34\1\63\1\34\1\0\6\34\2\0\31\34\1\63"+
    "\36\34\1\0\1\34\1\0\2\34\2\0\6\34\1\0"+
    "\6\34\2\0\11\34\1\241\43\34\1\241\12\34\1\0"+
    "\1\34\1\0\2\34\2\0\5\34\1\u010f\1\0\6\34"+
    "\2\0\2\34\1\u010f\65\34\1\0\1\34\1\0\2\34"+
    "\2\0\5\34\1\u0168\1\0\6\34\2\0\2\34\1\u0168"+
    "\65\34\1\0\1\34\1\0\2\34\2\0\6\34\1\0"+
    "\6\34\2\0\40\34\1\u0169\21\34\1\u0169\5\34\1\0"+
    "\1\34\1\0\2\34\2\0\6\34\1\0\6\34\2\0"+
    "\36\34\1\u016a\24\34\1\u016a\4\34\1\0\1\34\1\0"+
    "\2\34\2\0\6\34\1\0\6\34\2\0\3\34\1\u016b"+
    "\30\34\1\u016b\33\34\1\0\1\34\1\0\2\34\2\0"+
    "\6\34\1\0\6\34\2\0\1\u0113\40\34\1\u0113\26\34"+
    "\1\0\1\34\1\0\2\34\2\0\6\34\1\0\6\34"+
    "\2\0\35\34\1\u010f\22\34\1\u010f\7\34\1\0\1\34"+
    "\1\0\2\34\2\0\6\34\1\0\6\34\2\0\32\34"+
    "\1\u016c\16\34\1\u016c\16\34\1\0\1\34\1\0\2\34"+
    "\2\0\3\34\1\u016d\2\34\1\0\6\34\2\0\30\34"+
    "\1\u016d\37\34\1\0\1\34\1\0\2\34\2\0\6\34"+
    "\1\0\6\34\2\0\32\34\1\u0112\16\34\1\u0112\16\34"+
    "\1\0\1\34\1\0\2\34\2\0\6\34\1\0\6\34"+
    "\2\0\33\34\1\u0113\17\34\1\u0113\14\34\1\0\1\34"+
    "\1\0\2\34\2\0\5\34\1\u016e\1\0\6\34\2\0"+
    "\2\34\1\u016e\65\34\1\0\1\34\1\0\2\34\2\0"+
    "\5\34\1\u016f\1\0\6\34\2\0\2\34\1\u016f\65\34"+
    "\1\0\1\34\1\0\2\34\2\0\1\34\1\u0170\4\34"+
    "\1\0\6\34\2\0\27\34\1\u0170\40\34\1\0\1\34"+
    "\1\0\2\34\2\0\6\34\1\0\6\34\2\0\14\34"+
    "\1\u0171\33\34\1\u0171\17\34\1\0\1\34\1\0\2\34"+
    "\2\0\6\34\1\0\6\34\2\0\35\34\1\63\22\34"+
    "\1\63\7\34\1\0\1\34\1\0\2\34\2\0\6\34"+
    "\1\0\6\34\2\0\33\34\1\u0172\17\34\1\u0172\14\34"+
    "\1\0\1\34\1\0\2\34\2\0\1\34\1\156\4\34"+
    "\1\0\6\34\2\0\27\34\1\156\40\34\1\0\1\34"+
    "\1\0\2\34\2\0\2\34\1\u0173\3\34\1\0\6\34"+
    "\2\0\1\34\1\u0173\66\34\1\0\1\34\1\0\2\34"+
    "\2\0\6\34\1\0\6\34\2\0\36\34\1\u0174\24\34"+
    "\1\u0174\4\34\1\0\1\34\1\0\2\34\2\0\6\34"+
    "\1\0\6\34\2\0\42\34\1\63\7\34\1\63\15\34"+
    "\1\0\1\34\1\0\2\34\2\0\6\34\1\0\6\34"+
    "\2\0\14\34\1\u0175\33\34\1\u0175\17\34\1\0\1\34"+
    "\1\0\2\34\2\0\6\34\1\0\6\34\2\0\14\34"+
    "\1\241\33\34\1\241\17\34\1\0\1\34\1\0\2\34"+
    "\2\0\6\34\1\0\6\34\2\0\14\34\1\244\33\34"+
    "\1\244\17\34\1\0\1\34\1\0\2\34\2\0\6\34"+
    "\1\0\6\34\2\0\36\34\1\u0176\24\34\1\u0176\4\34"+
    "\1\0\1\34\1\0\2\34\2\0\6\34\1\0\6\34"+
    "\2\0\11\34\1\u0177\43\34\1\u0177\12\34\1\0\1\34"+
    "\1\0\2\34\2\0\6\34\1\0\6\34\2\0\36\34"+
    "\1\63\24\34\1\63\4\34\1\0\1\34\1\0\2\34"+
    "\2\0\5\34\1\63\1\0\6\34\2\0\2\34\1\63"+
    "\65\34\1\0\1\34\1\0\2\34\2\0\6\34\1\0"+
    "\6\34\2\0\14\34\1\242\33\34\1\242\17\34\1\0"+
    "\1\34\1\0\2\34\2\0\6\34\1\0\6\34\2\0"+
    "\33\34\1\u0178\17\34\1\u0178\14\34\1\0\1\34\1\0"+
    "\2\34\2\0\6\34\1\0\6\34\2\0\32\34\1\63"+
    "\16\34\1\63\16\34\1\0\1\34\1\0\2\34\2\0"+
    "\6\34\1\0\6\34\2\0\11\34\1\u0179\43\34\1\u0179"+
    "\12\34\1\0\1\34\1\0\2\34\2\0\2\34\1\u017a"+
    "\3\34\1\0\6\34\2\0\1\34\1\u017a\66\34\1\0"+
    "\1\34\1\0\2\34\2\0\3\34\1\u016f\2\34\1\0"+
    "\6\34\2\0\30\34\1\u016f\7\34\1\u0169\21\34\1\u0169"+
    "\5\34\1\0\1\34\1\0\2\34\2\0\5\34\1\u017b"+
    "\1\0\6\34\2\0\2\34\1\u017b\65\34\1\0\1\34"+
    "\1\0\2\34\2\0\6\34\1\0\6\34\2\0\1\63"+
    "\40\34\1\63\26\34\1\0\1\34\1\0\2\34\2\0"+
    "\6\34\1\0\6\34\2\0\43\34\1\u017c\24\34\1\0"+
    "\1\34\1\0\2\34\2\0\6\34\1\0\6\34\2\0"+
    "\40\34\1\u017d\21\34\1\u017d\3\34\12\0\1\u017e\44\0"+
    "\1\u017e\46\0\1\u017f\105\0\1\100\10\0\1\100\1\u0180"+
    "\4\100\1\0\1\100\4\u0180\1\100\2\0\4\100\2\u0180"+
    "\2\0\2\100\3\u0180\11\0\1\100\1\u0180\2\100\1\u0180"+
    "\4\100\1\u0180\6\100\1\u0180\1\100\2\u0180\2\100\1\u0180"+
    "\12\100\10\0\6\107\1\0\5\107\1\254\2\0\6\107"+
    "\2\0\5\107\11\0\2\107\1\u0181\35\107\1\257\10\0"+
    "\6\257\1\0\1\257\2\u0122\1\257\1\u0122\1\257\2\0"+
    "\5\257\1\u0122\2\0\2\257\2\261\1\257\11\0\11\257"+
    "\1\261\6\257\1\u0122\5\257\1\261\11\257\21\0\2\u0122"+
    "\1\0\1\u0122\10\0\1\u0122\40\0\1\u0122\17\0\1\257"+
    "\10\0\1\257\1\u0125\4\257\1\0\1\257\4\u0125\1\257"+
    "\2\0\4\257\2\u0125\2\0\1\257\1\u0124\3\u0125\11\0"+
    "\1\257\1\u0125\2\257\1\u0125\4\257\1\u0125\6\257\1\u0125"+
    "\1\257\2\u0125\2\257\1\u0125\1\u0124\10\257\2\u0126\1\0"+
    "\23\u0126\1\272\71\u0126\1\0\17\u0126\1\u0129\1\u0126\1\u0129"+
    "\1\u0126\1\u0127\6\u0126\1\u0129\40\u0126\1\u0129\21\u0126\1\0"+
    "\17\u0126\1\267\1\u0126\1\267\1\u0126\1\u0127\6\u0126\1\267"+
    "\40\u0126\1\267\21\u0126\1\0\7\u0126\1\u0182\6\u0126\4\u0182"+
    "\1\u0126\1\272\5\u0126\2\u0182\4\u0126\3\u0182\12\u0126\1\u0182"+
    "\2\u0126\1\u0182\4\u0126\1\u0182\6\u0126\1\u0182\1\u0126\2\u0182"+
    "\2\u0126\1\u0182\11\u0126\2\u012b\1\0\22\u012b\1\u0183\1\u012b"+
    "\1\u0184\66\u012b\2\115\1\0\22\115\1\273\1\115\1\u0185"+
    "\66\115\2\u012b\1\0\7\u012b\1\u0186\6\u012b\4\u0186\1\u0183"+
    "\1\u012b\1\u0184\4\u012b\2\u0186\4\u012b\3\u0186\12\u012b\1\u0186"+
    "\2\u012b\1\u0186\4\u012b\1\u0186\6\u012b\1\u0186\1\u012b\2\u0186"+
    "\2\u012b\1\u0186\11\u012b\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\6\107\2\0\5\107\11\0\1\337\37\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\1\u0187"+
    "\5\107\2\0\5\107\11\0\40\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\6\107\2\0\5\107\11\0"+
    "\22\107\1\u0188\15\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\3\107\1\u0189\2\107\2\0\5\107\11\0"+
    "\40\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\6\107\2\0\5\107\11\0\25\107\1\u018a\12\107\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\6\107\2\0"+
    "\5\107\11\0\1\327\37\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\6\107\2\0\5\107\11\0\22\107"+
    "\1\u018b\15\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\5\107\11\0\27\107\1\327\10\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\6\107"+
    "\2\0\5\107\11\0\2\107\1\u018c\35\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\6\107\2\0\5\107"+
    "\11\0\23\107\1\u018d\14\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\6\107\2\0\5\107\11\0\27\107"+
    "\1\u018e\10\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\5\107\11\0\22\107\1\u018f\15\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\6\107"+
    "\2\0\5\107\11\0\1\107\1\u0190\36\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\6\107\2\0\5\107"+
    "\11\0\23\107\1\u0191\14\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\6\107\2\0\5\107\11\0\1\u0130"+
    "\37\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\6\107\2\0\5\107\11\0\23\107\1\u0192\14\107\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\6\107\2\0"+
    "\5\107\11\0\22\107\1\313\15\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\2\107\1\u0193\3\107\2\0"+
    "\5\107\11\0\40\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\2\107\1\u0143\3\107\2\0\5\107\11\0"+
    "\40\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\1\107\1\u0192\4\107\2\0\5\107\11\0\40\107\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\6\107\2\0"+
    "\5\107\11\0\1\107\1\u0194\36\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\6\107\2\0\5\107\11\0"+
    "\1\107\1\u015d\36\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\6\107\2\0\5\107\11\0\22\107\1\327"+
    "\15\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\2\107\1\u0195\3\107\2\0\5\107\11\0\1\u0196\37\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\6\107"+
    "\2\0\5\107\11\0\1\u0133\37\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\1\107\1\u018f\4\107\2\0"+
    "\5\107\11\0\40\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\6\107\2\0\5\107\11\0\22\107\1\u0197"+
    "\15\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\2\107\1\u0198\3\107\2\0\5\107\11\0\40\107\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\6\107\2\0"+
    "\5\107\11\0\2\107\1\u0199\35\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\6\107\2\0\5\107\11\0"+
    "\23\107\1\u019a\14\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\6\107\2\0\5\107\11\0\25\107\1\u019b"+
    "\1\107\1\u019c\10\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\6\107\2\0\5\107\11\0\27\107\1\u0193"+
    "\10\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\6\107\2\0\5\107\11\0\33\107\1\u019d\4\107\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\2\107\1\u019e"+
    "\3\107\2\0\5\107\11\0\40\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\6\107\2\0\5\107\11\0"+
    "\1\u019f\37\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\5\107\11\0\24\107\1\u01a0\13\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\6\107"+
    "\2\0\5\107\11\0\35\107\1\327\2\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\6\107\2\0\5\107"+
    "\11\0\23\107\1\u01a1\14\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\6\107\2\0\5\107\11\0\27\107"+
    "\1\u01a2\10\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\5\107\11\0\22\107\1\u01a3\15\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\6\107"+
    "\2\0\5\107\11\0\25\107\1\u019b\12\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\2\107\1\u01a4\3\107"+
    "\2\0\5\107\11\0\40\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\1\u01a5\5\107\2\0\5\107\11\0"+
    "\40\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\6\107\2\0\5\107\11\0\23\107\1\u01a6\14\107\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\6\107\2\0"+
    "\5\107\11\0\22\107\1\u01a7\15\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\4\107\1\u01a8\1\107\2\0"+
    "\5\107\11\0\40\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\6\107\2\0\5\107\11\0\34\107\1\u018f"+
    "\3\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\6\107\2\0\5\107\11\0\31\107\1\327\6\107\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\6\107\2\0"+
    "\5\107\11\0\27\107\1\u0144\10\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\6\107\2\0\5\107\11\0"+
    "\26\107\1\327\11\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\6\107\2\0\5\107\11\0\23\107\1\u01a9"+
    "\14\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\6\107\2\0\5\107\11\0\25\107\1\327\12\107\60\0"+
    "\1\u01aa\35\0\2\34\1\0\1\34\1\0\2\34\2\0"+
    "\4\34\1\u0113\1\34\1\0\6\34\2\0\31\34\1\u0113"+
    "\36\34\1\0\1\34\1\0\2\34\2\0\6\34\1\0"+
    "\6\34\2\0\42\34\1\176\7\34\1\176\15\34\1\0"+
    "\1\34\1\0\2\34\2\0\6\34\1\0\6\34\2\0"+
    "\3\34\1\175\30\34\1\175\33\34\1\0\1\34\1\0"+
    "\2\34\2\0\1\34\1\u0113\4\34\1\0\6\34\2\0"+
    "\27\34\1\u0113\40\34\1\0\1\34\1\0\2\34\2\0"+
    "\3\34\1\u016f\2\34\1\0\6\34\2\0\30\34\1\u016f"+
    "\37\34\1\0\1\34\1\0\2\34\2\0\2\34\1\u01ab"+
    "\3\34\1\0\6\34\2\0\1\34\1\u01ab\66\34\1\0"+
    "\1\34\1\0\2\34\2\0\6\34\1\0\6\34\2\0"+
    "\14\34\1\u01ac\33\34\1\u01ac\17\34\1\0\1\34\1\0"+
    "\2\34\2\0\6\34\1\0\6\34\2\0\37\34\1\u01ad"+
    "\14\34\1\u01ad\13\34\1\0\1\34\1\0\2\34\2\0"+
    "\6\34\1\0\6\34\2\0\36\34\1\176\24\34\1\176"+
    "\4\34\1\0\1\34\1\0\2\34\2\0\6\34\1\0"+
    "\6\34\2\0\3\34\1\u01ae\30\34\1\u01ae\33\34\1\0"+
    "\1\34\1\0\2\34\2\0\6\34\1\0\6\34\2\0"+
    "\32\34\1\u01af\16\34\1\u01af\16\34\1\0\1\34\1\0"+
    "\2\34\2\0\6\34\1\0\6\34\2\0\33\34\1\240"+
    "\17\34\1\240\14\34\1\0\1\34\1\0\2\34\2\0"+
    "\6\34\1\0\6\34\2\0\42\34\1\u01b0\7\34\1\u01b0"+
    "\15\34\1\0\1\34\1\0\2\34\2\0\6\34\1\0"+
    "\6\34\2\0\12\34\2\u01b1\54\34\1\0\1\34\1\0"+
    "\2\34\2\0\6\34\1\0\6\34\2\0\1\u0175\40\34"+
    "\1\u0175\26\34\1\0\1\34\1\0\2\34\2\0\6\34"+
    "\1\0\6\34\2\0\32\34\1\u01b2\16\34\1\u01b2\16\34"+
    "\1\0\1\34\1\0\2\34\2\0\6\34\1\0\6\34"+
    "\2\0\3\34\1\242\30\34\1\242\33\34\1\0\1\34"+
    "\1\0\2\34\2\0\6\34\1\0\6\34\2\0\14\34"+
    "\1\u01b3\33\34\1\u01b3\17\34\1\0\1\34\1\0\2\34"+
    "\2\0\6\34\1\0\6\34\2\0\37\34\1\u01b4\14\34"+
    "\1\u01b4\13\34\1\0\1\34\1\0\2\34\2\0\6\34"+
    "\1\0\6\34\2\0\3\34\1\u01b5\30\34\1\u01b5\33\34"+
    "\1\0\1\34\1\0\2\34\2\0\6\34\1\0\6\34"+
    "\2\0\14\34\1\u0113\33\34\1\u0113\17\34\1\0\1\34"+
    "\1\0\2\34\2\0\6\34\1\0\6\34\2\0\14\34"+
    "\1\u01b6\33\34\1\u01b6\17\34\1\0\1\34\1\0\2\34"+
    "\2\0\3\34\1\u01b7\2\34\1\0\6\34\2\0\30\34"+
    "\1\u01b7\37\34\1\0\1\34\1\0\2\34\2\0\6\34"+
    "\1\0\6\34\2\0\1\u01b8\40\34\1\u01b8\26\34\1\0"+
    "\1\34\1\0\2\34\2\0\6\34\1\0\6\34\2\0"+
    "\14\34\1\240\33\34\1\240\15\34\13\0\1\u01b9\15\0"+
    "\1\u01b9\64\0\1\100\10\0\1\100\1\u01ba\4\100\1\0"+
    "\1\100\4\u01ba\1\100\2\0\4\100\2\u01ba\2\0\2\100"+
    "\3\u01ba\11\0\1\100\1\u01ba\2\100\1\u01ba\4\100\1\u01ba"+
    "\6\100\1\u01ba\1\100\2\u01ba\2\100\1\u01ba\12\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\3\107\1\u01bb\2\107"+
    "\2\0\5\107\11\0\40\107\2\u0126\1\0\7\u0126\1\u01bc"+
    "\6\u0126\4\u01bc\1\u0126\1\272\5\u0126\2\u01bc\4\u0126\3\u01bc"+
    "\12\u0126\1\u01bc\2\u0126\1\u01bc\4\u0126\1\u01bc\6\u0126\1\u01bc"+
    "\1\u0126\2\u01bc\2\u0126\1\u01bc\11\u0126\2\u012b\1\0\22\u012b"+
    "\1\u0183\72\u012b\1\0\7\u012b\1\u01bd\6\u012b\4\u01bd\1\u0183"+
    "\1\u012b\1\u0184\4\u012b\2\u01bd\4\u012b\3\u01bd\12\u012b\1\u01bd"+
    "\2\u012b\1\u01bd\4\u012b\1\u01bd\6\u012b\1\u01bd\1\u012b\2\u01bd"+
    "\2\u012b\1\u01bd\11\u012b\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\1\107\1\u01be\4\107\2\0\5\107\11\0"+
    "\40\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\6\107\2\0\5\107\11\0\1\u01bf\37\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\6\107\2\0\5\107"+
    "\11\0\30\107\1\u01c0\7\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\6\107\2\0\5\107\11\0\25\107"+
    "\1\u01c1\12\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\5\107\11\0\33\107\1\u0144\4\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\6\107"+
    "\2\0\5\107\11\0\24\107\1\327\13\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\6\107\2\0\5\107"+
    "\11\0\22\107\1\u01c2\15\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\2\107\1\u01c3\3\107\2\0\5\107"+
    "\11\0\40\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\5\107\11\0\27\107\1\u01c4\10\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\2\107"+
    "\1\u018f\3\107\2\0\5\107\11\0\40\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\6\107\2\0\5\107"+
    "\11\0\2\107\1\u01c5\35\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\6\107\2\0\5\107\11\0\31\107"+
    "\1\u01c6\6\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\5\107\11\0\2\107\1\u01c7\35\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\2\107"+
    "\1\327\3\107\2\0\5\107\11\0\40\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\1\107\1\u01c8\4\107"+
    "\2\0\5\107\11\0\40\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\6\107\2\0\5\107\11\0\23\107"+
    "\1\u01c9\14\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\3\107\1\u01ca\2\107\2\0\5\107\11\0\40\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\6\107"+
    "\2\0\5\107\11\0\6\107\1\u01a2\31\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\1\107\1\u0196\4\107"+
    "\2\0\5\107\11\0\40\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\6\107\2\0\5\107\11\0\22\107"+
    "\1\u01cb\15\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\5\107\11\0\23\107\1\u01a7\14\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\6\107"+
    "\2\0\5\107\11\0\22\107\1\u01cc\15\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\6\107\2\0\5\107"+
    "\11\0\22\107\1\u01cd\15\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\6\107\2\0\5\107\11\0\23\107"+
    "\1\u01ce\14\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\5\107\11\0\3\107\1\u01cf\34\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\3\107"+
    "\1\u01d0\2\107\2\0\5\107\11\0\40\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\1\107\1\u01d1\4\107"+
    "\2\0\5\107\11\0\40\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\6\107\2\0\5\107\11\0\34\107"+
    "\1\u01d2\3\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\1\u01d3\5\107\2\0\5\107\11\0\40\107\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\2\107\1\u0144"+
    "\3\107\2\0\5\107\11\0\40\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\6\107\2\0\5\107\11\0"+
    "\27\107\1\u0139\10\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\2\107\1\350\3\107\2\0\5\107\11\0"+
    "\40\107\61\0\1\u01d4\34\0\2\34\1\0\1\34\1\0"+
    "\2\34\2\0\6\34\1\0\6\34\2\0\33\34\1\u01d5"+
    "\17\34\1\u01d5\14\34\1\0\1\34\1\0\2\34\2\0"+
    "\6\34\1\0\6\34\2\0\3\34\1\u0113\30\34\1\u0113"+
    "\33\34\1\0\1\34\1\0\2\34\2\0\6\34\1\0"+
    "\6\34\2\0\14\34\1\u01d6\33\34\1\u01d6\17\34\1\0"+
    "\1\34\1\0\2\34\2\0\5\34\1\u01d7\1\0\6\34"+
    "\2\0\2\34\1\u01d7\65\34\1\0\1\34\1\0\2\34"+
    "\2\0\2\34\1\226\3\34\1\0\6\34\2\0\1\34"+
    "\1\226\66\34\1\0\1\34\1\0\2\34\2\0\6\34"+
    "\1\0\6\34\2\0\43\34\1\u01d8\24\34\1\0\1\34"+
    "\1\0\2\34\2\0\6\34\1\0\6\34\2\0\33\34"+
    "\1\u01ac\17\34\1\u01ac\14\34\1\0\1\34\1\0\2\34"+
    "\2\0\6\34\1\0\6\34\2\0\36\34\1\u01d9\24\34"+
    "\1\u01d9\4\34\1\0\1\34\1\0\2\34\2\0\1\u0179"+
    "\5\34\1\0\6\34\2\0\26\34\1\u0179\41\34\1\0"+
    "\1\34\1\0\2\34\2\0\6\34\1\0\6\34\2\0"+
    "\35\34\1\u0112\22\34\1\u0112\7\34\1\0\1\34\1\0"+
    "\2\34\2\0\1\u01da\5\34\1\0\6\34\2\0\26\34"+
    "\1\u01da\41\34\1\0\1\34\1\0\2\34\2\0\1\34"+
    "\1\u01db\4\34\1\0\6\34\2\0\27\34\1\u01db\40\34"+
    "\1\0\1\34\1\0\2\34\2\0\6\34\1\0\6\34"+
    "\2\0\14\34\1\176\33\34\1\176\15\34\14\0\1\u01dc"+
    "\43\0\1\u01dc\35\0\1\100\10\0\1\100\1\u01dd\4\100"+
    "\1\0\1\100\4\u01dd\1\100\2\0\4\100\2\u01dd\2\0"+
    "\2\100\3\u01dd\11\0\1\100\1\u01dd\2\100\1\u01dd\4\100"+
    "\1\u01dd\6\100\1\u01dd\1\100\2\u01dd\2\100\1\u01dd\12\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\6\107\2\0"+
    "\5\107\11\0\2\107\1\u01de\35\107\2\u0126\1\0\7\u0126"+
    "\1\u01df\6\u0126\4\u01df\1\u0126\1\272\5\u0126\2\u01df\4\u0126"+
    "\3\u01df\12\u0126\1\u01df\2\u0126\1\u01df\4\u0126\1\u01df\6\u0126"+
    "\1\u01df\1\u0126\2\u01df\2\u0126\1\u01df\11\u0126\2\u012b\1\0"+
    "\7\u012b\1\u01e0\6\u012b\4\u01e0\1\u0183\1\u012b\1\u0184\4\u012b"+
    "\2\u01e0\4\u012b\3\u01e0\12\u012b\1\u01e0\2\u012b\1\u01e0\4\u012b"+
    "\1\u01e0\6\u012b\1\u01e0\1\u012b\2\u01e0\2\u012b\1\u01e0\11\u012b"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\3\107"+
    "\1\327\2\107\2\0\5\107\11\0\40\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\6\107\2\0\5\107"+
    "\11\0\2\107\1\u01e1\35\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\6\107\2\0\3\107\1\327\1\107"+
    "\11\0\40\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\5\107\11\0\23\107\1\u01e2\14\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\6\107"+
    "\2\0\5\107\11\0\2\107\1\u01e3\35\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\6\107\2\0\5\107"+
    "\11\0\27\107\1\u01e4\10\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\6\107\2\0\5\107\11\0\1\107"+
    "\1\327\36\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\1\107\1\u01e5\4\107\2\0\5\107\11\0\40\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\3\107"+
    "\1\u01e6\2\107\2\0\5\107\11\0\40\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\6\107\2\0\3\107"+
    "\1\u01e7\1\107\11\0\40\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\3\107\1\u01e8\2\107\2\0\5\107"+
    "\11\0\40\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\5\107\11\0\2\107\1\u01e9\35\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\6\107"+
    "\2\0\5\107\11\0\35\107\1\u01ea\2\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\6\107\2\0\5\107"+
    "\11\0\1\107\1\u01eb\36\107\1\100\10\0\3\107\1\u01ec"+
    "\2\107\1\0\5\107\1\254\2\0\6\107\2\0\2\107"+
    "\1\u01ed\2\107\11\0\40\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\6\107\2\0\5\107\11\0\34\107"+
    "\1\u0144\3\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\5\107\11\0\22\107\1\u01a2\15\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\6\107"+
    "\2\0\5\107\11\0\26\107\1\u0133\11\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\6\107\2\0\5\107"+
    "\11\0\23\107\1\u01ee\14\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\6\107\2\0\5\107\11\0\34\107"+
    "\1\u013e\3\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\5\107\11\0\27\107\1\u0196\10\107"+
    "\32\0\1\u01ef\63\0\2\34\1\0\1\34\1\0\2\34"+
    "\2\0\6\34\1\0\6\34\2\0\1\365\40\34\1\365"+
    "\26\34\1\0\1\34\1\0\2\34\2\0\6\34\1\0"+
    "\6\34\2\0\10\34\1\63\53\34\1\63\3\34\1\0"+
    "\1\34\1\0\2\34\2\0\6\34\1\0\6\34\2\0"+
    "\14\34\1\u01f0\33\34\1\u01f0\17\34\1\0\1\34\1\0"+
    "\2\34\2\0\6\34\1\0\6\34\2\0\1\u01f1\40\34"+
    "\1\u01f1\26\34\1\0\1\34\1\0\2\34\2\0\6\34"+
    "\1\0\6\34\2\0\14\34\1\u01da\33\34\1\u01da\17\34"+
    "\1\0\1\34\1\0\2\34\2\0\1\63\5\34\1\0"+
    "\6\34\2\0\26\34\1\63\41\34\1\0\1\34\1\0"+
    "\2\34\2\0\6\34\1\0\6\34\2\0\33\34\1\241"+
    "\17\34\1\241\12\34\15\0\1\u01f2\43\0\1\u01f2\34\0"+
    "\1\100\10\0\1\100\1\107\4\100\1\0\1\100\4\107"+
    "\1\100\2\0\4\100\2\107\2\0\2\100\3\107\11\0"+
    "\1\100\1\107\2\100\1\107\4\100\1\107\6\100\1\107"+
    "\1\100\2\107\2\100\1\107\12\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\2\107\1\u01e4\3\107\2\0\5\107"+
    "\11\0\40\107\2\u0126\1\0\7\u0126\1\267\6\u0126\4\267"+
    "\1\u0126\1\272\5\u0126\2\267\4\u0126\3\267\12\u0126\1\267"+
    "\2\u0126\1\267\4\u0126\1\267\6\u0126\1\267\1\u0126\2\267"+
    "\2\u0126\1\267\11\u0126\2\u012b\1\0\7\u012b\1\115\6\u012b"+
    "\4\115\1\u0183\1\u012b\1\u0184\4\u012b\2\115\4\u012b\3\115"+
    "\12\u012b\1\115\2\u012b\1\115\4\u012b\1\115\6\u012b\1\115"+
    "\1\u012b\2\115\2\u012b\1\115\11\u012b\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\6\107\2\0\5\107\11\0"+
    "\22\107\1\u01f3\15\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\3\107\1\u018f\2\107\2\0\5\107\11\0"+
    "\40\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\6\107\2\0\5\107\11\0\25\107\1\u01be\12\107\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\6\107\2\0"+
    "\5\107\11\0\32\107\1\327\5\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\6\107\2\0\5\107\11\0"+
    "\25\107\1\u01f4\12\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\1\u0144\5\107\2\0\5\107\11\0\40\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\6\107"+
    "\2\0\5\107\11\0\23\107\1\u01f5\14\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\6\107\2\0\5\107"+
    "\11\0\1\107\1\u0134\36\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\2\107\1\u01cf\3\107\2\0\5\107"+
    "\11\0\40\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\5\107\11\0\22\107\1\u01f6\15\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\2\107"+
    "\1\u01f7\3\107\2\0\5\107\11\0\40\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\3\107\1\u01f8\2\107"+
    "\2\0\5\107\11\0\40\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\6\107\2\0\5\107\11\0\27\107"+
    "\1\u01f9\10\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\5\107\11\0\1\107\1\u0196\36\107"+
    "\2\34\1\0\1\34\1\0\2\34\2\0\6\34\1\0"+
    "\6\34\2\0\10\34\1\u0113\53\34\1\u0113\3\34\1\0"+
    "\1\34\1\0\2\34\2\0\6\34\1\0\6\34\2\0"+
    "\33\34\1\165\17\34\1\165\12\34\16\0\1\u01fa\13\0"+
    "\1\u01fa\63\0\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\3\107\1\u0196\2\107\2\0\5\107\11\0\40\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\3\107"+
    "\1\u01fb\2\107\2\0\5\107\11\0\40\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\6\107\2\0\5\107"+
    "\11\0\1\107\1\u0144\36\107\1\100\10\0\6\107\1\0"+
    "\5\107\1\254\2\0\3\107\1\u01fc\2\107\2\0\5\107"+
    "\11\0\40\107\1\100\10\0\6\107\1\0\5\107\1\254"+
    "\2\0\6\107\2\0\5\107\11\0\22\107\1\u015f\15\107"+
    "\1\100\10\0\6\107\1\0\5\107\1\254\2\0\2\107"+
    "\1\u01a2\3\107\2\0\5\107\11\0\40\107\1\100\10\0"+
    "\6\107\1\0\5\107\1\254\2\0\6\107\2\0\5\107"+
    "\11\0\25\107\1\u01fd\12\107\17\0\1\u01fe\76\0\1\100"+
    "\10\0\6\107\1\0\5\107\1\254\2\0\6\107\2\0"+
    "\5\107\11\0\2\107\1\u01ff\35\107\1\100\10\0\6\107"+
    "\1\0\5\107\1\254\2\0\2\107\1\u0133\3\107\2\0"+
    "\5\107\11\0\40\107\1\100\10\0\6\107\1\0\5\107"+
    "\1\254\2\0\6\107\2\0\5\107\11\0\23\107\1\u01f8"+
    "\14\107\1\100\10\0\6\107\1\0\5\107\1\254\2\0"+
    "\6\107\2\0\5\107\11\0\37\107\1\u01f7";

  private static int [] zzUnpackTrans() {
    int [] result = new int[35958];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\5\0\2\1\1\0\2\1\2\0\2\1\1\11\4\1"+
    "\1\11\2\1\1\11\2\1\2\11\2\1\2\11\5\1"+
    "\1\11\1\1\2\11\16\1\1\11\1\1\1\11\1\1"+
    "\5\11\1\1\1\11\2\1\1\11\16\1\1\11\3\1"+
    "\1\11\16\1\1\11\2\1\1\11\1\0\1\11\1\0"+
    "\1\11\71\1\1\11\2\0\20\1\1\11\1\1\1\11"+
    "\56\1\1\11\2\0\1\11\57\1\2\0\3\1\1\0"+
    "\3\1\1\11\72\1\1\11\1\0\32\1\1\0\1\11"+
    "\4\1\1\11\45\1\1\0\16\1\1\0\32\1\1\0"+
    "\7\1\1\0\22\1\1\11\2\1\1\0\7\1\1\0"+
    "\3\1\1\11\1\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[511];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */

	/**
	 * Token type specific to HTMLTokenMaker; this signals that the user has
	 * ended a line with an unclosed HTML tag; thus a new line is beginning
	 * still inside of the tag.
	 */
	public static final int INTERNAL_INTAG					= -1;

	/**
	 * Token type specific to HTMLTokenMaker; this signals that the user has
	 * ended a line with an unclosed <code>&lt;script&gt;</code> tag.
	 */
	public static final int INTERNAL_INTAG_SCRIPT			= -2;

	/**
	 * Token type specifying we're in a double-qouted attribute in a
	 * script tag.
	 */
	public static final int INTERNAL_ATTR_DOUBLE_QUOTE_SCRIPT = -3;

	/**
	 * Token type specifying we're in a single-qouted attribute in a
	 * script tag.
	 */
	public static final int INTERNAL_ATTR_SINGLE_QUOTE_SCRIPT = -4;

	/**
	 * Token type specifying we're in JavaScript.
	 */
	public static final int INTERNAL_IN_JS					= -5;

	/**
	 * Token type specifying we're in a JavaScript multiline comment.
	 */
	public static final int INTERNAL_IN_JS_MLC				= -6;


	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public HTMLTokenMaker() {
		super();
	}


	/**
	 * Adds the token specified to the current linked list of tokens as an
	 * "end token;" that is, at <code>zzMarkedPos</code>.
	 *
	 * @param tokenType The token's type.
	 */
	private void addEndToken(int tokenType) {
		addToken(zzMarkedPos,zzMarkedPos, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * Returns the text to place at the beginning and end of a
	 * line to "comment" it in a this programming language.
	 *
	 * @return The start and end strings to add to a line to "comment"
	 *         it out.
	 */
	public String[] getLineCommentStartAndEnd() {
		return new String[] { "<!--", "-->" };
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;

		// Start off in the proper state.
		int state = Token.NULL;
		switch (initialTokenType) {
			case Token.COMMENT_MULTILINE:
				state = COMMENT;
				start = text.offset;
				break;
			case Token.PREPROCESSOR:
				state = PI;
				start = text.offset;
				break;
			case Token.VARIABLE:
				state = DTD;
				start = text.offset;
				break;
			case INTERNAL_INTAG:
				state = INTAG;
				start = text.offset;
				break;
			case INTERNAL_INTAG_SCRIPT:
				state = INTAG_SCRIPT;
				start = text.offset;
				break;
			case Token.LITERAL_STRING_DOUBLE_QUOTE:
				state = INATTR_DOUBLE;
				start = text.offset;
				break;
			case Token.LITERAL_CHAR:
				state = INATTR_SINGLE;
				start = text.offset;
				break;
			case INTERNAL_ATTR_DOUBLE_QUOTE_SCRIPT:
				state = INATTR_DOUBLE_SCRIPT;
				start = text.offset;
				break;
			case INTERNAL_ATTR_SINGLE_QUOTE_SCRIPT:
				state = INATTR_SINGLE_SCRIPT;
				start = text.offset;
				break;
			case INTERNAL_IN_JS:
				state = JAVASCRIPT;
				start = text.offset;
				break;
			case INTERNAL_IN_JS_MLC:
				state = JS_MLC;
				start = text.offset;
				break;
			default:
				state = Token.NULL;
		}

		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new DefaultToken();
		}

	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream 
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream 
	 */
	public final void yyreset(java.io.Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public HTMLTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public HTMLTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 194) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 2: 
          { addToken(Token.IDENTIFIER);
          }
        case 51: break;
        case 21: 
          { yybegin(INTAG_SCRIPT); addToken(start,zzStartRead, Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 52: break;
        case 47: 
          { addToken(Token.LITERAL_BOOLEAN);
          }
        case 53: break;
        case 4: 
          { addToken(Token.SEPARATOR); yybegin(INTAG);
          }
        case 54: break;
        case 39: 
          { addToken(Token.ERROR_CHAR);
          }
        case 55: break;
        case 36: 
          { addToken(Token.ERROR_NUMBER_FORMAT);
          }
        case 56: break;
        case 18: 
          { yybegin(JAVASCRIPT); addToken(Token.SEPARATOR);
          }
        case 57: break;
        case 19: 
          { start = zzMarkedPos-1; yybegin(INATTR_SINGLE_SCRIPT);
          }
        case 58: break;
        case 9: 
          { addToken(start,zzStartRead-1, Token.VARIABLE); return firstToken;
          }
        case 59: break;
        case 40: 
          { addToken(Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 60: break;
        case 29: 
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_IN_JS_MLC); return firstToken;
          }
        case 61: break;
        case 48: 
          { addToken(Token.FUNCTION);
          }
        case 62: break;
        case 24: 
          { addEndToken(INTERNAL_IN_JS); return firstToken;
          }
        case 63: break;
        case 30: 
          { start = zzMarkedPos-2; yybegin(DTD);
          }
        case 64: break;
        case 34: 
          { addToken(Token.COMMENT_EOL); addEndToken(INTERNAL_IN_JS); return firstToken;
          }
        case 65: break;
        case 50: 
          { yybegin(YYINITIAL);
								  addToken(zzStartRead,zzStartRead, Token.SEPARATOR);
								  addToken(zzMarkedPos-8,zzMarkedPos-2, Token.RESERVED_WORD);
								  addToken(zzMarkedPos-1,zzMarkedPos-1, Token.SEPARATOR);
          }
        case 66: break;
        case 26: 
          { addToken(Token.ERROR_CHAR); addEndToken(INTERNAL_IN_JS); return firstToken;
          }
        case 67: break;
        case 23: 
          { addToken(Token.ERROR_IDENTIFIER);
          }
        case 68: break;
        case 35: 
          { start = zzMarkedPos-2; yybegin(JS_MLC);
          }
        case 69: break;
        case 17: 
          { yybegin(INTAG); addToken(start,zzStartRead, Token.LITERAL_CHAR);
          }
        case 70: break;
        case 10: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead, Token.VARIABLE);
          }
        case 71: break;
        case 41: 
          { yybegin(JAVASCRIPT); addToken(start,zzStartRead+1, Token.COMMENT_MULTILINE);
          }
        case 72: break;
        case 33: 
          { addToken(zzMarkedPos-2, zzMarkedPos-2, Token.RESERVED_WORD);
								addToken(zzMarkedPos-1, zzMarkedPos-1, Token.SEPARATOR);
								yybegin(YYINITIAL);
          }
        case 73: break;
        case 32: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.PREPROCESSOR);
          }
        case 74: break;
        case 13: 
          { yybegin(YYINITIAL); addToken(Token.SEPARATOR);
          }
        case 75: break;
        case 43: 
          { addToken(Token.LITERAL_CHAR);
          }
        case 76: break;
        case 31: 
          { start = zzMarkedPos-2; yybegin(PI);
          }
        case 77: break;
        case 15: 
          { start = zzMarkedPos-1; yybegin(INATTR_DOUBLE);
          }
        case 78: break;
        case 38: 
          { addToken(Token.LITERAL_NUMBER_HEXADECIMAL);
          }
        case 79: break;
        case 20: 
          { start = zzMarkedPos-1; yybegin(INATTR_DOUBLE_SCRIPT);
          }
        case 80: break;
        case 5: 
          { addToken(Token.WHITESPACE);
          }
        case 81: break;
        case 6: 
          { addToken(Token.DATA_TYPE);
          }
        case 82: break;
        case 49: 
          { addToken(zzStartRead,zzStartRead, Token.SEPARATOR);
							  addToken(zzMarkedPos-6,zzMarkedPos-1, Token.RESERVED_WORD);
							  start = zzMarkedPos; yybegin(INTAG_SCRIPT);
          }
        case 83: break;
        case 25: 
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 84: break;
        case 14: 
          { start = zzMarkedPos-1; yybegin(INATTR_SINGLE);
          }
        case 85: break;
        case 16: 
          { yybegin(INTAG); addToken(start,zzStartRead, Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 86: break;
        case 22: 
          { yybegin(INTAG_SCRIPT); addToken(start,zzStartRead, Token.LITERAL_CHAR);
          }
        case 87: break;
        case 44: 
          { start = zzMarkedPos-4; yybegin(COMMENT);
          }
        case 88: break;
        case 12: 
          { addToken(Token.RESERVED_WORD);
          }
        case 89: break;
        case 42: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead+2, Token.COMMENT_MULTILINE);
          }
        case 90: break;
        case 28: 
          { addToken(Token.SEPARATOR);
          }
        case 91: break;
        case 27: 
          { addToken(Token.ERROR_STRING_DOUBLE); addEndToken(INTERNAL_IN_JS); return firstToken;
          }
        case 92: break;
        case 3: 
          { addNullToken(); return firstToken;
          }
        case 93: break;
        case 7: 
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); return firstToken;
          }
        case 94: break;
        case 11: 
          { addToken(Token.OPERATOR);
          }
        case 95: break;
        case 37: 
          { addToken(Token.LITERAL_NUMBER_FLOAT);
          }
        case 96: break;
        case 45: 
          { addToken(Token.COMMENT_MULTILINE);
          }
        case 97: break;
        case 8: 
          { addToken(start,zzStartRead-1, Token.PREPROCESSOR); return firstToken;
          }
        case 98: break;
        case 46: 
          { addToken(Token.ERROR_STRING_DOUBLE);
          }
        case 99: break;
        case 1: 
          { 
          }
        case 100: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case JS_MLC: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addEndToken(INTERNAL_IN_JS_MLC); return firstToken;
            }
            case 512: break;
            case INTAG_SCRIPT: {
              addToken(zzMarkedPos,zzMarkedPos, INTERNAL_INTAG_SCRIPT); return firstToken;
            }
            case 513: break;
            case INATTR_DOUBLE_SCRIPT: {
              addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_ATTR_DOUBLE_QUOTE_SCRIPT); return firstToken;
            }
            case 514: break;
            case INATTR_SINGLE_SCRIPT: {
              addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); addEndToken(INTERNAL_ATTR_SINGLE_QUOTE_SCRIPT); return firstToken;
            }
            case 515: break;
            case DTD: {
              addToken(start,zzStartRead-1, Token.VARIABLE); return firstToken;
            }
            case 516: break;
            case INATTR_SINGLE: {
              addToken(start,zzStartRead-1, Token.LITERAL_CHAR); return firstToken;
            }
            case 517: break;
            case INATTR_DOUBLE: {
              addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
            }
            case 518: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 519: break;
            case INTAG: {
              addToken(zzMarkedPos,zzMarkedPos, INTERNAL_INTAG); return firstToken;
            }
            case 520: break;
            case COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); return firstToken;
            }
            case 521: break;
            case JAVASCRIPT: {
              addEndToken(INTERNAL_IN_JS); return firstToken;
            }
            case 522: break;
            case PI: {
              addToken(start,zzStartRead-1, Token.PREPROCESSOR); return firstToken;
            }
            case 523: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
