/*
 * Copyright (c) 2009 Albert Kurucz.
 *
 * This file, SQLTokenMaker.java is part of JTStand.
 *
 * JTStand is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JTStand is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with JTStand.  If not, see <http://www.gnu.org/licenses/>.
 */

/* The following code was generated by JFlex 1.4.1 on 2/7/09 11:02 AM */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * This class generates tokens representing a text stream as SQL.<p>
 *
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated SQLTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.5
 *
 */

public class SQLTokenMaker extends AbstractJFlexTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int STRING = 1;
  public static final int YYINITIAL = 0;
  public static final int MLC = 3;
  public static final int CHAR = 2;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\4\1\1\25\0\1\4\1\0\1\54\4\0\1\55\2\15"+
    "\1\13\1\11\1\0\1\12\1\17\1\14\1\3\1\50\1\50\1\3"+
    "\1\45\3\3\1\46\1\3\1\16\1\0\1\10\1\7\1\6\2\0"+
    "\1\21\1\37\1\31\1\22\1\20\1\44\1\47\1\41\1\34\1\51"+
    "\1\52\1\23\1\35\1\26\1\33\1\42\1\53\1\25\1\30\1\24"+
    "\1\32\1\36\1\40\1\43\1\27\1\2\1\56\1\0\1\57\1\0"+
    "\1\5\1\0\1\21\1\37\1\31\1\22\1\20\1\44\1\47\1\41"+
    "\1\34\1\51\1\52\1\23\1\35\1\26\1\33\1\42\1\53\1\25"+
    "\1\30\1\24\1\32\1\36\1\40\1\43\1\27\1\2\uff85\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\4\0\1\1\1\2\1\1\1\3\1\4\5\5\1\6"+
    "\1\1\1\7\27\1\1\10\1\11\1\12\1\13\1\14"+
    "\1\15\1\13\1\16\1\17\1\13\1\20\1\13\1\0"+
    "\1\21\1\22\4\1\1\23\45\1\2\23\4\1\1\23"+
    "\7\1\1\23\22\1\1\24\1\13\1\25\1\7\1\0"+
    "\3\1\1\26\51\1\1\23\4\1\1\23\2\1\1\23"+
    "\22\1\1\23\4\1\1\23\4\1\1\23\17\1\1\23"+
    "\35\1\1\23\5\1\1\23\10\1\1\23\5\1\1\23"+
    "\11\1\1\23\42\1\1\23\4\1\1\23\16\1\1\26"+
    "\4\1";

  private static int [] zzUnpackAction() {
    int [] result = new int[354];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\60\0\140\0\220\0\300\0\300\0\360\0\u0120"+
    "\0\u0150\0\u0180\0\300\0\u01b0\0\u01e0\0\u0210\0\300\0\u0240"+
    "\0\u0270\0\u02a0\0\u02d0\0\u0300\0\u0330\0\u0360\0\u0390\0\u03c0"+
    "\0\u03f0\0\u0420\0\u0450\0\u0480\0\u04b0\0\u04e0\0\u0510\0\u0540"+
    "\0\u0570\0\u05a0\0\u05d0\0\u0600\0\u0630\0\u0660\0\u0690\0\u06c0"+
    "\0\300\0\300\0\u06f0\0\u0720\0\300\0\u0750\0\u0780\0\300"+
    "\0\u07b0\0\u07e0\0\300\0\u0810\0\u0840\0\u0870\0\300\0\u08a0"+
    "\0\u08d0\0\u0900\0\u0930\0\u0960\0\u0990\0\u09c0\0\u09f0\0\u0a20"+
    "\0\u0a50\0\u0a80\0\u0ab0\0\u0ae0\0\u0b10\0\u0b40\0\u0b70\0\u0ba0"+
    "\0\u0bd0\0\u0c00\0\u0c30\0\u0c60\0\u0c90\0\u0cc0\0\u0cf0\0\u0d20"+
    "\0\u0d50\0\u0d80\0\u0db0\0\u0de0\0\u0e10\0\u0e40\0\u0e70\0\u0ea0"+
    "\0\u0ed0\0\u0f00\0\u0f30\0\u0f60\0\u0f90\0\u0fc0\0\u0ff0\0\u1020"+
    "\0\u1050\0\u1080\0\360\0\u10b0\0\u10e0\0\u1110\0\u1140\0\u1170"+
    "\0\u11a0\0\u11d0\0\u1200\0\u1230\0\u1260\0\u1290\0\u12c0\0\u12f0"+
    "\0\u1320\0\u1350\0\u1380\0\u13b0\0\u13e0\0\u1410\0\u1440\0\u1470"+
    "\0\u14a0\0\u14d0\0\u1500\0\u1530\0\u1560\0\u1590\0\u15c0\0\u15f0"+
    "\0\u1620\0\u1650\0\300\0\300\0\300\0\u1680\0\u1680\0\u16b0"+
    "\0\u16e0\0\u1710\0\360\0\u1740\0\u0960\0\u1770\0\u17a0\0\u17d0"+
    "\0\u1800\0\u1830\0\u1860\0\u1890\0\u18c0\0\u18f0\0\u1920\0\u1950"+
    "\0\u1980\0\u19b0\0\u19e0\0\u1a10\0\u1a40\0\u1a70\0\u1aa0\0\u1ad0"+
    "\0\u1b00\0\u1b30\0\u1b60\0\u1b90\0\u1bc0\0\u1bf0\0\u1c20\0\u1c50"+
    "\0\u1c80\0\u1cb0\0\u1ce0\0\u1d10\0\u1d40\0\u1d70\0\u1da0\0\u1dd0"+
    "\0\u1e00\0\u1e30\0\u1e60\0\u1e90\0\u1ec0\0\u1ef0\0\u1f20\0\u1f50"+
    "\0\u1f80\0\u1fb0\0\u1fe0\0\u2010\0\u2040\0\u2070\0\u20a0\0\u20d0"+
    "\0\u2100\0\u2130\0\u2160\0\u2190\0\u21c0\0\u21f0\0\u2220\0\u2250"+
    "\0\u2280\0\u22b0\0\u22e0\0\u2310\0\u2340\0\u2370\0\u12f0\0\u23a0"+
    "\0\u23d0\0\u2400\0\u2430\0\u2460\0\u2490\0\u24c0\0\u24f0\0\u2520"+
    "\0\u2550\0\u2580\0\u25b0\0\u25e0\0\u2610\0\u2640\0\u2670\0\u26a0"+
    "\0\u26d0\0\u2700\0\u2730\0\u2760\0\u2790\0\u27c0\0\u27f0\0\u2820"+
    "\0\u2850\0\u2880\0\u28b0\0\u28e0\0\u2910\0\u2940\0\u2970\0\u29a0"+
    "\0\u29d0\0\u2a00\0\u2a30\0\u2a60\0\u2a90\0\u2ac0\0\u2af0\0\u2b20"+
    "\0\u2b50\0\u2b80\0\u2bb0\0\u2be0\0\u2c10\0\u2c40\0\u2c70\0\u2ca0"+
    "\0\u2cd0\0\u2d00\0\u2d30\0\u2d60\0\u2d90\0\u2dc0\0\u2df0\0\u15f0"+
    "\0\u2e20\0\u2e50\0\u2e80\0\u2eb0\0\u2ee0\0\u0c30\0\u2f10\0\u2f40"+
    "\0\u2f70\0\u2fa0\0\u2fd0\0\u3000\0\u3030\0\u3060\0\u0ff0\0\u3090"+
    "\0\u30c0\0\u2040\0\u30f0\0\u3120\0\u2ca0\0\u3150\0\u3180\0\u31b0"+
    "\0\u31e0\0\u3210\0\u3240\0\u3270\0\u32a0\0\u32d0\0\u3300\0\u3330"+
    "\0\u3360\0\u3390\0\u33c0\0\u33f0\0\u3420\0\u3450\0\u3480\0\u34b0"+
    "\0\u34e0\0\u3510\0\u3540\0\u3570\0\u35a0\0\u35d0\0\u3600\0\u3630"+
    "\0\u3660\0\u3690\0\u36c0\0\u36f0\0\u3720\0\u3750\0\u3780\0\u37b0"+
    "\0\u37e0\0\u3810\0\u3840\0\u3870\0\u38a0\0\u38d0\0\u3900\0\u3930"+
    "\0\u3960\0\u3990\0\u39c0\0\u39f0\0\u3a20\0\u3a50\0\u3a80\0\u3ab0"+
    "\0\u3ae0\0\u3b10\0\u3b40\0\u3b70\0\u3ba0\0\u3bd0\0\u3c00\0\u3c30"+
    "\0\u3c60\0\u3c90\0\u3cc0\0\u3cf0\0\u3d20\0\u3d50\0\u3d80\0\u3db0"+
    "\0\u3de0\0\u3e10";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[354];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\5\1\6\1\7\1\10\1\11\1\5\1\12\1\13"+
    "\1\14\1\13\1\15\1\13\1\16\1\17\1\20\1\21"+
    "\1\22\1\23\1\24\1\25\1\26\1\27\1\30\1\31"+
    "\1\32\1\33\1\34\1\35\1\36\1\37\1\40\1\41"+
    "\1\42\1\43\1\44\1\7\1\45\2\10\1\46\1\10"+
    "\1\47\1\50\1\7\1\51\1\52\1\53\1\5\1\54"+
    "\1\55\52\54\1\56\3\54\1\57\1\60\53\57\1\61"+
    "\2\57\1\62\1\63\11\62\1\64\44\62\62\0\2\7"+
    "\1\0\1\7\12\0\34\7\7\0\1\10\13\0\1\21"+
    "\1\65\24\0\2\10\1\0\1\10\13\0\1\11\62\0"+
    "\1\13\56\0\2\13\62\0\1\66\60\0\1\67\46\0"+
    "\1\7\15\0\25\7\2\0\1\7\1\0\3\7\7\0"+
    "\1\21\14\0\1\65\24\0\2\21\1\0\1\21\11\0"+
    "\2\7\1\0\1\7\12\0\23\7\1\70\10\7\6\0"+
    "\2\7\1\0\1\7\12\0\2\7\1\71\1\72\2\7"+
    "\1\73\1\7\1\74\1\7\1\75\3\7\1\76\15\7"+
    "\6\0\2\7\1\0\1\7\12\0\1\77\1\100\3\7"+
    "\1\101\5\7\1\102\1\103\17\7\6\0\2\7\1\0"+
    "\1\7\12\0\1\104\12\7\1\105\1\106\17\7\6\0"+
    "\2\7\1\0\1\7\12\0\1\107\1\110\3\7\1\111"+
    "\1\7\1\112\3\7\1\113\1\114\17\7\6\0\2\7"+
    "\1\0\1\7\12\0\1\115\13\7\1\116\17\7\6\0"+
    "\2\7\1\0\1\7\12\0\12\7\1\117\1\120\20\7"+
    "\6\0\2\7\1\0\1\7\12\0\1\121\33\7\6\0"+
    "\2\7\1\0\1\7\12\0\1\122\3\7\1\123\2\7"+
    "\1\124\2\7\1\125\1\126\1\127\1\130\3\7\1\131"+
    "\12\7\6\0\2\7\1\0\1\7\12\0\5\7\1\132"+
    "\4\7\1\133\1\134\5\7\1\135\12\7\6\0\2\7"+
    "\1\0\1\7\12\0\6\7\1\136\1\7\1\137\11\7"+
    "\1\140\11\7\6\0\2\7\1\0\1\7\12\0\3\7"+
    "\1\141\1\7\1\142\1\143\2\7\1\144\1\145\5\7"+
    "\1\146\1\7\1\147\11\7\6\0\2\7\1\0\1\7"+
    "\12\0\6\7\1\150\1\7\1\143\4\7\1\113\11\7"+
    "\1\151\4\7\6\0\2\7\1\0\1\7\12\0\1\152"+
    "\1\153\11\7\1\154\1\155\17\7\6\0\2\7\1\0"+
    "\1\7\12\0\1\7\1\156\32\7\6\0\2\7\1\0"+
    "\1\7\12\0\1\157\6\7\1\160\3\7\1\161\1\162"+
    "\17\7\6\0\2\7\1\0\1\7\12\0\14\7\1\163"+
    "\4\7\1\164\12\7\6\0\2\7\1\0\1\7\12\0"+
    "\1\7\1\165\32\7\6\0\2\7\1\0\1\7\12\0"+
    "\1\166\1\167\3\7\1\170\5\7\1\171\1\172\17\7"+
    "\6\0\2\7\1\0\1\7\12\0\3\7\1\173\1\7"+
    "\1\174\5\7\1\175\20\7\6\0\2\7\1\0\1\7"+
    "\12\0\1\176\4\7\1\177\4\7\1\200\21\7\6\0"+
    "\2\7\1\0\1\7\12\0\13\7\1\201\20\7\6\0"+
    "\2\7\1\0\1\7\12\0\1\202\33\7\4\0\57\53"+
    "\1\203\1\54\1\0\52\54\1\0\3\54\54\0\1\204"+
    "\3\0\1\57\1\0\53\57\1\0\2\57\55\0\1\204"+
    "\2\0\1\62\1\0\11\62\1\0\44\62\14\0\1\205"+
    "\46\0\1\206\5\0\2\207\32\0\2\206\1\0\1\206"+
    "\7\0\1\66\1\0\56\66\2\0\2\7\1\0\1\7"+
    "\12\0\4\7\1\210\7\7\1\211\17\7\6\0\2\7"+
    "\1\0\1\7\12\0\2\7\1\143\31\7\6\0\2\7"+
    "\1\0\1\7\12\0\3\7\1\143\1\137\27\7\6\0"+
    "\2\7\1\0\1\7\12\0\2\7\1\143\4\7\1\143"+
    "\24\7\6\0\2\7\1\0\1\7\12\0\11\7\1\143"+
    "\22\7\6\0\2\7\1\0\1\7\12\0\4\7\1\212"+
    "\27\7\6\0\2\7\1\0\1\7\12\0\1\7\1\143"+
    "\25\7\1\213\4\7\6\0\2\7\1\0\1\7\12\0"+
    "\3\7\1\214\4\7\1\215\23\7\6\0\2\7\1\0"+
    "\1\7\12\0\4\7\1\216\27\7\6\0\2\7\1\0"+
    "\1\7\12\0\13\7\1\113\20\7\6\0\2\7\1\0"+
    "\1\7\12\0\12\7\1\217\21\7\6\0\2\7\1\0"+
    "\1\7\12\0\10\7\1\220\23\7\6\0\2\7\1\0"+
    "\1\7\12\0\16\7\1\221\5\7\1\120\7\7\6\0"+
    "\2\7\1\0\1\7\12\0\6\7\1\222\11\7\1\223"+
    "\6\7\1\224\4\7\6\0\2\7\1\0\1\7\12\0"+
    "\32\7\1\225\1\7\6\0\2\7\1\0\1\7\12\0"+
    "\23\7\1\120\10\7\6\0\2\7\1\0\1\7\12\0"+
    "\17\7\1\226\14\7\6\0\2\7\1\0\1\7\12\0"+
    "\1\7\1\227\12\7\1\230\17\7\6\0\2\7\1\0"+
    "\1\7\12\0\22\7\1\225\11\7\6\0\2\7\1\0"+
    "\1\7\12\0\22\7\1\143\11\7\6\0\2\7\1\0"+
    "\1\7\12\0\15\7\1\231\16\7\6\0\2\7\1\0"+
    "\1\7\12\0\1\7\1\232\22\7\1\233\7\7\6\0"+
    "\2\7\1\0\1\7\12\0\27\7\1\234\4\7\6\0"+
    "\2\7\1\0\1\7\12\0\3\7\1\232\11\7\1\235"+
    "\16\7\6\0\2\7\1\0\1\7\12\0\4\7\1\143"+
    "\27\7\6\0\2\7\1\0\1\7\12\0\10\7\1\236"+
    "\23\7\6\0\2\7\1\0\1\7\12\0\3\7\1\237"+
    "\1\143\3\7\1\240\23\7\6\0\2\7\1\0\1\7"+
    "\12\0\2\7\1\241\2\7\1\242\26\7\6\0\2\7"+
    "\1\0\1\7\12\0\10\7\1\243\23\7\6\0\2\7"+
    "\1\0\1\7\12\0\15\7\1\143\1\7\1\244\14\7"+
    "\6\0\2\7\1\0\1\7\12\0\15\7\1\225\16\7"+
    "\6\0\2\7\1\0\1\7\12\0\6\7\1\245\25\7"+
    "\6\0\2\7\1\0\1\7\12\0\1\7\1\246\32\7"+
    "\6\0\2\7\1\0\1\7\12\0\13\7\1\247\20\7"+
    "\6\0\2\7\1\0\1\7\12\0\1\250\33\7\6\0"+
    "\2\7\1\0\1\7\12\0\5\7\1\251\26\7\6\0"+
    "\2\7\1\0\1\7\12\0\3\7\1\252\2\7\1\253"+
    "\3\7\1\254\21\7\6\0\2\7\1\0\1\7\12\0"+
    "\1\7\1\255\32\7\6\0\2\7\1\0\1\7\12\0"+
    "\14\7\1\256\17\7\6\0\2\7\1\0\1\7\12\0"+
    "\1\257\33\7\6\0\2\7\1\0\1\7\12\0\2\7"+
    "\1\250\17\7\1\223\11\7\6\0\2\7\1\0\1\7"+
    "\12\0\1\260\33\7\6\0\2\7\1\0\1\7\12\0"+
    "\2\7\1\137\31\7\6\0\2\7\1\0\1\7\12\0"+
    "\4\7\1\261\27\7\6\0\2\7\1\0\1\7\12\0"+
    "\4\7\1\137\27\7\6\0\2\7\1\0\1\7\12\0"+
    "\6\7\1\262\25\7\6\0\2\7\1\0\1\7\12\0"+
    "\4\7\1\263\27\7\6\0\2\7\1\0\1\7\12\0"+
    "\2\7\1\264\1\7\1\265\1\7\1\137\1\7\1\266"+
    "\23\7\6\0\2\7\1\0\1\7\12\0\6\7\1\267"+
    "\25\7\6\0\2\7\1\0\1\7\12\0\15\7\1\270"+
    "\16\7\6\0\2\7\1\0\1\7\12\0\23\7\1\143"+
    "\10\7\6\0\2\7\1\0\1\7\12\0\2\7\1\143"+
    "\3\7\1\50\25\7\6\0\2\7\1\0\1\7\12\0"+
    "\6\7\1\143\25\7\6\0\2\7\1\0\1\7\12\0"+
    "\3\7\1\271\1\7\1\272\26\7\6\0\2\7\1\0"+
    "\1\7\12\0\4\7\1\273\27\7\6\0\2\7\1\0"+
    "\1\7\12\0\4\7\1\225\27\7\6\0\2\7\1\0"+
    "\1\7\12\0\13\7\1\274\20\7\6\0\2\7\1\0"+
    "\1\7\12\0\4\7\1\275\1\7\1\276\25\7\6\0"+
    "\2\7\1\0\1\7\12\0\4\7\1\277\27\7\6\0"+
    "\2\7\1\0\1\7\12\0\1\300\33\7\6\0\2\7"+
    "\1\0\1\7\12\0\16\7\1\242\15\7\6\0\2\7"+
    "\1\0\1\7\12\0\5\7\1\301\26\7\6\0\2\7"+
    "\1\0\1\7\12\0\5\7\1\302\2\7\1\303\23\7"+
    "\6\0\2\7\1\0\1\7\12\0\14\7\1\304\17\7"+
    "\6\0\2\7\1\0\1\7\12\0\10\7\1\305\23\7"+
    "\6\0\2\7\1\0\1\7\12\0\16\7\1\306\15\7"+
    "\6\0\2\7\1\0\1\7\12\0\13\7\1\307\20\7"+
    "\6\0\2\7\1\0\1\7\12\0\13\7\1\310\20\7"+
    "\6\0\2\7\1\0\1\7\12\0\5\7\1\311\26\7"+
    "\6\0\2\7\1\0\1\7\12\0\6\7\1\312\25\7"+
    "\6\0\2\7\1\0\1\7\12\0\13\7\1\313\20\7"+
    "\6\0\2\7\1\0\1\7\12\0\14\7\1\71\17\7"+
    "\6\0\2\7\1\0\1\7\12\0\14\7\1\155\17\7"+
    "\6\0\2\7\1\0\1\7\12\0\7\7\1\143\24\7"+
    "\7\0\1\206\41\0\2\206\1\0\1\206\11\0\2\7"+
    "\1\0\1\7\12\0\5\7\1\314\26\7\6\0\2\7"+
    "\1\0\1\7\12\0\10\7\1\315\23\7\6\0\2\7"+
    "\1\0\1\7\12\0\13\7\1\316\20\7\6\0\2\7"+
    "\1\0\1\7\12\0\1\317\33\7\6\0\2\7\1\0"+
    "\1\7\12\0\1\320\1\321\32\7\6\0\2\7\1\0"+
    "\1\7\12\0\17\7\1\322\14\7\6\0\2\7\1\0"+
    "\1\7\12\0\1\7\1\323\2\7\1\324\27\7\6\0"+
    "\2\7\1\0\1\7\12\0\1\232\33\7\6\0\2\7"+
    "\1\0\1\7\12\0\27\7\1\325\4\7\6\0\2\7"+
    "\1\0\1\7\12\0\1\326\33\7\6\0\2\7\1\0"+
    "\1\7\12\0\14\7\1\327\17\7\6\0\2\7\1\0"+
    "\1\7\12\0\1\143\33\7\6\0\2\7\1\0\1\7"+
    "\12\0\3\7\1\330\30\7\6\0\2\7\1\0\1\7"+
    "\12\0\6\7\1\331\25\7\6\0\2\7\1\0\1\7"+
    "\12\0\15\7\1\213\16\7\6\0\2\7\1\0\1\7"+
    "\12\0\1\332\33\7\6\0\2\7\1\0\1\7\12\0"+
    "\3\7\1\143\30\7\6\0\2\7\1\0\1\7\12\0"+
    "\1\333\33\7\6\0\2\7\1\0\1\7\12\0\21\7"+
    "\1\120\12\7\6\0\2\7\1\0\1\7\12\0\1\334"+
    "\16\7\1\137\14\7\6\0\2\7\1\0\1\7\12\0"+
    "\6\7\1\270\25\7\6\0\2\7\1\0\1\7\12\0"+
    "\1\335\33\7\6\0\2\7\1\0\1\7\12\0\10\7"+
    "\1\336\23\7\6\0\2\7\1\0\1\7\12\0\1\337"+
    "\33\7\6\0\2\7\1\0\1\7\12\0\14\7\1\340"+
    "\17\7\6\0\2\7\1\0\1\7\12\0\4\7\1\341"+
    "\27\7\6\0\2\7\1\0\1\7\12\0\10\7\1\342"+
    "\23\7\6\0\2\7\1\0\1\7\12\0\27\7\1\322"+
    "\4\7\6\0\2\7\1\0\1\7\12\0\3\7\1\343"+
    "\30\7\6\0\2\7\1\0\1\7\12\0\5\7\1\120"+
    "\26\7\6\0\2\7\1\0\1\7\12\0\1\7\1\317"+
    "\32\7\6\0\2\7\1\0\1\7\12\0\5\7\1\344"+
    "\26\7\6\0\2\7\1\0\1\7\12\0\12\7\1\345"+
    "\21\7\6\0\2\7\1\0\1\7\12\0\10\7\1\346"+
    "\1\347\4\7\1\350\15\7\6\0\2\7\1\0\1\7"+
    "\12\0\6\7\1\351\25\7\6\0\2\7\1\0\1\7"+
    "\12\0\5\7\1\352\26\7\6\0\2\7\1\0\1\7"+
    "\12\0\13\7\1\155\17\7\1\353\6\0\2\7\1\0"+
    "\1\7\12\0\5\7\1\143\26\7\6\0\2\7\1\0"+
    "\1\7\12\0\13\7\1\354\20\7\6\0\2\7\1\0"+
    "\1\7\12\0\1\355\33\7\6\0\2\7\1\0\1\7"+
    "\12\0\1\356\33\7\6\0\2\7\1\0\1\7\12\0"+
    "\14\7\1\357\17\7\6\0\2\7\1\0\1\7\12\0"+
    "\1\153\33\7\6\0\2\7\1\0\1\7\12\0\1\360"+
    "\12\7\1\143\20\7\6\0\2\7\1\0\1\7\12\0"+
    "\1\247\33\7\6\0\2\7\1\0\1\7\12\0\13\7"+
    "\1\300\20\7\6\0\2\7\1\0\1\7\12\0\13\7"+
    "\1\143\20\7\6\0\2\7\1\0\1\7\12\0\12\7"+
    "\1\361\21\7\6\0\2\7\1\0\1\7\12\0\11\7"+
    "\1\362\5\7\1\363\2\7\1\143\11\7\6\0\2\7"+
    "\1\0\1\7\12\0\20\7\1\364\13\7\6\0\2\7"+
    "\1\0\1\7\12\0\3\7\1\365\30\7\6\0\2\7"+
    "\1\0\1\366\12\0\34\7\6\0\2\7\1\0\1\7"+
    "\12\0\1\7\1\367\32\7\6\0\2\7\1\0\1\7"+
    "\12\0\21\7\1\143\12\7\6\0\2\7\1\0\1\7"+
    "\12\0\5\7\1\225\26\7\6\0\2\7\1\0\1\7"+
    "\12\0\11\7\1\370\22\7\6\0\2\7\1\0\1\7"+
    "\12\0\1\7\1\371\32\7\6\0\2\7\1\0\1\7"+
    "\12\0\10\7\1\372\23\7\6\0\2\7\1\0\1\7"+
    "\12\0\15\7\1\276\16\7\6\0\2\7\1\0\1\7"+
    "\12\0\14\7\1\373\17\7\6\0\2\7\1\0\1\7"+
    "\12\0\13\7\1\120\20\7\6\0\2\7\1\0\1\7"+
    "\12\0\1\7\1\374\32\7\6\0\2\7\1\0\1\7"+
    "\12\0\15\7\1\143\16\7\6\0\2\7\1\0\1\7"+
    "\12\0\1\375\33\7\6\0\2\7\1\0\1\7\12\0"+
    "\1\376\33\7\6\0\2\7\1\0\1\7\12\0\12\7"+
    "\1\113\21\7\6\0\2\7\1\0\1\7\12\0\1\7"+
    "\1\377\32\7\6\0\2\7\1\0\1\7\12\0\4\7"+
    "\1\u0100\27\7\6\0\2\7\1\0\1\7\12\0\14\7"+
    "\1\u0101\17\7\6\0\2\7\1\0\1\7\12\0\4\7"+
    "\1\u0102\27\7\6\0\2\7\1\0\1\7\12\0\17\7"+
    "\1\u0103\14\7\6\0\2\7\1\0\1\7\12\0\3\7"+
    "\1\225\30\7\6\0\2\7\1\0\1\7\12\0\3\7"+
    "\1\u0104\30\7\6\0\2\7\1\0\1\7\12\0\14\7"+
    "\1\u0105\17\7\6\0\2\7\1\0\1\7\12\0\4\7"+
    "\1\u0106\12\7\1\363\14\7\6\0\2\7\1\0\1\7"+
    "\12\0\5\7\1\213\26\7\6\0\2\7\1\0\1\7"+
    "\12\0\11\7\1\u0107\22\7\6\0\2\7\1\0\1\7"+
    "\12\0\1\u0108\33\7\6\0\2\7\1\0\1\7\12\0"+
    "\10\7\1\u0109\23\7\6\0\2\7\1\0\1\7\12\0"+
    "\10\7\1\u010a\23\7\6\0\2\7\1\0\1\7\12\0"+
    "\5\7\1\u010b\26\7\6\0\2\7\1\0\1\7\12\0"+
    "\5\7\1\u010c\26\7\6\0\2\7\1\0\1\7\12\0"+
    "\11\7\1\120\22\7\6\0\2\7\1\0\1\7\12\0"+
    "\14\7\1\u010d\17\7\6\0\2\7\1\0\1\7\12\0"+
    "\16\7\1\u010e\15\7\6\0\2\7\1\0\1\7\12\0"+
    "\6\7\1\u010f\25\7\6\0\2\7\1\0\1\7\12\0"+
    "\1\u0110\33\7\6\0\2\7\1\0\1\7\12\0\4\7"+
    "\1\u0111\27\7\6\0\2\7\1\0\1\7\12\0\3\7"+
    "\1\u0112\30\7\6\0\2\7\1\0\1\7\12\0\1\u0113"+
    "\33\7\6\0\2\7\1\0\1\7\12\0\15\7\1\155"+
    "\16\7\6\0\2\7\1\0\1\7\12\0\4\7\1\u0114"+
    "\27\7\6\0\2\7\1\0\1\7\12\0\1\7\1\u0115"+
    "\32\7\6\0\2\7\1\0\1\7\12\0\1\u0116\33\7"+
    "\6\0\2\7\1\0\1\7\12\0\4\7\1\u0117\27\7"+
    "\6\0\2\7\1\0\1\366\12\0\1\7\1\u0118\32\7"+
    "\6\0\2\7\1\0\1\7\12\0\12\7\1\225\21\7"+
    "\6\0\2\7\1\0\1\7\12\0\17\7\1\u0119\14\7"+
    "\6\0\2\7\1\0\1\7\12\0\4\7\1\u011a\27\7"+
    "\6\0\2\7\1\0\1\7\12\0\5\7\1\u011b\26\7"+
    "\6\0\2\7\1\0\1\7\12\0\13\7\1\155\20\7"+
    "\6\0\2\7\1\0\1\7\12\0\27\7\1\u011c\4\7"+
    "\6\0\2\7\1\0\1\7\12\0\1\u011d\33\7\6\0"+
    "\2\7\1\0\1\7\12\0\21\7\1\u011e\12\7\6\0"+
    "\2\7\1\0\1\7\12\0\14\7\1\u011f\17\7\6\0"+
    "\2\7\1\0\1\7\12\0\1\u0120\33\7\6\0\2\7"+
    "\1\0\1\7\12\0\1\u0121\33\7\6\0\2\7\1\0"+
    "\1\7\12\0\3\7\1\u0122\30\7\6\0\2\7\1\0"+
    "\1\7\12\0\5\7\1\202\26\7\6\0\2\7\1\0"+
    "\1\7\12\0\1\u0123\33\7\6\0\2\7\1\0\1\7"+
    "\12\0\15\7\1\u0124\16\7\6\0\2\7\1\0\1\7"+
    "\12\0\20\7\1\u0125\13\7\6\0\2\7\1\0\1\7"+
    "\12\0\4\7\1\u0126\27\7\6\0\2\7\1\0\1\7"+
    "\12\0\4\7\1\u0127\27\7\6\0\2\7\1\0\1\7"+
    "\12\0\14\7\1\u0128\17\7\6\0\2\7\1\0\1\7"+
    "\12\0\5\7\1\u0107\26\7\6\0\2\7\1\0\1\7"+
    "\12\0\11\7\1\u0129\22\7\6\0\2\7\1\0\1\7"+
    "\12\0\10\7\1\143\23\7\6\0\2\7\1\0\1\7"+
    "\12\0\6\7\1\u012a\25\7\6\0\2\7\1\0\1\7"+
    "\12\0\14\7\1\126\17\7\6\0\2\7\1\0\1\7"+
    "\12\0\1\7\1\u012b\32\7\6\0\2\7\1\0\1\7"+
    "\12\0\3\7\1\u012c\30\7\6\0\2\7\1\0\1\7"+
    "\12\0\6\7\1\u012d\25\7\6\0\2\7\1\0\1\7"+
    "\12\0\1\107\33\7\6\0\2\7\1\0\1\7\12\0"+
    "\1\7\1\232\32\7\6\0\2\7\1\0\1\7\12\0"+
    "\3\7\1\u012e\20\7\1\u012f\7\7\6\0\2\7\1\0"+
    "\1\7\12\0\4\7\1\u0130\27\7\6\0\2\7\1\0"+
    "\1\7\12\0\1\u0131\33\7\6\0\2\7\1\0\1\7"+
    "\12\0\14\7\1\215\17\7\6\0\2\7\1\0\1\7"+
    "\12\0\13\7\1\u0132\20\7\6\0\2\7\1\0\1\7"+
    "\12\0\27\7\1\143\4\7\6\0\2\7\1\0\1\7"+
    "\12\0\15\7\1\u0133\16\7\6\0\2\7\1\0\1\7"+
    "\12\0\5\7\1\u0134\26\7\6\0\2\7\1\0\1\7"+
    "\12\0\14\7\1\u0123\17\7\6\0\2\7\1\0\1\7"+
    "\12\0\6\7\1\u0135\25\7\6\0\2\7\1\0\1\7"+
    "\12\0\5\7\1\u0136\26\7\6\0\2\7\1\0\1\7"+
    "\12\0\4\7\1\u0137\27\7\6\0\2\7\1\0\1\7"+
    "\12\0\5\7\1\u0129\26\7\6\0\2\7\1\0\1\7"+
    "\12\0\11\7\1\145\22\7\6\0\2\7\1\0\1\7"+
    "\12\0\31\7\1\237\2\7\6\0\2\7\1\0\1\7"+
    "\12\0\1\7\1\u0138\32\7\6\0\2\7\1\0\1\7"+
    "\12\0\1\u0139\33\7\6\0\2\7\1\0\1\7\12\0"+
    "\1\7\1\257\32\7\6\0\2\7\1\0\1\7\12\0"+
    "\6\7\1\276\25\7\6\0\2\7\1\0\1\7\12\0"+
    "\1\155\33\7\6\0\2\7\1\0\1\7\12\0\1\7"+
    "\1\155\32\7\6\0\2\7\1\0\1\7\12\0\1\u013a"+
    "\33\7\6\0\2\7\1\0\1\7\12\0\6\7\1\120"+
    "\25\7\6\0\2\7\1\0\1\7\12\0\1\u013b\33\7"+
    "\6\0\2\7\1\0\1\7\12\0\13\7\1\u013c\20\7"+
    "\6\0\2\7\1\0\1\7\12\0\14\7\1\u013d\17\7"+
    "\6\0\2\7\1\0\1\7\12\0\25\7\2\143\5\7"+
    "\6\0\2\7\1\0\1\7\12\0\27\7\1\155\4\7"+
    "\6\0\2\7\1\0\1\7\12\0\4\7\1\213\27\7"+
    "\6\0\2\7\1\0\1\7\12\0\11\7\1\u013e\22\7"+
    "\6\0\2\7\1\0\1\7\12\0\10\7\1\225\23\7"+
    "\6\0\2\7\1\0\1\7\12\0\13\7\1\u013f\20\7"+
    "\6\0\2\7\1\0\1\7\12\0\11\7\1\u0140\22\7"+
    "\6\0\2\7\1\0\1\7\12\0\1\7\1\u0141\32\7"+
    "\6\0\2\7\1\0\1\7\12\0\13\7\1\u0142\20\7"+
    "\6\0\2\7\1\0\1\7\12\0\1\7\1\u0143\32\7"+
    "\6\0\2\7\1\0\1\7\12\0\6\7\1\u0144\25\7"+
    "\6\0\2\7\1\0\1\7\12\0\6\7\1\u0133\25\7"+
    "\6\0\2\7\1\0\1\u0145\12\0\34\7\6\0\2\7"+
    "\1\0\1\7\12\0\14\7\1\u0146\17\7\6\0\2\7"+
    "\1\0\1\7\12\0\4\7\1\u0147\4\7\1\202\22\7"+
    "\6\0\2\7\1\0\1\7\12\0\1\7\1\u0112\32\7"+
    "\6\0\2\7\1\0\1\7\12\0\1\u0148\33\7\6\0"+
    "\2\7\1\0\1\7\12\0\11\7\1\u0149\22\7\6\0"+
    "\2\7\1\0\1\7\12\0\5\7\1\u014a\26\7\6\0"+
    "\2\7\1\0\1\7\12\0\6\7\1\u014b\25\7\6\0"+
    "\2\7\1\0\1\7\12\0\4\7\1\u014c\27\7\6\0"+
    "\2\7\1\0\1\7\12\0\5\7\1\71\26\7\6\0"+
    "\2\7\1\0\1\7\12\0\13\7\1\u014d\20\7\6\0"+
    "\2\7\1\0\1\7\12\0\5\7\1\u014e\26\7\6\0"+
    "\2\7\1\0\1\7\12\0\20\7\1\143\13\7\6\0"+
    "\2\7\1\0\1\7\12\0\4\7\1\u014f\27\7\6\0"+
    "\2\7\1\0\1\7\12\0\4\7\1\u0150\27\7\6\0"+
    "\2\7\1\0\1\7\12\0\5\7\1\310\26\7\6\0"+
    "\2\7\1\0\1\7\12\0\15\7\1\113\16\7\6\0"+
    "\2\7\1\0\1\7\12\0\11\7\1\u0151\22\7\6\0"+
    "\2\7\1\0\1\7\12\0\12\7\1\u0152\21\7\6\0"+
    "\2\7\1\0\1\7\12\0\6\7\1\u0153\25\7\6\0"+
    "\2\7\1\0\1\u0154\12\0\34\7\6\0\2\7\1\0"+
    "\1\7\12\0\6\7\1\u012e\25\7\6\0\2\7\1\0"+
    "\1\7\12\0\11\7\1\u0155\22\7\6\0\2\7\1\0"+
    "\1\7\12\0\25\7\1\143\2\7\1\143\3\7\6\0"+
    "\2\7\1\0\1\7\12\0\27\7\1\u0156\4\7\6\0"+
    "\2\7\1\0\1\7\12\0\1\u0157\33\7\6\0\2\7"+
    "\1\0\1\7\12\0\6\7\1\213\25\7\6\0\2\7"+
    "\1\0\1\7\12\0\1\u0158\33\7\6\0\2\7\1\0"+
    "\1\7\12\0\5\7\1\u012c\26\7\6\0\2\7\1\0"+
    "\1\7\12\0\1\213\33\7\6\0\2\7\1\0\1\7"+
    "\12\0\1\u0100\33\7\6\0\2\7\1\0\1\7\12\0"+
    "\10\7\1\223\23\7\6\0\2\7\1\0\1\7\12\0"+
    "\27\7\1\213\4\7\6\0\2\7\1\0\1\7\12\0"+
    "\2\7\1\u012e\1\7\1\u0159\5\7\1\u0152\21\7\6\0"+
    "\2\7\1\0\1\7\12\0\1\u015a\33\7\6\0\2\7"+
    "\1\0\1\7\12\0\4\7\1\u015b\27\7\6\0\2\7"+
    "\1\0\1\7\12\0\5\7\1\u0100\26\7\6\0\2\7"+
    "\1\0\1\7\12\0\15\7\1\370\16\7\6\0\2\7"+
    "\1\0\1\7\12\0\14\7\1\u015c\17\7\6\0\2\7"+
    "\1\0\1\7\12\0\10\7\1\u0100\23\7\6\0\2\7"+
    "\1\0\1\7\12\0\21\7\1\213\12\7\6\0\2\7"+
    "\1\0\1\7\12\0\15\7\1\u015d\16\7\6\0\2\7"+
    "\1\0\1\7\12\0\1\u015e\33\7\6\0\2\7\1\0"+
    "\1\7\12\0\10\7\1\u015f\23\7\6\0\2\7\1\0"+
    "\1\7\12\0\4\7\1\u0160\27\7\6\0\2\7\1\0"+
    "\1\7\12\0\1\7\1\u0161\32\7\6\0\2\7\1\0"+
    "\1\7\12\0\15\7\1\u0162\16\7\6\0\2\7\1\0"+
    "\1\7\12\0\22\7\1\213\11\7\4\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[15936];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\4\0\2\11\4\1\1\11\3\1\1\11\31\1\2\11"+
    "\2\1\1\11\2\1\1\11\2\1\1\11\1\1\1\0"+
    "\1\1\1\11\113\1\3\11\1\1\1\0\333\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[354];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */


	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public SQLTokenMaker() {
		super();
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * Returns the text to place at the beginning and end of a
	 * line to "comment" it in a this programming language.
	 *
	 * @return The start and end strings to add to a line to "comment"
	 *         it out.
	 */
	public String[] getLineCommentStartAndEnd() {
		return new String[] { "--", null };
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;

		// Start off in the proper state.
		int state = Token.NULL;
		switch (initialTokenType) {
			case Token.LITERAL_STRING_DOUBLE_QUOTE:
				state = STRING;
				start = text.offset;
				break;
			case Token.LITERAL_CHAR:
				state = CHAR;
				start = text.offset;
				break;
			case Token.COMMENT_MULTILINE:
				state = MLC;
				start = text.offset;
				break;
			default:
				state = Token.NULL;
		}

		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new DefaultToken();
		}

	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 */
	private boolean zzRefill() {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream 
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream 
	 */
	public final void yyreset(java.io.Reader reader) {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public SQLTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public SQLTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 178) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 20: 
          { addToken(Token.PREPROCESSOR);
          }
        case 23: break;
        case 2: 
          { addNullToken(); return firstToken;
          }
        case 24: break;
        case 21: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.COMMENT_MULTILINE);
          }
        case 25: break;
        case 18: 
          { start = zzMarkedPos-2; yybegin(MLC);
          }
        case 26: break;
        case 4: 
          { addToken(Token.WHITESPACE);
          }
        case 27: break;
        case 14: 
          { addToken(start,zzStartRead-1, Token.LITERAL_CHAR); return firstToken;
          }
        case 28: break;
        case 9: 
          { start = zzMarkedPos-1; yybegin(CHAR);
          }
        case 29: break;
        case 7: 
          { addToken(Token.LITERAL_NUMBER_FLOAT);
          }
        case 30: break;
        case 19: 
          { addToken(Token.RESERVED_WORD);
          }
        case 31: break;
        case 6: 
          { addToken(Token.SEPARATOR);
          }
        case 32: break;
        case 15: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead, Token.LITERAL_CHAR);
          }
        case 33: break;
        case 1: 
          { addToken(Token.IDENTIFIER);
          }
        case 34: break;
        case 22: 
          { addToken(Token.FUNCTION);
          }
        case 35: break;
        case 12: 
          { addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
          }
        case 36: break;
        case 17: 
          { addToken(Token.COMMENT_EOL);
          }
        case 37: break;
        case 8: 
          { start = zzMarkedPos-1; yybegin(STRING);
          }
        case 38: break;
        case 3: 
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 39: break;
        case 5: 
          { addToken(Token.OPERATOR);
          }
        case 40: break;
        case 13: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead, Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 41: break;
        case 10: 
          { addToken(Token.ERROR_IDENTIFIER); addNullToken(); return firstToken;
          }
        case 42: break;
        case 11: 
          { 
          }
        case 43: break;
        case 16: 
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); return firstToken;
          }
        case 44: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case STRING: {
              addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
            }
            case 355: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 356: break;
            case MLC: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); return firstToken;
            }
            case 357: break;
            case CHAR: {
              addToken(start,zzStartRead-1, Token.LITERAL_CHAR); return firstToken;
            }
            case 358: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
