/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.fife.io.DocumentReader;
import org.fife.ui.rsyntaxtextarea.Parser;
import org.fife.ui.rsyntaxtextarea.ParserNotice;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

class ParserManager
implements DocumentListener,
ActionListener {
    private RSyntaxTextArea textArea;
    private Parser parser;
    private Timer timer;
    private static final boolean DEBUG_PARSING = true;
    private static final int DEFAULT_DELAY_MS = 1250;

    public ParserManager(RSyntaxTextArea textArea) {
        this(1250, textArea);
    }

    public ParserManager(int delay, RSyntaxTextArea textArea) {
        this.textArea = textArea;
        this.timer = new Timer(delay, this);
        this.timer.setRepeats(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.parser == null) {
            return;
        }
        long begin = 0L;
        begin = System.currentTimeMillis();
        RSyntaxDocument doc = (RSyntaxDocument)this.textArea.getDocument();
        doc.readLock();
        try {
            DocumentReader r = new DocumentReader(doc);
            this.parser.parse(r);
            r.close();
        }
        finally {
            doc.readUnlock();
        }
        float time = (float)(System.currentTimeMillis() - begin) / 1000.0f;
        System.err.println("Parsing took: " + time + " seconds");
        this.textArea.refreshParserNoticeHighlights(this.parser.getNoticeIterator());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public int getDelay() {
        return this.timer.getDelay();
    }

    public Parser getParser() {
        return this.parser;
    }

    public String getToolTipText(MouseEvent e) {
        int pos = this.textArea.viewToModel(e.getPoint());
        Iterator i = this.parser.getNoticeIterator();
        if (i != null) {
            while (i.hasNext()) {
                ParserNotice notice = (ParserNotice)i.next();
                if (!notice.containsPosition(pos)) continue;
                return notice.getMessage();
            }
        }
        return null;
    }

    public void handleDocumentEvent(DocumentEvent e) {
        this.timer.restart();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleDocumentEvent(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleDocumentEvent(e);
    }

    public void setDelay(int millis) {
        boolean running = this.timer.isRunning();
        this.timer.stop();
        this.timer.setDelay(millis);
        if (running) {
            this.timer.start();
        }
    }

    public void setParser(Parser parser) {
        if (this.parser != null) {
            this.timer.stop();
            this.textArea.getDocument().removeDocumentListener(this);
        }
        this.parser = parser;
        if (parser != null) {
            ToolTipManager.sharedInstance().registerComponent(this.textArea);
            this.textArea.getDocument().addDocumentListener(this);
            this.timer.start();
        }
    }
}

