/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.fife.print.RPrintUtilities;
import org.fife.ui.rtextarea.ChangeableHighlightPainter;
import org.fife.ui.rtextarea.ConfigurableCaret;
import org.fife.ui.rtextarea.IconGroup;
import org.fife.ui.rtextarea.LineHighlightManager;
import org.fife.ui.rtextarea.Macro;
import org.fife.ui.rtextarea.RTextAreaBase;
import org.fife.ui.rtextarea.RTextAreaEditorKit;
import org.fife.ui.rtextarea.RTextAreaUI;
import org.fife.ui.rtextarea.RUndoManager;
import org.fife.ui.rtextarea.RecordableTextAction;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.ToolTipSupplier;

public class RTextArea
extends RTextAreaBase
implements Printable,
Serializable {
    public static final int INSERT_MODE = 0;
    public static final int OVERWRITE_MODE = 1;
    public static final String MARK_ALL_COLOR_PROPERTY = "RTA.markAllColor";
    private static final int MIN_ACTION_CONSTANT = 0;
    public static final int COPY_ACTION = 0;
    public static final int CUT_ACTION = 1;
    public static final int DELETE_ACTION = 2;
    public static final int PASTE_ACTION = 3;
    public static final int REDO_ACTION = 4;
    public static final int SELECT_ALL_ACTION = 5;
    public static final int UNDO_ACTION = 6;
    private static final int MAX_ACTION_CONSTANT = 6;
    private static final Color DEFAULT_MARK_ALL_COLOR = Color.ORANGE;
    private int textMode;
    private static boolean recordingMacro;
    private static Macro currentMacro;
    private JPopupMenu popupMenu;
    private boolean popupMenuCreated;
    private ToolTipSupplier toolTipSupplier;
    private static RecordableTextAction cutAction;
    private static RecordableTextAction copyAction;
    private static RecordableTextAction pasteAction;
    private static RecordableTextAction deleteAction;
    private static RecordableTextAction undoAction;
    private static RecordableTextAction redoAction;
    private static RecordableTextAction selectAllAction;
    private static IconGroup iconGroup;
    private transient RUndoManager undoManager;
    private transient LineHighlightManager lineHighlightManager;
    private ArrayList markAllHighlights;
    private String markedWord;
    private ChangeableHighlightPainter markAllHighlightPainter;
    private int[] carets;
    private static final String MSG = "org.fife.ui.rtextarea.RTextArea";
    private StringBuffer repTabsSB;

    public RTextArea() {
        this.init(0);
    }

    public RTextArea(AbstractDocument doc) {
        super(doc);
        this.init(0);
    }

    public RTextArea(String text) {
        super(text);
        this.init(0);
    }

    public RTextArea(int rows, int cols) {
        super(rows, cols);
        this.init(0);
    }

    public RTextArea(String text, int rows, int cols) {
        super(text, rows, cols);
        this.init(0);
    }

    public RTextArea(AbstractDocument doc, String text, int rows, int cols) {
        super(doc, text, rows, cols);
        this.init(0);
    }

    public RTextArea(int textMode) {
        this.init(textMode);
    }

    static synchronized void addToCurrentMacro(String id, String actionCommand) {
        currentMacro.addMacroRecord(new Macro.MacroRecord(id, actionCommand));
    }

    public Object addLineHighlight(int line, Color color) throws BadLocationException {
        if (this.lineHighlightManager == null) {
            this.lineHighlightManager = new LineHighlightManager(this);
        }
        return this.lineHighlightManager.addLineHighlight(line, color);
    }

    public void beginAtomicEdit() {
        this.undoManager.beginInternalAtomicEdit();
    }

    public static synchronized void beginRecordingMacro() {
        if (RTextArea.isRecordingMacro()) {
            return;
        }
        if (currentMacro != null) {
            currentMacro = null;
        }
        currentMacro = new Macro();
        recordingMacro = true;
    }

    public void clearMarkAllHighlights() {
        Highlighter h = this.getHighlighter();
        if (h != null && this.markAllHighlights != null) {
            int count = this.markAllHighlights.size();
            for (int i = 0; i < count; ++i) {
                h.removeHighlight(this.markAllHighlights.get(i));
            }
            this.markAllHighlights.clear();
        }
        this.markedWord = null;
        this.repaint();
    }

    protected void configurePopupMenu(JPopupMenu popupMenu) {
    }

    @Override
    protected RTextAreaBase.RTAMouseListener createMouseListener() {
        return new RTextAreaMutableCaretEvent(this);
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(undoAction);
        menuItem.setAccelerator(null);
        menuItem.setToolTipText(null);
        menu.add(menuItem);
        menuItem = new JMenuItem(redoAction);
        menuItem.setAccelerator(null);
        menuItem.setToolTipText(null);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem(cutAction);
        menuItem.setAccelerator(null);
        menuItem.setToolTipText(null);
        menu.add(menuItem);
        menuItem = new JMenuItem(copyAction);
        menuItem.setAccelerator(null);
        menuItem.setToolTipText(null);
        menu.add(menuItem);
        menuItem = new JMenuItem(pasteAction);
        menuItem.setAccelerator(null);
        menuItem.setToolTipText(null);
        menu.add(menuItem);
        menuItem = new JMenuItem(deleteAction);
        menuItem.setAccelerator(null);
        menuItem.setToolTipText(null);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem(selectAllAction);
        menuItem.setAccelerator(null);
        menuItem.setToolTipText(null);
        menu.add(menuItem);
        return menu;
    }

    @Override
    protected RTextAreaUI createRTextAreaUI() {
        return new RTextAreaUI(this);
    }

    public void discardAllEdits() {
        this.undoManager.discardAllEdits();
        this.getDocument().removeUndoableEditListener(this.undoManager);
        this.undoManager = new RUndoManager(this);
        this.getDocument().addUndoableEditListener(this.undoManager);
        this.undoManager.updateActions();
    }

    public void endAtomicEdit() {
        this.undoManager.endInternalAtomicEdit();
    }

    public static synchronized void endRecordingMacro() {
        if (!RTextArea.isRecordingMacro()) {
            return;
        }
        recordingMacro = false;
    }

    @Override
    protected void fireCaretUpdate(CaretEvent e) {
        this.possiblyUpdateCurrentLineHighlightLocation();
        if (e != null && e.getDot() != e.getMark()) {
            cutAction.setEnabled(true);
            copyAction.setEnabled(true);
        } else if (cutAction.isEnabled()) {
            cutAction.setEnabled(false);
            copyAction.setEnabled(false);
        }
        super.fireCaretUpdate(e);
    }

    private void fixCtrlH() {
        InputMap inputMap = this.getInputMap();
        KeyStroke char010 = KeyStroke.getKeyStroke("typed \b");
        for (InputMap parent = inputMap; parent != null; parent = parent.getParent()) {
            parent.remove(char010);
        }
        KeyStroke backspace = KeyStroke.getKeyStroke("BACK_SPACE");
        inputMap.put(backspace, "delete-previous");
    }

    public static RecordableTextAction getAction(int action) {
        if (action < 0 || action > 6) {
            return null;
        }
        switch (action) {
            case 0: {
                return copyAction;
            }
            case 1: {
                return cutAction;
            }
            case 2: {
                return deleteAction;
            }
            case 3: {
                return pasteAction;
            }
            case 4: {
                return redoAction;
            }
            case 5: {
                return selectAllAction;
            }
            case 6: {
                return undoAction;
            }
        }
        return null;
    }

    public static synchronized Macro getCurrentMacro() {
        return currentMacro;
    }

    public static final Color getDefaultMarkAllHighlightColor() {
        return DEFAULT_MARK_ALL_COLOR;
    }

    public static IconGroup getIconGroup() {
        return iconGroup;
    }

    LineHighlightManager getLineHighlightManager() {
        return this.lineHighlightManager;
    }

    public Color getMarkAllHighlightColor() {
        return (Color)this.markAllHighlightPainter.getPaint();
    }

    public int getMaxAscent() {
        return this.getFontMetrics(this.getFont()).getAscent();
    }

    public JPopupMenu getPopupMenu() {
        if (!this.popupMenuCreated) {
            this.popupMenu = this.createPopupMenu();
            if (this.popupMenu != null) {
                ComponentOrientation orientation = ComponentOrientation.getOrientation(Locale.getDefault());
                this.popupMenu.applyComponentOrientation(orientation);
            }
            this.popupMenuCreated = true;
        }
        return this.popupMenu;
    }

    public final int getTextMode() {
        return this.textMode;
    }

    public ToolTipSupplier getToolTipSupplier() {
        return this.toolTipSupplier;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String tip = null;
        if (this.getToolTipSupplier() != null) {
            tip = this.getToolTipSupplier().getToolTipText(this, e);
        }
        return tip != null ? tip : super.getToolTipText();
    }

    protected void handleReplaceSelection(String content) {
        super.replaceSelection(content);
    }

    private void init(int textMode) {
        this.undoManager = new RUndoManager(this);
        this.getDocument().addUndoableEditListener(this.undoManager);
        Color markAllHighlightColor = RTextArea.getDefaultMarkAllHighlightColor();
        this.markAllHighlightPainter = new ChangeableHighlightPainter(markAllHighlightColor);
        this.setMarkAllHighlightColor(markAllHighlightColor);
        this.carets = new int[2];
        this.setCaretStyle(0, 4);
        this.setCaretStyle(1, 2);
        this.setDragEnabled(true);
        this.setTextMode(textMode);
        this.fixCtrlH();
    }

    public static synchronized boolean isRecordingMacro() {
        return recordingMacro;
    }

    public static synchronized void loadMacro(Macro macro) {
        currentMacro = macro;
    }

    public int markAll(String toMark, boolean matchCase, boolean wholeWord, boolean regex) {
        Highlighter h = this.getHighlighter();
        int numMarked = 0;
        if (toMark != null && !toMark.equals(this.markedWord) && h != null) {
            if (this.markAllHighlights != null) {
                this.clearMarkAllHighlights();
            } else {
                this.markAllHighlights = new ArrayList(10);
            }
            int caretPos = this.getCaretPosition();
            this.markedWord = toMark;
            this.setCaretPosition(0);
            boolean found = SearchEngine.find(this, toMark, true, matchCase, wholeWord, regex);
            while (found) {
                int start = this.getSelectionStart();
                int end = this.getSelectionEnd();
                try {
                    this.markAllHighlights.add(h.addHighlight(start, end, this.markAllHighlightPainter));
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
                ++numMarked;
                found = SearchEngine.find(this, toMark, true, matchCase, wholeWord, regex);
            }
            this.setCaretPosition(caretPos);
            this.repaint();
        }
        return numMarked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void playbackLastMacro() {
        if (currentMacro != null) {
            Action[] actions = this.getActions();
            int numActions = actions.length;
            List macroRecords = currentMacro.getMacroRecords();
            int num = macroRecords.size();
            if (num > 0) {
                this.undoManager.beginInternalAtomicEdit();
                try {
                    block3: for (int i = 0; i < num; ++i) {
                        Macro.MacroRecord record = (Macro.MacroRecord)macroRecords.get(i);
                        for (int j = 0; j < numActions; ++j) {
                            if (!(actions[j] instanceof RecordableTextAction) || !record.id.equals(((RecordableTextAction)actions[j]).getMacroID())) continue;
                            actions[j].actionPerformed(new ActionEvent(this, 1001, record.actionCommand));
                            continue block3;
                        }
                    }
                }
                finally {
                    this.undoManager.endInternalAtomicEdit();
                }
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        return RPrintUtilities.printDocumentWordWrap(g, this, this.getFont(), pageIndex, pageFormat, this.getTabSize());
    }

    @Override
    public void read(Reader in, Object desc) throws IOException {
        RTextAreaEditorKit kit = (RTextAreaEditorKit)this.getUI().getEditorKit(this);
        this.setText(null);
        Document doc = this.getDocument();
        if (desc != null) {
            doc.putProperty("stream", desc);
        }
        try {
            kit.read(in, doc, 0);
        }
        catch (BadLocationException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.undoManager = new RUndoManager(this);
        this.getDocument().addUndoableEditListener(this.undoManager);
        this.lineHighlightManager = null;
    }

    public void redoLastAction() {
        try {
            if (this.undoManager.canRedo()) {
                this.undoManager.redo();
            }
        }
        catch (CannotRedoException cre) {
            cre.printStackTrace();
        }
    }

    public void removeAllLineHighlights() {
        if (this.lineHighlightManager != null) {
            this.lineHighlightManager.removeAllLineHighlights();
        }
    }

    public void removeLineHighlight(Object tag) {
        if (this.lineHighlightManager != null) {
            this.lineHighlightManager.removeLineHighlight(tag);
        }
    }

    @Override
    public void replaceRange(String str, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("end before start");
        }
        Document doc = this.getDocument();
        if (doc != null) {
            try {
                this.undoManager.beginInternalAtomicEdit();
                ((AbstractDocument)doc).replace(start, end - start, str, null);
            }
            catch (BadLocationException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            finally {
                this.undoManager.endInternalAtomicEdit();
            }
        }
    }

    @Override
    public void replaceSelection(String text) {
        if (text == null) {
            this.handleReplaceSelection(text);
            return;
        }
        if (this.getTabsEmulated() && text.indexOf(9) > -1) {
            text = this.replaceTabsWithSpaces(text);
        }
        if (this.textMode == 1) {
            Caret caret = this.getCaret();
            int caretPos = caret.getDot();
            Document doc = this.getDocument();
            Element map = doc.getDefaultRootElement();
            int curLine = map.getElementIndex(caretPos);
            int lastLine = map.getElementCount() - 1;
            try {
                if (text.equals("\n")) {
                    if (curLine == lastLine) {
                        this.setCaretPosition(this.getLineEndOffset(curLine));
                        this.handleReplaceSelection(text);
                    } else {
                        this.setCaretPosition(this.getLineStartOffset(curLine + 1));
                    }
                    return;
                }
                int curLineEnd = this.getLineEndOffset(curLine);
                if (caretPos == caret.getMark() && caretPos != curLineEnd) {
                    caretPos = curLine == lastLine ? Math.min(caretPos + text.length(), curLineEnd) : Math.min(caretPos + text.length(), curLineEnd - 1);
                    caret.moveDot(caretPos);
                }
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
                ble.printStackTrace();
            }
        }
        this.handleReplaceSelection(text);
    }

    private final String replaceTabsWithSpaces(String text) {
        String tabText = "";
        int temp = this.getTabSize();
        for (int i = 0; i < temp; ++i) {
            tabText = tabText + ' ';
        }
        if (text.length() == 1) {
            return tabText;
        }
        if (this.repTabsSB == null) {
            this.repTabsSB = new StringBuffer();
        }
        this.repTabsSB.setLength(0);
        char[] array = text.toCharArray();
        int oldPos = 0;
        int pos = 0;
        while ((pos = text.indexOf(9, oldPos)) > -1) {
            if (pos > oldPos) {
                this.repTabsSB.append(array, oldPos, pos - oldPos);
            }
            this.repTabsSB.append(tabText);
            oldPos = pos + 1;
        }
        if (oldPos < array.length) {
            this.repTabsSB.append(array, oldPos, array.length - oldPos);
        }
        return this.repTabsSB.toString();
    }

    public static void setActionProperties(int action, String name, char mnemonic, KeyStroke accelerator) {
        RTextArea.setActionProperties(action, name, new Integer(mnemonic), accelerator);
    }

    public static void setActionProperties(int action, String name, Integer mnemonic, KeyStroke accelerator) {
        RecordableTextAction tempAction = null;
        switch (action) {
            case 1: {
                tempAction = cutAction;
                break;
            }
            case 0: {
                tempAction = copyAction;
                break;
            }
            case 3: {
                tempAction = pasteAction;
                break;
            }
            case 2: {
                tempAction = deleteAction;
                break;
            }
            case 5: {
                tempAction = selectAllAction;
                break;
            }
            default: {
                return;
            }
        }
        tempAction.putValue("Name", name);
        tempAction.putValue("ShortDescription", name);
        tempAction.putValue("AcceleratorKey", accelerator);
        tempAction.putValue("MnemonicKey", mnemonic);
    }

    @Override
    public void setCaret(Caret caret) {
        if (!(caret instanceof ConfigurableCaret)) {
            throw new IllegalArgumentException("RTextArea needs ConfigurableCaret");
        }
        super.setCaret(caret);
        if (this.carets != null) {
            ((ConfigurableCaret)caret).setStyle(this.carets[this.getTextMode()]);
        }
    }

    public void setCaretStyle(int mode, int style) {
        this.carets[mode] = style = style >= 0 && style <= 4 ? style : 4;
        if (mode == this.getTextMode()) {
            ((ConfigurableCaret)this.getCaret()).setStyle(style);
        }
    }

    @Override
    public void setDocument(Document document) {
        if (!(document instanceof AbstractDocument)) {
            throw new IllegalArgumentException("RTextArea requires instances of AbstractDocument for its document");
        }
        super.setDocument(document);
    }

    public static synchronized void setIconGroup(IconGroup group) {
        Icon icon = group.getIcon("cut");
        cutAction.putValue("SmallIcon", icon);
        icon = group.getIcon("copy");
        copyAction.putValue("SmallIcon", icon);
        icon = group.getIcon("paste");
        pasteAction.putValue("SmallIcon", icon);
        icon = group.getIcon("delete");
        deleteAction.putValue("SmallIcon", icon);
        icon = group.getIcon("undo");
        undoAction.putValue("SmallIcon", icon);
        icon = group.getIcon("redo");
        redoAction.putValue("SmallIcon", icon);
        icon = group.getIcon("selectall");
        selectAllAction.putValue("SmallIcon", icon);
        iconGroup = group;
    }

    public void setMarkAllHighlightColor(Color color) {
        Color old = (Color)this.markAllHighlightPainter.getPaint();
        if (old != null && !old.equals(color)) {
            this.markAllHighlightPainter.setPaint(color);
            if (this.markedWord != null) {
                this.repaint();
            }
            this.firePropertyChange(MARK_ALL_COLOR_PROPERTY, old, color);
        }
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
        this.popupMenuCreated = true;
    }

    @Override
    public void setRoundedSelectionEdges(boolean rounded) {
        if (this.getRoundedSelectionEdges() != rounded) {
            this.markAllHighlightPainter.setRoundedEdges(rounded);
            super.setRoundedSelectionEdges(rounded);
        }
    }

    public void setTextMode(int mode) {
        if (mode != 0 && mode != 1) {
            mode = 0;
        }
        if (this.textMode != mode) {
            ConfigurableCaret cc = (ConfigurableCaret)this.getCaret();
            cc.setStyle(this.carets[mode]);
            this.textMode = mode;
        }
    }

    public void setToolTipSupplier(ToolTipSupplier supplier) {
        this.toolTipSupplier = supplier;
    }

    @Override
    public final void setUI(TextUI ui) {
        RTextAreaUI rtaui;
        if (this.popupMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.popupMenu);
        }
        if ((rtaui = (RTextAreaUI)this.getUI()) != null) {
            rtaui.installDefaults();
        }
    }

    public void undoLastAction() {
        try {
            if (this.undoManager.canUndo()) {
                this.undoManager.undo();
            }
        }
        catch (CannotUndoException cre) {
            cre.printStackTrace();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.getDocument().removeUndoableEditListener(this.undoManager);
        s.defaultWriteObject();
        this.getDocument().addUndoableEditListener(this.undoManager);
    }

    static {
        ResourceBundle bundle = ResourceBundle.getBundle(MSG);
        int mod = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        String name = bundle.getString("CutName");
        char mnemonic = bundle.getString("CutMnemonic").charAt(0);
        String desc = bundle.getString("CutDesc");
        cutAction = new RTextAreaEditorKit.CutAction(name, null, desc, new Integer(mnemonic), KeyStroke.getKeyStroke(88, mod));
        name = bundle.getString("CopyName");
        mnemonic = bundle.getString("CopyMnemonic").charAt(0);
        desc = bundle.getString("CopyDesc");
        copyAction = new RTextAreaEditorKit.CopyAction(name, null, desc, new Integer(mnemonic), KeyStroke.getKeyStroke(67, mod));
        name = bundle.getString("PasteName");
        mnemonic = bundle.getString("PasteMnemonic").charAt(0);
        desc = bundle.getString("PasteDesc");
        pasteAction = new RTextAreaEditorKit.PasteAction(name, null, desc, new Integer(mnemonic), KeyStroke.getKeyStroke(86, mod));
        name = bundle.getString("DeleteName");
        mnemonic = bundle.getString("DeleteMnemonic").charAt(0);
        desc = bundle.getString("DeleteDesc");
        deleteAction = new RTextAreaEditorKit.DeleteNextCharAction(name, null, desc, new Integer(mnemonic), KeyStroke.getKeyStroke(127, 0));
        name = bundle.getString("CantUndoName");
        mnemonic = bundle.getString("UndoMnemonic").charAt(0);
        desc = bundle.getString("UndoDesc");
        undoAction = new RTextAreaEditorKit.UndoAction(name, null, desc, new Integer(mnemonic), KeyStroke.getKeyStroke(90, mod));
        name = bundle.getString("CantRedoName");
        mnemonic = bundle.getString("RedoMnemonic").charAt(0);
        desc = bundle.getString("RedoDesc");
        redoAction = new RTextAreaEditorKit.RedoAction(name, null, desc, new Integer(mnemonic), KeyStroke.getKeyStroke(89, mod));
        name = bundle.getString("SAName");
        mnemonic = bundle.getString("SAMnemonic").charAt(0);
        desc = bundle.getString("SelectAllDesc");
        selectAllAction = new RTextAreaEditorKit.SelectAllAction(name, null, desc, new Integer(mnemonic), KeyStroke.getKeyStroke(65, mod));
    }

    protected class RTextAreaMutableCaretEvent
    extends RTextAreaBase.RTAMouseListener {
        protected RTextAreaMutableCaretEvent(RTextArea textArea) {
            super(RTextArea.this, textArea);
        }

        @Override
        public void focusGained(FocusEvent e) {
            Caret c = RTextArea.this.getCaret();
            boolean enabled = c.getDot() != c.getMark();
            cutAction.setEnabled(enabled);
            copyAction.setEnabled(enabled);
            RTextArea.this.undoManager.updateActions();
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if ((e.getModifiers() & 0x10) != 0) {
                Caret caret = RTextArea.this.getCaret();
                this.dot = caret.getDot();
                this.mark = caret.getMark();
                RTextArea.this.fireCaretUpdate(this);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if ((e.getModifiers() & 0x10) != 0) {
                Caret caret = RTextArea.this.getCaret();
                this.dot = caret.getDot();
                this.mark = caret.getMark();
                RTextArea.this.fireCaretUpdate(this);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if ((e.getModifiers() & 4) != 0) {
                this.showPopup(e);
            }
        }

        private void showPopup(MouseEvent e) {
            JPopupMenu popupMenu = RTextArea.this.getPopupMenu();
            if (popupMenu != null) {
                RTextArea.this.configurePopupMenu(popupMenu);
                popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

