/*
 * Decompiled with CFR 0.152.
 */
package com.jtstand.label;

import com.jtstand.TestSequenceInstance;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.BarcodeException;
import net.sourceforge.barbecue.BarcodeFactory;

public class TestSequenceInstanceLabel
extends JPanel {
    public static final String PRINTER_NAME = "Smart Label Printer 450";
    public static final String PRINTER_MEDIA = "SLP-SRL Shipping(2.13x4.00)";
    String printerName = "Smart Label Printer 450";
    String printerMedia = "SLP-SRL Shipping(2.13x4.00)";
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel12;
    private JLabel jLabel14;
    private JLabel jLabel16;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JLabel jLabelFixture;
    private JLabel jLabelOperator;
    private JLabel jLabelPartNumber;
    private JLabel jLabelPartRevision;
    private JLabel jLabelTestStation;
    private JLabel jLabelTestTime;
    private JLabel jLabelTestType;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;

    public TestSequenceInstanceLabel() {
        this.initComponents();
        try {
            Barcode barcodeSerial = BarcodeFactory.createCode128B((String)"1234567890");
            barcodeSerial.setBarWidth(1);
            this.jPanel1.add((Component)barcodeSerial);
            Barcode barcodeErrorCode = BarcodeFactory.createCode128B((String)"ERR01");
            barcodeErrorCode.setBarWidth(1);
            this.jPanel16.add((Component)barcodeErrorCode);
        }
        catch (BarcodeException ex) {
            Logger.getLogger(TestSequenceInstanceLabel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public TestSequenceInstanceLabel(String printerName, String printerMedia) {
        this();
        this.printerName = printerName;
        this.printerMedia = printerMedia;
    }

    public void setTestSequenceInstance(TestSequenceInstance tsi) {
        this.jLabelOperator.setText(tsi.getEmployeeNumber());
        this.jLabelTestStation.setText(tsi.getTestStation().getHostName());
        this.jLabelFixture.setText(tsi.getTestFixture().getFixtureName());
        this.jLabelPartNumber.setText(tsi.getPartNumber());
        this.jLabelPartRevision.setText(tsi.getPartRevision());
        this.jLabelTestType.setText(tsi.getTestTypeName());
        this.jLabelTestTime.setText(tsi.getStartedString());
        try {
            String sn = tsi.getSerialNumber();
            if (sn == null) {
                sn = "null";
            }
            Barcode barcodeSerial = BarcodeFactory.createCode128B((String)sn);
            barcodeSerial.setBarWidth(1);
            this.jPanel1.removeAll();
            this.jPanel1.add((Component)barcodeSerial);
            this.jPanel1.validate();
            String fcode = "PASS";
            if (!tsi.isPassed() && (fcode = tsi.getFailureCode()) == null) {
                fcode = "null";
            }
            Barcode barcodeErrorCode = BarcodeFactory.createCode128B((String)fcode);
            barcodeErrorCode.setBarWidth(1);
            this.jPanel16.removeAll();
            this.jPanel16.add((Component)barcodeErrorCode);
            this.jPanel16.validate();
        }
        catch (BarcodeException ex) {
            Logger.getLogger(TestSequenceInstanceLabel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.validate();
    }

    public static void printPageFormat(PageFormat pf) {
        System.out.println("paper size:" + pf.getWidth() + "x" + pf.getHeight() + " orientation:" + pf.getOrientation());
        System.out.println("imageable position: X=" + pf.getImageableX() + " Y=" + pf.getImageableY());
        System.out.println("imageable size:" + pf.getImageableWidth() + "x" + pf.getImageableHeight());
    }

    public void print(PrinterJob printerJob) throws PrinterException {
        HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
        Media[] res = (Media[])printerJob.getPrintService().getSupportedAttributeValues(Media.class, null, null);
        for (int i = 0; i < res.length; ++i) {
            System.out.println("res[" + i + "]=" + res[i]);
            System.out.println(res[i].toString());
            if (!res[i].toString().equals(this.printerMedia)) continue;
            attributes.add(res[i]);
        }
        printerJob.print(attributes);
        PageFormat pageFormat = printerJob.getPageFormat(attributes);
        System.out.println("[after opening]");
        TestSequenceInstanceLabel.printPageFormat(pageFormat);
        pageFormat.setOrientation(1);
        printerJob.setPrintable(new MyPrintable(this), pageFormat);
        try {
            printerJob.print();
        }
        catch (PrinterException ex) {
            ex.printStackTrace();
        }
    }

    public void print(String printerName, String printerMedia) {
        this.printerName = printerName;
        this.printerMedia = printerMedia;
        this.print();
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PrintService[] printService = PrinterJob.lookupPrintServices();
        for (int i = 0; i < printService.length; ++i) {
            System.out.println(printService[i].getName());
            if (printService[i].getName().compareTo(this.printerName) != 0) continue;
            try {
                printerJob.setPrintService(printService[i]);
                this.setDoubleBuffered(false);
                this.setSize(this.getPreferredSize());
                this.addNotify();
                this.validate();
                this.print(printerJob);
                continue;
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        TestSequenceInstanceLabel tsil = new TestSequenceInstanceLabel();
        tsil.print();
    }

    private void initComponents() {
        this.jLabel9 = new JLabel();
        this.jPanel12 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel7 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabelOperator = new JLabel();
        this.jPanel5 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabelTestStation = new JLabel();
        this.jPanel6 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jLabelFixture = new JLabel();
        this.jPanel10 = new JPanel();
        this.jLabel10 = new JLabel();
        this.jLabelPartNumber = new JLabel();
        this.jPanel9 = new JPanel();
        this.jLabel12 = new JLabel();
        this.jLabelPartRevision = new JLabel();
        this.jPanel8 = new JPanel();
        this.jLabel14 = new JLabel();
        this.jLabelTestType = new JLabel();
        this.jPanel11 = new JPanel();
        this.jLabel16 = new JLabel();
        this.jLabelTestTime = new JLabel();
        this.jPanel13 = new JPanel();
        this.jPanel14 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel15 = new JPanel();
        this.jPanel16 = new JPanel();
        this.jLabel9.setText("jLabel9");
        this.setLayout(new BorderLayout());
        this.jPanel12.setBackground(new Color(255, 255, 255));
        this.jPanel12.setLayout(new BorderLayout());
        this.jPanel3.setBackground(new Color(255, 255, 255));
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 1));
        this.jLabel1.setFont(new Font("Arial", 0, 12));
        this.jLabel1.setText("Serial Number:");
        this.jPanel3.add(this.jLabel1);
        this.jPanel12.add((Component)this.jPanel3, "North");
        this.jPanel7.setBackground(new Color(255, 255, 255));
        this.jPanel7.setLayout(new BoxLayout(this.jPanel7, 1));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
        this.jPanel7.add(this.jPanel1);
        this.jPanel12.add((Component)this.jPanel7, "Center");
        this.add((Component)this.jPanel12, "North");
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setLayout(new GridLayout(0, 1));
        this.jPanel4.setBackground(new Color(255, 255, 255));
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 1));
        this.jLabel3.setFont(new Font("Arial", 0, 12));
        this.jLabel3.setText("Operator:");
        this.jPanel4.add(this.jLabel3);
        this.jLabelOperator.setFont(new Font("Tahoma", 1, 14));
        this.jLabelOperator.setText("12345");
        this.jPanel4.add(this.jLabelOperator);
        this.jPanel2.add(this.jPanel4);
        this.jPanel5.setBackground(new Color(255, 255, 255));
        this.jPanel5.setLayout(new BoxLayout(this.jPanel5, 1));
        this.jLabel5.setFont(new Font("Arial", 0, 12));
        this.jLabel5.setText("Test Station:");
        this.jPanel5.add(this.jLabel5);
        this.jLabelTestStation.setFont(new Font("Tahoma", 1, 14));
        this.jLabelTestStation.setText("STATION1");
        this.jPanel5.add(this.jLabelTestStation);
        this.jPanel2.add(this.jPanel5);
        this.jPanel6.setBackground(new Color(255, 255, 255));
        this.jPanel6.setLayout(new BoxLayout(this.jPanel6, 1));
        this.jLabel7.setFont(new Font("Arial", 0, 12));
        this.jLabel7.setText("Fixture:");
        this.jPanel6.add(this.jLabel7);
        this.jLabelFixture.setFont(new Font("Tahoma", 1, 14));
        this.jLabelFixture.setText("FX1");
        this.jPanel6.add(this.jLabelFixture);
        this.jPanel2.add(this.jPanel6);
        this.jPanel10.setBackground(new Color(255, 255, 255));
        this.jPanel10.setLayout(new BoxLayout(this.jPanel10, 1));
        this.jLabel10.setFont(new Font("Arial", 0, 12));
        this.jLabel10.setText("Part Number:");
        this.jPanel10.add(this.jLabel10);
        this.jLabelPartNumber.setFont(new Font("Tahoma", 1, 14));
        this.jLabelPartNumber.setText("MYDEMO");
        this.jPanel10.add(this.jLabelPartNumber);
        this.jPanel2.add(this.jPanel10);
        this.jPanel9.setBackground(new Color(255, 255, 255));
        this.jPanel9.setLayout(new BoxLayout(this.jPanel9, 1));
        this.jLabel12.setFont(new Font("Arial", 0, 12));
        this.jLabel12.setText("Part Revision:");
        this.jPanel9.add(this.jLabel12);
        this.jLabelPartRevision.setFont(new Font("Tahoma", 1, 14));
        this.jLabelPartRevision.setText("001");
        this.jPanel9.add(this.jLabelPartRevision);
        this.jPanel2.add(this.jPanel9);
        this.jPanel8.setBackground(new Color(255, 255, 255));
        this.jPanel8.setLayout(new BoxLayout(this.jPanel8, 1));
        this.jLabel14.setFont(new Font("Arial", 0, 12));
        this.jLabel14.setText("Test Type:");
        this.jPanel8.add(this.jLabel14);
        this.jLabelTestType.setFont(new Font("Tahoma", 1, 14));
        this.jLabelTestType.setText("FULL");
        this.jPanel8.add(this.jLabelTestType);
        this.jPanel2.add(this.jPanel8);
        this.jPanel11.setBackground(new Color(255, 255, 255));
        this.jPanel11.setLayout(new BoxLayout(this.jPanel11, 1));
        this.jLabel16.setFont(new Font("Arial", 0, 12));
        this.jLabel16.setText("Test Time:");
        this.jPanel11.add(this.jLabel16);
        this.jLabelTestTime.setFont(new Font("Tahoma", 1, 14));
        this.jLabelTestTime.setText("2013/03/01 14:38");
        this.jPanel11.add(this.jLabelTestTime);
        this.jPanel2.add(this.jPanel11);
        this.add((Component)this.jPanel2, "Center");
        this.jPanel13.setBackground(new Color(255, 255, 255));
        this.jPanel13.setLayout(new BorderLayout());
        this.jPanel14.setBackground(new Color(255, 255, 255));
        this.jPanel14.setLayout(new BoxLayout(this.jPanel14, 1));
        this.jLabel2.setFont(new Font("Arial", 0, 12));
        this.jLabel2.setText("Error Code:");
        this.jPanel14.add(this.jLabel2);
        this.jPanel13.add((Component)this.jPanel14, "North");
        this.jPanel15.setBackground(new Color(255, 255, 255));
        this.jPanel15.setLayout(new BoxLayout(this.jPanel15, 1));
        this.jPanel16.setBackground(new Color(255, 255, 255));
        this.jPanel16.setLayout(new BoxLayout(this.jPanel16, 1));
        this.jPanel15.add(this.jPanel16);
        this.jPanel13.add((Component)this.jPanel15, "Center");
        this.add((Component)this.jPanel13, "South");
    }

    public static class MyPrintable
    implements Printable {
        private JPanel panel;

        public MyPrintable(JPanel panel) {
            this.panel = panel;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            System.out.println(pageIndex);
            int result = 1;
            if (pageIndex < 1) {
                Graphics2D g2d = (Graphics2D)graphics;
                g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                g2d.scale(pageFormat.getImageableWidth() / (double)this.panel.getPreferredSize().width, pageFormat.getImageableHeight() / (double)this.panel.getPreferredSize().height);
                this.panel.paint(g2d);
                result = 0;
            }
            return result;
        }
    }
}

