/*
 * Decompiled with CFR 0.152.
 */
package org.codetome.hexameter.api;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codetome.hexameter.api.Hexagon;
import org.codetome.hexameter.api.HexagonOrientation;
import org.codetome.hexameter.api.HexagonalGrid;
import org.codetome.hexameter.api.HexagonalGridCalculator;
import org.codetome.hexameter.api.HexagonalGridLayout;
import org.codetome.hexameter.api.exception.HexagonalGridCreationException;
import org.codetome.hexameter.internal.SharedHexagonData;
import org.codetome.hexameter.internal.impl.HexagonalGridCalculatorImpl;
import org.codetome.hexameter.internal.impl.HexagonalGridImpl;
import org.codetome.hexameter.internal.impl.layoutstrategy.GridLayoutStrategy;

public final class HexagonalGridBuilder {
    private int gridWidth;
    private int gridHeight;
    private double radius;
    private Map<String, Hexagon> customStorage = new ConcurrentHashMap<String, Hexagon>();
    private HexagonOrientation orientation = HexagonOrientation.POINTY_TOP;
    private HexagonalGridLayout gridLayout = HexagonalGridLayout.RECTANGULAR;

    public HexagonalGridBuilder setGridLayout(HexagonalGridLayout gridLayout) {
        this.gridLayout = gridLayout;
        return this;
    }

    public HexagonalGrid build() {
        this.checkParameters();
        return new HexagonalGridImpl(this);
    }

    private void checkParameters() {
        if (this.orientation == null) {
            throw new HexagonalGridCreationException("Orientation must be set.");
        }
        if (this.radius <= 0.0) {
            throw new HexagonalGridCreationException("Radius must be greater than 0.");
        }
        if (this.gridLayout == null) {
            throw new HexagonalGridCreationException("Grid layout must be set.");
        }
        if (!this.gridLayout.checkParameters(this.gridHeight, this.gridWidth)) {
            throw new HexagonalGridCreationException("Width: " + this.gridWidth + " and height: " + this.gridHeight + " is not valid for: " + this.gridLayout.name() + " layout.");
        }
    }

    public HexagonalGridCalculator buildCalculatorFor(HexagonalGrid hexagonalGrid) {
        return new HexagonalGridCalculatorImpl(hexagonalGrid);
    }

    public double getRadius() {
        return this.radius;
    }

    public HexagonalGridBuilder setRadius(double radius) {
        this.radius = radius;
        return this;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public HexagonalGridBuilder setGridWidth(int gridWidth) {
        this.gridWidth = gridWidth;
        return this;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public HexagonalGridBuilder setGridHeight(int gridHeight) {
        this.gridHeight = gridHeight;
        return this;
    }

    public HexagonOrientation getOrientation() {
        return this.orientation;
    }

    public HexagonalGridBuilder setOrientation(HexagonOrientation orientation) {
        this.orientation = orientation;
        return this;
    }

    public GridLayoutStrategy getGridLayoutStrategy() {
        return this.gridLayout.getGridLayoutStrategy();
    }

    public Map<String, Hexagon> getCustomStorage() {
        return this.customStorage;
    }

    public HexagonalGridBuilder setCustomStorage(Map<String, Hexagon> customStorage) {
        if (customStorage == null) {
            throw new IllegalArgumentException("customStorage cannot be null!");
        }
        this.customStorage = customStorage;
        return this;
    }

    public SharedHexagonData getSharedHexagonData() {
        if (this.orientation == null || this.radius == 0.0) {
            throw new IllegalStateException("orientation or radius is not yet initialized");
        }
        return new SharedHexagonData(this.orientation, this.radius);
    }
}

